/**
*       corba.h
*       -------
*
*       CORBA Include header
*
*       Copyright Mitch Britton 1998-1999
*       All Rights Reserved
*       See the file licence.txt
*
**/

#ifndef __CORBA_H
#define __CORBA_H

#include <orbtypes.h>
#include <IOP.h>

typedef struct
{
    IOP_ServiceContextList ctxList ;
    CORBA_long request_id ;
    CORBA_boolean response_expected ;
    CORBA_Sequence_octet object_key ;
    char * opName ;
    CORBA_Sequence requesting_principal ;
    void * obj ; 
}
CORBA_iRequest ;

typedef int ( * CORBA_iServerExceptionFunc )( void * _o, CORBA_char * _id, void * _params ) ;

typedef struct CORBA_iORB_Str
{
    void * oa ;              /* Object Adaptor pointer           */
    CORBA_boolean freeOA ;   
    CORBA_char * id ;        /* ORB Id                           */
    char * logName ;         /* log file name                    */
    FILE * log ;             /* log file pointer for 'C' objects */
    void * cppLog ;          /* log file pointer for C++ objects */
    int debug ;
}
CORBA_iORB ;

typedef struct CORBA_IOR_Str
{
    CORBA_unsigned_short tag ;   /* IOR type */
    char * id ;
    IIOP_ProfileBody_1_1 pb ;
}
CORBA_IOR ;

typedef struct CORBA_Iobj_Str
{
    void * Oadaptor ;
    GIOP_MessageHeader_1_1 msgHdr ;
    CORBA_iRequest req ;
    CORBA_Dbuff buff ;
    CORBA_Dbuff obuff ;
    CORBA_iServerExceptionFunc exceptions ;
    CORBA_long idNum ;
    int adaptorSlot ;
    void * server ;
    /* C++ attributes */
    char * id ;
}
CORBA_iObject ;

#define CORBA_DBUFF( O )           &( ( CORBA_iObject * )O )->buff 
#define CORBA_OBJ_ENV(O)           ((O)->buff.env)
#define CORBA_resetBuff( B )       B.curr = 0
#define CORBA_preImpl( A )         CORBA_resetBuff( A->buff ) ; A->buff.offset =12
#define CORBA_exceptionOnObj( O )  (O->buff.env._major)
#define CORBA_exceptionOn( A )     (A->env._major)
#define CORBA_postImpl( A )         if ( !CORBA_exceptionOnObj(A) ) CORBA_resetBuff( A->buff )


typedef void ( * CORBA_iServer_Func )( CORBA_iObject * _o, CORBA_Environment * _ev ) ;

typedef int ( * CORBA_Function )( CORBA_Object o ) ;

typedef struct
{
    char * opName ;
    CORBA_iServer_Func func ;
}
CORBA_iIFACE_TABLE ;

typedef struct
{
    CORBA_iIFACE_TABLE * table ;
    int size ;
}
CORBA_iIFACE_TABLES ;

typedef struct str_CORBA_BOA_OBJS
{
    CORBA_iObject * obj ;
    CORBA_IOR ior ;
    int num ;
    int socket ;
    int channel ;
    CORBA_boolean isServer ;
} 
CORBA_BOA_OBJS ;

typedef struct str_CORBA_BOA_PARAMS
{
    int connections ;
    int timeout ;
} 
CORBA_BOA_PARAMS ; 

struct str_CORBA_BOA
{
    char name[ 20 ] ;
    CORBA_iORB * orb ;
    CORBA_long addr ;
    CORBA_Function onConnect ;
    CORBA_BOA_PARAMS params ; 
    CORBA_BOA_OBJS objs[ 1 ] ;
} ; 

typedef struct str_CORBA_BOA * CORBA_BOA ;

typedef int ( * CORBA_iClientExceptionFunc )( CORBA_iObject * _o, CORBA_char * _id ) ;

typedef int ( * CORBA_rwFunc )( CORBA_Dbuff * b, ... ) ;

typedef void * ( * CORBA_seqAllocFunc )( CORBA_unsigned_long ) ;

typedef struct
{
    CORBA_unsigned_long _maximum ;
    CORBA_unsigned_long _length ;
    void * _buffer ;
}
CORBA_Generic_Sequence ;

#define CORBA_SOCKFAIL        -1
#define CORBA_BINDFAIL        -2
#define CORBA_LISTFAIL        -3
#define CORBA_ACCPTFAIL       -4
#define CORBA_HOSTNOTFND      -5
#define CORBA_CONNFAIL        -6
#define CORBA_FAILTOSEND      -7
#define CORBA_TIMEOUT         -8
#define CORBA_SOCK_CLOSE      -9

#define CORBA_DEFAULT_TIMEOUT  180 

#ifdef __cplusplus
extern "C" {
#endif

MSC_EXPORT CORBA_ORB CORBA_ORB_init( int * argc, char ** argv,
    CORBA_ORBid orb_identifier, CORBA_Environment * ev ) ;

/* C */

MSC_EXPORT void CORBA_duplicate_object( CORBA_Object trg, CORBA_Object src ) ;

MSC_EXPORT void CORBA_free_object( CORBA_iObject * o ) ;

MSC_EXPORT CORBA_char * CORBA_ORB_object_to_string( CORBA_ORB orb, CORBA_Object obj, 
    CORBA_Environment * ev ) ;

MSC_EXPORT CORBA_Object * CORBA_ORB_string_to_object( CORBA_ORB orb, CORBA_char * str, 
    CORBA_Environment * ev ) ;
    
MSC_EXPORT CORBA_BOA CORBA_BOA_init( CORBA_ORB orb, int * argc, char ** argv,
    CORBA_ORB_OAid boa_identifier, CORBA_Environment * ev ) ;

MSC_EXPORT void CORBA_BOA_set_exception( CORBA_Object obj, CORBA_Environment * ev,
    CORBA_exception_type major, CORBA_char * exceptname, void * param ) ;

MSC_EXPORT CORBA_Object CORBA_create_implementation( void * oa, CORBA_string service, 
    CORBA_iIFACE_TABLES * tables, CORBA_Environment * ev ) ;

MSC_EXPORT char ** CORBA_implements_nothing() ;

MSC_EXPORT void CORBA_add_object_ids( char ** ids ) ;

MSC_EXPORT CORBA_boolean CORBA_implements( char ** implements, const char * id ) ;

MSC_EXPORT CORBA_boolean CORBA_Object_is_a( CORBA_Object obj, const char * logical_type_id ) ;

MSC_EXPORT void CORBA_ORB_log( CORBA_Object obj, int severity, char * fmt, ... ) ;

MSC_EXPORT int CORBA_BOA_implementation_is_ready( CORBA_BOA boa, CORBA_Environment * env ) ;

void CORBA_BOA_onConnect( CORBA_BOA boa, CORBA_Function onConnect ) ;

void CORBA_unknownException( CORBA_iObject * o ) ;

MSC_EXPORT void CORBA_set_exception_handler( CORBA_iObject * o, CORBA_iServerExceptionFunc fnc ) ;

MSC_EXPORT CORBA_Object CORBA_bind( CORBA_ORB orb, CORBA_string id, CORBA_Environment * ev ) ;

MSC_EXPORT void CORBA_bind_object( CORBA_ORB Orb, CORBA_iObject * o, CORBA_string id, CORBA_Environment * ev ) ;

extern void CORBA_requestAlloc( CORBA_iObject * o, CORBA_long size ) ;

#define CORBA_malloc( size ) CORBA_alloc( CORBA_MA_FIXED, size, CORBA_FALSE )

CORBA_BOA CORBA_alloc_BOA( int conns ) ;

MSC_EXPORT extern void * CORBA_alloc( CORBA_short type, CORBA_long size, CORBA_boolean zero ) ;

MSC_EXPORT extern void * CORBA_Sequence_Alloc( CORBA_unsigned_long max ) ;

MSC_EXPORT extern void * CORBA_seqBuffAlloc( CORBA_iFreeFunc fnc, CORBA_unsigned_long size,
    CORBA_unsigned_long len ) ;

MSC_EXPORT extern void * CORBA_calloc( CORBA_long num, CORBA_long size ) ;

MSC_EXPORT extern void * CORBA_varAlloc( CORBA_iFreeFunc fnc, CORBA_long size ) ;

MSC_EXPORT extern void CORBA_free( void * p ) ;

/* extern void CORBA_Free_Variable( void * p ) ; */

MSC_EXPORT extern void CORBA_conditionalFree( void * p ) ;

MSC_EXPORT extern void CORBA_sequence_set_release( void * buff, CORBA_boolean value ) ;

#define CORBA_var_set_release( A, B ) CORBA_sequence_set_release( A, B )

#define CORBA_set_env( O, E ) *E = ( ( CORBA_iObject * )O )->buff.env

MSC_EXPORT extern CORBA_boolean CORBA_sequence_get_release( void * buff ) ;

MSC_EXPORT extern CORBA_char * CORBA_string_copy( CORBA_char * src ) ;

MSC_EXPORT extern char * CORBA_string_alloc( CORBA_unsigned_long len ) ;

MSC_EXPORT extern CORBA_wchar * CORBA_wstring_alloc( CORBA_unsigned_long len ) ;

MSC_EXPORT int CORBA_wstring_len( CORBA_wchar * src ) ;

MSC_EXPORT CORBA_wchar * CORBA_wstring_copy( CORBA_wchar * src ) ;

MSC_EXPORT extern CORBA_any * CORBA_any_alloc( void ) ;

MSC_EXPORT extern void CORBA_any_set_release( CORBA_any * any, CORBA_boolean value ) ;

MSC_EXPORT extern CORBA_boolean CORBA_any_get_release( CORBA_any * any ) ;

extern int CORBA_Dbuff_allocate( CORBA_Dbuff * buff, int size ) ;

extern void CORBA_Dbuff_free( CORBA_Dbuff * buff ) ;

extern void CORBA_dispatch( CORBA_iObject * _o ) ;

MSC_EXPORT extern int CORBA_server( CORBA_iObject * _o, int channel, CORBA_Environment * env ) ;

MSC_EXPORT extern void CORBA_request_write( CORBA_iObject * _o, char * operation, CORBA_boolean response ) ;

extern void CORBA_request_read( CORBA_iObject * o ) ;

extern void CORBA_reply_read( CORBA_iObject * o, CORBA_iClientExceptionFunc fnc ) ;

MSC_EXPORT extern void CORBA_reply_write( CORBA_Dbuff * o, CORBA_long reqId ) ;

MSC_EXPORT extern void CORBA_Reply_Write( CORBA_iObject * o ) ;

MSC_EXPORT extern int CORBA_request( CORBA_iObject * o, CORBA_iClientExceptionFunc fnc ) ;

MSC_EXPORT extern CORBA_char * CORBA_exception_id( CORBA_Environment * ev ) ;

MSC_EXPORT extern void * CORBA_exception_value( CORBA_Environment * ev ) ;

MSC_EXPORT extern CORBA_boolean CORBA_check_sys_exception( CORBA_iObject * o ) ;

MSC_EXPORT extern void CORBA_exception_free( CORBA_Environment * ev ) ;

MSC_EXPORT int CORBA_Basic_Sequence_write( CORBA_Dbuff * b,
    CORBA_Generic_Sequence * s, CORBA_unsigned_long size ) ;

MSC_EXPORT int CORBA_Basic_Sequence_read( CORBA_Dbuff * b,
    CORBA_Generic_Sequence * s, CORBA_unsigned_long size ) ;

MSC_EXPORT int CORBA_Generic_Sequence_write( CORBA_Dbuff * b,
    CORBA_Generic_Sequence * s, CORBA_rwFunc func, CORBA_unsigned_long size ) ;

MSC_EXPORT int CORBA_Generic_Sequence_read( CORBA_Dbuff * b, CORBA_Generic_Sequence * s,
    CORBA_rwFunc func, CORBA_unsigned_long size, CORBA_seqAllocFunc allocFunc ) ;

#define CORBA_object_params(A) ((CORBA_iObject*)A)->params

MSC_EXPORT extern int CORBA_boolean_read( CORBA_Dbuff * d, CORBA_boolean * v ) ;

MSC_EXPORT extern int CORBA_char_read( CORBA_Dbuff * b, CORBA_char * v ) ;

MSC_EXPORT extern int CORBA_char_write( CORBA_Dbuff * b, CORBA_char v ) ;

MSC_EXPORT extern int CORBA_octet_read( CORBA_Dbuff * b, CORBA_octet * v ) ;

MSC_EXPORT extern int CORBA_octet_write( CORBA_Dbuff * b, CORBA_octet v ) ;

MSC_EXPORT extern int CORBA_wchar_write( CORBA_Dbuff * b, CORBA_wchar v ) ;

MSC_EXPORT extern int CORBA_wchar_read( CORBA_Dbuff * b, CORBA_wchar * v ) ;

MSC_EXPORT extern int CORBA_boolean_write( CORBA_Dbuff * b, CORBA_boolean v ) ;

MSC_EXPORT extern int CORBA_short_write( CORBA_Dbuff * b, CORBA_short v ) ;

MSC_EXPORT extern int CORBA_short_read( CORBA_Dbuff * b, CORBA_short * v ) ;

MSC_EXPORT extern int CORBA_unsigned_short_write( CORBA_Dbuff * b, CORBA_unsigned_short v ) ;

MSC_EXPORT extern int CORBA_unsigned_short_read( CORBA_Dbuff * b, CORBA_unsigned_short * v ) ;

MSC_EXPORT extern int CORBA_long_write( CORBA_Dbuff * b, CORBA_long v ) ;

MSC_EXPORT extern int CORBA_long_read( CORBA_Dbuff * b, CORBA_long * v ) ;

MSC_EXPORT extern int CORBA_unsigned_long_write( CORBA_Dbuff * b, CORBA_unsigned_long v ) ;

MSC_EXPORT extern int CORBA_unsigned_long_read( CORBA_Dbuff * b, CORBA_unsigned_long * v ) ;

MSC_EXPORT extern int CORBA_long_long_write( CORBA_Dbuff * b, CORBA_long_long v ) ;

MSC_EXPORT extern int CORBA_long_long_read( CORBA_Dbuff * b, CORBA_long_long * v ) ;

MSC_EXPORT extern int CORBA_unsigned_long_long_read( CORBA_Dbuff * b, CORBA_unsigned_long_long * v ) ;

MSC_EXPORT extern int CORBA_unsigned_long_long_write( CORBA_Dbuff * b, CORBA_unsigned_long_long v ) ;

MSC_EXPORT extern int CORBA_float_read( CORBA_Dbuff * b, CORBA_float * v ) ;

MSC_EXPORT extern int CORBA_float_write( CORBA_Dbuff * b, CORBA_float v ) ;

MSC_EXPORT extern int CORBA_double_read( CORBA_Dbuff * b, CORBA_double * v ) ;

MSC_EXPORT extern int CORBA_double_write( CORBA_Dbuff * b, CORBA_double v ) ;

MSC_EXPORT extern int CORBA_long_double_read( CORBA_Dbuff * b, CORBA_long_double * v ) ;

MSC_EXPORT extern int CORBA_long_double_write( CORBA_Dbuff * b, CORBA_long_double v ) ;

MSC_EXPORT extern int CORBA_string_write( CORBA_Dbuff * b, CORBA_char * v, CORBA_long max ) ;

MSC_EXPORT extern int CORBA_string_read( CORBA_Dbuff * b, CORBA_char ** v, CORBA_long max ) ;

MSC_EXPORT extern int CORBA_wstring_write( CORBA_Dbuff * b, CORBA_wchar * v, CORBA_long max ) ;

MSC_EXPORT extern int CORBA_wstring_read( CORBA_Dbuff * b, CORBA_wchar ** v, CORBA_long max) ;

MSC_EXPORT extern int CORBA_any_write( CORBA_Dbuff * b, CORBA_any * v ) ;

MSC_EXPORT extern int CORBA_any_read( CORBA_Dbuff * b, CORBA_any * v ) ;

MSC_EXPORT extern int CORBA_Fixed_Type_Read( CORBA_Dbuff * b, CORBA_char * v, CORBA_unsigned_short size ) ;

MSC_EXPORT extern int CORBA_Fixed_Type_Write( CORBA_Dbuff * b, CORBA_char * v, CORBA_unsigned_short size ) ;

extern CORBA_Object * CORBA_Object_alloc( char * name ) ;

extern int CORBA_objref_read( CORBA_Dbuff * b, CORBA_Object * objref ) ;

extern int CORBA_objref_write( CORBA_Dbuff * b, CORBA_Object objref ) ;

MSC_EXPORT extern int CORBA_Context_write( CORBA_Dbuff * b, CORBA_Context * ctx ) ;

MSC_EXPORT extern int CORBA_Context_read( CORBA_Dbuff * b, CORBA_Context * ctx ) ;

#define ALIGN_16( P ) ( ( P % 2 ) ? P+1 : P )

extern CORBA_long ALIGN_32( CORBA_long p ) ;

extern CORBA_long ALIGN_64( CORBA_long p ) ;

extern CORBA_short CORBA_swap_short( CORBA_short * v ) ;

extern CORBA_long CORBA_swap_long( CORBA_long * v ) ;

extern CORBA_long_long CORBA_swap_long_long( CORBA_long_long * v ) ;

/* TCP/IP */

MSC_EXPORT int CORBA_ServerLoop( CORBA_Object * _o, CORBA_iIFACE_TABLES tables[] ) ;

int CORBA_ServerSetup( int port ) ;

int CORBA_Connect( int sockFd, CORBA_long * addr ) ;

MSC_EXPORT void CORBA_Disconnect( int sockFd ) ;

int CORBA_SendMsg( int sockFd, void * msg, CORBA_long size ) ;

int CORBA_RecvMsg( int sockFd, void * msg, CORBA_long size ) ;

int CORBA_receive_message( CORBA_iObject * o, int channel ) ;

int CORBA_send_message( CORBA_iObject * o, CORBA_Dbuff * buff, 
    int channel, CORBA_octet messageType ) ;

/* Type Codes */

MSC_EXPORT void CORBA_s_copy_TypeCode( CORBA_TypeCode * target, CORBA_TypeCode * src ) ;

void CORBA_TypeCode_init( CORBA_TypeCode * tc ) ;

void CORBA_TypeCode_release(  CORBA_TypeCode * type ) ;    

void CORBA_any_replace( CORBA_any * any, CORBA_TypeCode * tc, void * value, CORBA_boolean release ) ;

MSC_EXPORT CORBA_boolean CORBA_TypeCode_equal( CORBA_TypeCode * t1, CORBA_TypeCode * t2 ) ;

#define DEFAULT_PORT    7070
#define DEFAULT_TIMEOUT   60

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus

#include <iostream.h>
#include <fstream.h>

#ifdef  NAMESPACE_SUPPORTED
#define NAMESPACE_OPEN( A ) namespace A {
#define NAMESPACE_CLOSE }
#define NS_STATIC
#define NS_DATA extern
#define NS_CONST extern
#define CORBA_Fixed Fixed
#else
#define NAMESPACE_OPEN( A ) class A { public:
#define NAMESPACE_CLOSE } ;
#define NS_STATIC static 
#define NS_CONST static 
#define NS_DATA static 
#endif

#if defined( GCC ) || defined( SUN_WORKSHOP )
typedef short boolean ;
#endif

NAMESPACE_OPEN( CORBA )

    typedef short Short ;
    typedef unsigned short UShort ;
    typedef long Long ;
    typedef unsigned long ULong ;
    typedef unsigned char Boolean ;
    typedef char Char ;
    typedef unsigned char UChar ;
    typedef CORBA_wchar_t WChar ;
    typedef unsigned char Octet ;
    typedef float Float ;
    typedef double Double ;

    typedef Char * String ;
    typedef WChar * WString ;
    
    struct longdblstr
    {
        Double d1 ;
        Double d2 ;
    } ;

    typedef longdblstr LongDouble ;

    struct longlongstr
    {
        Long l1 ;
        ULong l2 ;
    } ;

    typedef longlongstr LongLong ;

    struct ulonglongstr
    {
        ULong l1 ;
        ULong l2 ;
    } ;

    typedef ulonglongstr ULongLong ;

    class Ostream ;
    class Istream ;

    class Object ;
    typedef Object * Object_ptr ;
    class Any ;

    typedef ULong Flags ;
    typedef void Status ;

#undef FALSE
#undef TRUE

    NS_CONST _ER_IMPORT Boolean FALSE ;
    NS_CONST _ER_IMPORT Boolean TRUE ;
    NS_CONST _ER_IMPORT Object_ptr nillRef ;

    inline NS_STATIC char * string_alloc( ULong len ) { return CORBA_string_alloc( len ) ; }

    inline NS_STATIC char * string_dup( const char * str ) 
    { 
        return CORBA_string_copy( ( CORBA_char * )str ) ; 
    }

    inline NS_STATIC void string_free( char * str )
    { 
        if ( str )
            CORBA_free( str ) ; 
    }
    
    // Type Codes

    class TypeCode ;
    typedef TypeCode * TypeCode_ptr ;
    
    class _ER_IMPORT TypeCode : private CORBA_TypeCode
    {
    private:
        void writeStruct( Ostream & out ) const ;
        void writeEnum( Ostream & out ) const ;
        void writeUnion( Ostream & out ) const ;
        void writeArray_and_Seq( Ostream & out ) const ;
    public:
        class Bounds {} ;
        class BadKind {} ;
        TCKind kind() const { return tc ; }
        Boolean equal( TypeCode_ptr p ) const ;
        const char * id() const ;
        const char * name() const ;
        ULong member_count() const ;
        const char * member_name( ULong index ) const ;
        TypeCode_ptr member_type( ULong index ) const ;
        Any * member_label( ULong index ) const ;
        TypeCode_ptr discriminator_type() const ;
        Long default_index() const ;
        ULong length() const ;
        TypeCode_ptr content_type() const ;
        UShort fixed_digits() const ;
        Short fixed_scale() const ;
        Long param_count() const ;
        Any *parameter(Long) const ;
        static TypeCode_ptr _duplicate( TypeCode_ptr tc ) ;
        static TypeCode_ptr _nil() ;

        // ImpDef

        TypeCode() { CORBA_TypeCode_init( this ) ; }
        TypeCode( CORBA_TypeCode * typeCode ) { CORBA_s_copy_TypeCode( this, typeCode ) ; }
        void operator=( TypeCode & v ) { CORBA_s_copy_TypeCode( this, &v ) ; }
        bool operator==( TypeCode & v ) const ;
        bool operator!=( TypeCode & v ) const ;
        void write( CORBA::Ostream & out ) const ;
        void read( CORBA::Istream & in ) ;
        
        TCKind kind() { return tc ; } 
    } ;

    NS_DATA _ER_IMPORT TypeCode tk_null ;
    NS_DATA _ER_IMPORT TypeCode tk_void ;
    NS_DATA _ER_IMPORT TypeCode tk_short ;
    NS_DATA _ER_IMPORT TypeCode tk_long ;
    NS_DATA _ER_IMPORT TypeCode tk_ushort ;
    NS_DATA _ER_IMPORT TypeCode tk_ulong ;
    NS_DATA _ER_IMPORT TypeCode tk_float ;
    NS_DATA _ER_IMPORT TypeCode tk_double ;
    NS_DATA _ER_IMPORT TypeCode tk_boolean ;
    NS_DATA _ER_IMPORT TypeCode tk_char ;
    NS_DATA _ER_IMPORT TypeCode tk_octet ;
    NS_DATA _ER_IMPORT TypeCode tk_any ;
    NS_DATA _ER_IMPORT TypeCode tk_TypeCode ;
    NS_DATA _ER_IMPORT TypeCode tk_Principal ;
    NS_DATA _ER_IMPORT TypeCode tk_objref ;
    NS_DATA _ER_IMPORT TypeCode tk_struct ;
    NS_DATA _ER_IMPORT TypeCode tk_union ;
    NS_DATA _ER_IMPORT TypeCode tk_enum ;
    NS_DATA _ER_IMPORT TypeCode tk_string ;
    NS_DATA _ER_IMPORT TypeCode tk_sequence ;
    NS_DATA _ER_IMPORT TypeCode tk_array ;
    NS_DATA _ER_IMPORT TypeCode tk_alias ;
    NS_DATA _ER_IMPORT TypeCode tk_except ;
    NS_DATA _ER_IMPORT TypeCode tk_longlong ;
    NS_DATA _ER_IMPORT TypeCode tk_ulonglong ;
    NS_DATA _ER_IMPORT TypeCode tk_longdouble ;
    NS_DATA _ER_IMPORT TypeCode tk_wchar ;
    NS_DATA _ER_IMPORT TypeCode tk_wstring ;
    NS_DATA _ER_IMPORT TypeCode tk_fixed ;

    // Exceptions
    
    enum ReplyStatus 
    {
        NO_EXCEPTION,
        USER_EXCEPTION,
        SYSTEM_EXCEPTION
    } ;

    class _ER_IMPORT Exception
    {
    protected:
        ReplyStatus m_major ;
        char * m_id ;
    public:
        Exception() { m_id = NULL ; }
        Exception( const Exception & e ) ;
        virtual ~Exception() {}
        virtual void _raise() = 0 ;

        // ImpDef
        char * id() const { return m_id ; }
        ReplyStatus major() { return m_major ; } 
    } ;
    
    enum CompletionStatus 
    {
        COMPLETED_YES,
        COMPLETED_NO,
        COMPLETED_MAYBE
    } ;

    class _ER_IMPORT SystemException : public Exception
    {
    private:
        ULong m_minor ;
        CompletionStatus m_status ;
    public:
        SystemException()
        { 
            m_major  = SYSTEM_EXCEPTION ;
            m_minor  = 0 ; 
            m_status =  COMPLETED_NO ; 
        } 

        SystemException( const SystemException & val ) : Exception( val )
        { 
            m_major  = SYSTEM_EXCEPTION ;
            m_minor  = val.m_minor ; 
            m_status = val.m_status ; 
        } 

        SystemException( ULong minor, CompletionStatus status ) 
        { 
            m_major  = SYSTEM_EXCEPTION ;
            m_minor  = minor ; 
            m_status = status ; 
        } 

        ~SystemException() {}

        SystemException & operator=( const SystemException & val )
        { 
            m_major  = SYSTEM_EXCEPTION ;
            m_minor  = val.m_minor ; 
            m_status = val.m_status ; 
            return *this ;
        } 

        static SystemException * _narrow( Exception * e )
        {
            if ( e->major() == SYSTEM_EXCEPTION )
                return ( SystemException * )e ;

            return NULL ;                
        }

        ULong minor() const { return m_minor ; }
        void minor( ULong minor ) { m_minor = minor ; }
        void _raise() { throw * this ; }
        CompletionStatus completed() const { return m_status ; }
        void completed( CompletionStatus status ) { m_status = status ; }
    } ;
    
    class _ER_IMPORT UNKNOWN : public SystemException
    {
    private:
        void init() { m_id = "UNKNOWN" ; }
    public:
        UNKNOWN() : SystemException() { init() ; }
        UNKNOWN( const SystemException & val ) : SystemException( val ) { init() ; }
        UNKNOWN( ULong minor, CompletionStatus status ) : SystemException( minor, status ) { init() ; } 
        void _raise() { throw * this ; }
    } ;

    class _ER_IMPORT BAD_PARAM : public SystemException
    {
    private:
        void init() { m_id = "BAD_PARAM" ; }
    public:
        BAD_PARAM() : SystemException() { init() ; }
        BAD_PARAM( const SystemException & val ) : SystemException( val ) { init() ; }
        BAD_PARAM( ULong minor, CompletionStatus status ) : SystemException( minor, status ) { init() ; } 
        void _raise() { throw * this ; }
    } ;

    class _ER_IMPORT NO_MEMORY : public SystemException
    {
    private:
        void init() { m_id = "NO_MEMORY" ; }
    public:
        NO_MEMORY() : SystemException() { init() ; }
        NO_MEMORY( const SystemException & val ) : SystemException( val ) { init() ; }
        NO_MEMORY( ULong minor, CompletionStatus status ) : SystemException( minor, status ) { init() ; } 
        void _raise() { throw * this ; }
    } ;

    class _ER_IMPORT INITIALIZE : public SystemException
    {
    private:
        void init() { m_id = "INITIALIZE" ; }
    public:
        INITIALIZE() : SystemException() { init() ; }
        INITIALIZE( const SystemException & val ) : SystemException( val ) { init() ; }
        INITIALIZE( ULong minor, CompletionStatus status ) : SystemException( minor, status ) { init() ; } 
        void _raise() { throw * this ; }
    } ;

    class _ER_IMPORT OBJECT_NOT_EXIST : public SystemException
    {
    private:
        void init() { m_id = "OBJECT_NOT_EXIST" ; }
    public:
        OBJECT_NOT_EXIST() : SystemException() { init() ; }
        OBJECT_NOT_EXIST( const SystemException & val ) : SystemException( val ) { init() ; }
        OBJECT_NOT_EXIST( ULong minor, CompletionStatus status ) : SystemException( minor, status ) { init() ; } 
        void _raise() { throw * this ; }
    } ;

    class _ER_IMPORT COMM_FAILURE : public SystemException
    {
    private:
        void init() { m_id = "COMM_FAILURE" ; }
    public:
        COMM_FAILURE() : SystemException() { init() ; }
        COMM_FAILURE( const SystemException & val ) : SystemException( val ) { init() ; }
        COMM_FAILURE( ULong minor, CompletionStatus status ) : SystemException( minor, status ) { init() ; } 
        void _raise() { throw * this ; }
    } ;

    class _ER_IMPORT BAD_INV_ORDER : public SystemException
    {
    private:
        void init() { m_id = "BAD_INV_ORDER" ; }
    public:
        BAD_INV_ORDER() : SystemException() { init() ; }
        BAD_INV_ORDER( const SystemException & val ) : SystemException( val ) { init() ; }
        BAD_INV_ORDER( ULong minor, CompletionStatus status ) : SystemException( minor, status ) { init() ; } 
        void _raise() { throw * this ; }
    } ;

    class _ER_IMPORT IMP_LIMIT : public SystemException
    {
    private:
        void init() { m_id = "IMP_LIMIT" ; }
    public:
        IMP_LIMIT() : SystemException() { init() ; }
        IMP_LIMIT( const SystemException & val ) : SystemException( val ) { init() ; }
        IMP_LIMIT( ULong minor, CompletionStatus status ) : SystemException( minor, status ) { init() ; } 
        void _raise() { throw * this ; }
    } ;

    class _ER_IMPORT INV_OBJREF : public SystemException
    {
    private:
        void init() { m_id = "INV_OBJREF" ; }
    public:
        INV_OBJREF() : SystemException() { init() ; }
        INV_OBJREF( const SystemException & val ) : SystemException( val ) { init() ; }
        INV_OBJREF( ULong minor, CompletionStatus status ) : SystemException( minor, status ) { init() ; } 
        void _raise() { throw * this ; }
    } ;

    class _ER_IMPORT NO_PERMISSION : public SystemException
    {
    private:
        void init() { m_id = "NO_PERMISSION" ; }
    public:
        NO_PERMISSION() : SystemException() { init() ; }
        NO_PERMISSION( const SystemException & val ) : SystemException( val ) { init() ; }
        NO_PERMISSION( ULong minor, CompletionStatus status ) : SystemException( minor, status ) { init() ; } 
        void _raise() { throw * this ; }
    } ;

    class _ER_IMPORT INTERNAL : public SystemException
    {
    private:
        void init() { m_id = "INTERNAL" ; }
    public:
        INTERNAL() : SystemException() { init() ; }
        INTERNAL( const SystemException & val ) : SystemException( val ) { init() ; }
        INTERNAL( ULong minor, CompletionStatus status ) : SystemException( minor, status ) { init() ; } 
        void _raise() { throw * this ; }
    } ;

    class _ER_IMPORT MARSHAL : public SystemException
    {
    private:
        void init() { m_id = "MARSHAL" ; }
    public:
        MARSHAL() : SystemException() { init() ; }
        MARSHAL( const SystemException & val ) : SystemException( val ) { init() ; }
        MARSHAL( ULong minor, CompletionStatus status ) : SystemException( minor, status ) { init() ; } 
        void _raise() { throw * this ; }
    } ;

    class _ER_IMPORT NO_IMPLEMENT : public SystemException
    {
    private:
        void init() { m_id = "NO_IMPLEMENT" ; }
    public:
        NO_IMPLEMENT() : SystemException() { init() ; }
        NO_IMPLEMENT( const SystemException & val ) : SystemException( val ) { init() ; }
        NO_IMPLEMENT( ULong minor, CompletionStatus status ) : SystemException( minor, status ) { init() ; } 
        void _raise() { throw * this ; }
    } ;

    class _ER_IMPORT BAD_TYPECODE : public SystemException
    {
    private:
        void init() { m_id = "BAD_TYPECODE" ; }
    public:
        BAD_TYPECODE() : SystemException() { init() ; }
        BAD_TYPECODE( const SystemException & val ) : SystemException( val ) { init() ; }
        BAD_TYPECODE( ULong minor, CompletionStatus status ) : SystemException( minor, status ) { init() ; } 
        void _raise() { throw * this ; }
    } ;

    class _ER_IMPORT BAD_OPERATION : public SystemException
    {
    private:
        void init() { m_id = "BAD_OPERATION" ; }
    public:
        BAD_OPERATION() : SystemException() { init() ; }
        BAD_OPERATION( const SystemException & val ) : SystemException( val ) { init() ; }
        BAD_OPERATION( ULong minor, CompletionStatus status ) : SystemException( minor, status ) { init() ; } 
        void _raise() { throw * this ; }
    } ;

    class _ER_IMPORT NO_RESOURCES : public SystemException
    {
    private:
        void init() { m_id = "NO_RESOURCES" ; }
    public:
        NO_RESOURCES() : SystemException() { init() ; }
        NO_RESOURCES( const SystemException & val ) : SystemException( val ) { init() ; }
        NO_RESOURCES( ULong minor, CompletionStatus status ) : SystemException( minor, status ) { init() ; } 
        void _raise() { throw * this ; }
    } ;

    class _ER_IMPORT NO_RESPONSE : public SystemException
    {
    private:
        void init() { m_id = "NO_RESPONSE" ; }
    public:
        NO_RESPONSE() : SystemException() { init() ; }
        NO_RESPONSE( const SystemException & val ) : SystemException( val ) { init() ; }
        NO_RESPONSE( ULong minor, CompletionStatus status ) : SystemException( minor, status ) { init() ; } 
        void _raise() { throw * this ; }
    } ;

    class _ER_IMPORT PERSIST_STORE : public SystemException
    {
    private:
        void init() { m_id = "PERSIST_STORE" ; }
    public:
        PERSIST_STORE() : SystemException() { init() ; }
        PERSIST_STORE( const SystemException & val ) : SystemException( val ) { init() ; }
        PERSIST_STORE( ULong minor, CompletionStatus status ) : SystemException( minor, status ) { init() ; } 
        void _raise() { throw * this ; }
    } ;

    class _ER_IMPORT TRANSIENT : public SystemException
    {
    private:
        void init() { m_id = "TRANSIENT" ; }
    public:
        TRANSIENT() : SystemException() { init() ; }
        TRANSIENT( const SystemException & val ) : SystemException( val ) { init() ; }
        TRANSIENT( ULong minor, CompletionStatus status ) : SystemException( minor, status ) { init() ; } 
        void _raise() { throw * this ; }
    } ;

    class _ER_IMPORT FREE_MEM : public SystemException
    {
    private:
        void init() { m_id = "FREE_MEM" ; }
    public:
        FREE_MEM() : SystemException() { init() ; }
        FREE_MEM( const SystemException & val ) : SystemException( val ) { init() ; }
        FREE_MEM( ULong minor, CompletionStatus status ) : SystemException( minor, status ) { init() ; } 
        void _raise() { throw * this ; }
    } ;

    class _ER_IMPORT INV_IDENT : public SystemException
    {
    private:
        void init() { m_id = "INV_IDENT" ; }
    public:
        INV_IDENT() : SystemException() { init() ; }
        INV_IDENT( const SystemException & val ) : SystemException( val ) { init() ; }
        INV_IDENT( ULong minor, CompletionStatus status ) : SystemException( minor, status ) { init() ; } 
        void _raise() { throw * this ; }
    } ;

    class _ER_IMPORT INV_FLAG : public SystemException
    {
    private:
        void init() { m_id = "INV_FLAG" ; }
    public:
        INV_FLAG() : SystemException() { init() ; }
        INV_FLAG( const SystemException & val ) : SystemException( val ) { init() ; }
        INV_FLAG( ULong minor, CompletionStatus status ) : SystemException( minor, status ) { init() ; } 
        void _raise() { throw * this ; }
    } ;

    class _ER_IMPORT INTF_REPOS : public SystemException
    {
    private:
        void init() { m_id = "INTF_REPOS" ; }
    public:
        INTF_REPOS() : SystemException() { init() ; }
        INTF_REPOS( const SystemException & val ) : SystemException( val ) { init() ; }
        INTF_REPOS( ULong minor, CompletionStatus status ) : SystemException( minor, status ) { init() ; } 
        void _raise() { throw * this ; }
    } ;

    class _ER_IMPORT BAD_CONTEXT : public SystemException
    {
    private:
        void init() { m_id = "BAD_CONTEXT" ; }
    public:
        BAD_CONTEXT() : SystemException() { init() ; }
        BAD_CONTEXT( const SystemException & val ) : SystemException( val ) { init() ; }
        BAD_CONTEXT( ULong minor, CompletionStatus status ) : SystemException( minor, status ) { init() ; } 
        void _raise() { throw * this ; }
    } ;

    class _ER_IMPORT OBJ_ADAPTER : public SystemException
    {
    private:
        void init() { m_id = "OBJ_ADAPTER" ; }
    public:
        OBJ_ADAPTER() : SystemException() { init() ; }
        OBJ_ADAPTER( const SystemException & val ) : SystemException( val ) { init() ; }
        OBJ_ADAPTER( ULong minor, CompletionStatus status ) : SystemException( minor, status ) { init() ; } 
        void _raise() { throw * this ; }
    } ;

    class _ER_IMPORT DATA_CONVERSION : public SystemException
    {
    private:
        void init() { m_id = "DATA_CONVERSION" ; }
    public:
        DATA_CONVERSION() : SystemException() { init() ; }
        DATA_CONVERSION( const SystemException & val ) : SystemException( val ) { init() ; }
        DATA_CONVERSION( ULong minor, CompletionStatus status ) : SystemException( minor, status ) { init() ; } 
        void _raise() { throw * this ; }
    } ;

    class _ER_IMPORT TRANSACTIONREQUIRED : public SystemException
    {
    private:
        void init() { m_id = "TRANSACTIONREQUIRED" ; }
    public:
        TRANSACTIONREQUIRED() : SystemException() { init() ; }
        TRANSACTIONREQUIRED( const SystemException & val ) : SystemException( val ) { init() ; }
        TRANSACTIONREQUIRED( ULong minor, CompletionStatus status ) : SystemException( minor, status ) { init() ; } 
        void _raise() { throw * this ; }
    } ;

    class _ER_IMPORT TRANSACTIONROLLEDBACK : public SystemException
    {
    private:
        void init() { m_id = "TRANSACTIONROLLEDBACK" ; }
    public:
        TRANSACTIONROLLEDBACK() : SystemException() { init() ; }
        TRANSACTIONROLLEDBACK( const SystemException & val ) : SystemException( val ) { init() ; }
        TRANSACTIONROLLEDBACK( ULong minor, CompletionStatus status ) : SystemException( minor, status ) { init() ; } 
        void _raise() { throw * this ; }
    } ;

    class _ER_IMPORT INVALIDTRANSACTION : public SystemException
    {
    private:
        void init() { m_id = "INVALIDTRANSACTION" ; }
    public:
        INVALIDTRANSACTION() : SystemException() { init() ; }
        INVALIDTRANSACTION( const SystemException & val ) : SystemException( val ) { init() ; }
        INVALIDTRANSACTION( ULong minor, CompletionStatus status ) : SystemException( minor, status ) { init() ; } 
        void _raise() { throw * this ; }
    } ;

    class _ER_IMPORT UserException : public Exception
    {
    public:
        UserException( char * id ) { m_id = id ; }
        UserException() {}
        UserException( const UserException & e ) : Exception( e ) {} ;
        ~UserException() {}
        static UserException * _narrow( Exception * e )
        {
            if ( e->major() == USER_EXCEPTION )
                return ( UserException * )e ;

            return NULL ;                
        }
        
        void _raise() { throw * this ; }
    } ;

    class _ER_IMPORT UnknownUserException : public UserException
    {
    public:
        UnknownUserException() {}
        UnknownUserException( UnknownUserException & e ) ;
        ~UnknownUserException() { string_free( m_id ) ; }
        Any & exception() ;
        static UnknownUserException * _narrow( Exception * ex ) ;
        void _raise() { throw * this ; }
        void copyId( const char * eid ) { m_id = string_dup( eid ) ; }
        void setId( char * eid ) { m_id = eid ; }
    } ;

    // String Handling
    
    class _ER_IMPORT String_var
    {
    private:
        char * ptr_ ;
    public:
        String_var() { ptr_ = NULL ; }
        
        String_var( const String_var & v ) : 
                ptr_( string_dup( v.ptr_ ) ) {}

        String_var( char * p ) : ptr_( p ) {}
        
        String_var( const char * p ) : ptr_( string_dup( p ) ) {}
        
        ~String_var() { string_free( ptr_ ) ; }
        
        String_var & operator=( const char * p ) 
        {
            string_free( ptr_ ) ;
            ptr_ = string_dup( p ) ;
            return *this ;
        }

        String_var & operator =( char * p ) 
        {
            string_free( ptr_ ) ;
            ptr_ = p ;
            return *this ;
        }
        
        String_var & operator=( const String_var & v ) 
        {
            string_free( ptr_ ) ;
            ptr_ = string_dup( v.ptr_ ) ;
            return *this ;
        }

        operator char *() const { return ptr_ ; }
        operator const char *() const { return ptr_ ; }
        char & operator[]( ULong idx ) { return ptr_[ idx ] ; }
        char operator[]( ULong idx ) const { return ptr_[ idx ] ; }
    
        const char * in() const { return ptr_ ; }
        
        char *& out() 
        {
            string_free( ptr_ ) ;
            ptr_ = NULL ;
            return ptr_ ;
        }
        
        char *& inout() { return ptr_ ; }

        char * _retn() 
        {
            char * p = ptr_ ;
            ptr_ = NULL ;
            return p ;
        }
    } ;

    class _ER_IMPORT String_out
    {
    private:

        char *& ptr_ ;

        void operator=( const String_var & ) {}

    public:

        String_out( char *& p ) : ptr_( p ) { ptr_ = NULL ; }

        String_out( String_var & p ) : ptr_( p.inout() ) {}

        String_out( const String_out & o ) : ptr_( o.ptr_ ) {}

        String_out & operator=( String_out & s ) 
        {
            ptr_ = s.ptr_ ;
            return *this ;
        }
    
        String_out & operator=( char * p ) 
        {
            ptr_ = p ;
            return *this ;
        }

        String_out & operator=( const char * p ) 
        {
            ptr_ = string_dup( p ) ;
            return *this ;
        }

        operator char*&() { return ptr_ ; } 

        char *& ptr() { return ptr_ ; }
    } ;


    // Wide String Handling
    
    inline NS_STATIC WChar * wstring_alloc( ULong len ) { return CORBA_wstring_alloc( len ) ; }

    inline NS_STATIC WChar * wstring_dup( const WChar * str ) 
    { 
        return CORBA_wstring_copy( ( CORBA_wchar * )str ) ; 
    }

    inline NS_STATIC void wstring_free( WChar * str )
    { 
        if ( str )
            CORBA_free( str ) ; 
    }
    
    
    class _ER_IMPORT WString_var
    {
    private:
        WChar * ptr_ ;
    
    public:

        WString_var();
        WString_var( const WString_var & v ) : 
                ptr_( wstring_dup( v.ptr_ ) ) {}

        WString_var( WChar * p ) : ptr_( p ) {}
        
        WString_var( const WChar * p ) : ptr_( wstring_dup( p ) ) {}
        
        ~WString_var() { wstring_free( ptr_ ) ; }
        
        WString_var & operator=( const WChar * p ) 
        {
            wstring_free( ptr_ ) ;
            ptr_ = wstring_dup( p ) ;
            return *this ;
        }

        WString_var & operator =( WChar * p ) 
        {
            wstring_free( ptr_ ) ;
            ptr_ = p ;
            return *this ;
        }
        
        WString_var & operator=( const WString_var & v ) 
        {
            wstring_free( ptr_ ) ;
            ptr_ = wstring_dup( v.ptr_ ) ;
            return *this ;
        }

        operator WChar *() { return ptr_ ; }
        operator const WChar *() const { return ptr_ ; }
        WChar &operator[]( ULong idx ) { return ptr_[ idx ] ; }
        WChar operator[]( ULong idx ) const { return ptr_[ idx ] ; }
    
        const WChar * in() const { return ptr_ ; }
        
        WChar *& out() 
        {
            wstring_free( ptr_ ) ;
            ptr_ = NULL ;
            return ptr_ ;
        }
        
        WChar *& inout() { return ptr_ ; }

        WChar * _retn() 
        {
            WChar * p = ptr_ ;
            ptr_ = NULL ;
            return p ;
        }
    } ;
    
    class _ER_IMPORT WString_out
    {
    private:

        WChar *& ptr_ ;

        void operator=( const WString_var & ) {}

    public:

        WString_out( WChar *& p ) : ptr_( p ) { ptr_ = 0 ; }

        WString_out( WString_var & p ) : ptr_( p.inout() ) {}

        WString_out( const WString_out & o ) : ptr_( o.ptr_ ) {}

        WString_out & operator=( WString_out & s ) 
        {
            ptr_ = s.ptr_ ;
            return *this ;
        }
    
        WString_out & operator=( WChar * p ) 
        {
            ptr_ = p ;
            return *this ;
        }

        WString_out & operator=( const WChar * p ) 
        {
            ptr_ = wstring_dup( p ) ;
            return *this ;
        }

        operator WChar*&() { return ptr_ ; } 

        WChar *& ptr() { return ptr_ ; }
    } ;

    class _ER_IMPORT IOstream : private CORBA_Dbuff_Str
    {
    protected:
        void setSize( ULong sz )   { curr = sz ; }
    public:
        IOstream() ;
        ~IOstream() ;
        void extend( CORBA::ULong required ) ;
        ULong size()               { return curr ; }
        ULong length()             { return len ; }
        unsigned char * buff()     { return p ; }
        unsigned char * current()  { return p + curr ; }
        void setBounds( int b )    { bounds = b ; }
        void reset() ;
    } ;
    
    class _ER_IMPORT Istream : public IOstream
    {
    private:
        // Octet flags ;
        void read( char * u, CORBA::ULong size, CORBA::ULong num ) ;
    public:
        Istream() {}
        Istream & operator>>( Short & in ) ;
        Istream & operator>>( UShort & in  ) ;
        Istream & operator>>( Long & in ) ;
        Istream & operator>>( ULong & in ) ;
        Istream & operator>>( Float & in ) ;
        Istream & operator>>( Double & in ) ;
        Istream & operator>>( Char & in ) ;
        Istream & operator>>( Octet & in ) ;
#ifndef _MSC_VER
        Istream & operator>>( WChar & in ) ;
#endif
        Istream & operator>>( String_var & in ) ;
        Istream & operator>>( LongLong & in ) ;
        Istream & operator>>( ULongLong & in ) ;
        Istream & operator>>( LongDouble & in ) ;
        Istream & operator>>( WChar * in ) ;
        Istream & operator>>( Any & in ) ;
        Istream & operator>>( Object * in ) ;
        Istream & operator>>( char *& in ) ;
        Istream & Istream::operator>>( TypeCode & v ) ;
    } ;         

    class _ER_IMPORT Ostream : public IOstream
    {
    private:
        void write( const char * u, CORBA::ULong size, CORBA::ULong num ) ;
    public:
        Ostream() {}
        Ostream & operator<<( Short out ) ;
        Ostream & operator<<( UShort out ) ;
        Ostream & operator<<( Long out ) ;
        Ostream & operator<<( ULong out ) ;
        Ostream & operator<<( Float out ) ;
        Ostream & operator<<( Double out ) ;
        Ostream & operator<<( Char out ) ;
        Ostream & operator<<( Octet out ) ;
#ifndef _MSC_VER
        Ostream & operator<<( WChar out ) ;
#endif
        Ostream & operator<<( const String_var & out ) ;
        Ostream & operator<<( const LongLong & out ) ;
        Ostream & operator<<( const ULongLong & out ) ;
        Ostream & operator<<( const LongDouble & out ) ;
        Ostream & operator<<( const WChar * out ) ;
        Ostream & operator<<( Object * out ) ;
        Ostream & operator<<( const Any & out ) ;
        Ostream & operator<<( const char * out ) ;
        Ostream & operator<<( const TypeCode & v ) ;
    } ;          

    class NamedValue ;
    typedef NamedValue * NamedValue_ptr ;
    typedef NamedValue & NamedValue_out ;

    class Request ;
    typedef Request * Request_ptr ;
    typedef Request & Request_out ;
    
    class Context ;
    typedef Context * Context_ptr ;
    typedef Context & Context_out ;
    
    class Environment ;
    typedef Environment * Environment_ptr ; 
    typedef Environment & Environment_out ; 
    
    class Policy {} ;    
    typedef Policy * Policy_ptr ;
    typedef Policy & Policy_out ;
    typedef Long PolicyType ;
    typedef Long SetOverrideType ;

    typedef void * DomainManagerList ;
    class PolicyList {} ;
    
    class NVList ;
    typedef NVList * NVList_ptr ;
    typedef NVList & NVList_out ;

    class ExceptionList ;
    typedef ExceptionList * ExceptionList_ptr ;

    class ContextList ;
    typedef ContextList * ContextList_ptr ;

    class InterfaceDef {} ;
    typedef InterfaceDef * InterfaceDef_ptr ;
    
    // Any Values 

    class _ER_IMPORT Any
    {
    private:
        // these are hidden and should not be implemented
        // so as to catch erroneous attempts to insert
        // or extract multiple IDL types mapped to unsigned char
        void operator<<=( unsigned char ) ;
        Boolean operator>>=( unsigned char & ) const ;
        void release() ; 
        TypeCode _type ;
        union 
        {
            Boolean bv ;
            Char cv ;
            WChar wcv ;
            Octet ov ;
            Short sv ;
            UShort usv ;
            Long lv ;
            ULong ulv ;
            Float fv ;
            Double dv ;
            LongDouble ldv ;
            LongLong llv ;
            ULongLong ullv ;
            void * v ;
        } _value ;
    public:
        void * operator new( size_t sz ) ;
        void operator delete( void * p ) { CORBA_free( p ) ; }
        Any() ;
        ~Any() ;
        Any( const Any & val ) ;
        Any( TypeCode_ptr tc, void * value, Boolean release = FALSE ) ;
        Any & operator=( const Any & val ) ;
        void operator<<=( Short val ) ;
        void operator<<=( UShort val ) ;
        void operator<<=( Long val ) ;
        void operator<<=( ULong val ) ;
        void operator<<=( Float val ) ;
        void operator<<=( Double val ) ;
        void operator<<=( const Any & val ) ;   // copying
        void operator<<=( Any * val ) ;         // non-copying
        void operator<<=( const char * val ) ;  // copying
        void operator<<=( char * val ) ;        // non-copying
        Boolean operator>>=( Short & val ) const ;
        Boolean operator>>=( UShort & val ) const ;
        Boolean operator>>=( Long & val ) const ;
        Boolean operator>>=( ULong & val ) const ;
        Boolean operator>>=( Float &  val ) const ;
        Boolean operator>>=( Double & val ) const ;
        Boolean operator>>=( Any *& val ) const ;
        Boolean operator>>=( char *& val ) const ;

        // special types needed for boolean, octet, char,
        // and bounded string insertion

        struct from_boolean 
        {
            from_boolean( Boolean b ) : val( b ) {}
            Boolean val ;
        } ;
        
        struct from_octet 
        {
            from_octet( Octet o ) : val( o ) {}
            Octet val ;
        } ;
        
        struct from_char 
        {
            from_char( Char c ) : val( c ) {}
            Char val ;
        } ;

        struct from_wchar 
        {
            from_wchar( WChar c ) : val( c ) {}
            WChar val ;
        } ;

        struct from_string 
        {
            from_string( char * s, ULong b, Boolean nocopy = FALSE ) : val( s ), bound( b ) {}
            char * val ;
            ULong bound ;
        } ;

        struct from_wstring 
        {
            from_wstring( WChar * s, ULong b, Boolean nocopy = FALSE ) : val( s ), bound( b ) {}
            WChar * val ;
            ULong bound ;
        } ;

        void operator<<=( from_boolean ) ;
        void operator<<=( from_char ) ;
        void operator<<=( from_wchar ) ;
        void operator<<=( from_octet ) ;
        void operator<<=( from_string ) ;
        void operator<<=( from_wstring );

        // special types needed for boolean, octet,
        // char extraction

        struct to_boolean 
        {
            to_boolean( Boolean & b ) : ref( b ) {}
            Boolean & ref ;
        } ;

        struct to_char 
        {
            to_char( Char & c ) : ref( c ) {}
            Char & ref ;
        } ;

        struct to_wchar 
        {
            to_wchar( WChar & c ) : ref( c ) {}
            WChar & ref ;
        } ;

        struct to_octet 
        {
            to_octet( Octet & o ) : ref( o ) {}
            Octet & ref ;
        } ;

        struct to_object 
        {
            to_object( Object_ptr & obj ) : ref( obj ) {}
            Object_ptr & ref ;
        } ;

        struct to_string 
        {
            to_string( char *& s, ULong b ) : val( s ), bound( b ) {}
            char *& val ;
            ULong bound ;
        } ;

        struct to_wstring 
        {
            to_wstring( WChar *& s, ULong b ) : val( s ), bound( b ) {}
            WChar *& val ;
            ULong bound ;
        } ;

        Boolean operator>>=( to_boolean ) const ;
        Boolean operator>>=( to_char    ) const ;
        Boolean operator>>=( to_wchar   ) const ;
        Boolean operator>>=( to_octet   ) const ;
        Boolean operator>>=( to_object  ) const ;
        Boolean operator>>=( to_string  ) const ;
        Boolean operator>>=( to_wstring ) const ;

        void replace( TypeCode_ptr tc, void * value, Boolean release = FALSE ) ;

        TypeCode_ptr type() const { return ( TypeCode * )&_type ; }
        const void * value() const { return &_value ; }

        // Impdef
        Ostream & os() ;
        Istream & is() const ;
        void write( CORBA::Ostream & out ) const ;
    } ;

    class _ER_IMPORT Any_var
    {
    public:
        Any_var() ;
        Any_var( Any * a ) ;
        Any_var( const Any_var & a ) ;
        ~Any_var() ; 
        Any_var & operator=( Any * a ) ;
        Any_var & operator=( const Any_var & a ) ;
        Any * operator->() ;
        const Any & in() const ;
        Any & inout() ;
        Any *& out() ;
        Any * _retn() ;
    } ;

    class _ER_IMPORT _var
    {
    public:
        void release( Object_ptr p ) ;
    } ;

    class Environment
    {
    public:
        void exception( Exception * ex ) ;
        Exception * exception() const ;
        void clear() ;
        static Environment_ptr _duplicate( Environment_ptr ev ) ;
        static Environment_ptr _nil() ;
    } ;
    
    class NamedValue
    {
    public:
        const char * name() const ;
        Any * value() const ;
        Flags flags() const ;
        static NamedValue_ptr _duplicate( NamedValue_ptr nv ) ;
        static NamedValue_ptr _nil() ;
    } ;
    
    class NVList
    {
    public:
        ULong count() const ;
        NamedValue_ptr add( Flags ) ;
        NamedValue_ptr add_item( const char * name, Flags f ) ;
        NamedValue_ptr add_value(const char * name, const Any & val, Flags f ) ;
        NamedValue_ptr add_item_consume( char * name, Flags f ) ;
        NamedValue_ptr add_value_consume( char * name, Any * val, Flags f ) ;
        NamedValue_ptr item( ULong index ) ;
        Status remove( ULong index ) ;
        static NVList_ptr _duplicate( NVList_ptr nv ) ;
        static NVList_ptr _nil() ;
    } ;
    
    class ExceptionList
    {
    public:
        ULong count();
        void add( TypeCode_ptr tc ) ;
        void add_consume( TypeCode_ptr tc ) ;
        TypeCode_ptr item( ULong index ) ;
        Status remove( ULong index ) ;
    } ;

    
    class ContextList
    {
    public:
        ULong count() ;
        void add( const char * ctxt ) ;
        void add_consume( char * ctxt ) ;
        const char * item( ULong index ) ;
        Status remove( ULong index ) ;
    } ;

    class _ER_IMPORT Object : public CORBA_iObject
    {
    private:
        Request & request() { return ( Request & )req ; }
        Request_ptr request_ptr() { return ( Request_ptr )&req ; }
    public:
        static Object_ptr _duplicate( Object_ptr obj ) ;
        static Object_ptr _nil() { return nillRef ; }
        InterfaceDef_ptr _get_interface() { return NULL ; } 
        Boolean _is_a( const char * logical_type_id ) ;
        Boolean _non_existent() ;
        Boolean _is_equivalent( Object_ptr other_object ) { return FALSE ; }
        ULong _hash( ULong maximum ) ;
        Status _create_request( Context_ptr ctx, const char * operation, NVList_ptr arg_list,
            NamedValue_ptr result, Request_out _request, Flags req_flags ) { }
        Status _create_request( Context_ptr ctx, const char * operation, 
                NVList_ptr arg_list,
                NamedValue_ptr result, 
                ExceptionList_ptr, 
                ContextList_ptr, 
                Request_out _request,
                Flags req_flags ) {}
        Request_ptr _request( const char * operation ) { return request_ptr() ; }
        Policy_ptr _get_policy( PolicyType policy_type ) ;
        DomainManagerList * _get_domain_managers() ;
        Object_ptr _set_policy_override( const PolicyList & policies, SetOverrideType set_or_add );

        Request & create_request( const char * opName, Boolean response = TRUE ) ;

        // ImpDef
        Object( const char * id = NULL ) ; 
        void setId( const char * id ) ; 
        Object( Object & toNarrow ) ; 
        virtual ~Object() { CORBA_free_object( Cobject() ) ; }
        virtual char ** implements() { return CORBA_implements_nothing() ; }
        Ostream & os() { return ( Ostream & )obuff ; }
        Istream & is() { return ( Istream & )buff ; }
        int sendMessage( int channel, CORBA_octet messageType ) ;
        int receiveMessage( int channel ) ;
        void _copy( Object_ptr tgt ) ;
        CORBA_iObject * Cobject() { return ( CORBA_iObject * )&Oadaptor ; }  // VC++ requirement
        ofstream & log() ;
    } ;
    
    class Object_var : public CORBA::_var
    {
    private:
        void operator=( const CORBA::_var & ) ; 
    
    protected:
        Object_ptr ptr_ ;
        void free() { release( ptr_ ) ; }
        void reset( Object_ptr p ) { free() ; ptr_ = p ; }
    
    public:
        Object_var() : ptr_(Object::_nil()) {}
        Object_var( Object_ptr p ) : ptr_(p) {}
        Object_var( const Object_var & a ) : ptr_( Object::_duplicate( a.in() ) ) {}
        ~Object_var() { free() ; }
    
        Object_var & operator=( Object_ptr p ) { reset( p ) ; return * this ; }
        Object_var & operator=( const Object_var & a ) 
        {
            if ( this != &a )
            {
                free() ;
                ptr_ = Object::_duplicate( a.in() ) ;
            }
            return * this ;
        }
        Object_ptr in() const { return ptr_ ; } 
        Object_ptr & inout() { return ptr_ ; } 
        Object_ptr & out() { reset( Object::_nil() ) ; return ptr_ ; } 
        Object_ptr _retn() { Object_ptr val = ptr_ ; ptr_ = Object::_nil() ; return ptr_; } 
        operator const Object_ptr & () const { return ptr_ ; }
#if XTRA_OP
        operator Object_ptr & () const { return ptr_ ; }
#endif         
        operator Object_ptr & () { return ptr_ ; }
        Object_ptr operator->() const { return ptr_ ; }
        friend class Object_out ;
    } ;
    

    // Request Object 

    class _ER_IMPORT Request : private CORBA_iRequest
    {
    private:
    public:
        Object_ptr target() const { return ( Object_ptr )obj ; }
        const char * operation() const { return opName ; }
        NVList_ptr arguments() ;
        NamedValue_ptr result() ;
        Environment_ptr env() ;
        ExceptionList_ptr exceptions() ;
        ContextList_ptr contexts() ;
        void ctx( Context_ptr ) ;
        Context_ptr ctx() const ;
        Any & add_in_arg() ;
        Any & add_in_arg( const char * name ) ;
        Any & add_inout_arg() ;
        Any & add_inout_arg( const char * name ) ;
        Any & add_out_arg() ;
        Any & add_out_arg( const char * name ) ;
        void set_return_type( TypeCode_ptr tc ) ;
        Any & return_value() ;
        Status invoke() ;
        Status send_oneway() ;
        Status send_deferred() ; 
        Status get_response() ;
        Boolean poll_response() ;
        static Request_ptr _duplicate( Request_ptr req ) ;
        static Request_ptr _nil() ;

        // ImpDef
        Request( Object_ptr = nillRef ) ;
        ~Request() ;
        void setResponse( boolean r ) { response_expected = r ; }
        void setTarget( Object_ptr o ) { obj = o ; }
        void setOperation( char * op ) ;
        void setOperation( const char * op ) ;
        ULong requestId() { return request_id ; }
        void set_request_id( CORBA::ULong rid ) { request_id = rid ; }
        void set_request_id() ;
        void header() ;
        Boolean respond() { return response_expected ; }
        void sysException( CORBA::Ostream & os, const CORBA::SystemException & sysE ) ;
        void userException( CORBA::Ostream & os, CORBA::Exception & e ) ;
    } ;

    class Context
    {
    public:
        const char * context_name() const ;
        Context_ptr parent() const ;
        Status create_child( const char * n, Context_out o ) ;
        Status set_one_value( const char * n, const Any & v ) ;
        Status set_values( NVList_ptr nv ) ;
        Status delete_values( const char * n ) ;
        Status get_values( const char * n, Flags f, const char * s, NVList_out o ) ;
        static Context_ptr _duplicate( Context_ptr ctx ) ;
        static Context_ptr _nil() ;
    } ;

    typedef Request RequestSeq[10] ; 
    typedef Long ServiceType ;
    typedef Long & ServiceInformation_out ;
    
    class POA ;
    typedef POA * POA_ptr ;

    class POA {} ;

    class ORB ;
    typedef ORB * ORB_ptr ;

    class BOA ;
    typedef BOA * BOA_ptr ;

    typedef void * OperationDef_ptr ;
    typedef void * ExceptionList_out ;
    typedef void * ContextList_out ;

    class _ER_IMPORT ORB 
    {
    public:
        char * object_to_string( Object_ptr ) ;
        Object_ptr string_to_object( const char * ) ;
        Status create_list( Long, NVList_out ) ;
        Status create_operation_list( OperationDef_ptr, NVList_out ) ;
        Status create_named_value( NamedValue_out ) ;
        Status create_exception_list( ExceptionList_out ) ;
        Status create_context_list( ContextList_out ) ;
        Status get_default_context( Context_out ) ;
        Status create_environment( Environment_out ) ;
        Status send_multiple_requests_oneway( const RequestSeq & ) ;
        Status send_multiple_requests_deferred( const RequestSeq & ) ;
        Boolean poll_next_response() ;
        Status get_next_response( Request_out ) ;
        // Obtaining initial object references
        typedef char * ObjectId ;
        class ObjectIdList {} ;
        class InvalidName {} ;
        ObjectIdList * list_initial_services() ;
        Object_ptr resolve_initial_references( const char * identifier ) ;
        Boolean work_pending() ;
        void perform_work() ;
        void shutdown( Boolean wait_for_completion ) ;
        void run() ;
        Boolean get_service_information( ServiceType svc_type, ServiceInformation_out svc_info ) ;
        static ORB_ptr _duplicate( ORB_ptr orb ) ;
        static ORB_ptr _nil() ;

        // ImpDef
        ~ORB() ;
        // void bind( Object_ptr obj, const char * service ) ;

        BOA_ptr BOA_init( int & argc, char ** argv, const char * boa_identifier = "BOA" ) ;
    } ;

    class _ER_IMPORT BOA : public str_CORBA_BOA
    {
    public:
        // BOA( CORBA_ORB o ) ;
        ~BOA() ;
        void obj_is_ready( Object_ptr obj ) ;
        int impl_is_ready() ;
    } ;

    typedef char * ORBid ;
    
    MSC_EXPORT NS_STATIC ORB_ptr ORB_init( int & argc, char ** argv, const char * orb_identifier = "" ) ;

    inline NS_STATIC void release( Object_ptr obj ) { delete obj ; }

    NS_STATIC Boolean is_nil( Object_ptr obj ) ;

    void release( Environment_ptr p ) ;
    void release( NamedValue_ptr p ) ;
    void release( NVList_ptr p ) ;
    void release( Request_ptr p ) ;
    void release( Context_ptr p ) ;
    void release( TypeCode_ptr p ) ;
    void release( POA_ptr p ) ;
    inline NS_STATIC void release( ORB_ptr p ) { delete p ; }

    Boolean is_nil( Environment_ptr p ) ;
    Boolean is_nil( NamedValue_ptr p ) ;
    Boolean is_nil( NVList_ptr p ) ;
    Boolean is_nil( Request_ptr p ) ;
    Boolean is_nil( Context_ptr p ) ;
    Boolean is_nil( TypeCode_ptr p ) ;
    Boolean is_nil( POA_ptr p ) ;
    Boolean is_nil( ORB_ptr p ) ;

#ifndef NAMESPACE_SUPPORTED
NAMESPACE_CLOSE ;
#endif

    // C++ class template
    template<CORBA::UShort d, CORBA::Short s>
    class CORBA_Fixed
    {
    public:
        // Constructors...
        CORBA_Fixed( int val = 0 ) ;
        CORBA_Fixed( CORBA::LongDouble val ) ;
        CORBA_Fixed( const CORBA_Fixed<d,s> & val ) ;
        ~CORBA_Fixed() ;
        // Conversions...    
        operator CORBA::LongDouble() const ;
        // Operators...
        CORBA_Fixed<d,s> & operator=( const CORBA_Fixed<d,s> & val ) ;
        CORBA_Fixed<d,s> & operator++() ;
        CORBA_Fixed<d,s> & operator++( int ) ;
        CORBA_Fixed<d,s> & operator--() ;
        CORBA_Fixed<d,s> & operator--( int ) ;
        CORBA_Fixed<d,s> & operator+() const ;
        CORBA_Fixed<d,s> & operator-() const ;
        int operator!() const ;
        CORBA::UShort fixed_digits() const ;
        CORBA::Short fixed_scale() const ;
    } ;


/*
#define GT31(A) (A) > 31 ? 31 : (A)
#define FTMAX(A,B) GT31( ( (A) > (B) ? (A) : (B) ) )

#define FIXED_ADDSUB_TYPE(d1,s1,d2,s2) \
  CORBA_Fixed<FTMAX(d1-s1,d2-s2)+FTMAX(s1,s2)+1,FTMAX(s1,s2)>

#define FIXED_MUL_TYPE(d1,s1,d2,s2) \
  CORBA_Fixed<GT31(d1+d2),GT31(s1,s2)>

#define FIXED_DIV_TYPE(d1,s1,d2,s2) \
  CORBA_Fixed<GT31(d1-s1+s2),FTMAX(s1,s2)>

const int tt1 = GT31(3-2) ;
const int tt2 = FTMAX(3-4,8-9) ;

// typedef FIXED_ADDSUB_TYPE(3,4,5,6) CRAP ;

    template<unsigned short d1, short s1, unsigned short d2, short s2>
    FIXED_ADDSUB_TYPE(d1,s1,d2,s2) operator+( const CORBA_Fixed<d1,s1> & val1, const CORBA_Fixed<d2,s2> & val2 ) ;

    template<unsigned short d1, short s1, unsigned short d2, short s2>
    FIXED_ADDSUB_TYPE(d1,s1,d2,s2) operator-( const CORBA_Fixed<d1,s1> & val1, const CORBA_Fixed<d2,s2> & val2 ) ;

    template<unsigned short d1, short s1, unsigned short d2, short s2>
    FIXED_MUL_TYPE(d1,s1,d2,s2) operator*( const CORBA_Fixed<d1,s1> & val1, const CORBA_Fixed<d2,s2> & val2 ) ;

    template<unsigned short d1, short s1, unsigned short d2, short s2>
    FIXED_DIV_TYPE( d1,s1,d2,s2) operator/( const CORBA_Fixed<d1,s1> & val1, const CORBA_Fixed<d2,s2> & val2 ) ;

    template<unsigned short d1, short s1, unsigned short d2, short s2>
    CORBA_Fixed<d1,s1> operator+=( const CORBA_Fixed<d1,s1> & val1, const CORBA_Fixed<d2,s2> & val2 ) ;

    template<unsigned short d1, short s1, unsigned short d2, short s2>
    CORBA_Fixed<d1,s1> operator-=( const CORBA_Fixed<d1,s1> & val1, const CORBA_Fixed<d2,s2> & val2 ) ;

    template<unsigned short d1, short s1, unsigned short d2, short s2>
    CORBA_Fixed<d1,s1> operator*=( const CORBA_Fixed<d1,s1> & val1, const CORBA_Fixed<d2,s2> & val2 ) ;

    template<unsigned short d1, short s1, unsigned short d2, short s2>
    CORBA_Fixed<d1,s1> operator/=( const CORBA_Fixed<d1,s1> & val1, const CORBA_Fixed<d2,s2> & val2 ) ;

    template<unsigned short d1, short s1, unsigned short d2, short s2>
    int operator>( const CORBA_Fixed<d1,s1> & val1, const CORBA_Fixed<d2,s2> & val2 ) ;

    template<unsigned short d1, short s1, unsigned short d2, short s2>
    int operator<( const CORBA_Fixed<d1,s1> & val1, const CORBA_Fixed<d2,s2> & val2 ) ;

    template<unsigned short d1, short s1, unsigned short d2, short s2>
    int operator>=( const CORBA_Fixed<d1,s1> & val1, const CORBA_Fixed<d2,s2> & val2 );

    template<unsigned short d1, short s1, unsigned short d2, short s2>
    int operator<=( const CORBA_Fixed<d1,s1> & val1, const CORBA_Fixed<d2,s2> & val2 ) ;

    template<unsigned short d1, short s1, unsigned short d2, short s2>
    int operator==( const CORBA_Fixed<d1,s1> & val1, const CORBA_Fixed<d2,s2> & val2 ) ;
    
    template<unsigned short d1, short s1, unsigned short d2, short s2>
    int operator!=( const CORBA_Fixed<d1,s1> & val1, const CORBA_Fixed<d2,s2> & val2 ) ;

    */
#ifdef NAMESPACE_SUPPORTED
#undef CORBA_Fixed
#define CORBA_Fixed CORBA::Fixed
NAMESPACE_CLOSE ;
#endif

/*
template<unsigned short d1, unsigned short s1>
    CORBA::Istream & operator>>( CORBA::Istream & is, CORBA_Fixed<d1,s1> & val ) ;

template<unsigned short d1, unsigned short s1>
    CORBA::Ostream & operator<<( CORBA::Ostream& os, const CORBA_Fixed<d1,s1> & val ) ;)))
    */

NAMESPACE_OPEN( ERCORBA )

    // Sequences

    class Sequence
    {
    private:
    protected:
        CORBA::ULong max, len ;
        CORBA::Boolean release ;
        virtual CORBA::ULong size() const = 0 ;
        void * ptr ;
        void set( CORBA::ULong Max, CORBA::ULong l, void * data ) 
        { 
            max = Max ; 
            len = l ; 
            release = CORBA::TRUE ; 
            ptr = data ; 
        }
        void * idx( int index ) 
        { 
            if ( index > len )
                return NULL ;

            return ( char * )ptr + ( size() * index ) ;                
        }                
        const void * idx( int index ) const
        { 
            if ( index > len )
                return NULL ;

            return ( char * )ptr + ( size() * index ) ;                
        }                
    public:
        Sequence( CORBA::ULong Max = 0 ) 
        { 
            max = Max ; 
            len = 0 ; 
            release = CORBA::FALSE ; 
            ptr = NULL ; 
        }
        Sequence( CORBA::ULong length, void * data, CORBA::Boolean _release ) 
        { 
            len = length ; 
            release = _release ; 
            ptr = data ; 
        }
        void setRelease( CORBA::Boolean _release = CORBA::TRUE ) ;
    } ;

NAMESPACE_CLOSE


NAMESPACE_OPEN( PortableServer )

    class _ER_IMPORT ServantBase : public CORBA::Object
    {
    public:
        virtual ~ServantBase() {} ;
        ServantBase & operator=( const ServantBase & v ) ;
        virtual CORBA::POA_ptr _default_POA() { return NULL ; }
        virtual int dispatch( char * operation ) = 0 ;
        virtual int server( int channel ) ;
    protected:
        ServantBase() {}
        ServantBase( const ServantBase & v ) {}
    } ;

    typedef ServantBase * Servant ;

NAMESPACE_CLOSE

MSC_EXPORT ostream & operator<<( ostream & os, const CORBA::Exception & e ) ;

CORBA::Ostream & operator<<( CORBA::Ostream & os, CORBA::Request & r ) ;

CORBA::Istream & operator>>( CORBA::Istream & is, CORBA::Request & r ) ;


#endif

#endif


#if 0

#endif


