/**
*       orbtypes.h
*       ----------
*
*       CORBA Include header for 'C' base types. 
*       Also used by the C++ ORB
*
*       Copyright Mitch Britton 1998-1999
*       All Rights Reserved
*       See the file licence.txt
*
**/

#ifndef __CTYPES_H
#define __CTYPES_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>

#ifdef GCC
#define UNIX
#endif

#ifdef UNIX
#ifndef NULL
#define NULL (void*)0
#endif
#define closesocket(A) close(A)
#include <unistd.h>
#else
#include <wtypes.h> 
#endif

#if defined(__BORLANDC__)
    
    /* defined for the Borland C++ compiler */

    #define _Win32
    #ifndef _ER_IMPORT
    #define _ER_IMPORT __import
    #endif 
    
    #define MSC_EXPORT
    #define BC_EXPORT  

    #ifndef NAMESPACE
    #define NAMESPACE_SUPPORTED 1
    #endif 

#elif defined(_MSC_VER)

    /* defined for Visual C++ compiler */

    #define _Win32
    #ifndef _ER_IMPORT
    #define _ER_IMPORT __declspec(dllimport)
    #endif 

    #define MSC_EXPORT _ER_IMPORT
    #define BC_EXPORT  

    #ifndef NAMESPACE
    #define NAMESPACE_SUPPORTED 1
    #endif 

#else

    #ifndef _ER_IMPORT
    #define _ER_IMPORT
    #endif 

    #define MSC_EXPORT _ER_IMPORT
    #define BC_EXPORT  

#endif

#ifdef _EXP
    #undef _ER_IMPORT
    #if defined(__BORLANDC__)

        #undef BC_EXPORT
        #define BC_EXPORT __export
        #define _ER_IMPORT BC_EXPORT

    #elif defined(_MSC_VER)

        #undef MSC_EXPORT
        #define MSC_EXPORT __declspec(dllexport)
        #define _ER_IMPORT MSC_EXPORT

    #else
    #endif
#endif

#ifdef __cplusplus
#define EXTERN_C extern "C"
#else
#define EXTERN_C extern
#endif

#ifndef ENDIAN
#ifdef _Win32
/* little endian */
#define ENDIAN 1
#else
#define ENDIAN 0
#endif
#endif

#define CORBA_TRUE  ( CORBA_boolean )1
#define CORBA_FALSE ( CORBA_boolean )0

typedef wchar_t CORBA_wchar_t ;

typedef short CORBA_short ;

typedef unsigned short CORBA_unsigned_short ;

typedef long CORBA_long ;

typedef unsigned long CORBA_unsigned_long ;

typedef struct
{
    CORBA_long l1 ;
    CORBA_unsigned_long l2 ;
}
CORBA_long_long ;

typedef struct
{
    CORBA_unsigned_long l1 ;
    CORBA_unsigned_long l2 ;
}
CORBA_unsigned_long_long ;

typedef unsigned char CORBA_boolean ;

typedef char CORBA_char ;

typedef CORBA_wchar_t CORBA_wchar ;

typedef unsigned char CORBA_octet ;

typedef float CORBA_float ;

typedef double CORBA_double ;

typedef CORBA_long CORBA_enum ;

typedef struct
{
    CORBA_double l1 ;
    CORBA_double l2 ;
}
CORBA_long_double ;

typedef enum TCKind
{
    CORBA_tk_null       = 0,
    CORBA_tk_void       = 1,
    CORBA_tk_short      = 2,
    CORBA_tk_long       = 3,
    CORBA_tk_ushort     = 4,
    CORBA_tk_ulong      = 5,
    CORBA_tk_float      = 6,
    CORBA_tk_double     = 7,
    CORBA_tk_boolean    = 8,
    CORBA_tk_char       = 9,
    CORBA_tk_octet      = 10,
    CORBA_tk_any        = 11,
    CORBA_tk_TypeCode   = 12,
    CORBA_tk_Principal  = 13,
    CORBA_tk_objref     = 14,
    CORBA_tk_struct     = 15,
    CORBA_tk_union      = 16,
    CORBA_tk_enum       = 17,
    CORBA_tk_string     = 18,
    CORBA_tk_sequence   = 19,
    CORBA_tk_array      = 20,
    CORBA_tk_alias      = 21,
    CORBA_tk_except     = 22,
    CORBA_tk_longlong   = 23,
    CORBA_tk_ulonglong  = 24,
    CORBA_tk_longdouble = 25,
    CORBA_tk_wchar      = 26,
    CORBA_tk_wstring    = 27,
    CORBA_tk_fixed      = 28,
    CORBA_tk_none       = 0xFFFFFFFF
} 
CORBA_TCKind ;

typedef struct _str_CORBA_TypeCode
{
    CORBA_TCKind tc ;
    char * _id ;
    char * _name ;
    void * _ptr ;
} 
CORBA_TypeCode ;

#ifdef __cplusplus
extern "C" {
#endif

#ifdef SUN_WORKSHOP
typedef short bool ;
#endif

extern _ER_IMPORT CORBA_TypeCode CORBA__tk_null ;
extern _ER_IMPORT CORBA_TypeCode CORBA__tk_void ;
extern _ER_IMPORT CORBA_TypeCode CORBA__tk_short ;
extern _ER_IMPORT CORBA_TypeCode CORBA__tk_long ;
extern _ER_IMPORT CORBA_TypeCode CORBA__tk_ushort ;
extern _ER_IMPORT CORBA_TypeCode CORBA__tk_ulong ;
extern _ER_IMPORT CORBA_TypeCode CORBA__tk_float ;
extern _ER_IMPORT CORBA_TypeCode CORBA__tk_double ;
extern _ER_IMPORT CORBA_TypeCode CORBA__tk_boolean ;
extern _ER_IMPORT CORBA_TypeCode CORBA__tk_char ;
extern _ER_IMPORT CORBA_TypeCode CORBA__tk_octet ;
extern _ER_IMPORT CORBA_TypeCode CORBA__tk_any ;
extern _ER_IMPORT CORBA_TypeCode CORBA__tk_TypeCode ;
extern _ER_IMPORT CORBA_TypeCode CORBA__tk_Principal ;
extern _ER_IMPORT CORBA_TypeCode CORBA__tk_objref ;
extern _ER_IMPORT CORBA_TypeCode CORBA__tk_struct ;
extern _ER_IMPORT CORBA_TypeCode CORBA__tk_union ;
extern _ER_IMPORT CORBA_TypeCode CORBA__tk_enum ;
extern _ER_IMPORT CORBA_TypeCode CORBA__tk_string ;
extern _ER_IMPORT CORBA_TypeCode CORBA__tk_sequence ;
extern _ER_IMPORT CORBA_TypeCode CORBA__tk_array ;
extern _ER_IMPORT CORBA_TypeCode CORBA__tk_alias ;
extern _ER_IMPORT CORBA_TypeCode CORBA__tk_except ;
extern _ER_IMPORT CORBA_TypeCode CORBA__tk_longlong ;
extern _ER_IMPORT CORBA_TypeCode CORBA__tk_ulonglong ;
extern _ER_IMPORT CORBA_TypeCode CORBA__tk_longdouble ;
extern _ER_IMPORT CORBA_TypeCode CORBA__tk_wchar ;
extern _ER_IMPORT CORBA_TypeCode CORBA__tk_wstring ;
extern _ER_IMPORT CORBA_TypeCode CORBA__tk_fixed ;

#ifdef __cplusplus
}
#endif

typedef struct _str_CORBA_StructMember
{
    char * name ;
    void * tc ;
    void * p ;
} 
CORBA_StructMember ;

typedef struct _str_CORBA_StructMemberSeq
{
    CORBA_long num ;
    CORBA_StructMember * members ;
} 
CORBA_StructMemberSeq ;

typedef struct _str_CORBA_UnionMember
{
    long value ;
    char * name ;
    void * tc ;
} 
CORBA_UnionMember ;

typedef struct _str_CORBA_Union_TC
{
    void * discriminant ;
    CORBA_long defUsed ;
    CORBA_unsigned_long num ;
    CORBA_UnionMember * members ;
} 
CORBA_Union_TC ;

typedef struct _str_CORBA_Array_And_Sequence_Types
{
    CORBA_long baseTc ;     /* base type (array or sequence)    */
    CORBA_long size ;       /* length               */ 
    void * tc ;             /* element type         */
} 
CORBA_Array_TypeCode, CORBA_Sequence_TypeCode ;
    
typedef struct _str_CORBA_Enum_TypeCode
{
    CORBA_long count ;
    char ** members ;
} 
CORBA_Enum_TypeCode ;

typedef struct
{
    CORBA_TypeCode _type ;
    void * _value ;
}
CORBA_any ;

typedef void * CORBA_ORB ;

typedef char * CORBA_string ;

typedef CORBA_string CORBA_ORBid, CORBA_ORB_OAid ;

typedef void * CORBA_Object ;

#define CORBA_OBJECT_NIL ( CORBA_Object )0L

typedef CORBA_short CORBA_exception_type ;

/* Exceptions */

#define CORBA_NO_EXCEPTION       0
#define CORBA_USER_EXCEPTION     1
#define CORBA_SYSTEM_EXCEPTION   2

#define CORBA_COMPLETED_YES      0
#define CORBA_COMPLETED_NO       1
#define CORBA_COMPLETED_MAYBE    2

#define ex_CORBA_UNKNOWN               "UNKNOWN"        /* the unknown exception */
#define ex_CORBA_BAD_PARAM             "BAD_PARAM"      /* an invalid parameter was passed */
#define ex_CORBA_NO_MEMORY             "NO_MEMORY"      /* dynamic memory allocation failure */
#define ex_CORBA_IMP_LIMIT             "IMP_LIMIT"      /* violated implementation limit */
#define ex_CORBA_COMM_FAILURE          "COMM_FAILURE"   /* communication failure */
#define ex_CORBA_INV_OBJREF            "INV_OBJREF"     /* invalid object reference */
#define ex_CORBA_NO_PERMISSION         "NO_PERMISSION"  /* no permission for attempted op. */
#define ex_CORBA_INTERNAL              "INTERNAL"       /* ORB internal error */
#define ex_CORBA_MARSHAL               "MARSHAL"        /* error marshalling param/result */
#define ex_CORBA_INITIALIZE            "INITIALIZE"     /* ORB initialization failure */
#define ex_CORBA_NO_IMPLEMENT          "NO_IMPLEMENT"   /* operation implementation unavailable */
#define ex_CORBA_BAD_TYPECODE          "BAD_TYPECODE"   /* bad typecode */
#define ex_CORBA_BAD_OPERATION         "BAD_OPERATION"  /* invalid operation */
#define ex_CORBA_NO_RESOURCES          "NO_RESOURCES"   /* insufficient resources for req. */
#define ex_CORBA_NO_RESPONSE           "NO_RESPONSE"    /* response to req. not yet */
#define ex_CORBA_PERSIST_STORE         "PERSIST_STORE"  /* persistent storage failure */
#define ex_CORBA_BAD_INV_ORDER         "BAD_INV_ORDER"  /* routine invocations out of order */
#define ex_CORBA_TRANSIENT             "TRANSIENT"      /* transient failure - reissue */
#define ex_CORBA_FREE_MEM              "FREE_MEM"       /* cannot free memory */
#define ex_CORBA_INV_IDENT             "INV_IDENT"      /* invalid identifier syntax */
#define ex_CORBA_INV_FLAG              "INV_FLAG"       /* invalid flag was specified */
#define ex_CORBA_INTF_REPOS            "INTF_REPOS"     /* error accessing interface */
#define ex_CORBA_BAD_CONTEXT           "BAD_CONTEXT"    /* error processing context object */
#define ex_CORBA_OBJ_ADAPTER           "OBJ_ADAPTER"    /* failure detected by object */
#define ex_CORBA_DATA_CONVERSION       "DATA_CONVERSION" /* data conversion error */
#define ex_CORBA_OBJECT_NOT_EXIST      "OBJECT_NOT_EXIST" /* non-existent object, delete */
#define ex_CORBA_TRANSACTIONREQUIRED   "TRANSACTIONREQUIRED" /* transaction required */
#define ex_CORBA_TRANSACTIONROLLEDBACK "TRANSACTIONROLLEDBACK"  /* transaction rolled back */
#define ex_CORBA_INVALIDTRANSACTION    "INVALIDTRANSACTION"  /* invalid transaction */

/* Memory allocation */

typedef CORBA_long ( * CORBA_iFreeFunc )( void * v ) ;

#define CORBA_MA_FIXED      0x0
#define CORBA_MA_SEQ        0x1
#define CORBA_MA_VAR        0x2
#define CORBA_MA_OBJECT     0x3
#define CORBA_MA_SIZED_MEM  0x4
#define CORBA_MA_ANY        0x5

#define CORBA_MA_OWNS   0x1

typedef struct
{
    CORBA_unsigned_long length ;
    CORBA_octet * data ;
}
CORBA_Sequence ;

typedef struct
{
    CORBA_unsigned_long minor_code_value ;       /* minor code (for system exceptions */
    CORBA_unsigned_long completion_status ;
}
CORBA_System_Exception ;

typedef struct CORBA_Env_Str
{
    CORBA_exception_type _major ;       /* major code                        */
    CORBA_char * id ;                   /* exception id                      */
    CORBA_System_Exception sysExcept ;
    void * value ;                      /* exception value                   */
}
CORBA_Environment ;

typedef struct CORBA_Ctx_Str
{
    char a[ 20 ] ;
}
CORBA_Context ;

typedef int ( * CORBA_streamFunc )( unsigned char * buff, int size ) ;

typedef struct CORBA_Dbuff_Str
{
    CORBA_boolean isCpp ;
    CORBA_long len ;        /* length of buffer                             */
    CORBA_long curr ;       /* current position                             */
    CORBA_long offset ;     /* Alignment offset                             */
    CORBA_long bounds ;     /* Current bound length (strings and sequences) */
    CORBA_octet endian ;    /* Data is big endian (0) or little endian (1)  */
    CORBA_Environment env ; /* Environment for exceptions                   */
    unsigned char * p ;     /* buffer pointer                               */
}
CORBA_Dbuff ;

#endif


