# Make file
# Copyright Mitch Britton 1998-1999
# All Rights Reserved
# See the file licence.txt

!include ..\bc32.mak

FLAGS               = ..\bci
CORBA_TCPIP_DLL     = ..\bin\orb.dll
CORBA_TCPIP_DLL_RSP = orbtcpip.rsp
O_ORB               = tcpip tcpip_s syserr corbac server corbacpp data IOP 
OBJS_ORB            = tcpip.obj tcpip_s.obj syserr.obj corbac.obj server.obj \
                      corbacpp.obj data.obj IOP.obj 
CC                  = $(CC) -D_EXP -D_Win32
IOP_H               = ../h/IOP.h

all:    $(FLAGS) orb 

$(FLAGS): ..\bc32.mak bc32.mak
    echo $(CWE) $(BEFORE_FLAGS) > $(FLAGS)
    

orb:    $(CORBA_TCPIP_LIB)

force:  clean all

regen:  clean gen all

gen:    $(IOP_H)

clean:
        del *.obj
        del *.lib
        del *.rsp
        del *.exe
        del *.bak
        del *.err

$(CORBA_TCPIP_DLL_RSP): bc32.mak
        echo $(STARTOBJD) $(O_ORB) > $@
        echo $(CORBA_TCPIP_DLL) >>  $@
        echo dll.map >>  $@
        echo $(SLIB_MT) >> $@

$(CORBA_TCPIP_DLL):  $(CORBA_TCPIP_DLL_RSP) $(OBJS_ORB)
        echo ---- Making $@ ----
        $(LINKER) $(LKFLAGSD) @$(CORBA_TCPIP_DLL_RSP)

$(CORBA_TCPIP_LIB):    $(CORBA_TCPIP_DLL)
        echo ---- Making $@ ----
        $(IMPLIB) $@ $(CORBA_TCPIP_DLL)

$(IOP_H):   ../engroom/IOP.idl
           java idl -c ../engroom/IOP
           del IOP_c.c
           del IOP_s.c
           del IOP.bas
           copy IOP*.h ..\h 
           del IOP*.h
