/**
*       corba_i.h
*       ---------
*
*       Internal CORBA header file
*
*
*       Copyright Mitch Britton 1998-1999
*       All Rights Reserved
*       See the file licence.txt
*
**/

#define SIZEOF_CORBA_BOA( A ) ( sizeof( struct str_CORBA_BOA ) + ( ( A -1 ) * sizeof( CORBA_BOA_OBJS ) ) )

#define COI_MIN_BASE    20000
#define CM_VAL(A) (A+COI_MIN_BASE)

#define COI_MIN_NO_CLIENT_CONNECT   CM_VAL(1)  /* can't connect to client */
#define COI_MIN_SOCK_TO             CM_VAL(2)  /* Socket timeout          */
#define COI_MIN_CANT_START_OBJ      CM_VAL(3)  /* The ORB can't find or start the implementation */

#define COI_OBJ(A) ((CORBA_iObject*)A)

#define CORBA_resetpBuff( B )       B->curr = 0

#define BOA_FROM_OBJ(A) ( ( CORBA_BOA )A->Oadaptor )
#define ORB_FROM_OBJ(A) ( BOA_FROM_OBJ( A )->orb )
#define BOA_OBJ(A)      BOA_FROM_OBJ(A)->objs[ A->adaptorSlot ]
#define OBJ_CHANNEL(A)  BOA_OBJ(A).channel 
#define CPP_OBJ(OB)    ( OB->buff.isCpp )
#define THROW_OENV(OB) ( OB->buff.isCpp ? NULL : &OB->buff.env )
#define THROW_BENV(B)  ( (B)->isCpp ? NULL : &(B)->env )
#define CORBA_read_endian( B ) CORBA_octet_read( (B), &(B)->endian )
#define CORBA_write_endian( B ) CORBA_octet_write( (B), ENDIAN )

#define GIOP_MESSAGEHEADER_SIZE     12 

#define LOG_SYS_ERR 0 

#define EX_CORBA_UNKNOWN                 0
#define EX_CORBA_BAD_PARAM               1
#define EX_CORBA_NO_MEMORY               2
#define EX_CORBA_IMP_LIMIT               3
#define EX_CORBA_COMM_FAILURE            4
#define EX_CORBA_INV_OBJREF              5
#define EX_CORBA_NO_PERMISSION           6
#define EX_CORBA_INTERNAL                7
#define EX_CORBA_MARSHAL                 8
#define EX_CORBA_INITIALIZE              9
#define EX_CORBA_NO_IMPLEMENT           10
#define EX_CORBA_BAD_TYPECODE           11
#define EX_CORBA_BAD_OPERATION          12
#define EX_CORBA_NO_RESOURCES           13
#define EX_CORBA_NO_RESPONSE            14
#define EX_CORBA_PERSIST_STORE          15
#define EX_CORBA_BAD_INV_ORDER          16
#define EX_CORBA_TRANSIENT              17
#define EX_CORBA_FREE_MEM               18
#define EX_CORBA_INV_IDENT              19
#define EX_CORBA_INV_FLAG               20
#define EX_CORBA_INTF_REPOS             21
#define EX_CORBA_BAD_CONTEXT            22
#define EX_CORBA_OBJ_ADAPTER            23
#define EX_CORBA_DATA_CONVERSION        24
#define EX_CORBA_OBJECT_NOT_EXIST       25
#define EX_CORBA_TRANSACTIONREQUIRED    26
#define EX_CORBA_TRANSACTIONROLLEDBACK  27
#define EX_CORBA_INVALIDTRANSACTION     28


#ifdef __cplusplus
extern "C" {
#endif

void CORBA_CancelRequest( CORBA_iObject * obj, CORBA_Environment * env ) ;

void CORBA_LocateRequest( CORBA_iObject * obj, int socket, CORBA_Environment * env ) ;

CORBA_char * CORBA_getRepId( CORBA_Object obj ) ;

void CORBA_init_object( CORBA_iObject * obj ) ;

void CORBA_free_ORB( CORBA_iORB * orb ) ;

void CORBA_request_free( CORBA_iRequest * req ) ;

CORBA_ORB CORBA_iORB_init( int * argc, char ** argv,
    CORBA_ORBid orb_identifier, CORBA_Environment * ev ) ;

int CORBA_Dbuff_write( CORBA_Dbuff * buff, char * u, 
    CORBA_unsigned_long size, CORBA_unsigned_long num ) ;

int CORBA_Dbuff_read( CORBA_Dbuff * buff, char * tgt, 
    CORBA_unsigned_long size, CORBA_unsigned_long num ) ;

void CORBA_Dbuff_reset( CORBA_Dbuff * buff ) ;

void CORBA_request_init( CORBA_iRequest * r ) ;

void CORBA_Request_read( CORBA_Dbuff * buff, CORBA_iRequest * req ) ;

void CORBA_Request_write( CORBA_Dbuff * buff, CORBA_iRequest * req ) ;

void CORBA_Request_set( CORBA_iRequest * req, CORBA_iObject * o ) ;

void CORBA_Dbuff_Init( CORBA_Dbuff * buff ) ;

int serverLoop( CORBA_BOA boa, CORBA_Environment * env ) ;

int CORBA_cppServer( CORBA_iObject * obj, int channel ) ;

void CORBA_throw_system_exception( CORBA_Environment * ev, int err, 
    CORBA_unsigned_long minor, CORBA_unsigned_long compStatus ) ;

CORBA_iORB * CORBA_alloc_ORB( CORBA_char * orbId ) ;

void _CORBA_BOA_object_is_ready( CORBA_BOA boa, CORBA_iObject * obj, 
    CORBA_char * service, CORBA_Environment * env ) ;

void * CORBA_get_log( CORBA_iObject * o ) ;

void CORBA_getPID( unsigned long * pid, unsigned long * tid ) ;

void CORBA_free_object( CORBA_iObject * o ) ;

CORBA_short CORBA_swap_short( CORBA_short * v ) ;

CORBA_long CORBA_swap_long( CORBA_long * v ) ;

CORBA_long_long CORBA_swap_long_long( CORBA_long_long * v ) ;

MSC_EXPORT char * CORBA_inetAddr( unsigned int addr, long port ) ;

MSC_EXPORT long BC_EXPORT CORBA_string_to_inetAddr( char * str, CORBA_unsigned_long * addr ) ;

MSC_EXPORT void CORBA_ORB_Params( int * argc, char ** argv, CORBA_iORB * orb ) ;

CORBA_iObject * CORBA_alloc_object( void ) ;

CORBA_long CORBA_getLocalAddress( void ) ;

/* EXTERN_C int CORBA_ServerSocket( CORBA_short port ) ; */

int CORBA_waitForConnect( int sockFd, CORBA_long * addr ) ;

MSC_EXPORT int CORBA_Listen( int sockFd ) ;

MSC_EXPORT int BC_EXPORT CORBA_getSocket( CORBA_long port ) ;

int CORBA_getSockAddr( int sock, CORBA_long * addr, CORBA_long * port ) ;

CORBA_long CORBA_getPort( CORBA_long * addr ) ;

int CORBA_ClientConnect( char * server, long addr, int port ) ;

void initMsgHdr( GIOP_MessageHeader_1_1 * hdr, CORBA_octet minor ) ;

int CORBA_getMsgHdr( int channel, GIOP_MessageHeader_1_1 * msgHdr ) ;

CORBA_BOA_OBJS * CORBA_BOA_find_slot( CORBA_BOA boa, CORBA_iObject * o ) ;

MSC_EXPORT int CORBA_sockErr( char * msg ) ;

void _string_to_object( CORBA_ORB orb, CORBA_char * str, CORBA_iObject * o, CORBA_Environment * ev ) ;

#ifdef __cplusplus
}
#endif
