//
//      corbacpp.cpp
//      ------------
//
//      Base CORBA Module for C++
//
//
//      Copyright Mitch Britton 1998-1999
//      All Rights Reserved
//      See the file licence.txt
//
//

//
//      Compilation Switches and Definitions
//      ------------------------------------
//


//
//       Header Files
//       ------------
//

#include <stdio.h>
#include <corba.h>
#include "corba_i.h"


//
//       External Data
//       -------------
//

//
//       Internal Global Data
//       --------------------
//

class ORB_Holder
{
#define MAX_ORBS 200 
private:
    CORBA_ORB orbs[ MAX_ORBS ] ;    
    int count ;
public:
    ORB_Holder() ;
    ~ORB_Holder() ;
    CORBA::ORB_ptr add( CORBA_ORB orb ) ;
} ;

static ORB_Holder orbHolder ;


//
//       Internal Function Declarations
//       ------------------------------
//

//
//       External Function Declarations
//       ------------------------------
//

//
//       Public Global Data
//       ------------------
//


//
//       Methods
//       -------
//


ORB_Holder::ORB_Holder()
{
    count = 0 ;
}

CORBA::ORB_ptr ORB_Holder::add( CORBA_ORB orb )
{
    if ( count + 1 == MAX_ORBS )
    {
        cerr << "Max number of ORBS exceeded" ;
        return NULL ;
    }
    
    orbs[ count ] = orb ;
    
    count++ ;
    
    return ( CORBA::ORB_ptr )orb ;
}

ORB_Holder::~ORB_Holder()
{
    for ( int i = 0 ; i < count ; i++ )
    {
        CORBA_free( orbs[ i ] ) ;
    }
}

void CORBA::_var::release( CORBA::Object_ptr p )
{ 
    delete p ; 
}

MSC_EXPORT CORBA::ORB_ptr BC_EXPORT CORBA::ORB_init( int & argc, char ** argv, 
    const char * orb_identifier )
{
    CORBA_ORB orb = CORBA_ORB_init( &argc, argv, ( char * )orb_identifier, NULL ) ;

    CORBA_iORB * o = ( CORBA_iORB * )orb ;

    if ( o->logName )
    {
        o->cppLog = new ofstream( fileno( o->log ) ) ; 
    }
    else
        o->cppLog = cerr ;

    return orbHolder.add( orb ) ;
}

 
ofstream & CORBA::Object::log()
{
    CORBA_iORB * orb = ( CORBA_iORB * )ORB_FROM_OBJ( this->Cobject() ) ;
    
    return *( ( ofstream * )orb->cppLog ) ;
}

CORBA::BOA_ptr CORBA::ORB::BOA_init( int & argc, char ** argv, const char * boa_identifier )
{
    CORBA_BOA boa = CORBA_BOA_init( ( CORBA_ORB )this, &argc, argv, 
        ( char * )boa_identifier, NULL ) ;

    return ( CORBA::BOA_ptr )boa ;
}

char * CORBA::ORB::object_to_string( CORBA::Object_ptr obj )
{
    return CORBA_ORB_object_to_string( this, obj->Cobject(), NULL ) ;
}

CORBA::Object_ptr CORBA::ORB::string_to_object( const char * ior )
{
    CORBA::Object_ptr o = new CORBA::Object() ;

    _string_to_object( this, ( CORBA_char * )ior, o->Cobject(), NULL ) ;
    
    return o ;
}

CORBA::Exception::Exception( const CORBA::Exception & e )
{ 
    m_major = e.m_major ;
    m_id    = e.m_id ;
}
        
CORBA::UnknownUserException::UnknownUserException( CORBA::UnknownUserException & e )
{ 
    m_id = string_dup( e.m_id ) ; 
}
        
MSC_EXPORT ostream & BC_EXPORT operator<<( ostream & os, const CORBA::Exception & e )
{
    os << "Exception of type " << e.id() ;

    return os ;
}

CORBA::Any::Any()
{
}

void * CORBA::Any::operator new( size_t sz )
{ 
    return CORBA_alloc( CORBA_MA_FIXED, sz, CORBA_TRUE ) ; 
}

CORBA::Any::~Any()
{
    switch ( _type.kind() )
    {
        case CORBA_tk_string :
        case CORBA_tk_wstring :
        CORBA::string_free( ( char * )_value.v ) ;
        break ;
    }
}

void CORBA::Any::release()
{ 
    switch ( _type.kind() )
    {
        case CORBA_tk_string :
        case CORBA_tk_wstring :
        CORBA::string_free( ( char * )_value.v ) ;
        break ;

        default :
        break ;
    }        
}

void CORBA::Any::replace( CORBA::TypeCode_ptr tc, void * value, CORBA::Boolean release )
{
}

void CORBA::Any::write( CORBA::Ostream & out ) const
{
    switch ( _type.kind() )
    {
        case CORBA_tk_short :
        out << _value.sv ;
        break ;
        
        case CORBA_tk_ushort :
        out << _value.usv ;
        break ;
        
        case CORBA_tk_long :
        out << _value.lv ;
        break ;
        
        case CORBA_tk_ulong :
        out << _value.ulv ;
        break ;
        
        case CORBA_tk_float :
        out << _value.fv ;
        break ;
        
        case CORBA_tk_double :
        out << _value.dv ;
        break ;
        
        case CORBA_tk_boolean :
        out << _value.bv ;
        break ;
        
        case CORBA_tk_char :
        out << _value.cv ;
        break ;
        
        case CORBA_tk_octet :
        out << _value.ov ;
        break ;
        
        case CORBA_tk_enum :
        out << _value.lv ;
        break ;
        
        case CORBA_tk_longlong :
        out << _value.llv ;
        break ;
        
        case CORBA_tk_ulonglong :
        out << _value.ullv ;
        break ;
        
        case CORBA_tk_longdouble :
        out << _value.ldv ;
        break ;
        
        case CORBA_tk_wchar :
        out << _value.wcv ;
        break ;
        
        case CORBA_tk_string :
        case CORBA_tk_wstring :
        out.setBounds( 0 ) ;
        out << ( char * )_value.v ;
        break ;
    }
}

void CORBA::Any::operator<<=( CORBA::Short val )
{ 
    release() ;
    _value.sv  = val ; 
    _type = CORBA::tk_short ;
}

void CORBA::Any::operator<<=( CORBA::UShort val )
{ 
    release() ;
    _value.usv  = val ; 
    _type = CORBA::tk_ushort ;
}

void CORBA::Any::operator<<=( CORBA::Long val )
{ 
    release() ;
    _value.lv  = val ; 
    _type = CORBA::tk_long ;
}

CORBA::Boolean CORBA::Any::operator>>=( CORBA::Short & val ) const
{ 
    if ( _type == CORBA::tk_short )
    {
        val = _value.sv ; 
        return CORBA::TRUE ;
    }        
    
    return CORBA::FALSE ;
}

CORBA::Boolean CORBA::Any::operator>>=( CORBA::Long & val ) const
{ 
    if ( _type == CORBA::tk_long )
    {
        val = _value.lv ; 
        return CORBA::TRUE ;
    }        
    
    return CORBA::FALSE ;
}

CORBA::Boolean CORBA::Any::operator>>=( char *& val ) const
{ 
    if ( _type == CORBA::tk_string )
    {
        val = ( char * )_value.v ; 
        return CORBA::TRUE ;
    }        
    
    return CORBA::FALSE ;
}

void CORBA::Any::operator<<=( const char * val )
{ 
    release() ;
    _value.v  = CORBA::string_dup( val ) ; 
    _type = CORBA::tk_string ;
}

void CORBA::Any::operator<<=( char * val )
{ 
    release() ;
    _value.v  = val ; 
    _type = CORBA::tk_string ;
}

CORBA::ORB::~ORB()
{
    CORBA_free_ORB( ( CORBA_iORB * )this ) ;
}


CORBA::Object::Object( const char * objType ) 
{
    CORBA_init_object( this->Cobject() ) ;
    buff.isCpp  = CORBA_TRUE ;
    obuff.isCpp = CORBA_TRUE ;
    setId( objType ) ;
}

void CORBA::Object::setId( const char * objType )
{
    id = ( char * )objType ;
}

CORBA::Object_ptr CORBA::Object::_duplicate( CORBA::Object_ptr obj )
{
    CORBA_throw_system_exception( THROW_OENV( obj ), EX_CORBA_NO_IMPLEMENT, 0, CORBA_COMPLETED_NO ) ;
    return NULL ;
}

void CORBA::Object::_copy( CORBA::Object_ptr tgt )
{
    CORBA_duplicate_object( tgt->Cobject(), this->Cobject() ) ;
}

CORBA::Boolean CORBA::Object::_is_a( const char * logical_type_id )
{ 
    return CORBA_Object_is_a( this->Cobject(), logical_type_id ) ;
}

//
//      sendMessage
//      -----------
//
//      Send a message
//
int CORBA::Object::sendMessage( int channel, CORBA_octet messageType )
{
    return CORBA_send_message( this->Cobject(), &obuff, channel, messageType ) ;
}

//
//      receiveMessage
//      --------------
//
//      Receive a message
//
int CORBA::Object::receiveMessage( int channel )
{
    return CORBA_receive_message( this->Cobject(), channel ) ;
}

static void readSysException( CORBA::Istream & is, char * id )
{
    CORBA::ULong minor, cs ;
    char eId[ 200 ] ;
    
    strcpy( eId, id ) ;
    
    CORBA::string_free( id ) ;

    is >> minor ;
    is >> cs ;

    CORBA::CompletionStatus completion_status = ( CORBA::CompletionStatus )cs ;

    if ( strcmp( eId, "NO_MEMORY" ) == 0 )
    {
        CORBA::NO_MEMORY sysE( minor, completion_status ) ;

        sysE._raise() ;
    }
    else if ( strcmp( eId, "BAD_PARAM" ) == 0 )
    {
        CORBA::BAD_PARAM sysE( minor, completion_status ) ;

        sysE._raise() ;
    }
    else
    {
        CORBA::UNKNOWN sysE( minor, completion_status ) ; 

        sysE._raise() ;
    }
}

CORBA::Ostream & operator<<( CORBA::Ostream & os, const CORBA::SystemException & sysE )
{
    os << sysE.minor() ;
    os << ( CORBA::ULong )sysE.completed() ;

    return os ;
}

CORBA::Request::~Request()
{
    CORBA_request_free( this ) ; 
}

void CORBA::Request::userException( CORBA::Ostream & os, CORBA::Exception & e )
{
    os.reset() ;
    
    os << ( CORBA::ULong )0 ;     // context stuff
    os << requestId() ;   
    os << ( CORBA::ULong )CORBA::USER_EXCEPTION ; 
    os << e.id() ;
}

void CORBA::Request::sysException( CORBA::Ostream & os, const CORBA::SystemException & sysE )
{
    os.reset() ;
    
    os << ( CORBA::ULong )0 ;     // context stuff
    os << requestId() ;   
    os << ( CORBA::ULong )CORBA::SYSTEM_EXCEPTION ;
    os << sysE.id() ;
    ::operator<<( os, sysE ) ;
}

static CORBA::ULong reply_read( CORBA::Istream & is ) throw( CORBA::Exception )
{
    CORBA::ULong discard, requestID, reply_status ;
    char * exceptionID = NULL ;

    is >> discard ;    // context stuff 
    is >> requestID ;
    is >> reply_status ;

    if ( reply_status != CORBA::NO_EXCEPTION )
    {
        is >> exceptionID ;

        if ( reply_status == CORBA::SYSTEM_EXCEPTION )
        {
            readSysException( is, exceptionID ) ;
        }
        else if ( reply_status == CORBA::USER_EXCEPTION )
        {
            CORBA::UnknownUserException userE ;

            userE.setId( exceptionID ) ;

            userE._raise() ;
        }
        else
            CORBA::string_free( exceptionID ) ;
    }

    return requestID ;
}

CORBA::Request::Request( CORBA::Object_ptr o )
{ 
    opName            = NULL ;
    response_expected = TRUE ; 
    obj               = o ;
} 

CORBA::Status CORBA::Request::invoke()
{
    Object_ptr o = ( Object_ptr )obj ;
    
    int channel = OBJ_CHANNEL( o ) ;
        
    if ( o->sendMessage( channel, GIOP_MsgType_1_1_Request ) )
        throw CORBA::COMM_FAILURE() ;

    CORBA_free( opName ) ;

    opName = NULL ;

    if ( response_expected )
    {
        if ( o->receiveMessage( channel ) < 0 )
            throw CORBA::COMM_FAILURE() ;

        CORBA::ULong rid = reply_read( o->is() ) ;
        
        if ( rid != request_id )
        {
            CORBA::BAD_INV_ORDER sysE ;

            sysE._raise() ;
        }
    }
}

CORBA::Request & CORBA::Object::create_request( const char * operationName, CORBA::Boolean response )
{
    CORBA::Request * request = ( CORBA::Request * )&req ;

    request->setTarget( this ) ;

    request->setResponse( response ) ;

    request->setOperation( operationName ) ;

    CORBA_Request_set( ( CORBA_iRequest * )request, Cobject() ) ;

    request->header() ;
   
    return *request ;
}
 
void CORBA::Request::setOperation( const char * op )
{ 
    CORBA::string_free( opName ) ; 
        
    opName = CORBA::string_dup( op ) ; 
}

void CORBA::Request::setOperation( char * op )
{ 
    CORBA::string_free( opName ) ; 
        
    opName = op ; 
}

CORBA::Istream & operator>>( CORBA::Istream & is, CORBA::Request & r )
{
    CORBA_Request_read( ( CORBA_Dbuff * )&is, ( CORBA_iRequest * )&r ) ;

    return is ;
}

void CORBA::Request::header()
{
    CORBA::Ostream & os = target()->os() ;

    os.reset() ;

    os << *this ;
}

CORBA::Ostream & operator<<( CORBA::Ostream & os, CORBA::Request & r )
{
    CORBA_Request_write( ( CORBA_Dbuff * )&os, ( CORBA_iRequest * )&r ) ;

    return os ;
}

//
//       IOstream::constructor
//       ---------------------
//
//
CORBA::IOstream::IOstream()
{
    len = 0 ;     // length of buffer 
    curr = 0 ;    // current position
    p = NULL ;    // buffer pointer
}

//
//       IOstream::destructor
//       --------------------
//
//
CORBA::IOstream::~IOstream()
{
    if ( p )
        free( p ) ;
}

void CORBA::IOstream::reset()
{
    CORBA_Dbuff_reset( this ) ;
}

//
//       IOstream::extend
//       ----------------
//
//       Extend the buffer size
//
//
void CORBA::IOstream::extend( CORBA::ULong required )
{
    if ( required > ( len - curr ) )
        if ( CORBA_Dbuff_allocate( this, required ) )
            throw CORBA::NO_MEMORY() ; 
}


CORBA::Ostream & CORBA::Ostream::operator<<( const CORBA::String_var & v )
{
    operator<<( ( char * )v ) ;
    
    return *this ;
}

#define DBUFF ( CORBA_Dbuff * )this

CORBA::Ostream & CORBA::Ostream::operator<<( CORBA::Short v )
{
    CORBA_Dbuff_write( DBUFF, ( char * )&v, sizeof( CORBA::Short ), 1 ) ;

    return *this ;
}

CORBA::Ostream & CORBA::Ostream::operator<<( CORBA::UShort v )
{
    CORBA_Dbuff_write( DBUFF, ( char * )&v, sizeof( CORBA::UShort ), 1 ) ;

    return *this ;
}

CORBA::Ostream & CORBA::Ostream::operator<<( CORBA::Long v )
{
    CORBA_Dbuff_write( DBUFF, ( char * )&v, sizeof( CORBA::Long ), 1 ) ;

    return *this ;
}

CORBA::Ostream & CORBA::Ostream::operator<<( const CORBA::ULongLong & v )
{
    CORBA_Dbuff_write( DBUFF, ( char * )&v, sizeof( CORBA::ULongLong ), 1 ) ;

    return *this ;
}

CORBA::Ostream & CORBA::Ostream::operator<<( CORBA::Float v )
{
    CORBA_Dbuff_write( DBUFF, ( char * )&v, sizeof( CORBA::Float ), 1 ) ;

    return *this ;
}

CORBA::Ostream & CORBA::Ostream::operator<<( CORBA::Double v )
{
    CORBA_Dbuff_write( DBUFF, ( char * )&v, sizeof( CORBA::Double ), 1 ) ;

    return *this ;
}

CORBA::Ostream & CORBA::Ostream::operator<<( CORBA::Octet v )
{
    CORBA_Dbuff_write( DBUFF, ( char * )&v, sizeof( CORBA::Octet ), 1 ) ;

    return *this ;
}


CORBA::Ostream & CORBA::Ostream::operator<<( CORBA::Char v )
{
    CORBA_Dbuff_write( DBUFF, &v, sizeof( CORBA::Char ), 1 ) ;

    return *this ;
}

#ifndef _MSC_VER

CORBA::Ostream & CORBA::Ostream::operator<<( CORBA::WChar v )
{
    CORBA_Dbuff_write( DBUFF, ( char * )&v, sizeof( CORBA::WChar ), 1 ) ;

    return *this ;
}

#endif

CORBA::Ostream & CORBA::Ostream::operator<<( CORBA::ULong v )
{
    CORBA_Dbuff_write( DBUFF, ( char * )&v, sizeof( CORBA::ULong ), 1 ) ;

    return *this ;
}

CORBA::Ostream & CORBA::Ostream::operator<<( const CORBA::LongLong & v )
{
    CORBA_Dbuff_write( DBUFF, ( char * )&v, sizeof( CORBA::LongLong ), 1 ) ;

    return *this ;
}

CORBA::Ostream & CORBA::Ostream::operator<<( const CORBA::LongDouble & v )
{
    CORBA_Dbuff_write( DBUFF, ( char * )&v, sizeof( CORBA::LongDouble ), 1 ) ;

    return *this ;
}

CORBA::Ostream & CORBA::Ostream::operator<<( const char * v )
{
    CORBA_string_write( DBUFF, ( char * )v, -1 ) ;

    return *this ;
}

CORBA::Ostream & CORBA::Ostream::operator<<( const CORBA::TypeCode & v )
{
    v.write( *this ) ;

    return *this ;
}

void CORBA::TypeCode::writeStruct( CORBA::Ostream & out ) const
{
    out << _id ;
    out << _name ;

    CORBA_StructMemberSeq * seq = ( CORBA_StructMemberSeq * )_ptr ;

    CORBA::Long count = seq->num ;
    
    out << count ;
    
    for ( int i = 0 ; i < count ; i++ )
    {
        out << seq->members[ i ].name ;
        out << *( ( CORBA::TypeCode * )seq->members[ i ].tc ) ;
    }
}

void CORBA::TypeCode::writeEnum( CORBA::Ostream & out ) const
{
    out << _id ;
    out << _name ;

    CORBA_Enum_TypeCode * enums = ( CORBA_Enum_TypeCode * )_ptr ;

    CORBA::Long count = enums->count ;
    
    out << count ;
    
    for ( int i = 0 ; i < count ; i++ )
        out << enums->members[ i ] ;
}

void CORBA::TypeCode::writeUnion( CORBA::Ostream & out ) const
{
    CORBA_Union_TC * utc = ( CORBA_Union_TC * )_ptr ;
    CORBA_UnionMember * members = utc->members ;
    CORBA::Long count = utc->num ;
    CORBA::TypeCode * typeC = ( CORBA::TypeCode * )utc->discriminant ;

    out << _id ;
    out << _name ;
    out << *typeC ;
    out << utc->defUsed ;
    out << count ;

    for ( int i = 0 ; i < count ; i++ )
    {
        typeC = ( CORBA::TypeCode * )members[ i ].tc ;

        out << members[ i ].value ;
        out << members[ i ].name ;
        out << *typeC ;
    }        
}

void CORBA::TypeCode::writeArray_and_Seq( CORBA::Ostream & out ) const
{
    CORBA_Array_TypeCode * atc = ( CORBA_Array_TypeCode * )this ;
    CORBA::TypeCode * typeC = ( CORBA::TypeCode * )atc->tc ;

    out << *typeC ;
    out << atc->size ;
}

void CORBA::TypeCode::write( CORBA::Ostream & out ) const
{
    CORBA::Long code = ( CORBA::Long )tc ;
    
    out << code ;
    
    switch ( code )
    {
        case CORBA_tk_fixed :
        // not imp
        break ;
        
        case CORBA_tk_string :
        case CORBA_tk_wstring :
        out << ( CORBA::Long )_ptr ;
        break ;

        case CORBA_tk_objref :
        out << _id ;
        out << _name ;
        break ;
        
        case CORBA_tk_struct :
        case CORBA_tk_except :
        writeStruct( out ) ;
        break ;

        case CORBA_tk_enum :
        writeEnum( out ) ;
        break ;

        case CORBA_tk_union :
        writeUnion( out ) ;
        break ;

        case CORBA_tk_array :
        case CORBA_tk_sequence :
        writeArray_and_Seq( out ) ;
        break ;

        case CORBA_tk_alias :
        {
            CORBA::TypeCode * typeC = ( CORBA::TypeCode * )_ptr ;

            out << _id ;
            out << _name ;
            out << *typeC ;
        }
        break ;
    }
}

void CORBA::TypeCode::read( CORBA::Istream & in )
{
    CORBA_TypeCode_release( this ) ;

    CORBA::Long t ;
    
    in >> t ;

    tc = ( CORBA_TCKind )t ;
    
    switch ( tc )
    {
        case CORBA_tk_fixed :
        // not imp
        break ;
        
        case CORBA_tk_string :
        case CORBA_tk_wstring :
        {
            CORBA::ULong size ;
            
            in >> size ;
            
            _ptr = ( void * )size ;
        }
        break ;

        case CORBA_tk_objref :
        in >> _id ;
        in >> _name ;
        break ;
        
        case CORBA_tk_struct :
        case CORBA_tk_except :
        break ;

        case CORBA_tk_enum :
        break ;

        case CORBA_tk_union :
        break ;

        case CORBA_tk_array :
        case CORBA_tk_sequence :
        break ;

        case CORBA_tk_alias :
        {
            CORBA::TypeCode * typeC = ( CORBA::TypeCode * )_ptr ;

            in >> _id ;
            in >> _name ;
            in >> *typeC ;
        }
        break ;
    }
}

CORBA::Ostream & CORBA::Ostream::operator<<( const CORBA::Any & v )
{
    operator<<( *v.type() ) ;  // write out the type

    v.write( *this ) ;
    
    return *this ;
}

//
//      istream::read
//      -------------
//
//      General function to read data from the buffer
//
//
void CORBA::Istream::read( char * u, CORBA::ULong sz, CORBA::ULong num )
{
    CORBA_Dbuff_read( ( CORBA_Dbuff * )this, u, sz, num ) ;
}

CORBA::Istream & CORBA::Istream::operator>>( CORBA::TypeCode & v )
{
    v.read( *this ) ;

    return *this ;
}

CORBA::Istream & CORBA::Istream::operator>>( CORBA::Short & in )
{
    read( ( char * )&in, sizeof( CORBA::Short ), 1 ) ;

    return *this ;
}

CORBA::Istream & CORBA::Istream::operator>>( CORBA::UShort & in )
{
    read( ( char * )&in, sizeof( CORBA::UShort ), 1 ) ;

    return *this ;
}


CORBA::Istream & CORBA::Istream::operator>>( CORBA::Char & in )
{
    read( ( char * )&in, sizeof( CORBA::Char ), 1 ) ;

    return *this ;
}

CORBA::Istream & CORBA::Istream::operator>>( CORBA::UChar & in )
{
    read( ( char * )&in, sizeof( CORBA::UChar ), 1 ) ;

    return *this ;
}

#ifndef _MSC_VER

CORBA::Istream & CORBA::Istream::operator>>( CORBA::WChar & in )
{
    read( ( char * )&in, sizeof( CORBA::WChar ), 1 ) ;

    return *this ;
}

#endif

CORBA::Istream & CORBA::Istream::operator>>( CORBA::Long & in )
{
    read( ( char * )&in, sizeof( CORBA::Long ), 1 ) ;

    return *this ;
}

CORBA::Istream & CORBA::Istream::operator>>( CORBA::ULong & in )
{
    read( ( char * )&in, sizeof( CORBA::ULong ), 1 ) ;

    return *this ;
}

CORBA::Istream & CORBA::Istream::operator>>( CORBA::Float & in )
{
    read( ( char * )&in, sizeof( CORBA::Float ), 1 ) ;

    return *this ;
}

CORBA::Istream & CORBA::Istream::operator>>( CORBA::Double & in )
{
    read( ( char * )&in, sizeof( CORBA::Double ), 1 ) ;

    return *this ;
}

CORBA::Istream & CORBA::Istream::operator>>( CORBA::LongLong & in )
{
    read( ( char * )&in, sizeof( CORBA::LongLong ), 1 ) ;

    return *this ;
}

CORBA::Istream & CORBA::Istream::operator>>( CORBA::ULongLong & in )
{
    read( ( char * )&in, sizeof( CORBA::ULongLong ), 1 ) ;

    return *this ;
}

CORBA::Istream & CORBA::Istream::operator>>( CORBA::LongDouble & in )
{
    read( ( char * )&in, sizeof( CORBA::LongDouble ), 1 ) ;

    return *this ;
}

CORBA::Istream & CORBA::Istream::operator>>( char *& in )
{
    CORBA_string_read( ( CORBA_Dbuff * )this, ( char ** )&in, -1 ) ;
/*    
    CORBA::Long size ;
    char * s = NULL ;

    operator>>( size ) ;

    if ( in ) 
    {
        CORBA::Long currentSize = strlen( in ) ;

        if ( size > currentSize )
            CORBA::string_free( in ) ;
        else
            s = in ;
    }        

    if ( ( s == NULL ) && 
         ( ( s = CORBA::string_alloc( size ) ) == NULL ) )
        throw CORBA::NO_MEMORY() ;

    read( s, sizeof( CORBA::Char ), size ) ;

    s[ size ] = '\0' ;

    in = s ;
*/
    return *this ;
}

CORBA::Istream & CORBA::Istream::operator>>( CORBA::String_var & in )
{
    char * s = NULL ;

    operator>>( s ) ;

    in = s ;

    return *this ;
}


CORBA::Istream & CORBA::Istream::operator>>( CORBA::Any & in )
{
    TypeCode t ;
    
    t.read( *this ) ;
    
    switch ( t.kind() )
    {
        case CORBA_tk_short :
        {
            CORBA::Short v ;
            operator>>( v ) ;           
            in <<= v ;
        }            
        break ;
        
        case CORBA_tk_ushort :
        {
            CORBA::UShort v ;
            operator>>( v ) ;           
            in <<= v ;
        }            
        break ;

        case CORBA_tk_long :
        {
            CORBA::Long v ;
            operator>>( v ) ;           
            in <<= v ;
        }            

        case CORBA_tk_ulong :
        case CORBA_tk_float :

        case CORBA_tk_double :
        case CORBA_tk_boolean :
        case CORBA_tk_char :
        case CORBA_tk_octet :

        case CORBA_tk_enum :
        case CORBA_tk_longlong :
        case CORBA_tk_ulonglong :
        case CORBA_tk_longdouble :
        case CORBA_tk_wchar :
        break ;

        case CORBA_tk_string :
        {
            char * v = NULL ;
            setBounds( 0 ) ;  // no bounds check on any !
            operator>>( v ) ;           
            in <<= v ;
        }            
    }

    // CORBA_any_set_release( v, CORBA_TRUE ) ;

    return *this ;
}

CORBA::Boolean CORBA::TypeCode::equal( CORBA::TypeCode_ptr p ) const
{
    return CORBA_TypeCode_equal( ( CORBA_TypeCode * )this, p ) ;
}

bool CORBA::TypeCode::operator==( CORBA::TypeCode & p ) const
{
    return CORBA_TypeCode_equal( ( CORBA_TypeCode * )this, ( CORBA_TypeCode * )&p ) ;
}

CORBA::BOA::~BOA()
{
    CORBA_free( this ) ;
}

int CORBA::BOA::impl_is_ready()
{
    int r ;

    for ( ; ; )
    {
        if ( ( r = serverLoop( this, NULL ) ) != 0 ) 
            return r ;
    }
}


static void reply_write( CORBA::Ostream & os, CORBA::ULong requestID ) throw( CORBA::Exception )
{
    os << ( CORBA::ULong )0 ;     // context stuff
    os << requestID ;   
    os << ( CORBA::ULong )CORBA::NO_EXCEPTION ; // reply status = OK
}

int PortableServer::ServantBase::server( int socket ) 
{
    try 
    {
        if ( receiveMessage( socket ) < 0 )
            return -1 ;
    }
    catch ( CORBA::COMM_FAILURE & e )
    {
        return -1 ;
    }

    ofstream & logS = log() ;
    
    switch ( msgHdr.message_type )
    {
        case GIOP_MsgType_1_1_Request :
        {
            CORBA::Request rq = ( CORBA::Request & )req ;

            is() >> rq ;

            CORBA::Ostream & op = os() ;

            if ( rq.respond() )
            {
                op.reset() ;
                reply_write( op, rq.requestId() ) ;
            }
            
            try
            {
                dispatch( ( char * )rq.operation() ) ;
            }
            catch ( CORBA::SystemException sysE )
            {
                rq.sysException( op, sysE ) ;
            }

            if ( rq.respond() )
                sendMessage( socket, GIOP_MsgType_1_1_Reply ) ;
        }
        break ;
        
        case GIOP_MsgType_1_1_CloseConnection :
        logS << "RX close Connection" << endl ;
        return -1 ;

        case GIOP_MsgType_1_1_CancelRequest :
        CORBA_CancelRequest( this->Cobject(), NULL ) ;
        break ;

        case GIOP_MsgType_1_1_LocateRequest :
        CORBA_LocateRequest( this->Cobject(), socket, NULL ) ;
        break ;

        case GIOP_MsgType_1_1_MessageError :
        logS << "RX MessageError" ;
        break ;

        case GIOP_MsgType_1_1_Fragment :
        logS << "RX Fragment" ;
        break ;
        
        default :
        logS << "RX Message type " << msgHdr.message_type ;
        break ;
    }
    
    return 0 ;
}

void CORBA::BOA::obj_is_ready( CORBA::Object_ptr o )
{
    _CORBA_BOA_object_is_ready( this, o, o->id, NULL ) ;
}

CORBA::Object_ptr CORBA::ORB::resolve_initial_references( const char * service )
{
    ( void )service ;
    
    throw CORBA::NO_IMPLEMENT() ;
}

#if 0

#endif

