/**
*       server.c
*       --------
*
*       Server functions
*
*
*       Copyright Mitch Britton 1998-1999
*       All Rights Reserved
*       See the file licence.txt
*
**/

#include <corba.h>
#include "corba_i.h"

static CORBA_iServer_Func findOp( CORBA_iIFACE_TABLE * table, int size, char * opName )
{
    char * name ;
    ( void )size ;

    for ( ; ( name = table->opName ) != NULL ; table++ )
    {
        if ( strcmp( name, opName ) ==  0 )
            return table->func ;
    }

    return NULL ;
}

void CORBA_dispatch( CORBA_iObject * _o )
{
    CORBA_iServer_Func func ;
    int i ;
    CORBA_iIFACE_TABLES * _interfaces = ( CORBA_iIFACE_TABLES * )_o->server ;

    CORBA_request_read( _o ) ;

    for ( i = 0 ; _interfaces[ i ].table != NULL ; i++ )
    {
        if ( ( func = findOp( _interfaces[ i ].table, _interfaces[ i ].size, _o->req.opName ) ) != NULL )
        {
            ( *func )( _o, &CORBA_OBJ_ENV( _o ) ) ;
        }
        else
        {   
            CORBA_postImpl( _o ) ;
        
            CORBA_ORB_log( _o, LOG_SYS_ERR, "bad operation %s", _o->req.opName ) ;

            if ( _o->req.response_expected )
                CORBA_BOA_set_exception( _o, &_o->buff.env, CORBA_SYSTEM_EXCEPTION, ex_CORBA_BAD_OPERATION, NULL ) ;
        }
    }

    CORBA_request_free( &_o->req ) ; 
}



