/**
*       syserr.cpp
*       ----------
*
*       This module is used by both C and C++ ORBS
*       If you only have a C compiler then rename
*       it syserr.c and compile as a 'C' file
*
*       Copyright Mitch Britton 1998-1999
*       All Rights Reserved
*       See the file licence.txt
*
**/

/**
*       Compilation Switches and Definitions
*       ------------------------------------
**/


/**
*       Header Files
*       ------------
**/

#include <corba.h>
#include "corba_i.h"


/**
*       External Data
*       -------------
**/

/**
*       Internal Global Data
*       --------------------
**/

/**
*       Internal Function Declarations
*       ------------------------------
**/

/**
*       External Function Declarations
*       ------------------------------
**/

/**
*       Public Global Data
*       ------------------
**/

#ifdef __cplusplus

int CORBA_cppServer( CORBA_iObject * obj, int channel )
{
    PortableServer::ServantBase * object = ( PortableServer::ServantBase * )obj ;

    return object->server( channel ) ;
}    

static void throw_system_exception( int err, CORBA::ULong minor, CORBA::CompletionStatus status )
{
    CORBA::SystemException * sysE = NULL ;
    
    switch ( err )
    {
        case EX_CORBA_UNKNOWN                 :
        sysE = new CORBA::UNKNOWN( minor, status ) ;
        break ;
        
        case EX_CORBA_BAD_PARAM               :             
        sysE = new CORBA::BAD_PARAM( minor, status ) ;
        break ;
        
        case EX_CORBA_NO_MEMORY               :
        sysE = new CORBA::NO_MEMORY( minor, status ) ;
        break ;
        
        case EX_CORBA_IMP_LIMIT               :
        sysE = new CORBA::IMP_LIMIT( minor, status ) ;
        break ;
        
        case EX_CORBA_COMM_FAILURE            :
        sysE = new CORBA::COMM_FAILURE( minor, status ) ;
        break ;
        
        case EX_CORBA_INV_OBJREF              :
        sysE = new CORBA::INV_OBJREF( minor, status ) ;
        break ;
        
        case EX_CORBA_NO_PERMISSION           :
        sysE = new CORBA::NO_PERMISSION( minor, status ) ;
        break ;
        
        case EX_CORBA_INTERNAL                :
        sysE = new CORBA::INTERNAL( minor, status ) ;
        break ;
        
        case EX_CORBA_MARSHAL                 :
        sysE = new CORBA::MARSHAL( minor, status ) ;
        break ;
        
        case EX_CORBA_INITIALIZE              :
        sysE = new CORBA::INITIALIZE( minor, status ) ;
        break ;
        
        case EX_CORBA_NO_IMPLEMENT            :
        sysE = new CORBA::NO_IMPLEMENT( minor, status ) ;
        break ;
        
        case EX_CORBA_BAD_TYPECODE            :
        sysE = new CORBA::BAD_TYPECODE( minor, status ) ;
        break ;
        
        case EX_CORBA_BAD_OPERATION           :
        sysE = new CORBA::BAD_OPERATION( minor, status ) ;
        break ;
        
        case EX_CORBA_NO_RESOURCES            :
        sysE = new CORBA::NO_RESOURCES( minor, status ) ;
        break ;
        
        case EX_CORBA_NO_RESPONSE             :
        sysE = new CORBA::NO_RESPONSE( minor, status ) ;
        break ;
        
        case EX_CORBA_PERSIST_STORE           :
        sysE = new CORBA::PERSIST_STORE( minor, status ) ;
        break ;
        
        case EX_CORBA_BAD_INV_ORDER           :
        sysE = new CORBA::BAD_INV_ORDER( minor, status ) ;
        break ;
        
        case EX_CORBA_TRANSIENT               :
        sysE = new CORBA::TRANSIENT( minor, status ) ;
        break ;
        
        case EX_CORBA_FREE_MEM                :
        sysE = new CORBA::FREE_MEM( minor, status ) ;
        break ;
        
        case EX_CORBA_INV_IDENT               :
        sysE = new CORBA::INV_IDENT( minor, status ) ;
        break ;
        
        case EX_CORBA_INV_FLAG                :
        sysE = new CORBA::INV_FLAG( minor, status ) ;
        break ;
        
        case EX_CORBA_INTF_REPOS              :
        sysE = new CORBA::INTF_REPOS( minor, status ) ;
        break ;
        
        case EX_CORBA_BAD_CONTEXT             :
        sysE = new CORBA::BAD_CONTEXT( minor, status ) ;
        break ;
        
        case EX_CORBA_OBJ_ADAPTER             :
        sysE = new CORBA::OBJ_ADAPTER( minor, status ) ;
        break ;
        
        case EX_CORBA_DATA_CONVERSION         :
        sysE = new CORBA::DATA_CONVERSION( minor, status ) ;
        break ;
        
        case EX_CORBA_OBJECT_NOT_EXIST        :
        sysE = new CORBA::OBJECT_NOT_EXIST( minor, status ) ;
        break ;
        
        case EX_CORBA_TRANSACTIONREQUIRED    :
        sysE = new CORBA::TRANSACTIONREQUIRED( minor, status ) ;
        break ;
        
        case EX_CORBA_TRANSACTIONROLLEDBACK  :
        sysE = new CORBA::TRANSACTIONROLLEDBACK( minor, status ) ;
        break ;
        
        case EX_CORBA_INVALIDTRANSACTION     :
        sysE = new CORBA::INVALIDTRANSACTION( minor, status ) ;
        break ;
    }        

    if ( sysE != NULL )
        sysE->_raise() ;
}

#else

int CORBA_cppServer( CORBA_iObject * obj, int channel )
{
    fprintf( stderr, "No C++ Support - enable C++ ORB" ) ;
    exit( -1 ) ;
    return 0 ;
}    

#endif

static void setSysException( CORBA_char * exceptname, CORBA_unsigned_long minor, 
    CORBA_unsigned_long compStatus, CORBA_Environment * ev )
{
    memset( &ev->sysExcept, 0, sizeof( CORBA_System_Exception ) ) ;

    ev->sysExcept.minor_code_value  = minor ;
    ev->sysExcept.completion_status = compStatus ;

    ev->id  = CORBA_string_copy( exceptname ) ;

    ev->_major = CORBA_SYSTEM_EXCEPTION ;
}

void CORBA_throw_system_exception( CORBA_Environment * env, int err, 
    CORBA_unsigned_long minor, CORBA_unsigned_long compStatus )
{
    char * p ;
    
    if ( env == NULL )
    {
#ifdef __cplusplus
        throw_system_exception( err, minor, ( CORBA::CompletionStatus )compStatus ) ;
        return ; 
#else
        fprintf( stderr, "NULL Env in throw system exception - enable C++ ORB?" ) ;
        exit( -1 ) ;
#endif
    }
    
    switch ( err )
    {
        case EX_CORBA_UNKNOWN                 :
        p = ex_CORBA_UNKNOWN ;
        break ;
        
        case EX_CORBA_BAD_PARAM               :             
        p = ex_CORBA_BAD_PARAM ;
        break ;
        
        case EX_CORBA_NO_MEMORY               :
        p = ex_CORBA_NO_MEMORY ;
        break ;
        
        case EX_CORBA_IMP_LIMIT               :
        p = ex_CORBA_IMP_LIMIT ;
        break ;
        
        case EX_CORBA_COMM_FAILURE            :
        p = ex_CORBA_COMM_FAILURE ;
        break ;
        
        case EX_CORBA_INV_OBJREF              :
        p = ex_CORBA_INV_OBJREF ;
        break ;
        
        case EX_CORBA_NO_PERMISSION           :
        p = ex_CORBA_NO_PERMISSION ;
        break ;
        
        case EX_CORBA_INTERNAL                :
        p = ex_CORBA_INTERNAL ;
        break ;
        
        case EX_CORBA_MARSHAL                 :
        p = ex_CORBA_MARSHAL ;
        break ;
        
        case EX_CORBA_INITIALIZE              :
        p = ex_CORBA_INITIALIZE ;
        break ;
        
        case EX_CORBA_NO_IMPLEMENT            :
        p = ex_CORBA_NO_IMPLEMENT ;
        break ;
        
        case EX_CORBA_BAD_TYPECODE            :
        p = ex_CORBA_BAD_TYPECODE ;
        break ;
        
        case EX_CORBA_BAD_OPERATION           :
        p = ex_CORBA_BAD_OPERATION ;
        break ;
        
        case EX_CORBA_NO_RESOURCES            :
        p = ex_CORBA_NO_RESOURCES ;
        break ;
        
        case EX_CORBA_NO_RESPONSE             :
        p = ex_CORBA_NO_RESPONSE ;
        break ;
        
        case EX_CORBA_PERSIST_STORE           :
        p = ex_CORBA_PERSIST_STORE ;
        break ;
        
        case EX_CORBA_BAD_INV_ORDER           :
        p = ex_CORBA_BAD_INV_ORDER ;
        break ;
        
        case EX_CORBA_TRANSIENT               :
        p = ex_CORBA_TRANSIENT ;
        break ;
        
        case EX_CORBA_FREE_MEM                :
        p = ex_CORBA_FREE_MEM ;
        break ;
        
        case EX_CORBA_INV_IDENT               :
        p = ex_CORBA_INV_IDENT ;
        break ;
        
        case EX_CORBA_INV_FLAG                :
        p = ex_CORBA_INV_FLAG ;
        break ;
        
        case EX_CORBA_INTF_REPOS              :
        p = ex_CORBA_INTF_REPOS ;
        break ;
        
        case EX_CORBA_BAD_CONTEXT             :
        p = ex_CORBA_BAD_CONTEXT ;
        break ;
        
        case EX_CORBA_OBJ_ADAPTER             :
        p = ex_CORBA_OBJ_ADAPTER ;
        break ;
        
        case EX_CORBA_DATA_CONVERSION         :
        p = ex_CORBA_DATA_CONVERSION ;
        break ;
        
        case EX_CORBA_OBJECT_NOT_EXIST        :
        p = ex_CORBA_OBJECT_NOT_EXIST ;
        break ;
        
        case EX_CORBA_TRANSACTIONREQUIRED    :
        p = ex_CORBA_TRANSACTIONREQUIRED ;
        break ;
        
        case EX_CORBA_TRANSACTIONROLLEDBACK  :
        p = ex_CORBA_TRANSACTIONROLLEDBACK ;
        break ;
        
        case EX_CORBA_INVALIDTRANSACTION     :
        p = ex_CORBA_INVALIDTRANSACTION ;
        break ;

        default                               :
        p = ex_CORBA_UNKNOWN ;
        minor = 2000 ;
        fprintf( stderr, "Unknown sysE %d\n", err ) ;
        break ;
    }        

    setSysException( p, minor, compStatus, env ) ;
}
