/**
*       tcpip_s.c
*       ----------
*
*       Module for TCP/IP Server side
*
*
*       Copyright Mitch Britton 1998-1999
*       All Rights Reserved
*       See the file licence.txt
*
**/

#include <stdio.h>
#include <corba.h>
#include "corba_i.h"
#include "IOP_i.h"

#define MAX(A,B) (A>B?A:B)

#ifdef _Win32
#include <io.h>
#include <winsock.h>
#else
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#endif

void CORBA_CancelRequest( CORBA_iObject * obj, CORBA_Environment * env ) 
{
    struct GIOP_CancelRequestHeader crh ;

    CORBA_Dbuff * _b = CORBA_DBUFF( obj ) ;
    
    GIOP_CancelRequestHeader_read( _b, &crh ) ;

    if ( env )
        CORBA_set_env( obj, env ) ;
}

void CORBA_LocateRequest( CORBA_iObject * obj, int socket, CORBA_Environment * env ) 
{
    struct GIOP_LocateRequestHeader lreq ;
    struct GIOP_LocateReplyHeader   lrep ;

    CORBA_Dbuff * i_b = CORBA_DBUFF( obj ) ;
    CORBA_Dbuff * o_b ;
    
    memset( &lreq, 0, sizeof( struct GIOP_LocateRequestHeader ) ) ;
    
    GIOP_LocateRequestHeader_read( i_b, &lreq ) ;

    lrep.request_id    = lreq.request_id ;
    lrep.locate_status = GIOP_LocateStatusType_OBJECT_HERE ;
    
    if ( i_b->isCpp )
        o_b = &obj->obuff ;
    else
        o_b = i_b ;

    CORBA_resetpBuff( o_b ) ;

    GIOP_LocateReplyHeader_write( o_b, &lrep ) ;
    
    if ( CORBA_send_message( obj, o_b, socket, GIOP_MsgType_1_1_LocateReply ) )
        CORBA_throw_system_exception( env, EX_CORBA_COMM_FAILURE, 0, CORBA_COMPLETED_NO ) ;
        
    if ( env )
        CORBA_set_env( obj, env ) ;
}

MSC_EXPORT int BC_EXPORT CORBA_server( CORBA_iObject * obj, int socket, CORBA_Environment * env ) 
{
    int r = CORBA_receive_message( obj, socket ) ;
        
    if ( r )
        return r ;
            
    switch ( obj->msgHdr.message_type )
    {
        case GIOP_MsgType_1_1_Request :
        {
            CORBA_dispatch( obj ) ;

            if ( obj->req.response_expected )
            {
                if ( CORBA_send_message( obj, &obj->buff, socket, GIOP_MsgType_1_1_Reply ) )
                    CORBA_throw_system_exception( env, EX_CORBA_COMM_FAILURE, 0, CORBA_COMPLETED_NO ) ;
            }
        }
        break ;

        case GIOP_MsgType_1_1_CancelRequest :
        CORBA_CancelRequest( obj, env ) ;
        break ;

        case GIOP_MsgType_1_1_LocateRequest :
        CORBA_LocateRequest( obj, socket, env ) ;
        break ;

        case GIOP_MsgType_1_1_MessageError :
        CORBA_ORB_log( obj, LOG_SYS_ERR, "RX MessageError" ) ;
        break ;

        case GIOP_MsgType_1_1_Fragment :
        CORBA_ORB_log( obj, LOG_SYS_ERR, "RX Fragment" ) ;
        break ;
        
        default :
        CORBA_ORB_log( obj, LOG_SYS_ERR, "RX Message type %d",  obj->msgHdr.message_type ) ;
        break ;
    }
    
    return 0 ;
}

int serverLoop( CORBA_BOA boa, CORBA_Environment * env )
{
    CORBA_iObject * obj ;
    int r, i, conns, numSelect ;
    CORBA_BOA_OBJS * o ;
    fd_set readFds, writeFds, exceptFds ;
    struct timeval timeout ;
    CORBA_long addr ;
    int nfds = 0, s ;
    
    FD_ZERO( &readFds ) ;
    FD_ZERO( &writeFds ) ;
    FD_ZERO( &exceptFds ) ;
    
    for ( o = boa->objs, i = 0, conns = boa->params.connections ; 
            i < conns ; i++, o++ )
    {
        obj = ( CORBA_iObject * )o->obj ;

        if ( obj )
        {
            if ( o->socket < 0 )
            {
                CORBA_throw_system_exception( env, EX_CORBA_INITIALIZE, 
                    0, CORBA_COMPLETED_NO ) ; /* no server socket */

                return 0 ;
            }

            s = ( o->channel < 0 ) 
                ? o->socket  /* wait for connect on server socket */ 
                : o->channel /* wait on data socket */ ;
            
            if ( s >= 0 )
                FD_SET( s, &readFds ) ; 

            nfds = MAX( nfds, s ) ; 
        }
    }

    nfds++ ;
    
    if ( boa->params.timeout == -1 ) 
        numSelect = select( nfds, &readFds, &writeFds, &exceptFds, NULL ) ; 
    else    
    {
        timeout.tv_sec = boa->params.timeout ; 
        timeout.tv_usec = 0 ;

        numSelect = select( nfds, &readFds, &writeFds, &exceptFds, &timeout ) ; 
    }
    
    if ( numSelect == 0 )
        return CORBA_TIMEOUT ;
    
    for ( o = boa->objs, i = 0 ; numSelect && ( i < conns ) ; i++, o++ )
    {
        obj = ( CORBA_iObject * )o->obj ;
        
        if ( obj )
        {
            if ( o->channel < 0 )
            {
                if ( FD_ISSET( o->socket, &readFds ) )
                {
                    /* CORBA_ORB_log( obj, LOG_SYS_ERR, "ACCEPT on %d\n", o->socket ) ; */
                    
                    o->channel = CORBA_Connect( o->socket, &addr ) ;
                    FD_CLR( o->socket, &readFds ) ;
                    FD_SET( o->channel, &readFds ) ;
                    if ( boa->onConnect )
                        ( *boa->onConnect )( ( CORBA_Object )obj ) ;
                    numSelect-- ;
                }
            }                  
            else if ( FD_ISSET( o->channel, &readFds ) )
            {
                if ( CPP_OBJ( obj ) )
                    r = CORBA_cppServer( obj, o->channel ) ;
                else
                    r = CORBA_server( obj, o->channel, env ) ;

                if ( r )
                {
                    closesocket( o->channel ) ;
                    o->channel = -1 ;
                }

                numSelect-- ;
            }
        }
    }            

    return 0 ;        
}

