# Make file

!include $(CORBAD)\bc32.mak

TMPD                = tmp
CC                 = $(CC) -I$(TMPD)

CLIENT_TCPIP_RSP    = test1_c.rsp
SERVER_TCPIP_RSP    = test1_s.rsp
CLIENT_DLL          = funcargs_c.dll
CLIENT_LIB          = funcargs_c.lib
CLIENT_DLL_RSP      = funcargs_c.rsp
CLIENT_TCPIP        = test1_c.exe
SERVER_TCPIP        = test1_s.exe
O_COMMON            = $(TMPD)\funcargs $(TMPD)\inherit
OBJS_COMMON         = $(TMPD)\funcargs.obj $(TMPD)\inherit.obj
O_CLNT              = test1 print
OBJS_CLNT           = test1.obj print.obj
OBJS_CLIENT         = $(TMPD)\funcargs_c.obj $(TMPD)\inherit_c.obj
OBJS_SERV           = print.obj $(TMPD)\funcargs_s.obj funcargs_i.obj $(TMPD)\inherit_s.obj inherit_i.obj
O_SERV              = print $(TMPD)\funcargs_s funcargs_i $(TMPD)\inherit_s inherit_i
FUNCARGS_H          = $(TMPD)\funcargs.h
INHERIT_H           = $(TMPD)\inherit.h
INPROC              = inproc
TCPIP               =
TCPIP_S             = servmain.obj
OBJS_IP             = print.obj funcargs_i.obj
O_IP                = print funcargs_i
DLL_FLAGS           = -DBC_DLL_funcargs=_export -DBC_DLL_inherit=_export
COMPILE_FOR_DLL_RSP = bc32cc.rsp
COMPILE_FOR_DLL     = $(CC) @$(COMPILE_FOR_DLL_RSP)

all:    gen tcpip

force:  clean all

regen:  gen all

client_ip:  $(CLIENT_IP)

tcpip: $(CLIENT_TCPIP) $(SERVER_TCPIP)

gen:
        cd $(TMPD)
        make -f bc32.mak
        cd ..

clean:
        del $(TMPD)\funcargs.h
        del $(TMPD)\inherit.h
        del $(TMPD)\*.obj
        del *.obj
        del *.lib
        del *.rsp
        del *.exe
        del *.dll

# $(TMPD)\funcargs.obj:   $(TMPD)\funcargs.c
#        $(COMPILE_FOR_DLL) -o$*.obj $*.c

# $(TMPD)\funcargs_c.obj:   $(TMPD)\funcargs_c.c
#        $(COMPILE_FOR_DLL) -o$*.obj $*.c

#$(TMPD)\inherit_c.obj:   $(TMPD)\inherit_c.c
#        $(COMPILE_FOR_DLL) -o$*.obj $*.c

#$(TMPD)\inherit.obj:    $(TMPD)\inherit.c
#        $(COMPILE_FOR_DLL) -o$*.obj $*.c

#print.obj:    print.c
#        $(COMPILE_FOR_DLL) $*.c

#$(CLIENT_DLL) : $(OBJS_COMMON) $(OBJS_CLIENT) $(CLIENT_DLL_RSP)
#            $(LINKER) $(LKFLAGSD) $(LKF) @$(CLIENT_DLL_RSP)

#$(CLIENT_LIB) : $(CLIENT_DLL)
#                $(IMPLIB) $@ $(CLIENT_DLL)

#$(COMPILE_FOR_DLL_RSP):   bc32.mak
#            echo $(CWE) $(BEFORE_FLAGS) > $@
#            echo $(DLL_FLAGS) >> $@            

#$(CLIENT_DLL_RSP):   bc32.mak
#            echo $(STARTOBJD) $(O_COMMON) +  > $@
#            echo $(OBJS_CLIENT) >>  $@
#            echo $(CLIENT_DLL) >>  $@
#            echo map >>  $@
#            echo $(CORBA_TCPIP_LIB) $(SLIB_MT) ; >> $@

#$(CLIENT_TCPIP_RSP):   bc32.mak
#            echo $(STARTOBJ) $(O_CLNT) > $@
#            echo $(CLIENT_TCPIP) >>  $@
#            echo map >>  $@
#            echo $(CLIENT_LIB) $(CORBA_TCPIP_LIB) $(SLIB_MT) ; >> $@

#$(CLIENT_TCPIP_RSP):   bc32.mak
#            echo $(STARTOBJ) $(O_CLNT) > $@
#            echo $(CLIENT_TCPIP) >>  $@
#            echo map >>  $@
#            echo $(CLIENT_LIB) $(CORBA_TCPIP_LIB) $(SLIB_MT) ; >> $@

$(CLIENT_TCPIP) : $(OBJS_COMMON) $(OBJS_CLNT) $(OBJS_CLIENT) $(CORBA_TCPIP_LIB) $(CLIENT_TCPIP_RSP) 
            echo ---- Making $@ ----
            $(LINKER) $(LKFLAGS) $(LKF) @$(CLIENT_TCPIP_RSP)

$(CLIENT_TCPIP_RSP):   bc32.mak
            echo $(STARTOBJ) $(O_CLNT) $(O_COMMON) $(OBJS_CLIENT) > $@
            echo $(CLIENT_TCPIP) >>  $@
            echo map >>  $@
            echo $(CORBA_TCPIP_LIB) $(SLIB_MT) ; >> $@
            
$(SERVER_TCPIP):  $(OBJS_COMMON) $(OBJS_SERV) $(TCPIP_S) $(TCPIP) $(SERVER_TCPIP_RSP) $(CORBA_TCPIP_LIB)
            echo ---- Making $@ ----
            $(LINKER) $(LKFLAGS) $(LKF) @$(SERVER_TCPIP_RSP)

$(SERVER_TCPIP_RSP):  bc32.mak
                echo $(STARTOBJ) $(O_SERV) + > $@
                echo $(TCPIP_S) $(O_COMMON) >> $@
                echo $(SERVER_TCPIP) >>  $@
                echo map >>  $@
                echo $(CORBA_TCPIP_LIB) $(SLIB_MT) ; >> $@


