# Make file

include ../../gcc.mak

TMPD             = tmp
IDLDIR           = $(CORBAD)/samples/idl
FUNCARGS         = $(TMPD)/funcargs.h $(TMPD)/funcargs_i.h $(TMPD)/funcargs.c \
$(TMPD)/funcargs_c.c $(TMPD)/funcargs_s.c
INHERIT          = $(TMPD)/inherit.h $(TMPD)/inherit_i.h $(TMPD)/inherit.c \
$(TMPD)/inherit_c.c $(TMPD)/inherit_s.c

CLIENT_TCPIP     = test1_c
SERVER_TCPIP     = test1_s
O_COMMON         = $(TMPD)/funcargs.o print.o 
O_CLNT           = test1.o $(TMPD)/funcargs_c.o $(TMPD)/inherit_c.o
O_SERV           = $(TMPD)/funcargs_s.o $(TMPD)/inherit_s.o funcargs_i.o inherit_i.o 
TCPIP_S          = servmain.o

all:    gen tcpip

force:  clean all

tcpip: $(CLIENT_TCPIP) $(SERVER_TCPIP)

gen:	$(FUNCARGS) $(INHERIT)

$(FUNCARGS):    $(IDLDIR)/funcargs.idl
	java idl -c -d $(TMPD) $(IDLDIR)/funcargs

$(INHERIT):    $(IDLDIR)/inherit.idl
	java idl $(IDLDIR)/inherit -c -d $(TMPD)

clean:
	rm $(FUNCARGS)
	rm $(INHERIT)
	rm *.o
	rm $(TMPD)/*.o

$(CLIENT_TCPIP) : $(O_COMMON) $(O_CLNT) $(CORBA_TCPIP_LIB)
	echo ---- Making $@ ----
	$(CPPLINKER) -o $@ $(O_COMMON) $(O_CLNT) $(LIBS)


$(SERVER_TCPIP):  $(O_COMMON) $(O_SERV) $(TCPIP_S) $(TCPIP) $(CORBA_TCPIP_LIB)
	echo ---- Making $@ ----
	$(CPPLINKER) -o $@ $(O_COMMON) $(O_SERV) $(TCPIP_S) $(TCPIP) $(LIBS)






