#include "stdio.h"
#include "tmp/funcargs.h"
#include "print.h"

CORBA_Object getObjectFromIOR_File( char * fname, CORBA_ORB orb, 
                    CORBA_Environment * env )
{
    #define BUFFSIZE 400 
    char buff[ BUFFSIZE + 1 ] ;
    int len ;
    
    FILE * fp = fopen( fname, "r" ) ;

    if ( fp == NULL )
    {
        fprintf( stderr, "Can't open %s\n", fname ) ;
        exit( 0 ) ;
    }
    
    if ( ! fgets( buff, BUFFSIZE, fp ) )
        return NULL ;
    
    fclose( fp ) ;
   
    len = strlen( buff ) ;
    
    if ( len > 0 && ( buff[ len - 1 ] == '\n' ) )
        buff[ len - 1 ] = '\0' ;    /* Perl chop */
        
    return CORBA_ORB_string_to_object( orb, buff, env ) ; 
}

void writeObjectToIOR_File( char * IOR, char * fname )
{
    FILE * fp ;

    if ( ( fp = fopen( fname, "w" ) ) == NULL )
    {
        fprintf( stderr, "Can't open %s\n", fname ) ;
        exit( 0 ) ;
    }
    
    fputs( IOR, fp ) ;
    
    fclose( fp ) ;
}

void writeHTML_file( char * ref, char * applet, char * file )
{
    FILE * fp ;

    if ( ( fp = fopen( file, "w" ) ) == NULL )
    {
        fprintf( stderr, "Can't open %s\n", file ) ;
        exit( 0 ) ;
    }
    
    fputs( "<HTML>", fp ) ;
    fprintf( fp, "<B>The %s applet</B>\n", applet ) ;
    fprintf( fp, "<applet width=300 height=100 codebase=java code=%s.class>\n", applet ) ;
    fprintf( fp, "<param name=IOR value=%s>\n", ref ) ;
    fprintf( fp, "</param>\n</applet>\n</HTML>\n" ) ;
    
    fclose( fp ) ;
}

void printSysException( CORBA_Environment * env )
{
    CORBA_System_Exception * sysExcept ;
    CORBA_char * id ;

    if ( env->_major != CORBA_SYSTEM_EXCEPTION )
        return ;

    id = CORBA_exception_id( env ) ;

    printf( "System exception %s\n", id ) ;

    sysExcept = CORBA_exception_value( env ) ;

    printf( "minor code = %d completion status = %d\n",
        sysExcept->minor_code_value, sysExcept->completion_status ) ;
}

void any_print( CORBA_any * any )
{
    printf( "Any value=" ) ;

    switch ( any->_type.tc )
    {
        case CORBA_tk_short :
        printf( "%d", *( ( CORBA_short * )any->_value ) ) ;
        break ;

        case CORBA_tk_long :
        printf( "%ld", *( ( CORBA_long * )any->_value ) ) ;
        break ;

        case CORBA_tk_string :
        printf( "%s", ( CORBA_char * )any->_value ) ;
        break ;
    }

    printf( "\n" ) ;
}

void seqShort_print( seqShort * s )
{
    CORBA_unsigned_long i, l = s->_length ;
    CORBA_short * p = s->_buffer ;

    for ( i = 0 ; i < l ; i++ )
        printf( "%d ", p[ i ] ) ;

    printf( "\nSeq len=%d\n", s->_length ) ;
}

void fill_fixedStr( fixedStr * p, int series )
{
    p->a    = ( CORBA_char  )series ;
    p->b    = ( CORBA_octet )series ;
    p->c    = series ? CORBA_TRUE : CORBA_FALSE ;
    p->d    = ( CORBA_wchar )series ;
    p->e    = ( CORBA_short )( -series ) ;
    p->f    = ( CORBA_unsigned_short )series ;
    p->g    = -( ( CORBA_long )series + 100000 ) ;
    p->h    = ( CORBA_unsigned_long )series + 100000 ;
    p->i    = ( CORBA_float )series ;
    p->j    = ( CORBA_double )series ;
}

char * CORBA_boolean_print( CORBA_boolean v )
{
    if ( v )
        return "TRUE" ;

    return "FALSE" ;
}

void fixedStr_print( fixedStr * p )
{
    printf( "a = %c : b = %d : ",  p->a, p->b ) ;
    printf( "%s : ", CORBA_boolean_print( p->c ) ) ;
    printf( "d = %d : e = %d : f =%u : ",  p->d, p->e, p->f ) ;
    printf( "g = %ld : h = %lu\n",  p->g, p->h ) ;
    printf( "i = %f : j = %g\n", p->i, p->j ) ;
}


void fill_varStr( varStr * p, int series )
{
    sprintf( p->a, "Series %d", series ) ;

    p->b[ 0 ][ 0 ] = ( short )( series + 1 ) ;
    p->b[ 0 ][ 1 ] = ( short )( series + 2 ) ;
    p->b[ 1 ][ 0 ] = ( short )( series + 3 ) ;
    p->b[ 1 ][ 1 ] = ( short )( series + 4 ) ;

    p->c = series + 20 ;
}

varStr * get_varStr( int series )
{
    varStr * p = varStr__alloc() ;

    p->a = CORBA_string_alloc( 20 ) ;

    fill_varStr( p, series ) ;

    return p ;
}


void varStr_print( varStr * p1 )
{
    printf( "a=\"%s\" : ", p1->a ) ;

    printf( "b=%d %d %d %d : ", p1->b[0][0], p1->b[0][1],
        p1->b[1][0], p1->b[1][1] ) ;

    printf( "c=%d\n", p1->c ) ;
}

void fixedArr_print( fixedArr_slice * s )
{
    int i ;

    for ( i = 0 ; i < 10 ; i++ )
        printf( "[%d]=%d ", i, s[ i ] ) ;

    printf( "\n" ) ;
}

void fill_fixedArr( fixedArr_slice * s, int series )
{
    int i ;

    for ( i = 0 ; i < 10 ; i++ )
        s[ i ] = ( CORBA_short )( series + i ) ;
}

void fill_fixedUnion( int d, fixedUnion * u, int start )
{
    int i ;

    u->_d = ( CORBA_short )d ;

    switch ( d )
    {
        case 0 : u->_u.a = ( CORBA_short )start ; break ;

        case 1 : u->_u.b = ( CORBA_long  )start ; break ;

        case 2 :
        {
            for ( i = 0 ; i <  5 ; i++ )
                u->_u.c[ i ] = ( CORBA_short )start++ ;
        }
        break ;

        case 3 :
        {
            for ( i = 0 ; i < 20 ; i++ )
                u->_u.d[ i ] = ( CORBA_char )start++ ;
        }
        break ;
    }
}

void fixedUnion_print( fixedUnion * u )
{
    int i ;

    CORBA_short d = u->_d ;

    printf( "%d : ", d ) ;

    switch ( d )
    {
        case 0 : printf( "%d", u->_u.a  ) ; break ;

        case 1 :  printf( "%ld", u->_u.b  ) ; break ;

        case 2 :
        {
            for ( i = 0 ; i <  5 ; i++ )
                  printf( "%d, ", u->_u.c[ i ] ) ;
        }
        break ;

        case 3 :
        {
            for ( i = 0 ; i <  20 ; i++ )
                  printf( "%c", u->_u.d[ i ] ) ;
        }
        break ;
    }

    printf( "\n" ) ;
}

static varStr * get_varSeqBuff( int len, int series )
{
    varStr * p ;
    int i ;

    p = CORBA_sequence_varStr_allocbuf( len ) ;

    for ( i = 0 ; i < len ; i++ )
    {
        p[ i ].a = CORBA_string_alloc( 20 ) ;

        fill_varStr( &p[ i ], ( i * 100 ) + series ) ;
    }

    return p ;
}

varSeq * get_varSeq( int len, int series )
{
    varSeq * s = varSeq__alloc() ;
    varStr * p = get_varSeqBuff( len, series ) ;

    s->_length = len ;
    s->_buffer = p ;

    CORBA_sequence_set_release( s, CORBA_TRUE ) ;

    return s ;
}

void varSeq_print( varSeq * v )
{
    varStr * p ;
    int i, len ;

    len = v->_length ;

    p = v->_buffer ;

    for ( i = 0 ; i < len ; i++ )
        varStr_print( &p[ i ] ) ;
}

varArr_slice * get_varArr( int series )
{
    varArr_slice * s = varArr__alloc() ;
    varStr * p ;
    int i ;

    p = s ;

    for ( i = 0 ; i < 10 ; i++ )
    {
        p[ i ].a = CORBA_string_alloc( 20 ) ;

        fill_varStr( &p[ i ], ( i * 100 ) + series ) ;
    }

    return s ;
}

void varArr_print( varArr_slice * v )
{
    varStr * p ;
    int i ;

    p = v ;

    for ( i = 0 ; i < 10 ; i++ )
        varStr_print( &p[ i ] ) ;
}

void fill_varUnion( int d, varUnion * u, int start )
{
    u->_d = ( CORBA_short )d ;

    switch ( d )
    {
        case 1 :
        u->_u.a = CORBA_string_alloc( 30 ) ;
        sprintf( u->_u.a, "%d ---- %d", start, start ) ;
        break ;

        case 2 :
        u->_u.b.a = CORBA_string_alloc( 20 ) ;
        fill_varStr( &u->_u.b, start ) ;
        break ;

        case 3 :
        u->_u.c._buffer = get_varSeqBuff( 5, start ) ;
        u->_u.c._length = 5 ;
        break ;

        default :
        u->_u.d = ( CORBA_short )start ;
        break ;
    }
}

void varUnion_print( varUnion * u )
{
    CORBA_short d = u->_d ;

    switch ( d )
    {
        case 1 :
        printf( "1 : %s", u->_u.a ) ;
        break ;

        case 2 :
        printf( "2 : " ) ;
        varStr_print( &u->_u.b ) ;
        break ;

        case 3 :
        printf( "3 : " ) ;
        varSeq_print( &u->_u.c ) ;
        break ;

        default :
        printf( "default : %d", u->_u.d ) ;
        break ;
    }

    printf( "\n" ) ;
}

varUnion * get_varUnion( int d, int start )
{
    varUnion * u = varUnion__alloc() ;

    fill_varUnion( d, u, start ) ;

    return u ;
}
