#include "stdio.h"
#include "tmp/funcargs.h"
#include "tmp/inherit.h"
#include "print.h"


int main( int argc, char * argv[] )
{
    CORBA_Object * t2_obj ;
    int r ;
    CORBA_Object * secondMod_inner2_obj ;
    CORBA_Environment env ;
    CORBA_ORB orb ;
    CORBA_BOA boa ;
    CORBA_boolean oneShot = CORBA_FALSE ;
    CORBA_char * IOR ;
    
    if ( argc > 1 && ( strcmp( argv[ 1 ], "-o" ) == 0 ) )
        oneShot = CORBA_TRUE ;
        
    orb = CORBA_ORB_init( &argc, argv, "ORB1", &env ) ;

    if ( env._major != CORBA_NO_EXCEPTION )
    {
        printf( "No ORB!\n" ) ;
        exit( -1 ) ;
    }

    boa = CORBA_BOA_init( orb, &argc, argv, "BOA1", &env ) ;

    t2_obj = t2_create_implementation( boa, &env ) ;

    if ( env._major != CORBA_NO_EXCEPTION )
    {
        printf( "Can't create a t2 object\n" ) ;
        exit( -1 ) ;
    }

    IOR = CORBA_ORB_object_to_string( orb, t2_obj, &env ) ; 

    if ( env._major != CORBA_NO_EXCEPTION )
    {
        printSysException( &env ) ;
        printf( "Can't convert to string!\n" ) ;
        exit( -1 ) ;
    }

    writeObjectToIOR_File( IOR, "../t2.ref" ) ;

    writeHTML_file( IOR, "client", "../t2.html" ) ;
    
    CORBA_free( IOR ) ;

    secondMod_inner2_obj = secondMod_inner2_create_implementation( boa, &env ) ;

    if ( env._major != CORBA_NO_EXCEPTION )
    {
        printf( "Can't create a secondMod_inner2 object\n" ) ;
        exit( -1 ) ;
    }

    IOR = CORBA_ORB_object_to_string( orb, secondMod_inner2_obj, &env ) ; 

    if ( env._major != CORBA_NO_EXCEPTION )
    {
        printSysException( &env ) ;
        printf( "Can't convert to string!\n" ) ;
        exit( -1 ) ;
    }

    writeObjectToIOR_File( IOR, "../secondMod_inner2.ref" ) ;

    CORBA_free( IOR ) ;

    for ( ; ; )
    {
        r = CORBA_BOA_implementation_is_ready( boa, &env ) ;

        if ( env._major != CORBA_NO_EXCEPTION )
        {
            fprintf( stderr, "Exception!\n" ) ;
            exit( -1 ) ;
        }
        else if ( r == CORBA_TIMEOUT )
        {
            if ( oneShot )
                break ;
                
            fprintf( stderr, "+" ) ;
        }            
        else
            break ;
    }

    CORBA_free( t2_obj ) ;
    CORBA_free( secondMod_inner2_obj ) ;
    CORBA_free( boa ) ;
    CORBA_free( orb ) ;
    return 0 ;
}

