/**
*      Example 'C' client for T2 object
*      --------------------------------
*
*
*
**/

#if 0
#if defined(__BORLANDC__)
    
#define BC_DLL_funcargs __import
#define BC_DLL_inherit  __import

#elif defined(_MSC_VER)

#define VC_DLL_funcargs __declspec(dllimport)
#define VC_DLL_inherit  __declspec(dllimport)

#endif
#endif

#include "stdio.h"
#include "tmp/funcargs.h"
#include "tmp/inherit.h"
#include "print.h"

static int secondMod_inner2_main( int argc, char ** argv ) ;

static int t2_main( int argc, char ** argv ) ;

static int test_t2_attrLong( t2 * obj ) ;

static int test_t2_tfloat( t2 * obj ) ;

static int test_t2_double( t2 * obj ) ;

static int test_t2_op6( t2 * obj ) ;

static int test_t2_strings( t2 * obj ) ;

static void  test_t2_basicSequence( t2 * obj ) ;

static void test_t2_variableSequence( t2 * obj ) ;

static void test_t2_fixedArray( t2 * obj ) ;

static void test_t2_variableArray( t2 * obj ) ;

static void test_t2_fixed_union( t2 * obj ) ;

static void test_t2_variableUnion( t2 * obj ) ;

static void test_t2_fixed_structure( t2 * obj ) ;

static void test_t2_testAny( t2 * obj ) ;

static void test_t2_throws_a_lot( t2 * obj ) ;

int main( int argc, char ** argv )
{
    if ( ( argc > 1 ) && ( strcmp( argv[ 1 ], "-i" ) == 0 ) )
        return secondMod_inner2_main( argc, argv ) ;

    return t2_main( argc, argv ) ;
}


static int secondMod_inner2_main( int argc, char ** argv )
{
    secondMod_inner2 * obj ;
    CORBA_Environment env ;
    CORBA_Context ctx ;
    CORBA_ORB orb ;
    CORBA_short rtn, O ;
    CORBA_char * IO ;
    CORBA_long ll, L_IO, L_O, L_RTN ;
    
    printf( "Getting orb\n" ) ;

    orb = CORBA_ORB_init( &argc, argv, "orb1", &env ) ;

    printf( "Getting ref\n" ) ;

    obj = ( secondMod_inner2 * )getObjectFromIOR_File( "../secondMod_inner2.ref", orb, &env ) ;

    if ( env._major != CORBA_NO_EXCEPTION )
    {
        printSysException( &env ) ;
        printf( "Can't initialize a secondMod::inner2 object\n" ) ;
        exit( -1 ) ;
    }

    printf( "Calling service secondMod::inner2::set_ll\n" ) ;

    secondMod_inner2__set_ll( obj, 3000, &env ) ;

    if ( env._major != CORBA_NO_EXCEPTION )
        printf( "Major ex = %d\n", env._major ) ;

    printf( "Calling service secondMod::inner2::get_ll\n" ) ;

    ll = secondMod_inner2__get_ll( obj, &env ) ;

    if ( env._major == CORBA_NO_EXCEPTION )
    {
        printf( "ll=%d\n", ll ) ;
    }
    else
    {
        printf( "Major ex = %d\n", env._major ) ;
    }

    printf( "Calling service secondMod::inner2::tshort\n" ) ;

    IO = CORBA_string_copy( "alskals" ) ;
    
    rtn = secondMod_inner2_tshort( obj, 20, &IO, &O, &ctx, &env ) ;

    if ( env._major == CORBA_NO_EXCEPTION )
    {
        printf( "rtn=%d IO=%s O=%d\n", rtn, IO, O ) ;
    }
    else
    {
        printf( "Major ex = %d\n", env._major ) ;
    }

    CORBA_free( IO ) ;

    printf( "Calling service secondMod::inner2::tlong\n" ) ;

    L_IO = 45 ;
    
    L_RTN = secondMod_inner2_tlong( obj, 20, &L_IO, &L_O, &env ) ;

    if ( env._major == CORBA_NO_EXCEPTION )
    {
        printf( "L_RTN=%d L_IO=%d L_O=%d\n", L_RTN, L_IO, L_O ) ;
    }
    else
    {
        printf( "Major ex = %d\n", env._major ) ;
    }

    CORBA_free( obj ) ;

    CORBA_free( orb ) ;

    return 0 ;
}

static int t2_main( int argc, char ** argv )
{
    t2 * obj ;
    CORBA_Environment env ;
    CORBA_ORB orb ;

    printf( "Getting orb\n" ) ;

    orb = CORBA_ORB_init( &argc, argv, "orb1", &env ) ;

    printf( "Getting ref\n" ) ;

    obj = ( t2 * )getObjectFromIOR_File( "../t2.ref", orb, &env ) ;

    if ( env._major != CORBA_NO_EXCEPTION )
    {
        printSysException( &env ) ;
        printf( "Can't initialize a t2 object\n" ) ;
        exit( -1 ) ;
    }

    printf( "Calling service\n" ) ;

    t2_voidOp( obj, &env ) ;

    if ( env._major != CORBA_NO_EXCEPTION )
    {
        printSysException( &env ) ;
        exit( -1 ) ;
    }

    t2_onewayOp( obj, 23, 200000, &env ) ;

    if ( env._major != CORBA_NO_EXCEPTION )
    {
        printSysException( &env ) ;
        exit( -1 ) ;
    }

    test_t2_attrLong( obj ) ;

    test_t2_tfloat( obj ) ;

    test_t2_double( obj ) ;

    test_t2_op6( obj ) ;

    test_t2_strings( obj ) ;

    test_t2_basicSequence( obj ) ;

    test_t2_variableSequence( obj ) ;

    test_t2_variableSequence( obj ) ;

    test_t2_variableSequence( obj ) ;

    test_t2_fixedArray( obj ) ;

    test_t2_variableArray( obj ) ;

    test_t2_fixed_union( obj ) ;

    test_t2_variableUnion( obj ) ;

    test_t2_fixed_structure( obj ) ;

    test_t2_testAny( obj ) ;

    test_t2_throws_a_lot( obj ) ;

    CORBA_free( obj ) ;

    CORBA_free( orb ) ;

    return 0 ;
}

static int test_t2_attrLong( t2 * obj )
{
    long a ;
    CORBA_Environment env ;

    printf( "call t2__set_attrLong : " ) ;

    t2__set_attrLong( obj, 300, &env ) ;

    if ( env._major != CORBA_NO_EXCEPTION )
    {
        printSysException( &env ) ;
        exit( -1 ) ;
    }

    printf( "call t2__get_attrLong : " ) ;

    a = t2__get_attrLong( obj, &env ) ;

    if ( env._major != CORBA_NO_EXCEPTION )
    {
        printSysException( &env ) ;
        exit( -1 ) ;
    }

    printf( "attrLong = %ld\n", a ) ;

    return 0 ;
}

static int test_t2_tfloat( t2 * obj )
{
    float R_float, IO_float, O_float ;
    CORBA_Environment env ;

    IO_float = 6.4 ;

    R_float = t2_tfloat( obj, 25.6, &IO_float, &O_float, &env ) ;

    if ( env._major != CORBA_NO_EXCEPTION )
    {
        printSysException( &env ) ;
        exit( -1 ) ;
    }
    
    printf( "R_float = %f IO_float = %f O_float = %f\n",
             R_float, IO_float, O_float ) ;

    return 0 ;
}

static int test_t2_double( t2 * obj )
{
    double R_dbl, IO_dbl, O_dbl ;
    CORBA_Environment env ;

    IO_dbl = 106.4 ;

    R_dbl = t2_tdouble( obj, 10.6, &IO_dbl, &O_dbl, &env ) ;

    if ( env._major != CORBA_NO_EXCEPTION )
    {
        printSysException( &env ) ;
        exit( -1 ) ;
    }

    printf( "R_dbl = %g IO_dbl = %g O_dbl = %g\n",
             R_dbl, IO_dbl, O_dbl ) ;

    return 0 ;
}

static int test_t2_op6( t2 * obj )
{
    CORBA_Environment env ;

    varStr * p1 = get_varStr(  0 ) ;
    varStr * p2 = get_varStr( 10 ) ;
    varStr * p3, * ret ;

    ret = t2_op6( obj, p1, p2, &p3, &env ) ;

    if ( env._major != CORBA_NO_EXCEPTION )
    {
        printSysException( &env ) ;
        exit( -1 ) ;
    }

    varStr_print( ret ) ;
    varStr_print( p2 ) ;
    varStr_print( p3 ) ;

    CORBA_free( p3 ) ;
    CORBA_free( ret ) ;

    CORBA_free( p1 ) ;
    CORBA_free( p2 ) ;

    return 0 ;
}

static int test_t2_strings( t2 * obj )
{
    CORBA_Environment env ;

    CORBA_char * I = "hello" ;
    CORBA_char * IO = CORBA_string_alloc( 20 ) ;
    CORBA_char * ret, * O ;

    strcpy( IO, "IO param" ) ;

    ret = t2_strings( obj, I, &IO, &O, &env ) ;

    if ( env._major == CORBA_NO_EXCEPTION )
    {
        printf( "ret=%s IO=%s O=%s\n", ret, IO, O ) ;

        CORBA_free( O ) ;
        CORBA_free( ret ) ;
    }
    else
    {
        printSysException( &env ) ;
        exit( -1 ) ;
    }

    CORBA_free( IO ) ;

    return 0 ;
}

static void  test_t2_basicSequence( t2 * obj )
{
    CORBA_Environment env ;
    extern void seqShort_print( seqShort * s ) ;

    CORBA_short * p ;
    seqShort * I, * IO, * rtn, * O ;

    I  = seqShort__alloc() ;
    IO = seqShort__alloc() ;

    I->_length = 3 ;

    p = CORBA_sequence_short_allocbuf( 3 ) ;
    I->_buffer = p ;
    CORBA_sequence_set_release( I, CORBA_TRUE ) ;

    p[ 0 ] = 1000 ;
    p[ 1 ] = 1001 ;
    p[ 2 ] = 1002 ;
    IO->_length = 4 ;

    p = CORBA_sequence_short_allocbuf( 4 ) ;
    IO->_buffer = p ;
    CORBA_sequence_set_release( IO, CORBA_TRUE ) ;

    p[ 0 ] = 2000 ;
    p[ 1 ] = 2001 ;
    p[ 2 ] = 2002 ;
    p[ 3 ] = 2003 ;

    rtn = t2_basicSequence( obj, I, IO, &O, &env ) ;

    if ( env._major == CORBA_NO_EXCEPTION )
    {
        seqShort_print( IO ) ;
        seqShort_print( O ) ;
        seqShort_print( rtn ) ;

        if ( ! CORBA_sequence_get_release( O ) )
            CORBA_free( O->_buffer ) ;

        CORBA_free( O ) ;

        if ( ! CORBA_sequence_get_release( rtn ) )
            CORBA_free( rtn->_buffer ) ;

        CORBA_free( rtn ) ;
    }
    else
    {
        printf( "Major ex = %d\n", env._major ) ;
    }

    CORBA_free( I ) ;
    CORBA_free( IO ) ;
}

static void test_t2_variableSequence( t2 * obj )
{
    CORBA_Environment env ;
    varSeq * rtn, * O ;

    varSeq * I = get_varSeq( 3, 1000 ) ;
    varSeq * IO = get_varSeq( 4, 2000 ) ;

    printf( "call t2::variableSequence\n" ) ;

    rtn = t2_variableSequence( obj, I, IO, &O, &env ) ;

    if ( env._major == CORBA_NO_EXCEPTION )
    {
        varSeq_print( IO ) ;
        varSeq_print( rtn ) ;
        varSeq_print( O ) ;

        if ( ! CORBA_sequence_get_release( O ) )
            CORBA_free( O->_buffer ) ;

        CORBA_free( O ) ;

        if ( ! CORBA_sequence_get_release( rtn ) )
            CORBA_free( rtn->_buffer ) ;

        CORBA_free( rtn ) ;
    }
    else
    {
        printf( "Major ex = %d\n", env._major ) ;
    }

    CORBA_free( I ) ;
    CORBA_free( IO ) ;
}

static void test_t2_fixedArray( t2 * obj )
{
    CORBA_Environment env ;

    fixedArr I, IO, O ;
    fixedArr_slice * rtn ;

    fill_fixedArr( I, 10 ) ;
    fill_fixedArr( IO, 20 ) ;

    printf( "call t2::fixedArray\n" ) ;

    rtn = t2_fixedArray( obj, I, IO, O, &env ) ;

    if ( env._major == CORBA_NO_EXCEPTION )
    {
        fixedArr_print( IO ) ;
        fixedArr_print( rtn ) ;
        fixedArr_print( O ) ;

        CORBA_free( rtn ) ;
    }
    else
    {
        printf( "Major ex = %d\n", env._major ) ;
    }
}

static void test_t2_variableArray( t2 * obj )
{
    CORBA_Environment env ;
    varArr_slice * I, * IO, *O, * rtn ;

    I = get_varArr( 1000 ) ;
    IO = get_varArr( 2000 ) ;

    printf( "call t2::variableArray\n" ) ;

    rtn = t2_variableArray( obj, I, IO, &O, &env ) ;

    if ( env._major == CORBA_NO_EXCEPTION )
    {
        varArr_print( IO ) ;
        varArr_print( rtn ) ;
        varArr_print( O ) ;

        CORBA_free( rtn ) ;
        CORBA_free( O ) ;
    }
    else
    {
        printf( "Major ex = %d\n", env._major ) ;
    }

    CORBA_free( I ) ;
    CORBA_free( IO ) ;
}

static void test_t2_fixed_union( t2 * obj )
{
    CORBA_Environment env ;

    fixedUnion I, IO, O, rtn ;

    fill_fixedUnion( 0, &I, 10 ) ;
    fill_fixedUnion( 2, &IO, 20 ) ;

    printf( "call t2::fixed_union\n" ) ;

    rtn = t2_fixed_union( obj, &I, &IO, &O, &env ) ;

    if ( env._major == CORBA_NO_EXCEPTION )
    {
        fixedUnion_print( &IO ) ;
        fixedUnion_print( &rtn ) ;
        fixedUnion_print( &O ) ;
    }
    else
    {
        printf( "Major ex = %d\n", env._major ) ;
    }
}

static void test_t2_variableUnion( t2 * obj )
{
    CORBA_Environment env ;
    varUnion * I, * IO, *O, * rtn ;

    I  = get_varUnion( 1, 23 ) ;
    IO = get_varUnion( 2, 2000 ) ;

    printf( "call t2::variableUnion\n" ) ;

    rtn = t2_variableUnion( obj, I, IO, &O, &env ) ;

    if ( env._major == CORBA_NO_EXCEPTION )
    {
        varUnion_print( IO ) ;
        varUnion_print( rtn ) ;
        varUnion_print( O ) ;

        CORBA_free( rtn ) ;
        CORBA_free( O ) ;
    }
    else
    {
        printf( "Major ex = %d\n", env._major ) ;
    }

    CORBA_free( I ) ;
    CORBA_free( IO ) ;
}

static void test_t2_fixed_structure( t2 * obj )
{
    CORBA_Environment env ;

    fixedStr I, IO, O, rtn ;

    fill_fixedStr( &I, 48 ) ;
    fill_fixedStr( &IO, 50 ) ;

    printf( "call t2::fixed_structure\n" ) ;

    rtn = t2_fixed_structure( obj, &I, &IO, &O, &env ) ;

    if ( env._major == CORBA_NO_EXCEPTION )
    {
        fixedStr_print( &IO ) ;
        fixedStr_print( &rtn ) ;
        fixedStr_print( &O ) ;
    }
    else
    {
        printf( "Major ex = %d\n", env._major ) ;
    }
}

static void test_t2_testAny( t2 * obj )
{
    CORBA_Environment env ;
    CORBA_any * I, * IO, * O, * rtn ;
    CORBA_short v = 48 ;

    I  = CORBA_any_alloc() ;
    IO = CORBA_any_alloc() ;

    I->_type.tc = CORBA_tk_short ;
    I->_value = ( void * )&v ;

    IO->_type.tc = CORBA_tk_string ;
    IO->_value = "Hi there" ;

    printf( "call t2::testAny\n" ) ;

    rtn = t2_testAny( obj, I, IO, &O, &env ) ;

    if ( env._major == CORBA_NO_EXCEPTION )
    {
        any_print( IO ) ;
        any_print( rtn ) ;
        any_print( O ) ;

        if ( ! CORBA_any_get_release( O ) )
            CORBA_free( O->_value ) ;

        CORBA_free( O ) ;

        if ( ! CORBA_any_get_release( rtn ) )
            CORBA_free( rtn->_value ) ;

        CORBA_free( rtn ) ;
    }
    else
    {
        printf( "Major ex = %d\n", env._major ) ;
    }

    CORBA_free( I ) ;
    CORBA_free( IO ) ;
}


static void test_t2_throws_a_lot( t2 * obj )
{
    CORBA_Environment env ;
    CORBA_short i, rtn ;
    CORBA_char msg[ 50 ], * id ;
    wrecked * w ;
    buggered * b ;
    CORBA_System_Exception * sysExcept ;

    for ( i = 0 ; i < 9 ; i++ )
    {
        printf( "call t2::throws_a_lot\n" ) ;

        sprintf( msg, "%d -- msg - %d", i, i ) ;

        rtn = t2_throws_a_lot( obj, i, msg, &env ) ;

        switch ( env._major )
        {
            case CORBA_NO_EXCEPTION :
            printf( "No exception for case %d - returns %d\n", i, rtn ) ;
            break ;

            case CORBA_SYSTEM_EXCEPTION :
            id = CORBA_exception_id( &env ) ;
            printf( "System exception %s for case %d\n", id, i ) ;
            sysExcept = CORBA_exception_value( &env ) ;
            printf( "minor code = %d completion status = %d\n",
                sysExcept->minor_code_value, sysExcept->completion_status ) ;
            break ;

            case CORBA_USER_EXCEPTION :
            id = CORBA_exception_id( &env ) ;
            printf( "User exception %s for case %d\n", id, i ) ;
            if ( strcmp( id, ex_wrecked ) == 0 )
            {
                w = CORBA_exception_value( &env ) ;
                printf( "Wrecked reason = %s\n", w->reason ) ;
            }
            else if ( strcmp( id, ex_buggered ) == 0 )
            {
                b = CORBA_exception_value( &env ) ;
                printf( "Buggered reason = %s code = %d\n", b->reason, b->code ) ;
            }
            else
            {
                printf( "Wasn't expecting this!!!\n" ) ;
            }
            break ;

            default :
            printf( "Unknown major exception type %d\n", env._major ) ;
            exit( -2 ) ;
            break ;
        }

        CORBA_exception_free( &env ) ;
    }
}

