# Make file

!include $(CORBAD)\bc32.mak

TMPD                = tmp
CC                  = $(CC) -I$(TMPD)

CLIENT_TCPIP_RSP    = test1_c.rsp
SERVER_TCPIP_RSP    = test1_s.rsp
CLIENT_TCPIP        = test1_c.exe
SERVER_TCPIP        = test1_s.exe
O_COMMON            = $(TMPD)\funcargs $(TMPD)\inherit print 
OBJS_COMMON         = $(TMPD)\funcargs.obj $(TMPD)\inherit.obj print.obj 
O_CLNT              = test1 $(TMPD)\funcargs_c $(TMPD)\inherit_c 
OBJS_CLNT           = test1.obj $(TMPD)\funcargs_c.obj $(TMPD)\inherit_c.obj
OBJS_SERV           = $(TMPD)\funcargs_s.obj $(TMPD)\inherit_s.obj t2_Impl.obj secondMod_inner2_Impl.obj servmain.obj
O_SERV              = $(TMPD)\funcargs_s $(TMPD)\inherit_s t2_Impl secondMod_inner2_Impl
FUNCARGS_H          = $(TMPD)\funcargs.h
INPROC              = inproc
TCPIP               =
TCPIP_S             = servmain.obj
OBJS_IP             = print.obj funcargs_i.obj
O_IP                = print funcargs_i

all:    gen tcpip

force:  clean all

regen:  gen all

client_ip:  $(CLIENT_IP)

tcpip: $(CLIENT_TCPIP) $(SERVER_TCPIP)

gen:
        cd $(TMPD)
        make -f bc32.mak
        cd ..

clean:
        -del $(TMPD)\funcargs.h
        -del $(TMPD)\inherit.h
        -del *.obj
        -del *.lib
        -del *.rsp
        -del *.exe
        -del *.dll

$(CLIENT_TCPIP) : $(OBJS_COMMON) $(OBJS_CLNT) $(CLIENT_TCPIP_RSP) $(CORBA_TCPIP_LIB)
            echo ---- Making $@ ----
            $(LINKER) $(LKFLAGS) $(LKF) @$(CLIENT_TCPIP_RSP)

$(CLIENT_TCPIP_RSP):   bc32.mak
            echo $(STARTOBJ) $(O_CLNT) +  > $@
            echo $(O_COMMON) >>  $@
            echo $(CLIENT_TCPIP) >>  $@
            echo map >>  $@
            echo $(CORBA_TCPIP_LIB) $(SLIB_MT) ; >> $@

$(SERVER_TCPIP):  $(OBJS_COMMON) $(OBJS_SERV) $(TCPIP_S) $(TCPIP) $(SERVER_TCPIP_RSP) $(CORBA_TCPIP_LIB)
            echo ---- Making $@ ----
            $(LINKER) $(LKFLAGS) $(LKF) @$(SERVER_TCPIP_RSP)

$(SERVER_TCPIP_RSP):  bc32.mak
                echo $(STARTOBJ) $(O_SERV) + > $@
                echo $(TCPIP_S) $(O_COMMON) >> $@
                echo $(SERVER_TCPIP) >>  $@
                echo map >>  $@
                echo $(CORBA_TCPIP_LIB) $(SLIB_MT) ; >> $@


