# Make file
# Copyright Mitch Britton 1998-1999
# All Rights Reserved
# See the file licence.txt

include ../../gcc.mak

TMPD             = tmp
IDLDIR           = $(CORBAD)/samples/idl
FUNCARGS         = $(TMPD)/funcargs.h $(TMPD)/funcargs.cpp \
$(TMPD)/funcargs_c.cpp $(TMPD)/funcargs_s.cpp
INHERIT          = $(TMPD)/inherit.h $(TMPD)/inherit.cpp \
$(TMPD)/inherit_c.cpp $(TMPD)/inherit_s.cpp

CLIENT_TCPIP     = test1_c
SERVER_TCPIP     = test1_s
O_COMMON         = $(TMPD)/funcargs.o print.o 
O_CLNT           = test1.o $(TMPD)/funcargs_c.o
O_SERV           = $(TMPD)/funcargs_s.o t2_Impl.o \
$(TMPD)/inherit_s.o secondMod_inner2_Impl.o
FUNCARGS_H       = $(TMPD)/funcargs.h
TCPIP_S          = servmain.o

all:    gen tcpip

force:  clean all

tcpip: $(CLIENT_TCPIP) $(SERVER_TCPIP)

gen:    $(FUNCARGS)  $(INHERIT)

$(FUNCARGS):    $(IDLDIR)/funcargs.idl
	java idl -c++ -d $(TMPD) $(IDLDIR)/funcargs

$(INHERIT):    $(IDLDIR)/inherit.idl
	java idl $(IDLDIR)/inherit -c++ -d $(TMPD)

clean:
	-rm $(FUNCARGS)
	-rm $(INHERIT)
	-rm *.o
	-rm $(TMPD)/*.o

$(CLIENT_TCPIP) : $(O_COMMON) $(O_CLNT) $(CORBA_TCPIP_LIB)
	echo ---- Making $@ ----
	$(CPPLINKER) -o $@ $(O_COMMON) $(O_CLNT) $(LIBS)


$(SERVER_TCPIP):  $(O_COMMON) $(O_SERV) $(TCPIP_S) $(TCPIP) $(CORBA_TCPIP_LIB)
	echo ---- Making $@ ----
	$(CPPLINKER) -o $@ $(O_COMMON) $(O_SERV) $(TCPIP_S) $(TCPIP) $(LIBS)


