# Make file

!include $(CORBAD)\ms32.mak

TMPD                = tmp

CLIENT_TCPIP_RSP    = test1_c.rsp
SERVER_TCPIP_RSP    = test1_s.rsp
CLIENT_TCPIP        = test1_c.exe
SERVER_TCPIP        = test1_s.exe
O_COMMON            = print $(TMPD)\funcargs # $(TMPD)\inherit
OBJS_COMMON         = print.obj $(TMPD)\funcargs.obj # $(TMPD)\inherit.obj
O_CLNT              = test1 $(TMPD)\funcargs_c # $(TMPD)\inherit_c
OBJS_CLNT           = test1.obj $(TMPD)\funcargs_c.obj # $(TMPD)\inherit_c.obj
OBJS_SERV           = $(TMPD)\funcargs_s.obj t2_Impl.obj secondMod_inner2_Impl.obj $(TMPD)\inherit_s.obj
O_SERV              = $(TMPD)\funcargs_s t2_Impl secondMod_inner2_Impl $(TMPD)\inherit_s
FUNCARGS_H          = $(TMPD)\funcargs.h
INHERIT_H           = $(TMPD)\inherit.h
INPROC              = inproc
TCPIP               =
TCPIP_S             = servmain.obj

all:    tcpip

force:  clean all

regen:  gen all

client_ip:  $(CLIENT_IP)

tcpip: gen $(CLIENT_TCPIP) $(SERVER_TCPIP)

gen:
        cd $(TMPD)
        nmake -f ms32.mak
        cd ..

clean:
        -del $(TMPD)\funcargs.h
        -del $(TMPD)\inherit.h
        -del *.obj
        -del *.lib
        -del *.rsp
        -del *.exe
        -del *.dll

$(CLIENT_TCPIP) : $(FUNCARGS_H) $(OBJS_COMMON) $(OBJS_CLNT) $(CORBA_TCPIP_LIB) # $(INHERIT_H) 
            echo ---- Making $@ ----
            echo $(O_CLNT) > ms32c.rsp
            echo $(O_COMMON) >> ms32c.rsp
            echo $(CORBA_TCPIP_LIB) >> ms32c.rsp
            $(LINKER) $(LDBF) /out:$(CLIENT_TCPIP) $(LKF) @ms32c.rsp

$(SERVER_TCPIP):  $(FUNCARGS_H) $(OBJS_COMMON) $(OBJS_SERV) $(TCPIP_S) $(TCPIP) $(CORBA_TCPIP_LIB) # $(INHERIT_H) 
            echo ---- Making $@ ----
            echo $(O_SERV) $(TCPIP_S) > ms32s.rsp
            echo $(O_COMMON) >> ms32s.rsp
            echo $(CORBA_TCPIP_LIB) >> ms32s.rsp
            $(LINKER) $(LDBF) /out:$(SERVER_TCPIP) $(LKF) @ms32s.rsp

