#include "stdio.h"
#include "iostream.h"
#include "tmp/funcargs.h"
#include "print.h"

CORBA::Object_ptr getObjectFromIOR_File( char * fname, CORBA::ORB * orb )
{
    #define BUFFSIZE 400 
    char buff[ BUFFSIZE + 1 ] ;
    int len ;
    
    FILE * fp = fopen( fname, "r" ) ;

    if ( fp == NULL )
    {
        fprintf( stderr, "Can't open %s\n", fname ) ;
        exit( 0 ) ;
    }
    
    if ( ! fgets( buff, BUFFSIZE, fp ) )
        return NULL ;
    
    fclose( fp ) ;
   
    len = strlen( buff ) ;
    
    if ( len > 0 && ( buff[ len - 1 ] == '\n' ) )
        buff[ len - 1 ] = '\0' ;    /* Perl chop */
        
    return orb->string_to_object( buff ) ; 
}

void writeObjectToIOR_File( char * IOR, char * fname )
{
    FILE * fp ;

    if ( ( fp = fopen( fname, "w" ) ) == NULL )
    {
        fprintf( stderr, "Can't open %s\n", fname ) ;
        exit( 0 ) ;
    }
    
    fputs( IOR, fp ) ;
    
    fclose( fp ) ;
}

void writeHTML_file( char * ref, char * applet, char * file )
{
    FILE * fp ;

    if ( ( fp = fopen( file, "w" ) ) == NULL )
    {
        fprintf( stderr, "Can't open %s\n", file ) ;
        exit( 0 ) ;
    }
    
    fputs( "<HTML>", fp ) ;
    fprintf( fp, "<B>The %s applet</B>\n", applet ) ;
    fprintf( fp, "<applet width=300 height=100 codebase=java code=%s.class>\n", applet ) ;
    fprintf( fp, "<param name=IOR value=%s>\n", ref ) ;
    fprintf( fp, "</param>\n</applet>\n</HTML>\n" ) ;
    
    fclose( fp ) ;
}


char * CORBA_boolean_print( CORBA::Boolean v )
{
    if ( v )
        return "TRUE" ;

    return "FALSE" ;
}

void varStr_print( const varStr * p1 )
{
    cout << "a=\"" << ( char * )p1->a << "\" : " ;

    cout << "b=" << p1->b[0][0] << " " << p1->b[0][1] << " " << p1->b[1][0] << " " << p1->b[1][1] ;

    cout << " : c=" << p1->c << endl ;
}

void fill_fixedStr( fixedStr & p, int series )
{
    p.a    = ( CORBA::Char  )series ;
    p.b    = ( CORBA::Octet )series ;
    p.c    = series ? CORBA::TRUE : CORBA::FALSE ;
    p.d    = ( CORBA::WChar )series ;
    p.e    = ( CORBA::Short )( -series ) ;
    p.f    = ( CORBA::UShort )series ;
    p.g    = -( ( CORBA::Long )series + 100000 ) ;
    p.h    = ( CORBA::ULong )series + 100000 ;
    p.i    = ( CORBA::Float )series ;
    p.j    = ( CORBA::Double )series ;
}

void fixedStr_print( const fixedStr & p )
{
    cout << "a = " << p.a << " : b = " << ( int )p.b             << " : " ;
    cout << CORBA_boolean_print( p.c )                 << " : " ;
    cout << "d = " << p.d << " : e = " << p.e << " : f =" << p.f << " : " ;
    cout << "g = " << p.g << " : h = " << p.h << endl ;
    cout << "i = " << p.i << " : j = " << p.j << endl ;
}


void fill_varStr( varStr * p, int series )
{
    sprintf( p->a, "Series %d", series ) ;

    p->b[ 0 ][ 0 ] = ( short )( series + 1 ) ;
    p->b[ 0 ][ 1 ] = ( short )( series + 2 ) ;
    p->b[ 1 ][ 0 ] = ( short )( series + 3 ) ;
    p->b[ 1 ][ 1 ] = ( short )( series + 4 ) ;

    p->c = series + 20 ;
}

void get_varStr( varStr & p, int series )
{
    p.a = CORBA::string_alloc( 20 ) ;

    fill_varStr( &p, series ) ;
}

void seqShort_print( const seqShort & s )
{
    CORBA::ULong i, l = s.length() ;

    for ( i = 0 ; i < l ; i++ )
        cout << s[ i ] << " " ;

    cout << "\nSeq len=" << l << endl ;
}

varStr * get_varSeqBuff( int len, int series )
{
    varStr * p ;
    int i ;

    p = varSeq::allocbuf( len ) ;

    for ( i = 0 ; i < len ; i++ )
    {
        p[ i ].a = CORBA::string_alloc( 20 ) ;

        fill_varStr( &p[ i ], ( i * 100 ) + series ) ;
    }

    return p ;
}

void varSeq_print( const varSeq & v )
{
    int i, len ;

    len = v.length() ;

    for ( i = 0 ; i < len ; i++ )
        varStr_print( &v[ i ] ) ;
}

void fixedArr_print( const fixedArr_slice * s )
{
    int i ;

    for ( i = 0 ; i < 10 ; i++ )
        cout << "[" << i << "]=" << s[ i ] << " " ;

    cout << endl ;
}

void fill_fixedArr( fixedArr_slice * s, int series )
{
    int i ;

    for ( i = 0 ; i < 10 ; i++ )
        s[ i ] = ( CORBA_short )( series + i ) ;
}

void get_varArr( varArr_slice * s, int series )
{
    int i ;

    for ( i = 0 ; i < 10 ; i++ )
    {
        s[ i ].a = CORBA::string_alloc( 20 ) ;

        fill_varStr( &s[ i ], ( i * 100 ) + series ) ;
    }
}

void varArr_print( const varArr_slice * v )
{
    int i ;

    for ( i = 0 ; i < 10 ; i++ )
        varStr_print( &v[ i ] ) ;
}

void fill_fixedUnion( int d, fixedUnion & u, int start )
{
    int i ;

    switch ( d )
    {
        case 0 : u.a( ( CORBA::Short )start ) ; break ;

        case 1 : u.b( ( CORBA::Long )start ) ; break ;

        case 2 :
        {
            CORBA::Short tmp[ 5 ] ;
            
            for ( i = 0 ; i < 5 ; i++ )
                tmp[ i ] = ( CORBA::Short )start++ ;

            u.c( tmp ) ;
        }
        break ;

        case 3 :
        {
            CORBA::Char tmp[ 20 ] ;
            
            for ( i = 0 ; i < 20 ; i++ )
                tmp[ i ] = ( CORBA::Char )start++ ;

            u.d( tmp ) ;
        }
        break ;
    }
}

void fixedUnion_print( const fixedUnion & u )
{
    int i ;

    CORBA::Short d = u._d() ;

    cout << d << " : " ;

    switch ( d )
    {
        case 0 : cout << u.a() ; break ;
        case 1 : cout << u.b() ; break ;

        case 2 :
        {
            CORBA::Short * p = u.c() ;
            
            for ( i = 0 ; i <  5 ; i++ )
                cout << p[ i ] << ", " ;
        }
        break ;

        case 3 :
        {
            CORBA::Char * p = u.d() ;
            
            for ( i = 0 ; i < 20 ; i++ )
                cout << p[ i ] ;
        }
        break ;
    }

    cout << endl ;
}

void fill_varUnion( int d, varUnion & u, int start )
{
    u._d( ( CORBA_short )d ) ;

    switch ( d )
    {
        case 1 :
        {
            CORBA::Char * s = CORBA::string_alloc( 30 ) ;
            sprintf( s, "%d ---- %d", start, start ) ;
            u.a( s ) ;
        }
        break ;

        case 2 :
        {
            varStr s ;
            s.a = CORBA::string_alloc( 30 ) ;
            fill_varStr( &s, start ) ;
            u.b( s ) ;
        }
        break ;

        case 3 :
        {
            varSeq s( 5, get_varSeqBuff( 5, start ), CORBA::TRUE ) ;
        
            u.c( s ) ;
        }
        break ;

        default :
        u.d( ( CORBA_short )start ) ;
        break ;
    }
}

void varUnion_print( const varUnion & u )
{
    CORBA::Short d = u._d() ;

    switch ( d )
    {
        case 1 :
        cout << "1 : " << u.a() ;
        break ;

        case 2 :
        cout << "2 : " ;
        varStr_print( &u.b() ) ;
        break ;

        case 3 :
        cout << "3 : " ;
        varSeq_print( u.c() ) ;
        break ;

        default :
        cout << "default : " << u.d() ;
        break ;
    }

    cout << endl ;
}


void any_print( const CORBA::Any & any )
{
    cout << "Any value=" ;

    CORBA::TypeCode * tc = any.type() ;
    
    if ( *tc == CORBA::tk_short )
    {
        CORBA::Short s ;
        any >>= s ;
        cout << s ;
    }        
    else if ( *tc == CORBA::tk_long )
    {
        CORBA::Long l ;
        any >>= l ;
        cout << l ;
    }        
    else if ( *tc == CORBA::tk_string )
    {
        char * str ;
        any >>= str ;
        cout << str ;
    }        

    cout << endl ;
}
