#include "t2_Impl.h"
#include "secondMod_inner2_Impl.h"

int main( int argc, char * argv[] )
{
    CORBA::Boolean oneShot = CORBA::FALSE ;
    
    if ( argc > 1 && ( strcmp( argv[ 1 ], "-o" ) == 0 ) )
        oneShot = CORBA::TRUE ;
        
    try
    {
        CORBA::ORB_ptr orb = CORBA::ORB_init( argc, argv ) ;
        CORBA::BOA_ptr boa = orb->BOA_init( argc, argv ) ;    

        t2_Impl t2 ;

        boa->obj_is_ready( &t2 ) ;

        CORBA::String_var IOR = orb->object_to_string( &t2 ) ; 

        writeObjectToIOR_File( IOR, "../t2.ref" ) ;

        writeHTML_file( IOR, "client", "../t2.html" ) ;
        
        secondMod_inner2_Impl obj2 ;

        boa->obj_is_ready( &obj2 ) ;

        IOR = orb->object_to_string( &obj2 ) ; 
        
        writeObjectToIOR_File( IOR, "../secondMod_inner2.ref" ) ;
        
        for ( ; ; )
        {
            if ( boa->impl_is_ready() == CORBA_TIMEOUT )
            {
                if ( oneShot )
                    break ;
                    
                cerr << "+" << flush ;
            }                
            else
                break ;
        }
    }
    catch ( CORBA::Exception & e )
    {
        cerr << e << endl ;
    }

    return 0 ;
}
