#include "t2_Impl.h"

void t2_Impl::attrLong( CORBA::Long attrLong ) throw( CORBA::SystemException )
{
    m_attrLong = attrLong ;
}


CORBA::Long t2_Impl::attrLong() throw( CORBA::SystemException )
{
     return m_attrLong ;
}

void t2_Impl::onewayOp( CORBA::Short Is, CORBA::Long Il ) throw( CORBA::SystemException ) 
{
    cout << "t2::onewayOp called with " << Is << " " << Il << endl ;
}

void t2_Impl::voidOp() throw( CORBA::SystemException )
{
    cout << "t2::voidOp called" << endl ;
}

CORBA::Short t2_Impl::op2( CORBA::Short I, CORBA::Short & IO, CORBA::Short & O ) throw( CORBA::SystemException )
{
    cout << "I = " << I << " IO = " << IO << endl ;

    O = ( CORBA::Short )( I + IO ) ;

    IO += ( CORBA::Short )1 ;

    return ( CORBA::Short )( I - IO ) ;
}

CORBA::Float t2_Impl::tfloat( CORBA::Float I, CORBA::Float & IO, CORBA::Float & O ) throw( CORBA::SystemException )
{
    cout << "I = " << I << " IO = " << IO << endl ;

    O = I + IO ;

    IO += 1 ;

    return I - IO ;
}

CORBA::Double t2_Impl::tdouble( CORBA::Double I, CORBA::Double & IO, CORBA::Double & O ) throw( CORBA::SystemException )
{
    cout << "I = " << I << " IO = " << IO ;

    O = I + IO ;

    CORBA::Double rtn = I - IO ;

    IO -= 100 ;
    
    cout << " : rtn=" << rtn << " IO=" << IO << " O=" << O << endl ;

    return rtn ;
}

dogs t2_Impl::op4( const dogs I, dogs & IO, dogs & O ) throw( CORBA::SystemException )
{
    dogs _rtn = poodle ;
    O = mongrel ;

    ( void )I ;
    ( void )IO ;

     return _rtn ;
}

fixedStr t2_Impl::fixed_structure( const fixedStr & I, fixedStr & IO, fixedStr & O ) throw( CORBA::SystemException )
{
    fixedStr rtn  ;

    fixedStr_print( I ) ;
    fixedStr_print( IO ) ;

    fill_fixedStr( IO, 70 ) ;
    fill_fixedStr( rtn, 71 ) ;
    fill_fixedStr( O, 72 ) ;

    return rtn ;
}

varStr * t2_Impl::op6( const varStr & I, varStr & IO, varStr *& O ) throw( CORBA::SystemException )
{
    const char * iomsg = "io param" ;
    CORBA::Short inc = 200 ;
    
    O = new varStr() ;
    get_varStr( *O, 100 ) ;

    varStr * ret = new varStr() ;
    get_varStr( *ret, 300 ) ;

    varStr_print( &I ) ;
    varStr_print( &IO ) ;

    IO.a = iomsg ;

    IO.b[0][0] += inc ;
    IO.b[0][1] += inc ;
    IO.b[1][0] += inc ;
    IO.b[1][1] += inc ;

    IO.c += inc ;

    return ret ;
}

fixedUnion t2_Impl::fixed_union( const fixedUnion & I, fixedUnion & IO, fixedUnion & O ) throw( CORBA::SystemException )
{
    fixedUnion _rtn  ;

    fixedUnion_print( I ) ;
    fixedUnion_print( IO ) ;

    fill_fixedUnion( 1, _rtn, 100 ) ;
    fill_fixedUnion( 3, IO, ( int )'a' ) ;
    fill_fixedUnion( 3, O, ( int )'A' ) ;

    return _rtn ;
}

varUnion * t2_Impl::variableUnion( const varUnion & I, varUnion & IO, varUnion *& O ) throw( CORBA::SystemException )
{
    varUnion * rtn = new varUnion() ;
    
    fill_varUnion( -1, *rtn, 30000 ) ;

    O  = new varUnion() ;
    
    fill_varUnion( 3, *O, 500 ) ;

    varUnion_print( I ) ;
    varUnion_print( IO ) ;

    fill_varUnion( 1, IO, 90 ) ;

    return rtn ;
}

char * t2_Impl::strings( const char * I, char * & IO, char * & O ) throw( CORBA::SystemException )
{
    char * rtnmsg = "&return this string&" ;
    char * opmsg = "output string!" ;
    char * iomsg = "modified input/output string!" ;

    char * _rtn  = CORBA::string_dup( rtnmsg ) ;

    O = CORBA::string_dup( opmsg ) ;

    cout << "t2_op9_i -- I=" << I << " IO=" << IO << endl ;

    if ( strlen( IO ) < strlen( iomsg ) )
    {
        CORBA::string_free( IO ) ;

        IO = CORBA::string_dup( iomsg ) ;
    }
    else
        strcpy( IO, iomsg ) ;
        
    return _rtn ;
}

seqShort * t2_Impl::basicSequence( const seqShort & I, seqShort & IO, seqShort *& O ) throw( CORBA::SystemException )
{
    CORBA::Short * p = seqShort::allocbuf( 2 ) ;
    seqShort * rtn = new seqShort( 2, p, CORBA::TRUE ) ;     // do release the buffer

    (*rtn)[ 0 ] = 4000 ;
    (*rtn)[ 1 ] = 4001 ;

    p = seqShort::allocbuf( 5 ) ;
    seqShort * tmp = new seqShort( 5, p, CORBA::TRUE ) ;
    IO = *tmp ;
    delete tmp ;
    
    IO[ 0 ] = 2010 ;
    IO[ 1 ] = 2011 ;
    IO[ 2 ] = 2012 ;
    IO[ 3 ] = 2013 ;
    IO[ 4 ] = 2014 ;
    
    p = seqShort::allocbuf( 3 ) ;
    O = new seqShort( 3, p, CORBA::TRUE ) ;     // do release the buffer
    (*O)[ 0 ] = 3000 ;
    (*O)[ 1 ] = 3001 ;
    (*O)[ 2 ] = 3002 ;

    seqShort_print( I ) ;
    seqShort_print( IO ) ;

    return rtn ;
}

varSeq * t2_Impl::variableSequence( const varSeq & I, varSeq & IO, varSeq *& O ) throw( CORBA::SystemException )
{
    static int i = 0 ;

    varSeq * rtn, * tmp ;
    varStr * t ;

    CORBA::ULong IO_len, IO_seq, rtn_len, rtn_seq, O_len, O_seq ;
    
    switch ( i )
    {
        case 1 :
        IO_len = 2 ;
        IO_seq = 10000 ;
        rtn_len = 2 ;
        rtn_seq = 11000 ;
        O_len = 2 ;
        O_seq = 12000 ;
        break ;

        case 2 :
        IO_len = 8 ;
        IO_seq = 20000 ;
        rtn_len = 3 ;
        rtn_seq = 21000 ;
        O_len = 3 ;
        O_seq = 22000 ;
        break ;

        default :
        IO_len = 0 ;
        rtn_len = 5 ;
        rtn_seq = 5000 ;
        O_len = 6 ;
        O_seq = 6000 ;
        break ;
    }

    if ( IO_len )
    {
        t = get_varSeqBuff( IO_len, IO_seq ) ;
        tmp = new varSeq( IO_len, t, CORBA::TRUE ) ;  
        IO = *tmp ;
        delete tmp ;
    }
    
    t = get_varSeqBuff( rtn_len, rtn_seq ) ;
    rtn = new varSeq( rtn_len, t, CORBA::TRUE ) ;

    t = get_varSeqBuff( O_len, O_seq ) ;
    O = new varSeq( O_len, t, CORBA::TRUE ) ;

    i++ ;

    varSeq_print( I ) ;
    varSeq_print( IO ) ;

    return rtn ;
}

fixedArr_slice * t2_Impl::fixedArray( const fixedArr I, fixedArr IO, fixedArr O ) throw( CORBA::SystemException )
{
    fixedArr_slice * rtn = fixedArr_alloc() ;

    fixedArr_print( I ) ;
    fixedArr_print( IO ) ;

    fill_fixedArr( rtn, 40 ) ;
    fill_fixedArr( IO, 50 ) ;
    fill_fixedArr( O, 60 ) ;

    return rtn ;
}

varArr_slice * t2_Impl::variableArray( const varArr I, varArr IO, varArr_slice *& O ) throw( CORBA::SystemException )
{
    varArr_slice * rtn  = varArr_alloc() ;

    O = varArr_alloc() ;
    
    get_varArr( rtn, 3000 ) ;

    get_varArr( O, 4000 ) ;

    varArr_print( I ) ;
    varArr_print( IO ) ;

    return rtn ;
}

CORBA::Any * t2_Impl::testAny( const CORBA::Any & I, CORBA::Any & IO, CORBA::Any *& O ) throw( CORBA::SystemException )
{
    any_print( I ) ;
    any_print( IO ) ;

    O = new CORBA::Any() ;
    *O <<= ( const char * )"output an any" ;

    CORBA::Any * rtn = new CORBA::Any() ;
    *rtn <<= ( CORBA::Long )2000000 ;

    IO <<= ( const char * )"io parameter changed !" ;

    return rtn ;
}

CORBA::Short t2_Impl::throws_a_lot( CORBA::Short I, const char * reason ) throw( CORBA::SystemException, wrecked, buggered )
{
    switch ( I )
    {
        case 0 :
        break ;

        case 1 :
        case 2 :
        case 3 :
        {
            wrecked w ;
            w.reason = reason ;
            throw w ;
        }

        case 4 :
        case 5 :
        case 6 :
        {
            buggered b ;
            b.reason = reason ;
            b.code = I ;
            throw b ;
        }

        case 7 :
        throw CORBA::BAD_PARAM( 7, CORBA::COMPLETED_YES ) ;

        case 8 :
        throw CORBA::NO_MEMORY( 8, CORBA::COMPLETED_MAYBE ) ;
    }

    return 0 ;
}


#if 0


#if C_ONLY

CORBA_fixed_5_3 t2_op3( t2 _o, CORBA_fixed_5_4 * I, CORBA_fixed_5_5 * IO,
    CORBA_fixed_5_1 * O, CORBA_Environment * ev )
{
    CORBA_fixed_5_3 _rtn  ;
    _rtn._digits = 3 ;
    ( void )_o ; ( void )ev ;
    ( void )I ;
    ( void )IO ;
    ( void )O ;
     return _rtn ;
}

#endif

dogs t2_op4( t2 _o, dogs I, dogs * IO, dogs * O, CORBA_Environment * ev )
{
    dogs _rtn  = 0 ;
    ( void )_o ; ( void )ev ;
    ( void )I ;
    ( void )IO ;
    ( void )O ;
     return _rtn ;
}


fixedStr t2_fixed_structure( t2 _o, fixedStr * I, fixedStr * IO, fixedStr * O,
    CORBA_Environment * ev )
{
}


fixedUnion t2_fixed_union( t2 _o, fixedUnion * I, fixedUnion * IO,
    fixedUnion * O, CORBA_Environment * ev )
{
}


varUnion * t2_variableUnion( t2 _o, varUnion * I, varUnion * IO,
    varUnion ** O, CORBA_Environment * ev )
{
}


CORBA_char * t2_strings( t2 _o, CORBA_char * I, CORBA_char ** IO,
    CORBA_char ** O, CORBA_Environment * ev )
{
}


seqShort * t2_basicSequence( t2 _o, seqShort * I, seqShort * IO,
    seqShort ** O, CORBA_Environment * ev )
{
    CORBA_short * p ;
    seqShort * _rtn  = seqShort__alloc() ;
    seqShort * op  = seqShort__alloc() ;

    ( void )_o ; ( void )ev ;

    *O = op ;

    seqShort_print( I ) ;
    seqShort_print( IO ) ;

    CORBA_free( IO->_buffer ) ;
    IO->_length = 5 ;
    p = CORBA_sequence_short_allocbuf( 5 ) ;
    IO->_buffer = p ;
    CORBA_sequence_set_release( IO, CORBA_TRUE ) ;

    p[ 0 ] = 2010 ;
    p[ 1 ] = 2011 ;
    p[ 2 ] = 2012 ;
    p[ 3 ] = 2013 ;
    p[ 4 ] = 2014 ;

    op->_length = 3 ;

    p = CORBA_sequence_short_allocbuf( 3 ) ;
    op->_buffer = p ;
    CORBA_sequence_set_release( op, CORBA_TRUE ) ;

    p[ 0 ] = 3000 ;
    p[ 1 ] = 3001 ;
    p[ 2 ] = 3002 ;

    _rtn->_length = 2 ;
    p = CORBA_sequence_short_allocbuf( 3 ) ;
    _rtn->_buffer = p ;
    CORBA_sequence_set_release( _rtn, CORBA_TRUE ) ;
    p[ 0 ] = 4000 ;
    p[ 1 ] = 4001 ;

    return _rtn ;
}

varSeq * t2_variableSequence( t2 _o, varSeq * I, varSeq * IO, varSeq ** O,
    CORBA_Environment * ev )
{
    static int i = 0 ;

    varSeq * rtn, * tmp ;

    switch ( i )
    {
        case 1 :
        CORBA_free( IO->_buffer ) ;
        tmp = get_varSeq( 2, 10000 ) ;
        IO->_buffer = tmp->_buffer ;
        IO->_length = tmp->_length ;
        CORBA_sequence_set_release( tmp, CORBA_FALSE ) ;
        CORBA_free( tmp ) ;
        rtn = get_varSeq( 2, 11000 ) ;
        *O = get_varSeq( 2, 12000 ) ;
        break ;

        case 2 :
        CORBA_free( IO->_buffer ) ;
        tmp = get_varSeq( 8, 20000 ) ;
        IO->_buffer = tmp->_buffer ;
        IO->_length = tmp->_length ;
        CORBA_sequence_set_release( tmp, CORBA_FALSE ) ;
        CORBA_free( tmp ) ;
        rtn = get_varSeq( 3, 21000 ) ;
        *O = get_varSeq( 3, 22000 ) ;
        break ;

        default :
        rtn = get_varSeq( 5, 5000 ) ;
        *O = get_varSeq( 6, 6000 ) ;
        break ;
    }

    i++ ;

    ( void )_o ; ( void )ev ;

    varSeq_print( I ) ;
    varSeq_print( IO ) ;

     return rtn ;
}


fixedArr_slice * t2_fixedArray( t2 _o, fixedArr I, fixedArr IO, fixedArr O,
    CORBA_Environment * ev )
{
    fixedArr_slice * rtn = fixedArr__alloc() ;

    ( void )_o ; ( void )ev ;

    fixedArr_print( I ) ;
    fixedArr_print( IO ) ;

    fill_fixedArr( rtn, 40 ) ;
    fill_fixedArr( IO, 50 ) ;
    fill_fixedArr( O, 60 ) ;

    return rtn ;
}


varArr_slice * t2_variableArray( t2 _o, varArr I, varArr IO,
    varArr_slice ** O, CORBA_Environment * ev )
{
}

CORBA_any * t2_testAny( t2 _o, CORBA_any * I, CORBA_any * IO, CORBA_any ** O, CORBA_Environment * _ev )
{
    CORBA_any * rtn  = CORBA_any_alloc() ;
    CORBA_char * p = CORBA_string_alloc( 20 ) ;
    CORBA_long * l = CORBA_malloc( sizeof( CORBA_long ) ) ;

    *l = 2000000 ;

    any_print( I ) ;
    any_print( IO ) ;

    strcpy( p, "output an any" ) ;

    *O = CORBA_any_alloc() ;

    CORBA_any_set_release( *O, CORBA_TRUE ) ;
    CORBA_any_set_release( rtn, CORBA_TRUE ) ;

    rtn->_type.tc  = CORBA_tk_long ;
    rtn->_value = l ;

    (*O)->_type.tc  = CORBA_tk_string ;
    (*O)->_value = p ;

    if ( CORBA_any_get_release( IO ) )
        CORBA_free( IO->_value ) ;

    p = CORBA_string_alloc( 40 ) ;
    strcpy( p, "io parameter changed !" ) ;

    IO->_value = p ;
    CORBA_any_set_release( IO, CORBA_TRUE ) ;

    ( void )_o ; ( void )_ev ;

    return rtn ;
}


CORBA_short t2_throws_a_lot( t2 _o, CORBA_short I, CORBA_char * reason, CORBA_Environment * _ev )
{
    wrecked * w ;
    buggered * b ;
    CORBA_System_Exception sysExcept ;

    switch ( I )
    {
        case 0 :
        break ;

        case 1 :
        case 2 :
        case 3 :
        w = wrecked__alloc() ;
        w->reason = CORBA_string_alloc( strlen( reason ) ) ;
        strcpy( w->reason, reason ) ;
        CORBA_BOA_set_exception( _o, _ev, CORBA_USER_EXCEPTION, ex_wrecked, w ) ;
        CORBA_free( w ) ;
        break ;

        case 4 :
        case 5 :
        case 6 :
        b = buggered__alloc() ;
        b->reason = CORBA_string_alloc( strlen( reason ) ) ;
        b->code = I ;
        strcpy( b->reason, reason ) ;
        CORBA_BOA_set_exception( _o, _ev, CORBA_USER_EXCEPTION, ex_buggered, b ) ;
        CORBA_free( b ) ;
        break ;

        case 7 :
        sysExcept.minor_code_value = 7 ;
        sysExcept.completion_status = CORBA_COMPLETED_YES ;
        CORBA_BOA_set_exception( _o, _ev, CORBA_SYSTEM_EXCEPTION, ex_CORBA_BAD_PARAM, &sysExcept ) ;
        break ;

        case 8 :
        sysExcept.minor_code_value = 8 ;
        sysExcept.completion_status = CORBA_COMPLETED_MAYBE ;
        CORBA_BOA_set_exception( _o, _ev, CORBA_SYSTEM_EXCEPTION, ex_CORBA_NO_MEMORY, &sysExcept ) ;
        break ;
    }

    return 0 ;
}

#endif


