//    Example C++ client for T2 object
//    --------------------------------
//
//    Copyright Mitch Britton 1998-1999
//    All Rights Reserved
//    See the file licence.txt

#include "stdio.h"
#include "iostream.h"
#include "tmp/funcargs.h"
#include "tmp/inherit.h"
#include "print.h"

class T2Client
{
private:
    CORBA::ORB_ptr orb ;
    t2_var objref ;
    secondMod::inner2_ptr i2_objref ;
public:    
    T2Client( int argc, char ** argv ) ;
    ~T2Client() ;
    int test() ;
    void testAttrLong() ;
    void testFloat() ;
    void testDouble() ;
    void testOp6() ;
    void testStrings() ;
    void testBasicSequence() ;
    void testVariableSequence() ;
    void testFixedArray() ;
    void testVariableArray() ;
    void testFixedUnion() ;
    void testVariableUnion() ;
    void testFixedStructure() ;
    void test_throws_a_lot() ;
    void testAny() ;
} ;

const static char * orb_identifier = "orb1" ;

static void printSysException( CORBA::SystemException & s ) ;

int main( int argc, char ** argv )
{
    try
    {
        T2Client t2( argc, argv ) ;

        t2.test() ;
    }
    catch ( CORBA::SystemException & e )
    {
        printSysException( e ) ;
        cout << "Unexpected system exception" << endl ;
        return -1 ;
    }

    return 0 ;
}


T2Client::T2Client( int argc, char ** argv )
{
    char * service =  "IDL:t2:1.0" ;

    cout << "Getting orb" << endl ;

    objref = NULL ;
    orb = NULL ;
    
    try
    {
        orb = CORBA::ORB_init( argc, argv, orb_identifier ) ;

        cout << "Getting ref" << endl ;

        CORBA::Object_var p = getObjectFromIOR_File( "../t2.ref", orb ) ;

        objref = t2::_narrow( p ) ;
    }
    catch ( CORBA::SystemException e )
    {
        printSysException( e ) ;
        cout << "Can't initialize a " << service << " object" << endl ;
        exit( -1 ) ;
    }
}

T2Client::~T2Client()
{
}

int T2Client::test() 
{
    cout << "Calling service" << endl ;

    objref->voidOp() ;

    objref->onewayOp( 23, 200000 ) ;

    testAttrLong() ;

    testFloat() ;

    testDouble() ;
    
    testOp6() ;

    testStrings() ;

    testBasicSequence() ;

    testVariableSequence() ;

    testVariableSequence() ;

    testVariableSequence() ;

    testFixedArray() ;

    testVariableArray() ;

    testFixedUnion() ;

    testVariableUnion() ;

    testFixedStructure() ;

    test_throws_a_lot() ;

    testAny() ;

    return 0 ;
}

void T2Client::testAttrLong()
{
    long a ;

    cout << "call t2__set_attrLong : " ;

    objref->attrLong( 300 ) ;

    cout << "call t2__get_attrLong : " ;

    a = objref->attrLong() ;

    cout << "attrLong = " << a << endl ;
}

void T2Client::testFloat()
{
    float R_float, IO_float, O_float ;

    IO_float = 6.4 ;

    R_float = objref->tfloat( 25.6, IO_float, O_float ) ;

    cout << "R_float = " << R_float << " IO_float = " << IO_float << 
            " O_float = " << O_float << endl ;
}

void T2Client::testDouble()
{
    double R_dbl, IO_dbl, O_dbl ;

    IO_dbl = 106.4 ;

    R_dbl = objref->tdouble( 10.6, IO_dbl, O_dbl ) ;

    cout << "R_dbl = " << R_dbl << " IO_dbl = " << IO_dbl << " O_dbl = " << O_dbl << endl ;
}

void T2Client::testOp6()
{
    varStr p1, p2, * p3, * ret ;

    get_varStr( p1, 0 ) ;
    get_varStr( p2, 10 ) ;

    ret = objref->op6( p1, p2, p3 ) ;

    varStr_print( ret ) ;
    varStr_print( &p2 ) ;
    varStr_print( p3 ) ;

    delete p3 ;
    delete ret ;
}

void T2Client::testStrings()
{
    CORBA::String_var I  = ( const char * )"hello" ;
    CORBA::String_var IO, O, ret ;

    IO = ( const char * )"IO param" ;
    
    ret = objref->strings( I, IO.inout(), O.out() ) ;

    cout << "ret=" << ( char * )ret << " IO=" << ( char * )IO << " O=" << ( char * )O << endl ;
}

void T2Client::testBasicSequence()
{
    const CORBA::ULong Isize = 3, IOsize = 4 ;
    static CORBA::Short arr[ Isize ] = { 1000, 1001, 1002 } ;
    CORBA::Short * p = seqShort::allocbuf( IOsize ) ;

    seqShort I( Isize, arr ) ;                  // don't release the buffer
    seqShort IO( IOsize, p, CORBA::TRUE ) ;     // do release the buffer

    seqShort * rtn, * O ;

    IO[ 0 ] = 2000 ;
    IO[ 1 ] = 2001 ;
    IO[ 2 ] = 2002 ;
    IO[ 3 ] = 2003 ;

    rtn = objref->basicSequence( I, IO, O ) ;

    seqShort_print( IO ) ;
    seqShort_print( *O ) ;
    seqShort_print( *rtn ) ;

    delete rtn ;
    delete O ;
}

void T2Client::testVariableSequence()
{
    const CORBA::ULong Isize = 3, IOsize = 4 ;
    varSeq * rtn, * O ;

    varSeq I( Isize, get_varSeqBuff( Isize, 1000 ), CORBA::TRUE ) ;
    varSeq IO( IOsize, get_varSeqBuff( IOsize, 2000 ), CORBA::TRUE ) ;

    cout << "call t2::variableSequence" << endl ;

    rtn = objref->variableSequence( I, IO, O ) ;

    varSeq_print( IO ) ;
    varSeq_print( *rtn ) ;
    varSeq_print( *O ) ;

    delete O ;
    delete rtn ;
}


void T2Client::testFixedArray()
{
    fixedArr I, IO, O ;
    fixedArr_slice * rtn ;

    fill_fixedArr( I, 10 ) ;
    fill_fixedArr( IO, 20 ) ;

    cout << "call t2::fixedArray" << endl ;

    rtn = objref->fixedArray( I, IO, O ) ;

    fixedArr_print( IO ) ;
    fixedArr_print( rtn ) ;
    fixedArr_print( O ) ;

    fixedArr_free( rtn ) ;
}

void T2Client::testVariableArray()
{
    varArr I, IO ;
    varArr_slice * O, * rtn ;

    get_varArr( I, 1000 ) ;
    get_varArr( IO, 2000 ) ;

    cout << "call t2::variableArray" << endl ;

    rtn = objref->variableArray( I, IO, O ) ;

    varArr_print( IO ) ;
    varArr_print( rtn ) ;
    varArr_print( O ) ;

    varArr_free( rtn ) ;
    varArr_free( O ) ;
}


void T2Client::testFixedUnion()
{
    fixedUnion I, IO, O, rtn ;

    fill_fixedUnion( 0, I, 10 ) ;
    fill_fixedUnion( 2, IO, 20 ) ;

    cout << "call t2::fixed_union" << endl ;

    rtn = objref->fixed_union( I, IO, O ) ;

    fixedUnion_print( IO ) ;
    fixedUnion_print( rtn ) ;
    fixedUnion_print( O ) ;
}


void T2Client::testVariableUnion()
{
    varUnion I, IO, * O, * rtn ;

    fill_varUnion( 1, I, 23 ) ;
    fill_varUnion( 2, IO, 2000 ) ;

    cout << "call t2::variableUnion" << endl ;

    rtn = objref->variableUnion( I, IO, O ) ;

    varUnion_print( IO ) ;
    varUnion_print( *rtn ) ;
    varUnion_print( *O ) ;

    delete rtn ;
    delete O ;
}

void T2Client::testFixedStructure()
{
    fixedStr I, IO, O, rtn ;

    fill_fixedStr( I, 48 ) ;
    fill_fixedStr( IO, 50 ) ;

    cout << "call t2::fixed_structure" << endl ;

    rtn = objref->fixed_structure( I, IO, O ) ;

    fixedStr_print( IO ) ;
    fixedStr_print( rtn ) ;
    fixedStr_print( O ) ;
}

void T2Client::test_throws_a_lot()
{
    CORBA::Short i, rtn ;
    char msg[ 30 ] ;
    
    for ( i = 0 ; i < 9 ; i++ )
    {
        cout << "call t2::throws_a_lot" << endl ;

        sprintf( msg, "%d -- msg - %d", i, i ) ;

        try
        {
            rtn = objref->throws_a_lot( i, msg ) ;

            cout << "No exception for case " << i << " - returns " << rtn << endl ;
        }
        catch ( CORBA::BAD_PARAM & e )
        {
            cout << "System exception BAD_PARAM for case " << i << endl ;

            cout << "minor code = " << e.minor() << " completion status = " << 
                e.completed() << endl ;
        }
        catch ( CORBA::NO_MEMORY & e )
        {
            cout << "System exception NO_MEMORY for case " << i << endl ;

            cout << "minor code = " << e.minor() << " completion status = " << 
                e.completed() << endl ;
        }
        catch ( wrecked & w )
        {
            cout << "User exception " << w.id() << " for case " << i << endl ;
            cout << "Wrecked reason = " << ( char * )w.reason << endl ;
        }
        catch ( buggered & b )
        {
            cout << "User exception " << b.id() << " for case " << i << endl ;
            cout << "Buggered reason = " << ( char * )b.reason << " code = " << b.code << endl ;
        }        
    }
}

void T2Client::testAny()
{
    CORBA::Any I, IO, * O, * rtn ;

    I  <<= ( CORBA::Short )48 ;
    IO <<= ( const char * )"Hi there" ;

    cout << "call t2::testAny" << endl ;

    rtn = objref->testAny( I, IO, O ) ;

    any_print( IO ) ;
    any_print( *rtn ) ;
    any_print( *O ) ;

    delete O ;
    delete rtn ;
}



static void printSysException( CORBA::SystemException & s )
{
    cout << "System exception " << s.id() << endl ;

    cout << "minor code = " << s.minor() << " completion status = " << s.completed() << endl ;
}

