public class client extends java.applet.Applet
{
    t2 obj ;
    org.omg.CORBA.ORB orb ;
    boolean doAny ;

    public static void main( String[] args )
    {
        System.out.println( "args.length=" + args.length ) ;

        try
        {
            client c = new client( args ) ;
            c.test() ;
            c.destroy() ;
        }
        catch( org.omg.CORBA.SystemException sysE )
        {
            System.out.println( "CORBA System Exception caught" ) ;
            sysE.printStackTrace() ;
            System.exit( -1 ) ;
        }
        catch ( Exception e )
        {
            System.out.println( "Exception caught" ) ;
            e.printStackTrace() ;
            System.exit( -1 ) ;
        }
    }

    client( String[] args )
    {
        java.util.Properties props = Init.getProperties() ;

        orb = org.omg.CORBA.ORB.init( args, props ) ;

        String ref = Init.readIOR_file( "../t2.ref" ) ;

        org.omg.CORBA.Object _obj = orb.string_to_object( ref ) ;

        obj = t2Helper.narrow( _obj ) ;

        if ( args.length > 0 && args[ 0 ].equals( "-any" ) )
           doAny = true ;
        else
           doAny = false ;
    }

    public client()
    {
        super() ;
    }

    public void init()
    {
        obj = null ;

        System.out.println( "client loaded" ) ;

        String ref = getParameter( "IOR" ) ;

        System.out.println( "ref=" + ref ) ;

        if ( ref != null )
        {
            orb = org.omg.CORBA.ORB.init( this, null ) ;  // Initialize the ORB.

            if ( orb != null )
            {
                System.out.println( "orb ok" ) ;
            
                org.omg.CORBA.Object _obj = orb.string_to_object( ref ) ;

                if ( _obj != null )
                    System.out.println( "obj ok - now narrow" ) ;
                
                obj = t2Helper.narrow( _obj ) ;
            }
        }
    }

    public void start()
    {
        System.out.println( "client starts" ) ;

        if ( obj == null )
            System.out.println( "Can't initialize object" ) ;
        else
            test() ;
    }

    public void stop()
    {
        System.out.println( "client stops" ) ;
    }

    public void destroy()
    {
        System.out.println( "client destroyed" ) ;

        // orb.disconnect( obj ) ;
    }

    void test()
    {
        obj.voidOp() ;

        obj.onewayOp( ( short )23, 200000 ) ;

        int a = 302 ;

        obj.attrLong( a ) ;

        a = 22 ;

        a = obj.attrLong() ;

        System.out.println( "attrlong=" + a ) ;

        testFloat( ( float )25.6, ( float )6.4 ) ;
        testDouble( 10.6, 106.4 ) ;
        test_varStr() ;
        test_strings() ;
        test_basicSequence() ;
        test_variableSequence() ;
        test_variableSequence() ;
        test_variableSequence() ;
        test_fixedArray() ;
        test_variableArray() ;
        test_fixedUnion() ;
        test_variableUnion() ;
        test_fixed_structure() ;
        test_any() ;
        test_throws_a_lot() ;

        if ( doAny )
            testAny() ;
    }

    void testFloat( float I, float IO )
    {
        org.omg.CORBA.FloatHolder IO_float = new org.omg.CORBA.FloatHolder( IO ) ;
        org.omg.CORBA.FloatHolder O_float  = new org.omg.CORBA.FloatHolder() ;

        float R_float = obj.tfloat( I, IO_float, O_float ) ;

        System.out.println( "R_float = " + R_float + " IO_float = " + IO_float.value +
            " O_float = " + O_float.value ) ;
    }

    void testDouble( double I, double IO )
    {
        org.omg.CORBA.DoubleHolder IO_double = new org.omg.CORBA.DoubleHolder( IO ) ;
        org.omg.CORBA.DoubleHolder O_double  = new org.omg.CORBA.DoubleHolder() ;

        double R_double = obj.tdouble( I, IO_double, O_double ) ;

        System.out.println( "R_double = " + R_double + " IO_double = " + IO_double.value +
            " O_double = " + O_double.value ) ;
    }

    void test_varStr()
    {
        varStr I = t2support.get_varStr(  0 ) ;
        varStrHolder IO = new varStrHolder( t2support.get_varStr( 10 ) ) ;
        varStrHolder O  = new varStrHolder() ;

        varStr ret = obj.op6( I, IO, O ) ;

        t2support.print_varStr( ret ) ;
        t2support.print_varStr( IO.value ) ;
        t2support.print_varStr( O.value ) ;
    }

    private void test_strings()
    {
        String I = "hello" ;
        org.omg.CORBA.StringHolder IO = new org.omg.CORBA.StringHolder( "IO param" ) ;
        org.omg.CORBA.StringHolder O = new org.omg.CORBA.StringHolder() ;

        String ret = obj.strings( I, IO, O ) ;

        System.out.println( "ret=" + ret + " IO=" + IO.value + " O=" + O.value ) ;
    }

    private void test_basicSequence()
    {
        short[] I = t2support.get_seqShort( 3, ( short )1000 ) ;
        seqShortHolder IO = new seqShortHolder( t2support.get_seqShort( 4, ( short )2000 ) ) ;
        seqShortHolder O = new seqShortHolder() ;

        short[] rtn = obj.basicSequence( I, IO, O ) ;

        t2support.print_seqShort( IO.value ) ;
        t2support.print_seqShort( O.value ) ;
        t2support.print_seqShort( rtn ) ;
    }

    private void test_variableSequence()
    {
        varStr[] I = t2support.get_varSeq( 3, 1000 ) ;
        varSeqHolder IO = new varSeqHolder( t2support.get_varSeq( 4, 2000 ) ) ;
        varSeqHolder O = new varSeqHolder() ;

        System.out.println( "call t2::variableSequence" ) ;
        varStr[] rtn = obj.variableSequence( I, IO, O ) ;

        t2support.print_varSeq( IO.value ) ;
        t2support.print_varSeq( rtn ) ;
        t2support.print_varSeq( O.value ) ;
    }

    private void test_fixedArray()
    {
        fixedArrHolder IO = new fixedArrHolder() ;
        fixedArrHolder O  = new fixedArrHolder() ;

        short[] I = t2support.fill_fixedArr( 10 ) ;
        IO.value = t2support.fill_fixedArr( 20 ) ;

        System.out.println( "call t2::fixedArray" ) ;

        short[] rtn = obj.fixedArray( I, IO, O ) ;

        t2support.print_fixedArr( IO.value ) ;
        t2support.print_fixedArr( rtn ) ;
        t2support.print_fixedArr( O.value ) ;
    }

    private void test_variableArray()
    {
        varStr[] I = t2support.get_varArr( 1000 ) ;
        varArrHolder IO = new varArrHolder( t2support.get_varArr( 2000 ) ) ;
        varArrHolder O = new varArrHolder() ;

        System.out.println( "call t2::variableArray" ) ;

        varStr[] rtn = obj.variableArray( I, IO, O ) ;

        t2support.print_varArr( IO.value ) ;
        t2support.print_varArr( rtn ) ;
        t2support.print_varArr( O.value ) ;
    }

    private void test_fixedUnion()
    {
        fixedUnion I = t2support.get_fixedUnion( 0, 10 ) ;
        fixedUnionHolder IO = new fixedUnionHolder( t2support.get_fixedUnion( 2, 20 ) ) ;
        fixedUnionHolder O = new fixedUnionHolder() ;

        System.out.println( "call t2::fixed_union" ) ;

        fixedUnion rtn = obj.fixed_union( I, IO, O ) ;

        t2support.print_fixedUnion( IO.value ) ;
        t2support.print_fixedUnion( rtn ) ;
        t2support.print_fixedUnion( O.value ) ;
    }

    private void test_variableUnion()
    {
        varUnion I = t2support.get_varUnion( 1, 23 ) ;
        varUnionHolder IO = new varUnionHolder( t2support.get_varUnion( 2, 2000 ) ) ;
        varUnionHolder O = new varUnionHolder() ;

        System.out.println( "call t2::variableUnion" ) ;

        varUnion rtn = obj.variableUnion( I, IO, O ) ;

        t2support.print_varUnion( IO.value ) ;
        t2support.print_varUnion( rtn ) ;
        t2support.print_varUnion( O.value ) ;
    }

    private void test_fixed_structure()
    {
        fixedStr I = new fixedStr() ;
        fixedStrHolder IO = new fixedStrHolder( new fixedStr() ) ;
        fixedStrHolder O = new fixedStrHolder() ;

        t2support.fill_fixedStr( I, 48 ) ;
        t2support.fill_fixedStr( IO.value, 50 ) ;

        System.out.println( "call t2::fixed_structure" ) ;

        fixedStr rtn = obj.fixed_structure( I, IO, O ) ;

        t2support.print_fixedStr( IO.value ) ;
        t2support.print_fixedStr( rtn ) ;
        t2support.print_fixedStr( O.value ) ;
    }


    private void test_any()
    {
        org.omg.CORBA.Any I = orb.create_any() ;
        org.omg.CORBA.AnyHolder IO = new org.omg.CORBA.AnyHolder( orb.create_any() ) ;
        org.omg.CORBA.AnyHolder O = new org.omg.CORBA.AnyHolder() ;

        I.insert_short( ( short )48 ) ;
        IO.value.insert_string( "Hi there" ) ;

        System.out.println( "call t2::testAny" ) ;

        org.omg.CORBA.Any rtn = obj.testAny( I, IO, O ) ;

        t2support.print_any( IO.value ) ;
        t2support.print_any( rtn ) ;
        t2support.print_any( O.value ) ;
    }

    private void testAny()
    {
        org.omg.CORBA.Any I = orb.create_any() ;
        org.omg.CORBA.AnyHolder IO = new org.omg.CORBA.AnyHolder( orb.create_any() ) ;
        org.omg.CORBA.AnyHolder O = new org.omg.CORBA.AnyHolder() ;
        org.omg.CORBA.Any rtn ;

        short[] fa = t2support.fill_fixedArr( 130 ) ;
        fixedArrHelper.insert( I, fa ) ;

        fixedStr fstr = new fixedStr() ;

        t2support.fill_fixedStr( fstr, 48 ) ;
        fixedStrHelper.insert( IO.value, fstr ) ;

        System.out.println( "call t2::testAny" ) ;

        rtn = obj.testAny( I, IO, O ) ;

        t2support.print_any( IO.value ) ;
        t2support.print_any( rtn ) ;
        t2support.print_any( O.value ) ;

        fixedUnionHelper.insert( I, t2support.get_fixedUnion( 1, 5 ) ) ;
        fixedUnionHelper.insert( IO.value, t2support.get_fixedUnion( 2, 50 ) ) ;

        System.out.println( "call t2::testAny" ) ;

        rtn = obj.testAny( I, IO, O ) ;

        t2support.print_any( IO.value ) ;
        t2support.print_any( rtn ) ;
        t2support.print_any( O.value ) ;
    }

    private void test_throws_a_lot()
    {
        for ( int i = 0 ; i < 9 ; i++ )
        {
            System.out.println( "call t2::throws_a_lot" ) ;

            String msg = i + " -- msg - " + i ;

            try
            {
                short rtn = obj.throws_a_lot( ( short )i, msg ) ;

                System.out.println( "No exception for case " + i + " - returns " + rtn ) ;
            }
            catch( org.omg.CORBA.SystemException sysE )
            {
                System.out.println( "System exception " + sysE.getMessage() + " for case " + i ) ;

                System.out.println( "minor code = " + sysE.minor +
                    " completion status = " + sysE.completed.value() ) ;
            }
            catch ( wrecked we )
            {
                System.out.println( "User exception wrecked for case " + i ) ;
                System.out.println( "Wrecked reason = " + we.reason ) ;
            }
            catch ( buggered b )
            {
                System.out.println( "User exception buggered for case " + i ) ;
                System.out.println( "Buggered reason = " + b.reason + " code = " + b.code ) ;
            }
        }
    }
}

