/****************************************************************************
    INI Test v1.3
    by Joe Barta  jbarta@apk.net
    http://junior.apk.net/~jbarta/initest/
    Demonstrates the basic setting and retrieving of ini file data.
    Note this is not ALL that is possible... just the basics.

    By the way, this code was lovingly edited by hand and compiled with
    LCC-Win32. The only "wizard" used was the LCC resource editor that I
    used to rough out the dialog box layout.

    Version history:
    1.3 Added capacity to read/write integer values too. Made the "get
        ini file name & path" routine a self contained function.
    1.2 Re-wrote to make the code much more useable and RE-useable.
    1.1 Problem! The program couldn't find the ini file if a shortcut
        to the program didn't "Start in" the same folder as the
        program itself. Seems the GetFullPathName function returns the
        path of the "Start in" directory rather than the application
        directory. Such is the life of a hack I suppose.
        Corrected the misspelt "Retrive Entries" in the dialog box.
        Fiddled with the layout a little.
    1.0 Initial release

****************************************************************************/

#include <windows.h>
#include <string.h>
#include <stdlib.h>
#include "initest.h"

HINSTANCE hInstance; // hInstance of the application

// declare global variables
char lpIniFileName[] = "initest.ini"; // self-explanatory
char lpIniFileNameAndPath[256];       // storage area for ini file name + path
char lpIniSection[64];                // storage area for section name
char lpIniKeyName[128];               // storage area for key name
char lpIniKeyData[1024];              // storage area for data found in, or written to keys
INT INI_KEY_INTEGER = 0;              // storage area for integer value 
DWORD INI_DATA_BUFFER_SIZE = 1024;    // size of destination buffer above (lpIniKeyData)
char lpIniDefaultString[] = "\0";     // default string if no data (or key, or section) is found. \0 basically means "empty string"
char *p;                              // used in getting the ini file path


// Ini function prototypes
BOOL ReadWriteIniData (LPSTR, LPSTR, INT);
BOOL GetIniFilePath (VOID);

// read/write/int flags
INT ACTION;
#define READ_STRING   1
#define WRITE_STRING  2
#define READ_INTEGER  3
#define WRITE_INTEGER 4

/************************************************************************** 
This is what does the work... 

ReadWriteIniData( strcpy(lpIniSection, "fruit" ), // copies the string into lpIniSection
                  strcpy(lpIniKeyName, "name"  ), // copies the string into lpIniKeyName
                  WRITE_STRING                 ); // sets ACTION

You specify the section name, the key name and whether you wish to
read/write string/integer.
***************************************************************************/



BOOL CALLBACK DlgProc(HWND hDlg, UINT Message, WPARAM wParam, LPARAM lParam)
{
   switch (Message)
   {
      case WM_INITDIALOG:

         /* We must determine the path of the ini file when the program starts.
          * We are assuming th in file is in the same directory as the program itself.
          * By the way, if this were a normal windowed application, as opposed
          *  to a dialog box based application, this would go in WM_CREATE.
         *********************************************************************/

         GetIniFilePath();
         break;

      case WM_COMMAND:
         switch(LOWORD(wParam))
         {

            case IDC_FRUIT_SET_BUTTON:

               // read what's in the fruit/name edit box and store it in lpIniKeyData
               GetDlgItemText(hDlg, IDC_FRUIT_NAME, lpIniKeyData, (INT) INI_DATA_BUFFER_SIZE);
               // Execute the ReadWrite function sending it the section & key name and an action parameter (READ_STRING, WRITE_STRING, READ_INTEGER, WRITE_INTEGER)
               ReadWriteIniData( strcpy(lpIniSection, "fruit" ), // copies the string into lpIniSection
                                 strcpy(lpIniKeyName, "name"  ), // copies the string into lpIniKeyName
                                 WRITE_STRING                   ); // sets ACTION

               // read what's in the fruit/color edit box and store it in lpIniKeyData
               GetDlgItemText(hDlg, IDC_FRUIT_COLOR, lpIniKeyData, (INT) INI_DATA_BUFFER_SIZE);
               // Execute the ReadWrite function sending it the section & key name and an action parameter (READ_STRING, WRITE_STRING, READ_INTEGER, WRITE_INTEGER)
               ReadWriteIniData( strcpy(lpIniSection, "fruit" ), // copies the string into lpIniSection
                                 strcpy(lpIniKeyName, "color" ), // copies the string into lpIniKeyName
                                 WRITE_STRING                   ); // sets ACTION

               // read what's in the fruit/quantity edit box and place it in INI_KEY_INTEGER
               // Note we're handling this a little differently than the two above. Still, the same
               // stuff goes to the ReadWriteIniData function
               INI_KEY_INTEGER = GetDlgItemInt(hDlg, IDC_FRUIT_QUANTITY, NULL, FALSE);
               // Execute the ReadWrite function sending it the section & key name and an action parameter (READ_STRING, WRITE_STRING, READ_INTEGER, WRITE_INTEGER)
               ReadWriteIniData( strcpy(lpIniSection, "fruit"    ), // copies the string into lpIniSection
                                 strcpy(lpIniKeyName, "quantity" ), // copies the string into lpIniKeyName
                                 WRITE_INTEGER                    ); // sets ACTION

               break;

            case IDC_FRUIT_RETRIEVE_BUTTON:

               // Execute the ReadWrite function sending it the section & key name and an action parameter (READ_STRING, WRITE_STRING, READ_INTEGER, WRITE_INTEGER)
               ReadWriteIniData( strcpy(lpIniSection, "fruit" ), // copies the string into lpIniSection
                                 strcpy(lpIniKeyName, "name"  ), // copies the string into lpIniKeyName
                                 READ_STRING                  ); // sets ACTION
               // Place data into appropriate box
               SetDlgItemText(hDlg, IDC_FRUIT_NAME, lpIniKeyData);

               // Execute the ReadWrite function sending it the section & key name and an action parameter (READ_STRING, WRITE_STRING, READ_INTEGER, WRITE_INTEGER)
               ReadWriteIniData( strcpy(lpIniSection, "fruit" ), // copies the string into lpIniSection
                                 strcpy(lpIniKeyName, "color" ), // copies the string into lpIniKeyName
                                 READ_STRING                  ); // sets ACTION
               // Place data into appropriate box
               SetDlgItemText(hDlg, IDC_FRUIT_COLOR, lpIniKeyData);

               // Execute the ReadWrite function sending it the section & key name and an action parameter (READ_STRING, WRITE_STRING, READ_INTEGER, WRITE_INTEGER)
               ReadWriteIniData( strcpy(lpIniSection, "fruit"    ), // copies the string into lpIniSection
                                 strcpy(lpIniKeyName, "quantity" ), // copies the string into lpIniKeyName
                                 READ_INTEGER                    ); // sets ACTION
               // Place data into appropriate box (This is an integer so we do it slightly differently)
               SetDlgItemInt(hDlg, IDC_FRUIT_QUANTITY, INI_KEY_INTEGER, FALSE);

               break;

            case IDC_FRUIT_CLEAR_BUTTON:
               SetDlgItemText(hDlg, IDC_FRUIT_NAME,     "\0");
               SetDlgItemText(hDlg, IDC_FRUIT_COLOR,    "\0");
               SetDlgItemText(hDlg, IDC_FRUIT_QUANTITY, "\0"); // even though this is a numbers only box, we seem to be able to clear it this way
               break;

            case IDM_ABOUT:
               MessageBox( hDlg,   "INI Test v1.3\r\n\r\nby Joe Barta - jbarta@apk.net\r\nhttp://junior.apk.net/~jbarta/initest/\r\n\r\nDemonstrates the basic setting and retrieving of ini file data.  \r\nNote this is not ALL that is possible... just the basics.", "About", MB_OK | MB_ICONINFORMATION );
               break;

            case IDCANCEL:
               EndDialog(hDlg,FALSE);
               break;
         }
         break;

      default:
         return FALSE;
   }

return TRUE;
}


int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
   DialogBox(hInstance, MAKEINTRESOURCE(MAINDLG), 0, DlgProc);
   return 0;
}


BOOL ReadWriteIniData (LPSTR lpIniSection, LPSTR lpIniKeyName, INT ACTION)
{
   if (ACTION == READ_STRING)
   {
      GetPrivateProfileString( lpIniSection,         // points to section name 
                               lpIniKeyName,         // points to key name 
                               lpIniDefaultString,   // points to default string 
                               lpIniKeyData,         // points to destination buffer 
                               INI_DATA_BUFFER_SIZE, // size of destination buffer 
                               lpIniFileNameAndPath  // points to ini file name 
                               );
      return TRUE;
   }

   if (ACTION == WRITE_STRING)
   {
      WritePrivateProfileString( lpIniSection,         // pointer to section name 
                                 lpIniKeyName,         // pointer to key name 
                                 lpIniKeyData,         // pointer to string to add 
                                 lpIniFileNameAndPath  // pointer to ini file name 
                                 );
      return TRUE;
   }

   if (ACTION == READ_INTEGER)
   {
      INI_KEY_INTEGER = GetPrivateProfileInt( lpIniSection,         // points to section name 
                                              lpIniKeyName,         // points to key name 
                                              0,                    // return value if key name is not found 
                                              lpIniFileNameAndPath  // points to ini file name 
                                              );
      return TRUE;
   }

   if (ACTION == WRITE_INTEGER)
   {
      strcpy (lpIniKeyData, "\0");                     // clear the storage area (more or less)
      itoa (INI_KEY_INTEGER, lpIniKeyData, 10);        // convert the integer value into a string before storing it as a string (below)
      WritePrivateProfileString( lpIniSection,         // pointer to section name 
                                 lpIniKeyName,         // pointer to key name 
                                 lpIniKeyData,         // pointer to string to add 
                                 lpIniFileNameAndPath  // pointer to ini file name 
                                 );
      return TRUE;
      // Note we can Get an integer OR string but we can only Write a string
   }

   return FALSE;
}



BOOL GetIniFilePath (VOID)
{
   // First get the full path of the application (C:\DIR\DIR\APP.EXE)
   GetModuleFileName(hInstance, lpIniFileNameAndPath, sizeof(lpIniFileNameAndPath));

   // Then trim off the program name leaving just the path to the directory (C:\DIR\DIR\)
   p = lpIniFileNameAndPath;
   while(strchr(p,'\\')) {  // while there are more separators
      p = strchr(p,'\\');   // point to next separator
      p++;                  // point to char after last separator
   }
   *p = '\0';               // terminate string
   // lpIniFileNameAndPath now has the application's directory

   // append ini file name to the path (C:\DIR\DIR\initest.ini)
   strcat(lpIniFileNameAndPath, lpIniFileName);

   // Thanks to Robert Mashlan's Windows programmer FAQ
   // for much of the above code (http://www.r2m.com/win-developer-FAQ/)

   return TRUE;
}

