VERSION 4.00
Begin VB.Form Form1 
   Caption         =   "IO ActiveX Control Demo Application.                Visit: JSPayne.com"
   ClientHeight    =   5970
   ClientLeft      =   1335
   ClientTop       =   1470
   ClientWidth     =   8880
   Height          =   6375
   Left            =   1275
   LinkTopic       =   "Form1"
   ScaleHeight     =   5970
   ScaleWidth      =   8880
   Top             =   1125
   Width           =   9000
   Begin VB.CommandButton CommandCancelIO 
      Caption         =   "CancelIO()"
      Height          =   255
      Left            =   240
      TabIndex        =   38
      Top             =   1800
      Width           =   1815
   End
   Begin VB.CommandButton CommandWriteFile 
      Caption         =   "Write file to Port"
      Height          =   255
      Left            =   240
      TabIndex        =   37
      Top             =   2160
      Width           =   1815
   End
   Begin VB.FileListBox File1 
      Height          =   1035
      Left            =   240
      Pattern         =   "*.txt;*.bin"
      TabIndex        =   36
      Top             =   2400
      Width           =   1815
   End
   Begin VB.CheckBox CheckAutoRead 
      Caption         =   "Auto read on IOQueueEvent"
      Height          =   195
      Left            =   3120
      TabIndex        =   35
      Top             =   2160
      Width           =   2895
   End
   Begin VB.CommandButton ClearWriteWin 
      Caption         =   "Clear"
      Height          =   255
      Left            =   5280
      TabIndex        =   34
      Top             =   840
      Width           =   1215
   End
   Begin VB.CommandButton ClearReadWin 
      Caption         =   "Clear"
      Height          =   255
      Left            =   5280
      TabIndex        =   33
      Top             =   2400
      Width           =   1215
   End
   Begin VB.CheckBox CheckSym 
      Caption         =   "Use symbols for binary data. Ex:<ESC>"
      Height          =   195
      Left            =   2880
      TabIndex        =   32
      Top             =   600
      Width           =   3135
   End
   Begin VB.CommandButton Command6 
      Caption         =   "ReadData()"
      Height          =   255
      Left            =   3840
      TabIndex        =   29
      Top             =   2400
      Width           =   1455
   End
   Begin VB.CommandButton Command5 
      Caption         =   "WriteData()"
      Height          =   255
      Left            =   3840
      TabIndex        =   28
      Top             =   840
      Width           =   1455
   End
   Begin VB.CommandButton PortSettingsButton 
      Caption         =   "Serial Port Settings"
      Height          =   255
      Left            =   240
      TabIndex        =   26
      Top             =   1560
      Width           =   1815
   End
   Begin VB.Frame Frame2 
      Caption         =   "I/O Events"
      Height          =   2175
      Left            =   120
      TabIndex        =   22
      Top             =   3720
      Width           =   8655
      Begin VB.CommandButton Command7 
         Caption         =   "Clear Event List"
         Height          =   255
         Left            =   4920
         TabIndex        =   30
         Top             =   600
         Width           =   1815
      End
      Begin VB.CheckBox Check6 
         Caption         =   "Enable Periodic Event"
         Height          =   255
         Left            =   240
         TabIndex        =   27
         Top             =   240
         Width           =   2895
      End
      Begin VB.TextBox EventIntervalText 
         Height          =   285
         Left            =   3120
         TabIndex        =   25
         Top             =   600
         Width           =   735
      End
      Begin VB.TextBox TextEvents 
         Height          =   1215
         Left            =   120
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertical
         TabIndex        =   23
         Top             =   960
         Width           =   8415
      End
      Begin VB.Label Label7 
         Caption         =   "StatusEventInterval (Event Sensitivity)"
         Height          =   255
         Left            =   240
         TabIndex        =   24
         Top             =   600
         Width           =   2895
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Status by Polling"
      Height          =   3015
      Left            =   6600
      TabIndex        =   10
      Top             =   600
      Width           =   2175
      Begin VB.CheckBox Check5 
         Caption         =   "Power Off"
         Height          =   255
         Left            =   840
         TabIndex        =   21
         Top             =   1200
         Width           =   1095
      End
      Begin VB.CheckBox Check18 
         Caption         =   "RLSD On"
         Height          =   255
         Left            =   840
         TabIndex        =   20
         Top             =   2400
         Width           =   1095
      End
      Begin VB.CheckBox Check17 
         Caption         =   "Ring On"
         Height          =   255
         Left            =   840
         TabIndex        =   19
         Top             =   2160
         Width           =   975
      End
      Begin VB.CheckBox Check16 
         Caption         =   "DSR On"
         Height          =   255
         Left            =   840
         TabIndex        =   18
         Top             =   1920
         Width           =   1095
      End
      Begin VB.CheckBox Check15 
         Caption         =   "CTS On"
         Height          =   255
         Left            =   840
         TabIndex        =   17
         Top             =   1680
         Width           =   975
      End
      Begin VB.CheckBox Check4 
         Caption         =   "Busy"
         Height          =   255
         Left            =   840
         TabIndex        =   14
         Top             =   960
         Width           =   735
      End
      Begin VB.CheckBox Check3 
         Caption         =   "Paper Empty"
         Height          =   255
         Left            =   840
         TabIndex        =   13
         Top             =   720
         Width           =   1215
      End
      Begin VB.CheckBox Check2 
         Caption         =   "Selected"
         Height          =   255
         Left            =   840
         TabIndex        =   12
         Top             =   480
         Width           =   975
      End
      Begin VB.CheckBox Check1 
         Caption         =   "Off Line"
         Height          =   255
         Left            =   840
         TabIndex        =   11
         Top             =   240
         Width           =   975
      End
      Begin VB.Timer Timer1 
         Interval        =   500
         Left            =   240
         Top             =   2160
      End
      Begin VB.Label Label6 
         Caption         =   "Serial:"
         Height          =   255
         Left            =   240
         TabIndex        =   16
         Top             =   1680
         Width           =   495
      End
      Begin VB.Label Label5 
         Caption         =   "Parallel:"
         Height          =   255
         Left            =   120
         TabIndex        =   15
         Top             =   240
         Width           =   615
      End
   End
   Begin VB.TextBox TextRead 
      Height          =   975
      Left            =   2280
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   8
      Top             =   2640
      Width           =   4215
   End
   Begin VB.TextBox TextWrite 
      Height          =   975
      Left            =   2280
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   7
      Text            =   "IODemo.frx":0000
      Top             =   1080
      Width           =   4215
   End
   Begin VB.CommandButton Command4 
      Caption         =   "Close() Port"
      Height          =   255
      Left            =   240
      TabIndex        =   6
      Top             =   1320
      Width           =   1815
   End
   Begin VB.CommandButton Command3 
      Caption         =   "ReadString()"
      Height          =   255
      Left            =   2280
      TabIndex        =   5
      Top             =   2400
      Width           =   1575
   End
   Begin VB.CommandButton Command2 
      Caption         =   "WriteString()"
      Height          =   255
      Left            =   2280
      TabIndex        =   4
      Top             =   840
      Width           =   1575
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Open() Port for I/O"
      Height          =   255
      Left            =   240
      TabIndex        =   3
      Top             =   1080
      Width           =   1815
   End
   Begin VB.ComboBox Combo1 
      Height          =   315
      Left            =   240
      TabIndex        =   2
      Text            =   "Select a Port"
      Top             =   720
      Width           =   1815
   End
   Begin VB.OptionButton Option2 
      Caption         =   "Background I/O (Mode = 2)"
      Height          =   255
      Left            =   240
      TabIndex        =   1
      Top             =   360
      Width           =   2535
   End
   Begin VB.OptionButton Option1 
      Caption         =   "Normal I/O (Mode = 0)"
      Height          =   255
      Left            =   240
      TabIndex        =   0
      Top             =   120
      Width           =   1935
   End
   Begin VB.Label Label1 
      Alignment       =   2  'Center
      Caption         =   "Binary data as <value> Ex: <27>"
      Height          =   255
      Left            =   2520
      TabIndex        =   31
      Top             =   360
      Width           =   3735
   End
   Begin VB.Label Label4 
      BackStyle       =   0  'Transparent
      Caption         =   "Select a port. Open the Port. Write/Read to/from the Port."
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2280
      TabIndex        =   9
      Top             =   120
      Width           =   6615
   End
   Begin IOLib.IO IO1 
      Left            =   8040
      Top             =   0
      _Version        =   65536
      _ExtentX        =   1270
      _ExtentY        =   1270
      _StockProps     =   0
   End
End
Attribute VB_Name = "Form1"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Public PortName As String
Public PortOpen As Integer
Public PerEventCounter As Integer
Public EventCounter As Integer

Private Symbols(32) As String
Private Sub Check6_Click()
If Form1.Check6 = 0 Then
IO1.PeriodicEventEnabled = False
'Form1.Option3 = False
Else
IO1.PeriodicEventEnabled = True
'Form1.Option3 = False
End If


End Sub


Private Sub ClearReadWin_Click()
TextRead.Text = ""
End Sub

Private Sub ClearWriteWin_Click()
TextWrite.Text = ""
End Sub

Private Sub Combo1_Click()
IO1.Close
PortOpen = False
PortName = Combo1.Text
End Sub


Private Sub Command1_Click()
Dim Result As Integer

PortName = Combo1.Text

If (Left(PortName, 6) = "Select") Then
MsgBox ("You Must select a port before you can Open a port.")
Exit Sub
End If

If PortOpen = True Then
IO1.Close
PortOpen = False
End If


If (Left(PortName, 3) = "COM") Or (Left(PortName, 7) = "\\.\COM") Then
'Result = IO1.Open(PortName, "baud=9600 parity=N data=7 stop=1")
Result = IO1.Open(PortName, "baud=9600 parity=N data=8 stop=1")
'IO1.SetHandshaking (HS_HARDWARE)
MsgBox ("The serial port is opened with the following settings: baud=9600 parity=N data=8 stop=1 (no handshaking)")
PortSettingsButton.Enabled = True
Else
Result = IO1.Open(PortName, "")
PortSettingsButton.Enabled = False
End If

If (Result = 0) Then
MsgBox ("Open failed, Ensure other devices/drivers are not using this port.")
PortOpen = False
Else
PortOpen = True
IO1.StatusEventInterval = 25
EventIntervalText.Text = Format(IO1.StatusEventInterval)
End If

'IO1.StatusEventInterval = 10
End Sub


Private Sub Command2_Click()
Dim Strng As String

If PortOpen = False Then
MsgBox ("Port is not open, you must open a port before writing data.")
Exit Sub
End If

Strng = ConvertToBin(TextWrite.Text)
'Strng = TextWrite.Text

Result = IO1.WriteString(Strng)
If (Result = 0) Then
  MsgBox ("WriteString failed, make sure device is connected and port is opened.")
End If


End Sub

Private Sub Command3_Click()

If PortOpen = False Then
MsgBox ("Port is not open, you must open a port before reading data.")
Exit Sub
End If


TextRead.Text = TextRead.Text + ConvertFromBin(IO1.ReadString(50))




End Sub

Private Sub Command4_Click()
IO1.Close
PortOpen = False
End Sub


Private Sub Command5_Click()
Dim Strng As String


If PortOpen = False Then
MsgBox ("Port is not open, you must open a port before writing data.")
Exit Sub
End If


Strng = ConvertToBin(TextWrite.Text)


Result = IO1.WriteData(Strng, Len(Strng))
If (Result = 0) Then
  MsgBox ("WriteString failed, make sure device is connected and port is opened.")
End If



End Sub

Private Sub Command6_Click()

If PortOpen = False Then
MsgBox ("Port is not open, you must open a port before reading data.")
End If

TextRead.Text = TextRead.Text + ConvertFromBin(IO1.ReadData(50))

End Sub

Private Sub Command7_Click()

TextEvents.Text = ""

End Sub

Private Sub Command8_Click()
ret = IO1.DeviceControl(1441800, 3, "")
End Sub

Private Sub CommandCancelIO_Click()
IO1.CancelIO (CANCEL_TXABORT + CANCEL_RXABORT + CANCEL_TXCLEAR + CANCEL_RXCLEAR)
End Sub

Private Sub CommandWriteFile_Click()
Dim InputData As Byte
Dim st As String
Dim Data As String
Dim Count As Integer

If PortOpen = False Then
MsgBox ("Port is not open, you must open a port before writing data.")
Exit Sub
End If


st = File1.Path + "\" + File1.filename

Open st For Binary As #1

Do While Not EOF(1) ' Check for end of file.
    Get #1, , InputData
    Data = Data + Chr(InputData)
    Count = Count + 1
    If (Count > 100) Then
        If (IO1.WriteData(Data, Count) = 0) Then
            MsgBox "WriteData() failed, writing file to port aborted."
            Close #1    ' Close file.
            Exit Sub
        End If
        DoEvents     'allow events to be fired
        'IO1.Wait (4) 'allow events to be fired
        Data = ""
        Count = 0
    End If
Loop
If (IO1.WriteData(Data, Count) = 0) Then
    MsgBox "WriteData() failed, writing file to port aborted."
End If

Close #1    ' Close file.
End Sub

Private Sub EventIntervalText_Change()

IO1.StatusEventInterval = Val(EventIntervalText.Text)


End Sub

Private Sub Form_Load()

For i = 0 To 10
Combo1.AddItem IO1.ListPorts(i, 3)
Next i

If File1.ListCount <> 0 Then
    File1.Selected(0) = 1
End If

Symbols(0) = "NULL"
Symbols(1) = "SOH"
Symbols(2) = "STX"
Symbols(3) = "ETX"
Symbols(4) = "EOT"
Symbols(5) = "ENQ"
Symbols(6) = "ACK"
Symbols(7) = "BEL"
Symbols(8) = "BS>"
Symbols(9) = "HT>"
Symbols(10) = "LF>"
Symbols(11) = "VT>"
Symbols(12) = "FF>"
Symbols(13) = "CR>"
Symbols(14) = "SO>"
Symbols(15) = "SI>"
Symbols(16) = "DEL"
Symbols(17) = "DC1"
Symbols(18) = "DC2"
Symbols(19) = "DC3"
Symbols(20) = "DC4"
Symbols(21) = "NAK"
Symbols(22) = "SYN"
Symbols(23) = "ETB"
Symbols(24) = "CAN"
Symbols(25) = "EM>"
Symbols(26) = "SUB"
Symbols(27) = "ESC"
Symbols(28) = "FS>"
Symbols(29) = "GS>"
Symbols(30) = "RS>"
Symbols(31) = "US>"





End Sub



Private Sub Form_Unload(Cancel As Integer)
IO1.Close
End Sub


Private Sub IO1_IOCompleteEvent(ByVal JobType As Long, ByVal JobId As Long, ByVal JobResult As Long)
Dim NewText As String

EventCounter = EventCounter + 1

If (JobType = BKJOB_WRITE) Then
NewText = "#" + Str(EventCounter) + " [IOCompleteEvent]    Background Write Done,   Job ID: " + Format(JobId) + "   Job Result: " + Format(JobResult)
End If


If (JobType = BKJOB_READ) Then
NewText = "#" + Str(EventCounter) + " [IOCompleteEvent]    Background Read Done,   Job ID: " + Format(JobId) + "   Job Result: " + Format(JobResult)
TextRead.Text = TextRead.Text + ConvertFromBin(IO1.DataBuffer)
End If

AddTextToEventWin (NewText)

End Sub

Private Sub IO1_IOPeriodicEvent()
Dim NewText As String

EventCounter = EventCounter + 1

If EventCounter > 500 Then
EventCounter = 0
TextEvents.Text = ""
End If


PerEventCounter = PerEventCounter + 1

NewText = "#" + Str(EventCounter) + " [IOPeriodicEvent] #" + Str(PerEventCounter)

AddTextToEventWin (NewText)

End Sub


Private Sub IO1_IOQueueEvent(ByVal NumCharsInputQue As Long, ByVal NumCharsOutputQue As Long)
Dim NewText As String

If (CheckAutoRead = 1 And NumCharsInputQue > 0) Then
'While (IO1.NumCharsInQue)
If IO1.Mode = 0 Then
    TextRead.Text = TextRead.Text + ConvertFromBin(IO1.ReadData(20))
Else
    IO1.ReadData (20)
End If
'Wend
End If

EventCounter = EventCounter + 1

NewText = "#" + Str(EventCounter) + " [IOQueueEvent]    Input Queue:" + Format(NumCharsInputQue) + "   Output Queue: " + Format(NumCharsOutputQue)

AddTextToEventWin (NewText)

End Sub


Private Sub IO1_IOStatusEvent(ByVal StatusType As Long, ByVal IOStatus As Long)
Dim NewText As String
EventCounter = EventCounter + 1

'
'Handle Parallel Events
'
If (StatusType = STATUS_TYPE_PARALLEL) Then
NewText = "#" + Str(EventCounter) + " [IOStatusEvent]    Status Event: "

If (IOStatus And PARALLEL_PAPER_EMPTY) Then
NewText = NewText + "Paper Empty, "
Else
NewText = NewText + "Paper Ok, "
End If
If (IOStatus And PARALLEL_OFF_LINE) Then
NewText = NewText + "Off Line, "
Else
NewText = NewText + "On Line, "
End If
If (IOStatus And PARALLEL_POWER_OFF) Then
NewText = NewText + "Power Off, "
Else
NewText = NewText + "Power On, "
End If
If (IOStatus And PARALLEL_NOT_CONNECTED) Then
NewText = NewText + "Not Connected, "
Else
NewText = NewText + "Connected, "
End If
If (IOStatus And PARALLEL_BUSY) Then
NewText = NewText + "Busy, "
Else
NewText = NewText + "Not Busy, "
End If
If (IOStatus And PARALLEL_SELECTED) Then
NewText = NewText + "Selected. "
Else
NewText = NewText + "Not Selected. "
End If

End If

'
'Handle Serial Events
'
If (StatusType = STATUS_TYPE_SERIAL) Then
NewText = "#" + Str(EventCounter) + " [IOStatusEvent]    Status Event: "

If (IOStatus And SERIAL_RXOVER) Then
NewText = NewText + "RX Buffer Overrun, "
End If
If (IOStatus And SERIAL_RXPARITY) Then
NewText = NewText + "RX Pariety Error, "
End If
If (IOStatus And SERIAL_FRAME) Then
NewText = NewText + "RX Framing Error, "
End If
If (IOStatus And SERIAL_BREAK) Then
NewText = NewText + "Serial Break Occured, "
End If
If (IOStatus And SERIAL_TXFULL) Then
NewText = NewText + "TX Buffer Full, "
End If
If (IOStatus And SERIAL_TXEMPTY) Then
NewText = NewText + "TX Buffer Empty, "
Else
NewText = NewText + "TX Buffer Not Empty, "
End If
If (IOStatus And SERIAL_RXEMPTY) Then
NewText = NewText + "RX Buffer Empty, "
elseNewText = NewText + "RX Buffer Not Empty, "
End If
If (IOStatus And SERIAL_CTS_TXHOLD) Then
NewText = NewText + "TX Hold due to CTS, "
End If
If (IOStatus And SERIAL_DSR_TXHOLD) Then
NewText = NewText + "TX Hold due to DSR, "
End If
If (IOStatus And SERIAL_RLSD_TXHOLD) Then
NewText = NewText + "TX Hold due to RLSD, "
End If
If (IOStatus And SERIAL_XOFF_TXHOLD) Then
NewText = NewText + "TX Hold due to XOFF, "
End If
If (IOStatus And SERIAL_CTS_ON) Then
NewText = NewText + "CTS On, "
End If
If (IOStatus And SERIAL_DSR_ON) Then
NewText = NewText + "DSR On, "
End If
If (IOStatus And SERIAL_RING_ON) Then
NewText = NewText + "Ring On, "
End If
If (IOStatus And SERIAL_RLSD_ON) Then
NewText = NewText + "RLSD On, "
End If
End If


If (Len(TextEvents.Text) > 5000) Then
'TextEvents.Text = Left(TextEvents.Text, 300)
TextEvents.Text = ""
End If

AddTextToEventWin (NewText)


End Sub


Private Sub IO2_IOPeriodicEvent()
Dim NewText As String

EventCounter = EventCounter + 1

If EventCounter > 500 Then
EventCounter = 0
TextEvents.Text = ""
End If


PerEventCounter = PerEventCounter + 1

NewText = "#" + Str(EventCounter) + " [IOPeriodicEvent] #" + Str(PerEventCounter)

AddTextToEventWin (NewText)

End Sub

Private Sub Option1_Click()
IO1.Mode = MODE_NORMAL
End Sub


Private Sub Option2_Click()
IO1.Mode = MODE_ASYNC
End Sub



Private Sub PortSettingsButton_Click()

IO1.SerialGetPortDefaults (PortName)
Result = IO1.SerialPortSetupDialog(PortName)
If Result = 1 Then
    Result = IO1.SerialSetPortDefaults(PortName, "", -1)
End If


End Sub

Private Sub Timer1_Timer()
Dim Result As Long

Result = IO1.ParallelStatus
If (Result = -1) Then
 Check1.Enabled = False
 Check2.Enabled = False
 Check3.Enabled = False
 Check4.Enabled = False
 Check5.Enabled = False
Else
 Check1.Enabled = True
 Check2.Enabled = True
 Check3.Enabled = True
 Check4.Enabled = True
 Check5.Enabled = True
 If (Result And PARALLEL_OFF_LINE) Then
 Check1.Value = 1
 Else
 Check1.Value = 0
 End If
 If (Result And PARALLEL_SELECTED) Then
 Check2.Value = 1
 Else
 Check2.Value = 0
 End If
 If (Result And PARALLEL_PAPER_EMPTY) Then
 Check3.Value = 1
 Else
 Check3.Value = 0
 End If
 If (Result And PARALLEL_BUSY) Then
 Check4.Value = 1
 Else
 Check4.Value = 0
 End If
 If (Result And PARALLEL_POWER_OFF) Then
 Check5.Value = 1
 Else
 Check5.Value = 0
 End If
End If



Result = IO1.SerialStatus

If (Result = -1) Then
 Check15.Enabled = False
 Check16.Enabled = False
 Check17.Enabled = False
 Check18.Enabled = False
Else
 Check15.Enabled = True
 Check16.Enabled = True
 Check17.Enabled = True
 Check18.Enabled = True
 If (Result And SERIAL_CTS_ON) Then
 Check15.Value = 1
 Else
 Check15.Value = 0
 End If
 If (Result And SERIAL_DSR_ON) Then
 Check16.Value = 1
 Else
 Check16.Value = 0
 End If
 If (Result And SERIAL_RING_ON) Then
 Check17.Value = 1
 Else
 Check17.Value = 0
 End If
 If (Result And SERIAL_RLSD_ON) Then
 Check18.Value = 1
 Else
 Check18.Value = 0
 End If
End If

End Sub







Public Function AddTextToEventWin(NewText As String) As String

TextEvents.Text = TextEvents.Text + Chr(13) + Chr(10) + NewText

TextEvents.SelStart = Len(TextEvents.Text)

End Function
Public Function ConvertFromBin(Strng As String) As String
Dim NewStr As String
Dim Value As Integer
Dim Number As String




For n = 1 To Len(Strng)
If Mid(Strng, n, 1) < " " Then
Value = Asc(Mid(Strng, n, 1))
Number = Format(Value)
If CheckSym = 1 Then
    If Right(Symbols(Value), 1) = ">" Then
    NewStr = NewStr + "<" + Symbols(Value)
    Else
    NewStr = NewStr + "<" + Symbols(Value) + ">"
    End If
Else
    NewStr = NewStr + "<" + Number + ">"
End If
Else
NewStr = NewStr + Mid(Strng, n, 1)
End If

Next n

ConvertFromBin = NewStr

End Function

Public Function ConvertToBin(Strng As String) As String
Dim NewStr As String
Dim Number As Integer

For n = 1 To Len(Strng)
If (Mid(Strng, n, 1)) = "<" Then
Number = Val(Mid(Strng, n + 1, 3))
    If Number = 0 And Mid(Strng, n + 1, 1) <> "0" Then
        For Number = 0 To 30
        If Left(Symbols(Number), 3) = Mid(Strng, n + 1, 3) Then Exit For
        Next Number
        NewStr = NewStr + Chr(Number)
        If Right(Symbols(Number), 1) = ">" Then
        n = n + Len(Symbols(Number))
        Else
        n = n + Len(Symbols(Number)) + 1
        End If
        'n = n + 3
    Else
        NewStr = NewStr + Chr(Number)
        n = n + 2
        If (Number >= 10) Then n = n + 1
        If (Number >= 100) Then n = n + 1
    End If
Else
NewStr = NewStr + Mid(Strng, n, 1)
End If

Next n

ConvertToBin = NewStr

End Function

