/**********************************************************************/
#define DllAccess extern "C"  __declspec( dllimport )
                               

#define COM_ERROR           (-101)
#define MEMORY_ERROR        (-102)
#define COM_OPEN            (-103)
#define COM_CLOSE           (-104)
#define INVALID_COMPORT     (-105)
#define INVALID_PHONENO     (-106)
#define STRING_TOOLONG      (-107)
#define STRLEN_ERR          (-108) 
#define BAUDRATE_ERR        (-109)
#define PROTOCOLTYPE_ERR    (-110)
#define MSG_ERR             (-111)
#define BLOCKSIZE_ERR       (-112)
#define FILENAME_ERR        (-113)
#define PARAMREQUIRED_ERR   (-114)
#define CONNECT_ERR         (-115)
#define IDRECEIVE_ERR       (-116)
#define INVALID_DELAY       (-117)


/**********************************************************************/
//Pager Functions

/*
float GetDllVersion(
Returns the version number of the Dll.
*/
DllAccess float _stdcall GetDllVersion();

/*
short int WriteToLogFile(
char On, 1 to enable writing to the log file "event.log" . Be default events are logged.
         0 to disable writing to the log file. 
*/
DllAccess short int _stdcall WriteToLogFile(char EnableLogging);


/*
 SendNumericPage is used to send digital data to a Numeric Pager
 SendNumericPage(
  short int ComPort, // Serial Communication port number of your modem.
  char* PagerNo, //Phone number of your Pager.
  char* PinNo,  // Enter a Pin number if you have one otherwise enter NULL.
  char *message, // Enter your message. Limit is 250 characters.
  short int PDelay //Enter the time in seconds to wait after dialing the number.
  char PulseDial //0 for Tone Dial and 1 for Pulse Dial.
 );
*/
DllAccess short int _stdcall SendNumericPage(short int ComPort, char* PagerNo,
char* PinNo, char* message, short int PDelay, char PulseDial);

/*
 SendAlphaPage is used to send text data to an alphanumeric Pager
 SendAlphaPage(
  short int comport, // Serial Communication port number of your modem.
  char* PagerNumber, //Phone number of your Pager.
  char* PagerAccessNumber,  // Enter the Pin number of your Pager.
  char* message, // Enter your message. Limit is 250 characters.
  char PulseDial //0 for Tone Dial and 1 for Pulse Dial.
 );
*/
DllAccess short int _stdcall SendAlphaPage(short int comport, char* PagerNumber,
 char* PagerAccessNumber, char* message, char PulseDial);



/*
 SendAlphaPageAdvanced is used to send text data to an alphanumeric Pager and differs 
 from SendAlphaPage by offering more options to the user. 
 SendAlphaPage(
  short int comport, // Serial Communication port number of your modem.
  short int baudRate, // The baudrate at which the alphanumeric protocols work is
                      usually 1200.
  char* PagerNumber, //Phone number of your Pager.
  char* PagerAccessNumber,  // The Pin number of your Pager.
  char TypeOfProtocol, There are 2 protocols used in the Dll. Value of TypeOfProtocol should be 0
                    for Manual Entry protocol and 1 for Automatic Entry protocol.
  char* fileName // If the message exceeds 250 characters then you should use a text file containing
                    the message.
  char *message, // Enter your message. Limit is 250 characters. If you are using this parameter then 
                 enter NULL for filename.
  short int blockSize // Enter the max limit of characters your alphanumeric pager can accept. 
                     If the message is bigger than the blockSize then the message is broken at
                     word boundaries and multiple pages are sent.
  char PulseDial //0 for Tone Dial and 1 for Pulse Dial.
 );
*/
DllAccess short int _stdcall SendAlphaPageAdvanced(short int comport, short int baudRate, char* PagerNumber,
 char* PagerAccessNumber, char TypeOfProtocol, char* fileName, char* message,
 short int blockSize, char PulseDial);




/*
 SendAlphaPageByEmail(
  char* hostName, // Name of the mail server.
  char* senderAddr, // Email address of the sender.
  char* RecipientAddr, // Email address of the recipient.
  char* MsgID, //Message Id of the Email. This parameter is optional.
  char* Subject,  // Subject of the Email
  char *message, // Enter your message. Limit is 250 characters. If you are using this parameter then 
                 enter NULL for filename.
  short int blockSize // Enter the max limit of characters your alphanumeric pager can accept. 
                     If the message is bigger than the blockSize then the message is broken at
                     word boundaries and multiple Emails are sent. If you are using this parameter
                     then enter NULL for message.
 );

*/
DllAccess short int _stdcall SendAlphaPageByEmail(char* hostName, char* senderAddr,
 char* RecipientAddr, char* MsgID, char* Subject , char* message, char* fileName,
 short int blockSize );


