#!/bin/sh
# MetaCard 2.3 stack
# The following is not ASCII text,
# so now would be a good time to q out of more
exec mc $0 "$@"
                                                                                                                                  main  
on addExpenses
  global gDollarSign
  put 0 into zdollars
  put false into multiDirect
  put field "expense notes" into temp
  repeat with i = 1 to the number of words of temp
    put word i of temp into zword
    put false into multiply
    put false into dontAdd
    switch char 1 of zWord
    case  "#"
      next repeat
      break
    case "-"
      put true into dontAdd
      delete char 1 of zword
      break
    case "*"
      put true into multiply
      put true into multiDirect
      delete char 1 of zword
      break
    default
      break
    end switch
    repeat with x =  length(gDollarSign) down to 1
      --   if not(char 1 of zword is a number) AND (char 1 of zword <> ".")then -- delete $ signs
      if char x of zword is char x of gDollarSign then -- delete $ signs
        delete char x of zword
      end if
    end repeat
    put (the number of chars of zword) into lastChar
    -- if not(char lastChar of zword is a number) then
    if char lastChar of zword is "," then -- delete punctuation
      delete char lastChar of zword
    end if
    
    if zword is a number then
      if multiply then
        put item 2 of field "expense" into zExpenseAmount
        if zExpenseAmount is empty then
          next repeat
        else
          put zword * zExpenseAmount into temp2
          add temp2 to zdollars
          next repeat
        end if
      end if
      if dontAdd then
        subtract zword from zdollars
      else
        add zword to zdollars
      end if
    end if
  end repeat
  
  if gDollarSign = "$" then set the numberformat to 0.00
  put field "expense amount" into zAmount
  put item 2 of field "expense" into zExpenseAmount
  if multiDirect then
    put gDollarSign & zDollars into field "expense amount"
  else
    if zExpenseAmount <> empty AND zDollars <> 0 then
      answer question "Add amounts in Notes field to Expense Amount?" with "No" or "Just Notes" or "Yes"
      if it is "No" then
        put gDollarSign & zExpenseAmount into field "expense amount"
      end if
      if it is "Just Notes" then
        put gDollarSign & zDollars into field "expense amount"
      end if
      if it is "Yes" then
        add zDollars to zExpenseAmount
        put gDollarSign & zExpenseAmount into field "expense amount"
      end if
      exit addExpenses
    end if
    if zExpenseAmount <> empty AND zDollars = 0 then
      put gDollarSign & zExpenseAmount into field "expense amount"
    else
      put gDollarSign & zDollars into field "expense amount"
    end if
  end if
end addExpenses

on newExpense zStack
  global gDollarSign
  put field "expense amount" of stack zStack into zword
  ask "Enter an expense amount." with zWord
  if it is empty then exit newExpense
  put it into zword
  if gDollarSign = "$" then set the numberformat to 0.00
  if char 1 of zWord is "-" then
    put true into dontAdd
    delete char 1 of zword
  else
    put false into dontAdd
  end if
  if not (zword is a number) then
    repeat with x = 1 to length(gDollarSign)
      if not(char 1 of zword is a number) AND (char 1 of zword <> ".") then
        delete char 1 of zword
      end if
    end repeat
    if not (zword is a number) then
      answer error "Problem converting to a number. Please try again."
      put empty into field "expense amount" of stack zStack
      exit newExpense
      --   addExpenses
    else
      add 0 to zword
    end if
  else
    add 0 to zword
  end if
  if dontAdd then
    put gDollarSign & "-" & zword into field "expense amount" of stack zStack
  else
    put gDollarSign & zword into field "expense amount" of stack zStack
  end if
end newExpense

function daysofmonth zmonth, zyear
  put "1,3,5,7,8,10,12" into longMonth
  repeat with i = 1 to the number of items of longMonth
    if item i of longMonth is zmonth then
      return 31
    end if
  end repeat
  if zmonth = 2 then -- Feb
    if zyear/4 = trunc(zyear/4) then
      return 29
    else
      return 28
    end if
  else -- all other months
    return 30
  end if
end daysofmonth

function checkItems cardNum
  if field "project" of card cardNum of stack "records" is empty OR field "task" of card cardNum of stack "records" is empty OR field "elapsed" of card cardNum of stack "records" is empty then
    return true
  else
    return false
  end if
end checkItems

function checkExt fileName
  if the platform contains "win" AND (NOT fileName contains ".txt") then
    put ".txt" after filename
  end if
  return fileName
end checkExt

on version
  ask "Enter a new version" with field "version" of stack "prefs"
  put it into field "version" of stack "prefs"
  put it into field "version" of stack "register"
end version

on returnKey
  send mouseUp to the focusedObject
end returnKey

on enterKey
  send mouseUp to the focusedObject
end enterKey
    
LightSkyBlue     Hw          About      U AGaramond Italic   U Arial  
 U Arial   U Arial  
 U Arial  
 W Arial   W Arial   W Arial   W Arial  	 U Arial  
 U 
Helvetica   W Arial   U 
Helvetica   U 
Helvetica   W 
Helvetica   W 
Helvetica  	 U 
Helvetica  
 W 
Helvetica    main   IP
Eon openCard
  global gRegistered,gDollarSign,gVeffect
  
  if gVeffect <> empty then exit openCard
  if the hilitedButtonName of group "visualEffects" of stack "prefs" is "On" then
    put true into gVeffect
  else
    put false into gVeffect
  end if
  set the lookAndFeel to the hilitedButtonName of group "LooknFeel" of stack "prefs"
  set twelveHourTime to the hilite of button "AM/PM" of stack "prefs"
  set the hilitecolor to field "hColor" of stack "prefs"
  put field "symbol" of stack "prefs" into gDollarSign
  set the textArrows to true
  set the navigationArrows to false
  if field "firstdate" is "registered" then
    lock screen
    put true into gRegistered
    close stack "main"
    go last card of stack "records"
    topLevel "records"
    send setArrows to stack "records"
    unlock screen with visual plain
    exit openCard
  end if
  lock screen
  if field "firstdate" is empty then
    put the date into field "firstdate"
    put "tutorial" into gRegistered
    topLevel "records"
    send setArrows to stack "records"
    close stack "main"
    topLevel "Register"
    show field "readme" of stack "register"
    set the name of button 2 of stack "register" to "Close License Agreement"
    unlock screen with visual plain
    answer information "Welcome to Activity & Expense Tracker." & return & \
        "  Please read the License Agreement. " & return & \
        "   You may use this software for 30 days before registering it. "
    -- rest of code moved to close register window button
    exit openCard
  else
    put the date into endDate
    put  field "firstdate" into startDate
    convert endDate to seconds
    convert startDate to seconds
    
    if field "temp" of stack "register" is empty then
      add 60*60*24*31 to startDate
    else
      add 60*60*24*7 to startDate
    end if
    put round((startdate - enddate)/(60*60*24)) into daysleft
    if daysleft < 1 then
      put false into gRegistered
      put "how to register your software." into field "registration" of stack "register"
      put "See above for information on" into field "name" of stack "register"
      topLevel "records"
      close stack "main"
      topLevel "Register"
      answer warning "Your trial period has expired. Please register your software."
    else
      put daysleft into gRegistered
      close stack "main"
      go last card of stack "records"
      topLevel "records"
      send setArrows to stack "records"
      answer information "Your trial period for this software will expire in " & daysleft & " days."
    end if
  end if
  unlock screen with visual plain
end openCard








           w   z  $      
  $ 
firstdate  !h        @ \ ^                
  z top_bg 6`    @              
   contact  
  
 +on mouseUp
  close this stack
end mouseUp
   ff33     ) h$ X         2000 Garth Catterall-Heart   All rights reserved world wide.  !SpiritWorks Software Development  PO Box 216  Redwood Valley, CA 95470  !www.about-the-web.com/aetracker/    smSWSlogo.jpg 	P +on mouseUp
  close this stack
end mouseUp
        l 4  .  
 JFIF  H H   C 		

 $.' ",#(7),01444'9=82<.342 C			

2!!22222222222222222222222222222222222222222222222222  .                  5      !1"AQaq2RB#Cb              3       !1AqQa"2#B3   ? DQ2,DEDQDEDQDEE[i;ZPu
	lK$(ǐӡ'jk
8s\őMUDQDEqmy{*%6_*Q
-JH;=y_EI2|۸yedin/SܖVe4ۅ-NǩZI058c*}HPWj9`
HZN\ IA/+<*I<nsH'd\TDvnCJ]e2i<ܚݴ1X=p-{_27M*O*P	'F
	fZv%?ԑb9))%[I!C0~
i)2H4sL"Kr嶄":'*>b3  WX)*
-$RiykDI3-
+) >aq7|齁8K:VmEsh*Sm(I$A'?5}U5i>@A.<.s6<ukt)JZskOtz,moQMNIDkbv)INO$UgVsNKE)W_}:W-<X]@ֹWe-E)inVG~ݻkuSh¹18%/m)O~*+43Rz($ZxY~>چܧy<{$V%Unl>l2ScDbTt5#VﯔwˎYZ֛:]MjZ)d֤*ڭb;2)c\C2[0!?2B0jucR2OUr+i-
 pynb؎F7T
T띂QzԝY
$(gˑo7s,_@2栾θL.2
VH>qy{;eCs&x֚[m}ԅ#?D0Cw%e.@m-o8 % ɨtCJ#~-$:%J3rqIۋU:	Ȏ@)hOH7~%!#+(HHS̆z l]8JT]p 7xGC5GpRSWj
U6A[Kďn
V4wTAfa"}򓂯I |W^%oSP'[#c1Ҵ Ɲ
PW:8g~qa~WP~'ecZJ" $|9VY1|RY9a!_	"*:>*^A ʕl:A%㚣{I&;O!*'r~G?ٸs;GzoWw!Zc]PDtb!"]%EWi!~U 
k
,mNrNB&嗮iA6?ٲXovmoXjJLӅw(jIS}Ek+GGdbc}i*'r>9?XS@#1Juӻ[eۤniM,%X%$`WGFs6aePms)m*iS %c%~##u[R4vH꼞UqոvOI[X.BPEA	Z)Q%A$RHWVԝLl7ߔkloNC[[OMaKNy#Vw:F*d m=:wOΊn2\P;XNrUM_=CeyynO<BPҒP+V^U 'OqYd3;:BXyIpuZm(JS 
yӖӾ!JԾ蟯rN[bvR2s11=y'@X\ol~X޲~_!@	J* Y	6䊉`Gι6ɒKNxT3~<mu&v
B$w 0J>9Ul,L)L&,ĜZT?jUl]۩eZk\Ż.q!(d';BB@#}Mu|
X
=wZVқ:xɮ5o,d
3>zH)P	%DrxVlc椋׏
؞y#r3cZ-!w"^ci+d;.K6
j#Z#7lʔCؠۦIb_;}J\)
 2pSێ~Ʋygx^cVDEDd}hXq(pe; z=SIE͡!1T$r]ۄmEtrqh(F9 ocUB,̃jc C?Mori(e[}2`z˵]]-<1u3΋n4\Vo`UmCCwH қ- N|)Je( $gϭ4O:6>$4_I]n-FZ4V: @#` c	ܴyFyv染.3HyPI' Q*'*$bV֛{yY^oS,Mt6!)Jwgsws`^ܨTlWm!09=%yH$PՀl6q=o~駒X5Z.`md-,%N@;r<IoyEleM0_TF	';#<oQ#cU;4=	ۦuۓ8X!pKj	'V/ߤd[)ׂ@eљPK![RA<yeo2T*toF;p^~ja*)Rgq7ypI8D`
@793+a)r7߯T6I	 mJ2y>*hԝNn߄ ngf6@44 >4+eVEDQD^:Hvk[N8I@DAichJ{$
"E3DY9(-H,t" F$	B%#$Xźo[$UDt[?,	O`z/            T +on mouseUp
  close this stack
end mouseUp
         ` !  rJ%%##""RR  mm$$##!!oo""!!
    

  ``  {{QQqq##  88    ;;"RR  vv    	ZZ	



  	!!  VVhh44  ``  RR  JJ  !!          !!##    
##  HH  YY  ƃ  !!99    KK  nn  ::    33ee    HH``  nn  RR  JJee  ]]    nn  KK!!      PP  vv  މ  ""  ss  OO  CCss    22    MM  GG

  uu  у\\  ,,oo  ""    ``  oo  ߃    HH  Â  MM܉  EE          ``  

!!  PP          oott;;  ZZ``WW  LLPPSSJJ!!    JJ  pp  ZZ``WW  LLPPSSJJՂ  
""  KK  }}      ނ  Ƃ  
HH!!  hh    MMQQTTWWmm      JJ  ނ  66OORRTTIIׂ  QQ݂  ==  ك  uu  oott;;  ނ  ݃    MMQQTTWWmm  QQhh  ""!!00  ##  xxHH  ܂  99WW  !!  11    pp  WW  xx  XX  

      !!Â    !!    WW  MM  
    ''OOނ  ߂  SSނ    77  

  ܂  99ނ      MM  OO  	WW  ł  <<PP  ee  !!  ̂  xx77  jjqq  ee  	    ''    //  !!  QQ]]ffVV  qq  66  ==    ق  //gg߂  
__UU߂  SS߂  88YYcciiGG    	  PP  ߂  99  	  66  TT``ggVV  qqaa  >>  ""  nn  !!    ܂  qq  nn  	̃  RR  nn((    ((  ؃  22!!  

    55  
  KK  ߇  ߂  SS߉   &&vv  ??UU  ++""  ߅          ee!!  qq  
!!  WW  
uu  ,,qq  qq  //    VV  ii  


  		!!  77  	    
  CC  AA߂  

߂  SS߈  LL    ݂!!  ߃    SS  	  44҉  LL  qq  
!!  ނ  
EE  qq  qq  jj    dd    
Ǆ  bb!!    	MM  ƃ    RR  ߂  ߂  SS߂  
''  ##ۂ    XXLL  ߂  		>>    	MM  LLaa  
77  VVDD  ΂  ;;qq  !!    qq  qq  oo    TT        &&  !!    OO  ̄  
HH  ߂  
߂  SS߂    77  ς  ;;ނ      OO  PP  RR  Â  ;;

  66  {{qq  !!  ă  ??qq  qq  qq    JJ!!    RRbbllqq88  AA  **!!    UUaahhkkllnnrr    RR  HHyyTT  ߂  88ZZddjjkklloo߂  SS߂  ee      zz

  66  {{ނ  ɂ  ,,  UUaahhkkllnnrr  SSȂ  uu      pp  !!    pp  pp  pp  ć  ``55    eeЂ    
{{!!          މ  ffނ  RRނ  ߂  [[``  >>^^    ܂  ww  ~~    TT      @@  
ss    ߃  TT        XX  ۋ  ]]Ń    xx  ۉ  ۂ  nnӃ  ff  aa  ]]aa  aa  KKރ  dd    qq@@  ss``  [[ԃ  00ى  ۂ    	ق:Ԇԅ؅'	نuuqqppqq	
؄
/  mmllkk!!SS  {{Ȇ  qq	    
  ""'dd         !!    ##%%uu  ""OOcc  ##  $$  !!MM
  

yyƄ  66$$  !!  tt  tttt  xxŅ  
  ##
##ww  MMRR    rr
    vv  88    rruu  ""!!wwą        !!  $$  ""ee  ss  ""!!        ss^^  ^^$$##ww  MMww$$  ##  hhww88  vv  ""  $$  !!  rr    ""  bb0dd      HH##mm    jj7##      WW  kkNN      hh  qq  11  !""  qq      dd!!  

mm  DD  FFoo  ]]  pp  ߂  

  """".hh  qq    ww  

  !!  VV  ""  qq  EEll!!  !!  .--  11  gg  22  dd  KK
  aabbddڄ  NN    ""hh̓  ddrr!!ll  //WWss  -  ee  bbcc  jj        !!mm??    ##22  ,,  ??XX[[ق  mm  MMmm  aa    ss    !!  
ll  pp  ??  mm  ~~    !!mmjj  PP  DD\\ZZ    ,,ZZ    	    @@CC8    ll  HH

dd    rrnn##  __YYII  __  aa    ccJJ    mm  jj  zz!!ۂ!!ll  ??    [[(  00  vv  LL  kk  mm        /qq  qq    xx

  //]]  ,,  !!llyy  
    177  qq  \\  __    [[  ZZ             LL    KKZZ    NNss      ˃  jj  .""  ee  ??  rr  oo    ss""߂""nn  pp    !!qq  
--ii  aa  ii  CCll  pp      LL  !!  rr  rr  aa    cc  pp  ``  00!!nn    Ƅ  77  @@  bb##  ""  !!
  qq8؂)Â5҂
҂!ڂ/&ނ

*&
	
	
	        m records  0on openStack
  if the height of this stack = 215 then
    set the hilite of button "restore" to true
  end if
end openStack

on idle
  global gTimer,gElapsed
  if the time <> gTimer then
    if (the visible of button 10) AND (the short name of button 10 is "Pause") then
      computeElapsed
      put gElapsed into field "elapsed"
    end if
    put the time into gTimer
    put the time into field "ctime"
  else
    pass idle
  end if
end idle

on clearCardOne
  global gTimerRunning
  put the number of field "start date" into firstField
  repeat with i = firstField to the number of fields
    put empty into field i
  end repeat
  put "End Date" into field "edlabel"
  show button "Start timer"
  put false into gTimerRunning
  hide button "Stop"
  show group "edate"
  hide button 10
  put "Total Time" into field "elabel"
  put 1 into field "record"
end clearCardOne

on computeElapsed
  global gElapsed
  put field "telapsed" into oldEtime -- elapsed time
  if field "running" <> empty then
    put field "running" into startTime
  else
    put field "startimer" into startTime
  end if
  if startTime is empty then
    put "0 hrs 0 mins" into field "Elapsed"
    exit computeElapsed
  end if
  
  put the time into endTime
  put the date into endDate
  convert endDate to dateItems
  convert endTime to dateItems
  put item 1 to 3 of endDate into item 1 to 3 of endTime
  
  put daysofmonth(item 2 of startTime,item 1of startTime) into zdays
  if item 5 of startTime > item 5 of endTime then
    add 60 to item 5 of endTime -- add 60 minutes
    subtract 1 from item 4 of endTime
  end if
  if item 4 of startTime > item 4 of endTime then
    add 24 to item 4 of endTime -- add 24 hours
    subtract 1 from item 3 of endTime
  end if
  if item 3 of startTime > item 3 of endTime then
    add zdays to item 3 of endTime -- add about 30 days
    subtract 1 from item 2 of endTime
  end if
  if item 1 of startTime < item 1 of endTime then
    add 12 to item 2 of endTime -- add 12 months
    add 1 to item 1 of startTime
  end if
  if item 2 of startTime > item 2 of endTime then
    add (item 2 of startTime - item 2 of endTime)* zdays to item 3 of endTime
  end if
  
  put (item 2 of endTime - item 2 of startTime)*zdays into zdays
  add item 3 of endTime - item 3 of startTime to zdays
  put (item 4 of endTime - item 4 of startTime) + (zdays * 24) into zhours
  put item 5 of endTime - item 5 of startTime into zmins
  
  if oldEtime <> empty then
    add word 1 of oldETime to zhours
    add word 3 of oldEtime to zmins
    if zmins > 59 then
      subtract 60 from zmins
      add 1 to zhours
    end if
    if zmins > 59 then
      subtract 60 from zmins
      add 1 to zhours
    end if
  else
    if zmins > 59 then
      subtract 60 from zmins
      add 1 to zhours
    end if
  end if
  put zhours && "hrs" && zmins && "mins" into gElapsed --field "elapsed"
end computeElapsed

on goCardNum
  ask "Go to which record?"
  if it is a number then
    if it is empty then
      exit goCardNum
    else
      put the number of this card into which
      if it is which then
        answer information "Already on record" && it
        exit goCardNum
      end if
      if it > (the number of cards of stack "records") then
        answer information "No such record"
        exit goCardNum
      end if
      lock screen
      go card it of stack "records"
      unlock screen with visual plain
    end if
  end if
  setArrows
end goCardNum

on adjustTime dir,whichFld,whichNum
  global gStartDate, gEndDate, gStartTime, gEndTime,gWhichfield
  
  checkTimerRunning
  put whichFld into gWhichField
  put field "end time" into gEndTime
  if gEndTime is "n/a" OR word 1 of gEndTime is "timer" then
    put empty into gEndTime
    put empty into field "End time"
  end if
  
  if field "start date" is empty then
    put the date into gStartDate
    put the long date into field "start date"
  end if
  put field "start date" into gStartDate
  if field "start time" is empty then
    put the time into field "start time"
  end if
  put field "start time" into gStartTime
  
  if whichFld is "end time" and field "end time" is empty then
    put the short time into field "end time"
  end if
  put field "end time" into gEndTime
  if whichFld is "end time" and ((field "end date" is empty) or (field "end date" is "n/a")) then
    put the long date into field "end date"
  end if
  put field "end date" into gEndDate
  
  if whichNum is "min" then
    put 5 into znum
  else
    put 4 into znum
  end if
  
  repeat while the mouse is "down"
    put field whichFld into temp
    convert temp to dateitems
    if dir is "up" then
      add 1 to item znum of temp
    else
      subtract 1 from item znum of temp
    end if
    if item 4 of temp is 24 then adjustDate "up"
    if item 4 of temp is 23 AND item 5 of temp is 60 then adjustDate "up"
    if item 4 of temp is 0 AND item 5 of temp is -1 then adjustDate "down"
    if item 4 of temp is -1 then adjustDate "down"
    convert temp to short time
    put temp into field whichFld
    wait 20 ticks
  end repeat
end adjustTime

on adjustDate which
  global gStartDate, gEndDate, gStartTime, gEndTime,gWhichfield
  if gWhichField is "end time" then
    put gEndDate into temp
    convert temp to dateItems
    if which is "up" then
      add 1 to item 3 of temp
    else
      subtract 1 from item 3 of temp
    end if
    convert temp to long date
    put temp into field "end date"
  else -- start time
    put gStartDate into temp
    convert temp to dateItems
    if which is "up" then
      add 1 to item 3 of temp
    else
      subtract 1 from item 3 of temp
    end if
    convert temp to long date
    put temp into field "start date"
  end if
end adjustDate

on checkTime
  if field "end time" is empty OR field "end time" is not a date then
    exit checkTime
  end if
  checkNegTime
end checkTime

on checkNegTime
  global gAbortTest
  if field "end time" is empty OR field "end time" is not a date then
    put the time into endTime
  else
    put field "end time" into endTime
  end if
  
  if endTime is empty then exit checkNegTime
  put field "start time"  into startTime
  if startTime is empty then exit checkNegTime
  put field "start date" into startDate
  if field "end date" is empty then
    put startDate into field "end date"
  end if
  convert startDate to dateItems
  convert startTime to dateItems
  put item 1 to 3 of startDate into field "start items"
  put item 4 to 5 of startTime into item 4 to 5 of field "start items"
  put field "end date" into endDate
  convert endDate to dateItems
  convert endTime to dateItems
  put item 1 to 3 of endDate into field "end items"
  put item 4 to 5 of endTime into item 4 to 5 of field "end items"
  put field "end items"  into endTime
  put field "start items"  into startTime
  
  put daysofmonth(item 2 of startTime,item 1of startTime) into zdays
  if item 5 of startTime > item 5 of endTime then
    add 60 to item 5 of endTime -- add 60 minutes
    subtract 1 from item 4 of endTime
  end if
  if item 4 of startTime > item 4 of endTime then
    add 24 to item 4 of endTime -- add 24 hours
    subtract 1 from item 3 of endTime
  end if
  if item 3 of startTime > item 3 of endTime then
    add zdays to item 3 of endTime -- add about 30 days
    subtract 1 from item 2 of endTime
  end if
  if item 1 of startTime < item 1 of endTime then
    add 12 to item 2 of endTime -- add 12 months
    add 1 to item 1 of startTime
  end if
  if item 2 of startTime > item 2 of endTime then
    add (item 2 of startTime - item 2 of endTime)* zdays to item 3 of endTime
  end if
  
  repeat with i = 1 to 5
    if (item i of startTime > item i of endTime) then
      if gAbortTest is "timer" then
        put "abort" into gAbortTest
        answer warning "The end time is earlier than the start time" \
            & return & "or the start time is later than the current time." \
            & return & "The timer can't be started."
        exit checkNegTime
      end if
      put "0 hrs 0 mins" into field "elapsed"
      exit checkNegTime
    end if
  end repeat
  if gAbortTest is "timer" then
    put emtpy into gAbortTest
    exit checkNegTime
  end if
  
  put (item 2 of endTime - item 2 of startTime) * zdays into zdays
  add (item 3 of endTime - item 3 of startTime) to zdays
  put (item 4 of endTime - item 4 of startTime) + (zdays * 24) into zhours
  put item 5 of endTime - item 5 of startTime into zmins
  if zmins > 59 then
    subtract 60 from zmins
    add 1 to zhours
  end if
  put zhours && "hrs" && zmins && "mins" into field "elapsed"
end checkNegTime

on checkCompleted
  if the number of cards = 1 and field "project" is empty then exit checkCompleted
  if field "project" is empty OR field "task" is empty OR field "elapsed" is empty then
    if field "project" is empty  then
      put "project" into temp
    else
      if field  "task" is empty  then
        put "activity" into temp
      else
        if field  "elapsed" is empty then
          put "elapsed time" into temp
        end if
      end if
    end if
    if temp is "elapsed time" then
      answer warning "This record is missing information about the " & temp & return & \
          " and will not be included in any report." with "Fix now" or "Delete Record" or "Fix later"
    else
      answer warning "This record is missing information about the " & temp & return & \
          " and will not be included in any report." & return \
          & "All records must designate a Project and an Activity." with "Fix now" or "Delete Record" or "Fix later"
    end if
    if it is "fix now" then exit to metaCard
    if it is "Delete Record"  then
      if the number of cards > 1 then
        lock screen
        put the number of this card into cardNum
        delete this card
        go card cardNum
        unlock screen
      else
        repeat with i = 14 to the number of fields
          put empty into field i
        end repeat
      end if
      repeat with i = 1 to the number of cards
        put i into field "record" of card i
      end repeat
    end if
  end if
end checkCompleted

on openCard
  global gElapsed,gTimerRunning
  if field "startimer" <> empty then
    hide button "Start timer"
    show button "Stop"
    hide group "edate"
    put the time into field "ctime"
    put true into gTimerRunning
    if field "running" <> empty then
      if the short name of button 10 is "Go" then
        set the name of button 10 to "Pause"
      end if
      show button  "pause"
      computeElapsed
      put gElapsed into field "elapsed"
      put "Timer Running" into field "elabel"
    else
      if the short name of button 10 is "Pause" then
        set the name of button 10 to "Go"
      end if
      show button  "go"
      put "Timer Paused" into field "elabel"
      if field "startimer" <> "timer running or paused" then
        put field "telapsed" into field "elapsed"
      end if
    end if
  else
    show button "Start timer"
    hide button "Stop"
    show group "edate"
    if the short name of button 10 is "Pause" then
      hide button  "pause"
    else
      hide button  "go"
    end if
    put "Total Time" into field "elabel"
    put false into gTimerRunning
  end if
end openCard

on setArrows
  put the number of this card into temp
  put the number of cards of this stack into temp2
  -- lock screen
  if temp is 1 then
    hide button "first"
    hide button "prev"
  else
    show button "first"
    show button "prev"
  end if
  if temp is temp2 then
    hide button "last"
    hide button "next"
  else
    show button "last"
    show button "next"
  end if
  -- unlock screen
end setArrows

on checkTimerRunning
  global gTimerRunning
  if gTimerRunning then
    answer warning "You can't change the date or time when " \
        & return & "the timer is running or paused."
    exit to metaCard
  end if
end checkTimerRunning

on arrowKey which
  if word 1 of the focusedObject is "field" then pass arrowKey
  put the number of this card into cardNum
  if which is "left" then
    if cardNum > 1 then
      send mouseUp to button "prev"
    end if
  end if
  if which is "right" then
    if cardNum < the number of cards then
      send mouseUp to button "next"
    end if
  end if
end arrowKey

on closeStack
  save this stack
  quit
end closeStack

on closeCard
  save this stack
end closeCard

on returnKey
  send mouseUp to the focusedObject
end returnKey

on enterKey
  send mouseUp to the focusedObject
end enterKey
  v  
LightSkyBlue ffffff      white       	darkgray   	 -             A&E Tracker      U Arial  	 U Arial   W Arial  
 U Arial   W Arial   U 
Helvetica  	 U 
Helvetica   U 
Helvetica   W 
Helvetica   W 
Helvetica   U 
Helvetica  
 U 
Helvetica   U 
Helvetica   U 
Helvetica   m    	@               	recordbg   i        
  n start date label   on mouseUp
  ask "Go to the first record with date" with the short date
  if it is empty then exit mouseUp
  convert it to long date
  repeat with i = 1 to the number of cards
    if field "start date" of card i is it then
      lock screen
      go card i
      unlock screen with visual plain
      exit mouseUp
    end if
  end repeat
  answer information "No records with that date."
end mouseUp
         
 l            Start Date 
  p label1b           
 ~            Start Time 
   label1c         X  4            	H      M 
   title          d   "           
Edit Records 
   label2c         X N 4            	H      M 
  B label3           m l            Project 
   etlabel           8 j            	End Time 
  r elabel           e j            Total Time 
  C label5            l            Activity/Rate 
   label6    $on mouseUp
  goCardNum
end mouseUp
         D            	Record # 
  D label7            l            Activity Notes 
  I label8          > l            Expense 
  J label9          m             Expense Notes 
  N 
ExpenseLabel         } z            
Expense $ 
  @ ctlabel          " L             The current time is: 
  o start date  	x  on mouseUp
  global gStartDate
  checkTimerRunning
  
  if field "start date" is empty then
    put the long date into temp
  else
    put field "start date" into temp
  end if
  put temp into gStartDate
  
  convert temp to short date
  ask "Enter a Start Date" with temp
  if it is empty then exit mouseUp
  if offset(",",it)=0 AND offset("/",it)=0 then
    answer "Enter dates in the format dd/mm/yy."
    exit mouseUp
  end if
  if it is not a date then
    ask "You entered an invalid Start Date. Try again." with the date
    if it is empty then exit mouseUp
    if it is not a date then
      ask "You entered an invalid Start Date. Try again." with the date
      if it is empty then
        exit mouseUp
      end if
    else
      put it into temp
      convert temp to long date
      put temp into field "start date"
      convert temp to dateItems
      put item 1 to 3 of temp into item 1 to 3 of field "start items"
    end if
  else
    put it into temp
    convert temp to long date
    put temp into field "start date"
    convert temp to dateItems
    put item 1 to 3 of temp into item 1 to 3 of field "start items"
  end if
  checkTime
end mouseUp
        
           m  
  q start time  
x  on mouseUp
  global gStartTime
checkTimerRunning
  
  if field "start time" is empty then
    put the time into temp
  else
    put field "start time" into temp
  end if
  put temp into gStartTime
  ask "Enter a Start Time" with temp
  if it is empty then exit mouseUp
  if offset(":",it)=0 then
    answer warning "All times must be in the format hh:mm."
    exit mouseUp
  end if
  if it is not a date then
    ask "You entered an invalid Start Time. Try again." with the time
    if it is not a date then
      answer error "You entered an invalid Start Time. Try again."
    else
      put it into temp
      convert temp to short time
      put temp into field "start time"
      convert temp to dateItems
      put item 4 to 5 of temp into item 4 to 5 of field "start items"
    end if
  else
    put it into temp
    convert temp to short time
    put temp into field "start time"
    convert temp to dateItems
    put item 4 to 5 of temp into item 4 to 5 of field "start items"
  end if
  checkTime
end mouseUp
          N         m  
   	end time  
x  Ron mouseUp
  global gEndTime
checkTimerRunning
  if (field "end time" is empty) or (field "end time" is not a date) then
    put the time into temp
  else
    put field "end time" into temp
  end if
  put temp into gEndTime
  ask "Enter an End Time" with temp
  if it is empty then
    exit mouseUp
  end if
  if offset(":",it)=0 then
    answer warning "All times must be in the format hh:mm."
    exit mouseUp
  end if
  if it is not a date then
    ask "You entered an invalid End Time. Try again." with the time
    if it is not a date then
      answer error "You entered an invalid End Time. Try again."
      exit mouseUp
    end if
  end if
  put it into temp
  convert temp to short time
  put temp into field "end time"
  convert temp to dateItems
  put item 4 to 5 of temp into item 4 to 5 of field "end items"
  
  checkTime
end mouseUp
         M N         m  
  s elapsed  	x  oon mouseUp
checkTimerRunning
  
  if field "elapsed" is empty OR word 2 of field "elapsed" <> "hrs" then
    put 0 && "hrs" && 0 && "mins" into temp
  else
    put field "elapsed" into temp
  end if
  
  if field "End time" <> "n/a" then
    if field "Start time" <> empty AND field "End time" <> empty then
      answer question "Do you want to clear the End Date and End Time?" with "Yes" or "No"
      if it is "Yes" then
        put empty into field "end date"
        put empty into field "End Time"
      else
        answer warning "You need to adjust the start or end time or date."
        exit mouseUp
      end if
    end if
  end if
  ask "Enter a new Total Time" with temp
  if it is empty then exit mouseUp
  if checkElapsed(it) then
    put "n/a" into field "end date"
    put "n/a" into field "End Time"
    put it into field "elapsed"
  else
    ask "You entered an invalid Total Time. Try again." with field "elapsed"
    if it is empty then exit mouseUp
    if checkElapsed(it) then
      put "n/a" into field "end date"
      put "n/a" into field "End Time"
      put it into field "elapsed"
    else
      answer error "The Total Time must be in the format # hrs # mins. Try again."
      -- put empty into field "elapsed"
      exit mouseUp
    end if
  end if
end mouseUp

function checkElapsed input
  if (char 1 of word 1 of input is "-")  or (char 1 of word 3 of input is "-") then
    return false
  end if
  if (word 1 of input is a number) and (word 2 of input is "hrs") and \
      (word 3 of input is a number) and  (word 4 of input is "mins") then
    return true
  else
    return false
  end if
end checkElapsed
         z          m     Today Ex  
 on mouseUp
  global gStartDate
checkTimerRunning
  put field "start date" into gStartDate
  put the long date into field "Start date"
  checkTime  "Start date"
end mouseUp
   dd CornflowerBlue    d  (              	       . Edit Ex  
 =on mouseUp
  send mouseUp to field "Start date"
end mouseUp
   dd CornflowerBlue      (              	        Choose Ex  
Non mouseUp
  global gDateField,gDateStack,gWhichfield,gStartDate
  checkTimerRunning
  put field "start date" into gStartDate
  put "start date" into gDateField
  put "start date" into gWhichfield
  put short name of this stack into gDateStack
  set the title of stack "dates" to "Select a Start Date"
  go stack "dates"
end mouseUp
   dd CornflowerBlue      2              	        Now Ex  
on mouseUp
  global gStartTime,gStartDate
checkTimerRunning
  put field "start date" into gStartDate
  put field "start time" into gStartTime
  put the time into field "Start time"
  put the long date into field "Start date"
  checkTime "Start time"
end mouseUp
   dd CornflowerBlue   ?  "              	        Edit Ex  
 =on mouseUp
  send mouseUp to field "Start time"
end mouseUp
   dd CornflowerBlue   c  "              	       > Select Project ex   ron mouseUp
  global gStack
  put "records" into gStack
  go stack "projects"
  show stack "projects"
end mouseUp
           dd CornflowerBlue    j k       Add/Select Project         	       < Select Activity ex   lon mouseUp
  global gStack
  put "records" into gStack
  go stack "tasks"
  show stack "tasks"
end mouseUp
   dd CornflowerBlue    j        Add/Select Activity         	        Start Timer Ex 	 on mouseUp
  global gRegistered,gTimerRunning,gElapsed,gAbortTest
  
  if gRegistered is false then
    answer warning "Your trial period has expired. Please register your software."
    send mouseUp to button "Register"
    exit mouseUp
  end if
  
  if field "project" is empty then
    answer error "You must select or create a project first."
    global gStack
    put "records" into gStack
    go stack "projects"
    show stack "projects"
    exit mouseUp
  end if
  
  if field "task" is empty then
    answer error "You must select or create an Activity first."
    global gStack
    put "records" into gStack
    go stack "tasks"
    show stack "tasks"
    exit mouseUp
  end if
  
  lock screen
  if word 2 of field "elapsed" <> "hrs" then put "0 hrs 0 mins" into field "elapsed"
  if field "elapsed" <> "0 hrs 0 mins" then
    answer warning "Do you want to restart the timer or create a new record?" with "New Record" or "Restart Timer" or "Cancel"
    if it is "Cancel" then exit mouseUp
    if it is "New Record" then
      if (field "task notes" <> empty or field "expense" <> empty or field "expense notes" <> empty) then
        answer question "Do you want to duplicate the notes and expenses?" with "Yes" or "No"
      else
        put "no" into it
      end if
      if it is "Yes" then
        clone this card
        repeat with i = 1 to the number of cards
          put i into field "record" of card i
        end repeat
      end if
      if it is "No" then
        put field "project" into zProjectName
        put field "task" into zActivity
        go last
        create card
        put the number of this card into field "record"
        put zProjectName into field "project"
        put zActivity into field "Task"
      end if
      
      put "0 hrs 0 mins" into field "elapsed"
      put the time into field "start time"
      put the long date into field "start date"
      put empty into field "telapsed"
    else -- restart timer
      put field "elapsed" into field "telapsed"
      put "n/a" into field "end time"
    end if
  else -- field "elapsed" = "0 hrs 0 mins"
    if field "end time" <> empty then
      put empty into field "end time"
    end if
  end if
  
  put "timer" into gAbortTest
  checkNegTime
  if gAbortTest is "abort" then exit mouseUp
  
  put "Timer Running" into field "elabel"
  if field "start date" is empty then put the long date into field "start date"
  if field "start time" is empty then put the time into field "start time"
  hide group "edate"
  put the time into field "ctime"
  put true into gTimerRunning
  hide me
  set the name of button 10 to "Pause"
  show button "Stop"
  show button "Pause"
  put false into computeElapsedFlag
  if field "elapsed" = "0 hrs 0 mins" AND the time <> field "Start Time" then
    put field "start time" into temp
    put true into computeElapsedFlag
  else
    put the time into temp
  end if
  convert temp to dateitems
  put temp into field "startimer"
  put temp into field "running"
  put empty into field "end date"
  
  if computeElapsedFlag then
    global gElapsed
    computeElapsed
    put gElapsed into field "elapsed"
    --   put field "elapsed" into field "telapsed"
  end if
  setArrows
  unlock screen with visual plain
  save this stack
end mouseUp
           dd CornflowerBlue                   	       8 Stop Ex 	 on mouseUp
  global gElapsed,gTimerRunning
  put false into gTimerRunning
  
  lock screen
  hide me
  put "Total Time" into field "elabel"
  put "End Time" into field "etlabel"
  put the long date into field "end date"
  show group "edate"
  if the short name of button 10 is "Go" then
    set the name of button 10 to "Pause"
  else
    computeElapsed
    put gElapsed into field "elapsed"
    if field "end time" is empty then
      put the time into field "end time"
    end if
  end if
  hide button "pause"
  show button "Start Timer"
  put empty into field "startimer"
  put empty into field "telapsed"
  put empty into field "running"
  unlock screen with visual effect plain
  save this stack
end mouseUp
           dd CornflowerBlue      >             	       9 Pause Ex 	 
on mouseUp
  global gElapsed,gTimerRunning
  
  lock screen
  put true into gTimerRunning
  if the short name of me is "Pause" then
    set the name of me to "Go"
    computeElapsed
    put gElapsed into field "telapsed"
    put gElapsed into field "elapsed"
    put "n/a" into field "end time"
    put empty into field "running"
    put "Timer Paused" into field "elabel"
    
  else -- Restart
    put the time into temp
    convert temp to dateitems
    put temp into field "running"
    put field "elapsed" into field "telapsed"
    put the time into temp
    convert temp to dateitems
    put temp into field "startimer"
    set the name of me to "Pause"
    put "Timer Running" into field "elabel"
  end if
  unlock screen with visual plain
  save this stack
end mouseUp
           dd CornflowerBlue   <  J             	        Quick Check Ex  Son mouseUp
  global gRegistered
  if gRegistered is false then
    answer warning "Your trial period has expired. Please register your software."
    send mouseUp to button "Register"
    exit mouseUp
  end if
  put field "project" into field "project" of stack "quickcheck"
  put field "task" into field "task" of stack "quickcheck"
  set the hilite of button "all activity" of stack "quickcheck" to false
  put the long date into field "end date" of stack "quickcheck"
  show stack "quickcheck"
  topLevel "quickcheck"
  send mouseUp to button "recalculate" of stack "quickcheck"
end mouseUp
   dd CornflowerBlue      b             	     
  F task notes )x   on closeField
  if field "task" is empty then
    answer warning "You need to select an Activity Type too."
  end if
end closeField
        
   I        m    G    `    @     G   = Select Expense ex   ron mouseUp
  global gStack
  put "records" into gStack
  go stack "expenses"
  show stack "expenses"
end mouseUp
   dd CornflowerBlue    j<       Add/Select Expense         
	     
  K expense notes  )h         
  (        m    L    `    @    &    + Ep &on mouseUp
  addExpenses
end mouseUp
   dd CornflowerBlue                   	        	Collapse F
  
on mouseUp
  lock screen
  put the loc of this stack into temp
  if the height of this stack = 215 then
    set the hilite of me to false
    set the height of this stack to 475
    add 130 to item 2 of temp
    set the loc of this stack to temp
    set the name of me to "Collapse"
  else
    set the hilite of me to true
    set the height of this stack to 215
    subtract 130 from item 2 of temp
    set the loc of this stack to temp
    set the name of me to "Restore"
  end if
  unlock screen with visual plain
end mouseUp
   dd CornflowerBlue      8 ,             	  m 	       4 Add Ex  _on mouseUp
  global gProjectName,gActivity,gRegistered,gLastCreated
  if gRegistered is false then
    answer warning "Your trial period has expired. Please register your software."
    send mouseUp to button "Register"
    exit mouseUp
  end if
  
  if the number of cards = 1 AND field "start date" is empty then
    answer information "You need to use this record before creating another."
    exit mouseUp
  end if
  
  checkCompleted
  answer question "Do you want a duplicate of this record with or without notes?" \
      with "Clear All" or "With Notes" or "Just Project & Activity"
  put it into which
  lock screen
  lock messages
  put field "project" into zProjectName
  put field "task" into zActivity
  
  if which is "With Notes" then
    clone this card
    put empty into field "startimer"
    put empty into field "telapsed"
    put empty into field "running"
    repeat with i = 1 to the number of cards
      put i into field "record" of card i
    end repeat
  end if
  
  if which is "Clear All" then
    go last
    create card
    put the number of this card into field "record"
  end if
  
  if which is "Just Project & Activity" then
    go last
    create card
    put the number of this card into field "record"
    put zProjectName into field "project"
    put zActivity into field "Task"
  end if
  
  put "0 hrs 0 mins" into field "elapsed"
  put the long date into field "start date"
  put the time into field "start time"
  put empty into field "end time"
  put empty into field "end date"
  put "End Date" into field "edlabel"
  openCard
  setArrows
  unlock screen with visual plain
end mouseUp
           dd CornflowerBlue    	 A             	        Delete Ex  Bon mouseUp
  global gTimerRunning
  if the number of cards = 1 then
    if field "start date" is empty then
      answer information "There are no more records to delete."
    else
      lock screen
      clearCardOne
    end if
    exit mouseUp
  end if
  answer question "Delete all records, old records or just this one?" with "All" or "Older" or "Just this one" or "Cancel"
  if it is "Cancel" then exit mouseUp
  lock messages
  put the number of this card -1 into cardNum
  if it is "Older" then
    ask "Delete records older than what date?" with field "start date"
    if it is empty or it is not a date then exit mouseUp
    put it into theDate
    convert theDate to seconds
    put  "Deleting " & number of cards of stack "records" && " records." into field "message"
    show field "message"
    lock screen
    repeat with i = the number of cards of stack "records" down to 2
      set cursor to busy
      put field "start date" of card i into zdate
      convert zdate to seconds
      if zdate < theDate then  delete card i
    end repeat
    
    go card 1
    put field "start date" of card 1 into zdate
    convert zdate to seconds
    if zdate < theDate then
      if the number of cards of stack "records" is 1 then
        clearCardOne
      else
        delete card 1
      end if
    end if
  end if
  
  if it is "All" then
    put  "Deleting " & number of cards of stack "records" && " records." into field "message"
    show field "message"
    lock screen
    repeat with i = the number of cards of stack "records" down to 2
      set cursor to busy
      delete card i
    end repeat
    clearCardOne
    hide field "message"
    openCard
    setArrows
    unlock screen with visual plain
    exit mouseUp
  end if
  
  if it is "Just this one" then
    lock screen
    if the number of cards > 1 then
      delete this card
    else
      clearCardOne
    end if
    go card cardNum
  end if
  
  repeat with i = 1 to the number of cards
    put i into field "record" of card i
  end repeat
  hide field "message"
  openCard
  setArrows
  unlock screen with visual plain
end mouseUp
           dd CornflowerBlue   C	 A             	        Search Ex  on mouseUp
  global gFindStack, gFoundOne
  put false into gFoundOne
  put the short name of this stack into gFindStack
  checkCompleted
  get the loc of stack "records"
  if the loc of stack "atFind" = it then
    add 220 to item 1 of it
    add 75 to item 2 of it
    set the loc of stack "atFind" to it
  end if
  go card 1 of stack "atFind"
  show stack "atFind"
  select text of field "find" of stack "ATfind"
end mouseUp
           dd CornflowerBlue    & A             	        Sort Ex  gon mouseUp
  answer question "Sort records by date, activity or project?" with  "Cancel" or "Project" or "Activity" or "Date"
  if it is "Cancel" then exit mouseUp
  lock screen
  lock messages
  repeat with i = 1 to the number of cards
    put empty into temp
    put field "start time"  of card i into startTime
    put field "start date"  of card i into startDate
    convert startDate to dateItems
    convert startTime to dateItems
    put item 4 to 5 of startTime into item 4 to 5 of startDate
    repeat with n = 1 to 5
      if item n of startDate < 10 then
        put "0"&item n of startDate after temp
      else
        put item n of startDate after temp
      end if
    end repeat
    put temp into field "Start items" of card i
  end repeat
  
  sort stack "records" by field "Start items"
  if it is "Project" then
    sort stack "records" by field "project"
  end if
  if it is "Activity" then
    sort stack "records" by field "task"
  end if
  repeat with i = 1 to the number of cards
    put i into field "record" of card i
  end repeat
  openCard
  setArrows
  unlock screen with visual plain
end mouseUp
           dd CornflowerBlue   C& A             	        Import Ex  on mouseUp
  put the number of cards into znum
  if (the number of cards = 1) and (field "project" is empty) then
    put 1 into firstCard
  else
    answer question "Delete all records first or add to existing?" with "Delete" or "Add" or "Cancel"
    if it is "cancel" then exit mouseUp
    if it is "Delete" then
      if znum > 50 then
        put the seconds && "Deleting " && znum && "records." into field "message"
        show field "message"
      end if
      lock messages
      lock screen
      repeat with i = znum down to 2
        set cursor to busy
        delete card i
      end repeat
      put 1 into firstCard
      clearCardOne
      put false into renumberTasks
      unlock screen with visual plain
    else
      go card znum
      put znum into firstCard
      put true into renumberTasks
    end if
  end if
  hide field "message"
  importRecords firstCard, renumberTasks -- in this script
  hide field "message"
  openCard
  setArrows
  unlock screen with visual plain
end mouseUp

on  importRecords  firstCard, renumberTasks
  -- read from file, create and populate new cards
  answer file "Select a records file to import." with "records.txt"
  if the result is "Cancel" then exit to metacard
  put it into fileName
  open file fileName for read
  if the result is empty then
    read from file fileName until eof
    put it into temp
    if word 1 to 2 of temp <> "Start Date" then
      answer error "This is not a valid records file. Try again."
      exit to metaCard
    end if
    put the number of lines of temp into znum
    if znum > 50 then
      put "Importing" && znum - 1 && "records." into field "message"
      show field "message"
    end if
    lock messages
    lock recent
    lock screen
    go card firstCard of stack "records"
    if firstCard > 1 then add 1 to firstCard
    
    repeat with i = 2 to znum
      if line i of temp is empty then next repeat
      set cursor to busy
      if firstCard > 1 then create card
      put firstCard into field "record"
      put line i of temp into zline
      set the itemDelimiter to tab
      if NOT item 1 of zline is a date then next repeat
      put item 1 of zline into field "Start Date"
      put item 2 of zline into field "Start Time"
      put item 3 of zline into field "End Date"
      if item 4 of zline = "timer running or paused" then
        put item 4 of zline into field "startimer"
        put item 4 of zline into field "End Time"
      else
        put item 4 of zline into field "End Time"
      end if
      if item 5 of zline is empty then
        put "0 hrs 0 mins" into field "Elapsed"
      else
        put item 5 of zline into field "Elapsed"
      end if
      put item 6 of zline into field "Project"
      put item 7 of zline into field "Task"
      
      put item 8 of zline into tNotes
      repeat while offset(" | ",tnotes) > 0
        put offset(" | ",tnotes) into firstChar
        put firstChar + 2 into lastChar
        put return into char  firstChar to lastChar of tnotes
      end repeat
      put tnotes into field "Task Notes"
      
      put item 9 of zline into field "Expense"
      
      put item 10 of zline into enotes
      repeat while offset(" | ",enotes) > 0
        put offset(" | ",enotes) into firstChar
        put firstChar + 2 into lastChar
        put return into char  firstChar to lastChar of enotes
      end repeat
      put enotes into field "Expense Notes"
      
      put item 11 of zline into field "Expense Amount"
      set the itemDelimiter to comma
      
      if offset(field "Project", field "Projects" of stack "Projects") = 0 then
        put the number of lines of field "Projects" of stack "Projects" + 1into zlines
        put field "Project" into line zlines of field "Projects" of stack "Projects"
      end if
      if offset(field "Task", field "Tasks" of stack "Tasks") = 0 then
        put the number of lines of field "Tasks" of stack "Tasks" + 1into zlines
        put field "Task"  into line zlines of field "Tasks" of stack "Tasks"
      end if
      if offset(field "Expense", field "Expenses" of stack "Expenses") = 0 then
        put the number of lines of field "Expenses" of stack "Expenses" + 1into zlines
        put field "Expense"  into line zlines of field "Expenses" of stack "Expenses"
      end if
      
      add 1 to firstCard
    end repeat
    close file fileName
    hide field "message"
    if renumberTasks then
      repeat with n = 1 to the number of cards
        put n into field "record" of card n of stack "records"
      end repeat
    end if
    unlock screen with visual plain
    setarrows
    sort  field "projects" of stack "projects"
    sort  field "tasks" of stack "tasks"
    sort  field "expenses" of stack "expenses"
    
    answer information "Do you want to import old project, " & return \
        & "activity and expense types?" with "Yes" or "No"
    if it is "Yes" then
      answer file "Select a paetypes file to import." with "paetypes.txt"
      if the result is "Cancel" then exit to metacard
      put it into fileName
      open file fileName for read
      if the result is empty then
        lock screen
        read from file fileName until eof
        put it into temp
        if word 1 of temp <> "projects:" then
          answer error "This is not a valid paetypes file."
          exit to metaCard
        end if
        put lineoffset("Activities:",temp) into aline
        put lineoffset("Expenses:",temp) into eline
        put line 2 to aline-1 of temp into zprojects
        repeat with i = 1 to the number of lines of zprojects
          if line i of zprojects is empty then next repeat
          if field "projects" of stack "projects" contains line i of zprojects then
            next repeat
          else
            put return & line i of zprojects after field "projects" of stack "projects"
          end if
        end repeat
        
        put line aline + 1 to eline-1 of temp into ztasks
        repeat with i = 1 to the number of lines of ztasks
          if line i of ztasks is empty then next repeat
          if field "tasks" of stack "tasks" contains line i of ztasks then
            next repeat
          else
            put return & line i of ztasks after field "tasks" of stack "tasks"
          end if
        end repeat
        
        delete line 1 to eline of temp
        put  temp into zexpenses
        repeat with i = 1 to the number of lines of zexpenses
          if line i of zexpenses is empty then next repeat
          if  field "expenses" of stack "expenses" contains line i of zexpenses then
            next repeat
          else
            put return & line i of zexpenses after  field "expenses" of stack "expenses"
          end if
        end repeat
        sort  field "projects" of stack "projects"
        if line 1of field "projects" of stack "projects" is empty then
          delete line 1 of field "projects" of stack "projects"
        end if
        sort  field "tasks" of stack "tasks"
        if line 1of field "tasks" of stack "tasks" is empty then
          delete line 1 of field "tasks" of stack "tasks"
        end if
        sort  field "expenses" of stack "expenses"
        if line 1of field "expenses" of stack "expenses" is empty then
          delete line 1 of field "expenses" of stack "expenses"
        end if
      else
        answer "There was a problem opening this file." & return & the result & return & sysError()
      end if
      close file fileName
    end if
  else
    answer "There was a problem opening this file." & return & the result & return & sysError()
  end if
end  importRecords
           dd CornflowerBlue    C A             	        Export Ex  con mouseUp
  global gElapsed
  
  if the number of cards is 1 and field "project" is empty then
    answer information "There are no records to export."
    exit mouseUp
  end if
  answer question "Export all records or specific records?" with "All" or "Specific" or "Cancel"
  if it is "Cancel" then exit mouseUp
  put it into exportWhich
  put empty into whichProject
  put the short date into whichDate
  if it is "Specific" then
    answer question "Export old records, new records or project records?" with "New" or "Old" or "Project" or "Cancel"
    if it is "Cancel" then exit mouseUp
    put it into exportWhich
    if exportWhich is "Project" then
      answer "Export records for project" && field "project" & "?" with "OK" or "Help" or "Cancel"
      if it is "Cancel" then exit mouseUp
      if it is "Help" then
        answer "You can only export project records from a record for that project."
        exit mouseUp
      end if
      put field "project" into whichProject
      put empty into whichDate
      ask file "Save records as... " with whichProject&"_records.txt"
      if the result is "Cancel" then exit mouseUp
      put checkExt(it) into fileName
    end if
    if exportWhich is "New" then
      ask "Export records newer than what date?" with whichDate
      if it is empty then exit mouseUp
      if it is not a date then
        answer error "Invalid date. Try again."
        exit mouseUp
      end if
      put it into whichDate
      put it into temp
      convert temp to short date
      repeat while offset("/",temp) > 0
        put "_" into char offset("/",temp) of temp
      end repeat
      ask file "Save records as... " with "records_newer_" & temp & ".txt"
      if the result is "Cancel" then exit mouseUp
      put checkExt(it) into fileName
      convert whichDate to seconds
    end if
    if exportWhich is "Old" then
      ask "Export records older than what date?" with whichDate
      if it is empty then exit mouseUp
      if it is not a date then
        answer error "Invalid date. Try again."
        exit mouseUp
      end if
      put it into whichDate
      put it into temp
      convert temp to short date
      repeat while offset("/",temp) > 0
        put "_" into char offset("/",temp) of temp
      end repeat
      ask file "Save records as... " with "records_older_" & temp & ".txt"
      if the result is "Cancel" then exit mouseUp
      put checkExt(it) into fileName
      convert whichDate to seconds
    end if
  end if
  
  if exportWhich is "all" then
    repeat while offset("/",whichDate) > 0
      put "_" into char offset("/",whichDate) of whichDate
    end repeat
    ask file "Save records as... " with "all_records_" & whichDate & ".txt"
    if the result is "Cancel" then exit mouseUp
    put checkExt(it) into fileName
    put empty into whichDate
  end if
  
  -- save data from all cards to txt file
  open file fileName for write
  if the result is empty then
    put "Exporting " & exportWhich & " records." into field "message"
    show field "message"
    lock messages
    lock screen
    put true into noRecords
    write "Start Date" & tab & "Start Time" & tab & "End Date" & tab & "End Time" & tab & "Elapsed Time" & tab & "Project" & tab & "Activity/Rate" & tab \
        & "Activity Notes" & tab & "Expense" & tab & "Expense Notes" & tab & " Expense Amount" & return to file fileName
    repeat with i = 1 to the number of cards
      set cursor to busy
      go card i of stack "records"
      put true into exportRecord
      if whichProject <> empty then
        if  field "Project" <> whichProject then
          put false into exportRecord
        end if
      end if
      if whichDate<> empty then
        put field "start date" into startDate
        convert startDate to seconds
        if exportWhich is "New" then
          if startDate <= whichDate then
            put false into exportRecord
          end if
        else -- exportWhich is "old"
          if startDate >= whichDate then
            put false into exportRecord
          end if
        end if
      end if
      if exportRecord then
        put false into noRecords
        if field "startimer" <> empty then
          if field "running" is empty then
            put field "telapsed" into field "elapsed"
          else
            computeElapsed
            put gElapsed into field "elapsed"
          end if
          put "timer running or paused" into field "end time"
        end if
        
        put field "task notes" into tnotes
        repeat while offset(return,tnotes) > 0
          put " | " into char offset(return,tnotes) of tnotes
        end repeat
        
        put field "Expense notes" into enotes
        repeat while offset(return,enotes) > 0
          put " | " into char offset(return,enotes) of enotes
        end repeat
        
        write field  "Start Date" & tab & field "Start Time" & tab & field "End Date" & tab & field "End Time" & tab &  field "Elapsed" & tab & field "Project" & tab & field "Task" & tab \
            & tnotes & tab & field "Expense" & tab & enotes & tab & field "Expense Amount" & return to file fileName
      end if
    end repeat
    hide field "message"
    openCard
    setarrows
    unlock screen with visual plain
    close file fileName
    
    if  noRecords then
      answer information "No records were found to export."
    end if
    
    answer information "Do you want to export the project, " & return & "activity and expense types?" with "Yes" or "No"
    if it is "No" then exit mouseUp
    put the short date into whichDate
    repeat while offset("/",whichDate) > 0
      put "_" into char offset("/",whichDate) of whichDate
    end repeat
    ask file "Save project, activity and expense types as... " with whichDate &"_paetypes.txt"
    if the result is "Cancel" then exit mouseUp
    put checkExt(it) into fileName
    open file fileName for write
    if the result is empty then
      put "Projects:" & return & field "projects" of stack "projects" & return into temp
      put "Activities:" & return & field "tasks" of stack "tasks" & return after temp
      put "Expenses:" & return & field "expenses" of stack "expenses" after temp
      write temp to file fileName
      close file fileName
    else
      answer "There was a problem saving this file." & return & the result & return & sysError()
    end if
  else
    answer "There was a problem saving this file." & return & the result & return & sysError()
  end if
end mouseUp
           dd CornflowerBlue   CC A             	       5 Prefs Ex   @on mouseUp
  go stack "prefs"
  show stack "prefs"
end mouseUp
   dd CornflowerBlue    ` A             	       6 	Register Ex   Fon mouseUp
  go stack "Register"
  show stack "Register"
end mouseUp
   dd CornflowerBlue   C` A             	       
 Edit Ex  
 Aon mouseUp
  send mouseUp to field "expense amount"
end mouseUp
   dd CornflowerBlue   d                	        Help Ux  $on mouseUp
  visual effect plain
  get the loc of stack "records"
  if the loc of stack "help" = it then
    add 395 to item 1 of it
    set the loc of stack "help" to it
  end if
  -- go card "records" of stack "Help"
  go card "A&E Tracker" of stack "Help"
  show stack "help"
end mouseUp
   dd CornflowerBlue    
 H             	        Invoices & Reports Ex   -on mouseUp
  go stack "reports"
end mouseUp
   dd CornflowerBlue    \              	       7 Quit Ux   on mouseUp
  put the substacks of stack "main" into temp
  repeat with i = 1 to the number of lines of temp
    close stack line i of temp
  end repeat

  save this stack
  quit
end mouseUp
   dd CornflowerBlue     H             	        Save Ux   *on mouseUp
  save this stack
end mouseUp
   dd CornflowerBlue   < H              	     
   expense amount  	x   Aon mouseUp
 newExpense the short name of this stack
end mouseUp
        v         m  
  H project  	x   ron mouseUp
  global gStack
  put "records" into gStack
  go stack "projects"
  show stack "projects"
end mouseUp
        
           m     First @V  
 on mouseUp
  global gVeffect
  checkCompleted
  lock screen
  go first
  setArrows
  if gVeffect then
    put "scroll  left fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
   dd CornflowerBlue      * ,  ?         	  m 	        Prev @F  
 on mouseUp
  global gVeffect
  checkCompleted
  lock screen
  go prev
  setArrows
  if gVeffect then
    put "scroll  left fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
   dd CornflowerBlue     * ,  @         	  m 	         Next @F  
 on mouseUp
  global gVeffect
  checkCompleted
  lock screen
  go next
  setArrows
  if gVeffect then
    put "scroll  right fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
   dd CornflowerBlue   ?  * ,  A         	  m 	        Last @F  
 on mouseUp
  global gVeffect
  checkCompleted
  lock screen
  go last
  setArrows
  if gVeffect then
    put "scroll  right fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
   dd CornflowerBlue   f  * ,  B         	  m 	     
   record  x 	  %on mouseUp
  goCardNum
end mouseUp

       \  *         m 1 
  E task  	x   lon mouseUp
  global gStack
  put "records" into gStack
  go stack "tasks"
  show stack "tasks"
end mouseUp
        
           m  
  M expense  	x   ron mouseUp
  global gStack
  put "records" into gStack
  go stack "expenses"
  show stack "expenses"
end mouseUp
        
S          m  
  z start items  h        F  \         m       
  { 
end items  h        F 6 \         m     Clear expenses Ex  
 on mouseUp
  if the optionKey is "down" then clearstack
  put empty into field "expense notes"
  put empty into field "expense"
  put empty into field "expense amount"
end mouseUp
   dd CornflowerBlue    o b              	           	D                   P #     Y  ~ >           > ~ ~     <      ?           ?                             	D                   k #     Y  ~ >           > ~ ~     <      ?           ?                          UpSH A don mouseDown
  adjustTime "up","start time","hr"
end mouseDown

on mouseUp
  checkTime
end mouseUp
   dd CornflowerBlue @ P !               	        DnSH A fon mouseDown
  adjustTime "down","start time","hr"
end mouseDown

on mouseUp
  checkTime
end mouseUp
   dd CornflowerBlue @ P +               	        UpSM A eon mouseDown
  adjustTime "up","start time","min"
end mouseDown

on mouseUp
  checkTime
end mouseUp
   dd CornflowerBlue @ k !               	        DNSM A gon mouseDown
  adjustTime "down","start time","min"
end mouseDown

on mouseUp
  checkTime
end mouseUp
   dd CornflowerBlue @ k +               	           	D                   k Q     Y  ~ >           > ~ ~     <      ?           ?                             	D                   P Q     Y  ~ >           > ~ ~     <      ?           ?                          UpEH A bon mouseDown
  adjustTime "up","end time","hr"
end mouseDown

on mouseUp
  checkTime
end mouseUp
   dd CornflowerBlue @ P O               	        DnEH A don mouseDown
  adjustTime "down","end time","hr"
end mouseDown

on mouseUp
  checkTime
end mouseUp
   dd CornflowerBlue @ P Y               	        UpEM A con mouseDown
  adjustTime "up","end time","min"
end mouseDown

on mouseUp
  checkTime
end mouseUp
   dd CornflowerBlue @ k O               	        DnEM A eon mouseDown
  adjustTime "down","end time","min"
end mouseDown

on mouseUp
  checkTime
end mouseUp
   dd CornflowerBlue @ k Y               	     
  : 
startimer  h            h         m  
  ; 	telapsed  h                     m  
  < running  h        $   d         m  
  ? ctime  h          M H         m    > edate   i        4  5
   edlabel           8 l            	End Date 
   	end date  	x  on mouseUp
  global gEndDate
checkTimerRunning
  put field "start date" into temp
  convert temp to short date
  put temp into gEndDate
  if field "end date" is empty then
    ask "Enter an End Date" with temp
  else
    put field "end date" into temp
    put temp into gEndDate
    convert temp to short date
    ask "Enter an End Date" with temp
  end if
  if it is empty then
    exit mouseUp
  end if
  if offset(",",it)=0 AND offset("/",it)=0 then
    answer "Enter dates in the format dd/mm/yy."
    exit mouseUp
  end if
  if it is not a date then
    ask "You entered an invalid End Date. Try again." with the date
    if it is not a date then
      ask "You entered an invalid End Date. Try again." with the date
    else
      put it into temp
      convert temp to long date
      put temp into field "end date"
      convert temp to dateItems
      put item 1 to 3 of temp into item 1 to 3 of field "end items"
    end if
  else
    put it into temp
    convert temp to long date
    put temp into field "end date"
    convert temp to dateItems
    put item 1 to 3 of temp into item 1 to 3 of field "end items"
  end if
  checkTime
end mouseUp
        
 M          m     Today Ex  
 on mouseUp
  global gEndDate
checkTimerRunning
  put field "end date" into gEndDate
  put the long date into field "end date"
  checkTime "end date"
end mouseUp
   dd CornflowerBlue    d : (              	       - Edit Ex  
 ;on mouseUp
  send mouseUp to field "end date"
end mouseUp
   dd CornflowerBlue     : (              	       	 Choose Ex  
Bon mouseUp
  global gDateField,gDateStack,gWhichfield,gEndDate

checkTimerRunning
  put field "end date" into gEndDate
  put "end date" into gDateField
  put "end date" into gWhichfield
  put short name of this stack into gDateStack
  set the title of stack "dates" to "Select an End Date"
  go stack "dates"
end mouseUp
   dd CornflowerBlue     : 2              	        Edit Ex  
 :on mouseUp
  send mouseUp to field "elapsed"
end mouseUp
   dd CornflowerBlue   c g "              	        Edit Ex  
 ;on mouseUp
  send mouseUp to field "end time"
end mouseUp
   dd CornflowerBlue   c : "              	        Now Ex  
 on mouseUp
  global gEndDate,gEndTime
checkTimerRunning
  put field "end date" into gEndDate
  put field "end time" into gEndTime
  put the time into field "End time"
  put the long date into field "end date"
  checkTime "End time"
end mouseUp
   dd CornflowerBlue   ? : "              	     
  
 message  x 
  "on mouseUp
  hide me
end mouseUp
        
z                	projects  on openCard
  global gProject
  if field "projects" = empty then exit openCard
  if gProject is empty then
    set the hilitedlines of field "projects" to 1
    put 1 into gProject
  else
    set the hilitedlines of field "projects" to gProject
  end if
end openCard

on arrowKey which
  global gProject
  put the number of lines of field "projects" into numLines
  if which is "up" then
    if gProject is 1 then
      put numLines into gProject
    else
      subtract 1 from gProject
    end if
  end if
  if which is "down" then
    if gProject is numLines then
      put 1 into gProject
    else
      add 1 to gProject
    end if
  end if
  set the hilitedlines of field "projects" to gProject
end arrowKey

on returnKey
  checkFocus
end returnKey

on enterKey
  checkFocus
end enterKey

on closeStack
  save this stack
end closeStack

on checkFocus
  global gProject
  if word 3 of the focusedObject is the id of button "Create Project" then
    send mouseUp to button "Create Project"
  else
    if gProject is empty then
      send mouseUp to the focusedObject
    else
      send mouseUp to button "Choose Project"
    end if
  end if
end checkFocus
            
LightSkyBlue    " ^,         	Projects      U Arial   U Arial   U 
Helvetica  
 U Arial  	 U Arial   U Arial   U 
Helvetica  
 U 
Helvetica  
 W 
Helvetica   W Arial   W 
Helvetica       	@          ^,                
   projectsbg  	h          6                    `    @   7      Create Project Ex 
 on mouseUp
  global gProject
  put 32 into maxLength
  ask "Enter the name of the new project."
  if it is empty then exit mouseUp
  if length(it)> maxLength then
    ask "Enter a name for this project that is" && maxLength && "characters or less." with char 1 to maxLength of it
    if it is empty then exit mouseUp
    if length(it)> maxLength then exit mouseUp
  end if
  
  repeat with i = 1 to the number of lines of  field "projects"
    if line i of field "projects" is it then
      answer information "You have already created this project."
      exit mouseUp
    end if
  end repeat
  
  put the number of lines of field "projects" + 1 into temp
  put it into newProject
  put newProject into line temp of field "projects"
  sort field "projects"
  
  repeat with i = 1 to the number of lines of  field "projects"
    if line i of field "projects" is newProject then
      set the hilitedLines of field "projects" to i
      put i into gProject
      exit mouseUp
    end if
  end repeat
  
end mouseUp
           dd CornflowerBlue     t s             	        Delete Project Ex  pon mouseUp
  global gProject,gStack
  
  if the hilitedlines of field "projects" > 0 then
    put the hilitedlines of field "projects" into gProject
  end if
  
  if gProject is empty then
    put the number of lines of field "projects" into temp
    switch temp
    case 0
      answer information "Nothing to delete."
      exit mouseUp
    case 1
      put 1 into gProject
      break
    default
      answer information "First select a project to delete."
      exit mouseUp
    end switch
  end if
  put line gProject of field "projects" of stack "projects" into temp
  answer warning "After deleting this project, you will no longer " & return & "be able to generate reports on " &quote & temp & quote& "." with "Cancel" or "Delete"
  if it is "Cancel" then exit mouseUp
  delete line gProject of field "projects" of stack "projects"
  put empty into gProject
end mouseUp
   dd CornflowerBlue      s             	        Choose Project Mx  on mouseUp
  global gProject,gStack,gProjectName
  
  if the hilitedlines of field "projects" > 0 then
    put the hilitedlines of field "projects" into gProject
  end if
  
  if gProject is empty then
    put the number of lines of field "projects" into temp
    switch temp
    case 0
      answer information "First create a project."
      send mouseUp to button "Create Project"
      exit mouseUp
    case 1
      put 1 into gProject
      break
    default
      answer information "First select or create a project."
      exit mouseUp
    end switch
  end if
  put line gProject of field "projects" into field "project" of stack gStack
  put line gProject of field "projects" into gProjectName
  --  put empty into gProject
  close this stack
end mouseUp
   dd CornflowerBlue     9 q %            	        
Close Window Ex   +on mouseUp
  close this stack
end mouseUp
   dd CornflowerBlue      s             	     
   instruction 	          F (           :Create a project or select one from the list on the left   &and then click a button on the right. 
   	projects  	x  on mouseUp
  global gProject
  put word 2 of the clickLine into gProject
end mouseUp

on mouseDoubleDown
  global gProject,gStack,gProjectName
  put word 2 of the clickLine into gProject
  put line gProject of field "projects" of stack "projects" into field "project" of stack gStack
  put line gProject of field "projects" into gProjectName
  if gProjectName is empty then exit to metaCard
  -- put empty into gProject
  hide this stack
  choose browse tool
end mouseDoubleDown
        	 6                    `    @   7      Modify Project Ex  on mouseUp
  global gProject, gStack,gProjectName
  if the hilitedlines of field "projects" > 0 then
    put the hilitedlines of field "projects" into gProject
  end if
  
  if gProject is empty then
    put the number of lines of field "projects" into temp
    switch temp
    case 0
      answer information "Nothing to modify."
      exit mouseUp
    case 1
      put 1 into gProject
      break
    default
      answer information "First select a project."
      exit mouseUp
    end switch
  end if
  put line gProject of field "projects" of stack "projects" into origProject
  
  put 32 into maxLength
  ask "Enter the new name for this project." with origProject
  if it is empty then exit mouseUp
  if length(it)> maxLength then
    ask "Enter a name for this project that is " & maxLength & " characters or less." with char 1 to  maxLength of it
    if it is empty then exit mouseUp
    if length(it)> maxLength then exit mouseUp
  end if
  
  put it into gProjectName
  put gProjectName into line gProject of field "projects"
  sort field "projects"
  
  repeat with i = 1 to the number of lines of  field "projects"
    if line i of field "projects" is gProjectName then
      set the hilitedLines of field "projects" to i
      put i into gProject
      exit repeat
    end if
  end repeat
  
  repeat with i = 1 to the number of cards of stack "records"
    if field "project" of card i of stack "records" is origProject then
      put gProjectName into field "project" of card i of stack "records"
    end if
  end repeat
  
end mouseUp
   dd CornflowerBlue      s             	        tasks  lon openCard
  global gTask
  if field "tasks" = empty then exit openCard
  if gTask is empty then
    set the hilitedlines of field "tasks" to 1
    put 1 into gTask
  else
    set the hilitedlines of field "tasks" to gTask
  end if
end openCard

on arrowKey which
  global gTask
  put the number of lines of field "tasks" into numLines
  if which is "up" then
    if gTask is 1 then
      put numLines into gTask
    else
      subtract 1 from gTask
    end if
  end if
  if which is "down" then
    if gTask is numLines then
      put 1 into gTask
    else
      add 1 to gTask
    end if
  end if
  set the hilitedlines of field "tasks" to gTask
end arrowKey

function checknumber which
  global gDollarSign
  repeat with x = 1 to length(gDollarSign)
    if NOT (char 1 of which is a number) AND (char 1 of which <> ".") then
      delete char 1 of which
    end if
  end repeat
  if which is a number then
    if gDollarSign = "$" then
      set the numberFormat to 0.00
      add 0 to which
      put which & empty into which
    end if
    return which
  else
    answer error which & " is not a number. Click Modify Activity to enter a rate."
    return 0
  end if
end checkNumber

on returnKey
  checkFocus
end returnKey

on enterKey
  checkFocus
end enterKey

on closeStack
  save this stack
end closeStack

on checkFocus
  global gActivity
  
  if word 3 of the focusedObject is the id of button "Create Activity" then
    send mouseUp to button "Create Activity"
  else
    if gActivity is empty then
      send mouseUp to the focusedObject
    else
      send mouseUp to button "Choose Activity"
    end if
  end if
end checkFocus
            
LightSkyBlue    " ^,         Activities      U Arial   U Arial   U 
Helvetica   U 
helvetica   W Arial   W 
Helvetica       	@          ^,                  
   tasksbg  	h          6                    `    @   7      Create Activity Ex  on mouseUp
  global gTask,gRate
  
  put 25 into maxLength
  if gRate is empty then put 0 into gRate
  ask "Enter the name of the new activity."
  if it is empty then exit mouseUp
  if length(it)> maxLength then
    ask "Enter a name for this activity that is " & maxLength & " characters or less." with char 1 to  maxLength of it
    if it is empty then exit mouseUp
    if length(it)> maxLength then delete char (maxLength + 1) to length(it) of it
  end if
  
  put it into checkItems
  repeat until offset(comma,checkItems)=0
    put ";" into char offset(comma,checkItems) of checkItems
  end repeat
  put checkItems into task
  
  answer question "Do you want to add a rate per hour or a flat rate for this Activity?" with "None" or "Flat Rate" or "Per Hour"
  put it into which
  if which is "None" then
    put 0 into zRate
  else
    if which is "Per Hour" then
      ask  "Enter the rate per hour for this Activity." with gRate
      if it is empty then
        put 0 into zRate
      else
        put checkNumber (it) into gRate -- in stack script
        put gRate & "/hr" into zRate
      end if
    else
      if which is "Flat rate" then
        ask "Enter the flat rate." with "00.00"
      end if
      if it is empty then
        put 0 into zRate
      else
        put checkNumber (it) into zRate
      end if
    end if
  end if
  
  if zRate <> 0 then put zRate into item 2 of task
  
  repeat with i = 1 to the number of lines of field "tasks"
    if line i of field "tasks" is task then
      answer information "You have already created this task."
      exit mouseUp
    end if
  end repeat
  
  put the number of lines of field "tasks" + 1 into temp
  put task into line temp of field "tasks"
  sort field "tasks"
  
  repeat with i = 1 to the number of lines of  field "tasks"
    if line i of field "tasks" is task then
      set the hilitedLines of field "tasks" to i
      put i into gTask
      exit mouseUp
    end if
  end repeat
end mouseUp
   dd CornflowerBlue     h s             	        Delete Activity Ex  Con mouseUp
  global gTask, gStack
  if the hilitedlines of field "tasks" > 0 then
    put the hilitedlines of field "tasks" into gTask
  end if
  
  if gTask is empty then
    put the number of lines of field "tasks" into temp
    switch temp
    case 0
      answer information "Nothing to delete."
      exit mouseUp
    case 1
      put 1 into gTask
      break
    default
      answer information "First select an Activity to delete."
      exit mouseUp
    end switch
  end if
  put line gtask of field "tasks" of stack "tasks" into temp
  answer warning "After deleting this task, you will no longer " & return & "be able to generate reports on " &quote & temp & quote& "." with "Cancel" or "Delete"
  if it is "Cancel" then exit mouseUp
  delete line gTask of field "tasks" of stack "tasks"
  put empty into gTask
end mouseUp
   dd CornflowerBlue      s             	        Choose Activity Mx  on mouseUp
  global gTask, gStack, gActivity
  if the hilitedlines of field "tasks" > 0 then
    put the hilitedlines of field "tasks" into gTask
  end if
  
  if gTask is empty then
    put the number of lines of field "tasks" into temp
    switch temp
    case 0
      answer information "First create an Activity."
      exit mouseUp
    case 1
      put 1 into gTask
      break
    default
      answer information "First select or create an Activity."
      exit mouseUp
    end switch
  end if
  put line gTask of field "tasks" of stack "tasks" into field "task" of stack gStack
  put line gTask of field "tasks" into gActivity
  --  put empty into gTask
  close this stack
end mouseUp
   dd CornflowerBlue     8 q %            	        Modify Activity Ex  on mouseUp
  global gTask, gStack, gRate
  put 25 into maxLength
  if the hilitedlines of field "tasks" > 0 then
    put the hilitedlines of field "tasks" into gTask
  end if
  
  if gRate is empty then put 0 into gRate
  
  if gTask is empty then
    put the number of lines of field "tasks" into temp
    switch temp
    case 0
      answer information "Nothing to modify."
      exit mouseUp
    case 1
      put 1 into gTask
      break
    default
      answer information "First select an Activity."
      exit mouseUp
    end switch
  end if
  put line gtask of field "tasks" of stack "tasks" into origTask
  
  ask "Enter the new name for this activity." with item 1 of origTask
  if it is empty then exit mouseUp
  if length(it)> maxLength then
    ask "Enter a name for this activity that is " & maxLength & " characters or less." with char 1 to  maxLength of it
    if it is empty then exit mouseUp
    if length(it)> maxLength then exit mouseUp
  end if
  put it into checkItems
  repeat until offset(comma,checkItems)=0
    put ";" into char offset(comma,checkItems) of checkItems
  end repeat
  
  put checkItems into item 1 of line gTask of field "tasks"
  set the hilitedLines of field "tasks" to gTask
  put line gTask of field "tasks" into newTask
  repeat with i = 1 to the number of cards of stack "records"
    if field "task" of card i of stack "records" is origTask then
      put newTask into field "task" of card i of stack "records"
    end if
  end repeat
  
  sort field "tasks"
  
  repeat with i = 1 to the number of lines of  field "tasks"
    if line i of field "tasks" is newTask then
      set the hilitedLines of field "tasks" to i
      put i into gTask
      exit mouseUp
    end if
  end repeat
end mouseUp
   dd CornflowerBlue      s             	     
   instruction 	          H (           <Create an activity or select one from the list on the left   &and then click a button on the right.    
Close Window Ex   +on mouseUp
  close this stack
end mouseUp
   dd CornflowerBlue      s             	     
   tasks  	x  on mouseUp
  global gTask
  put word 2 of the clickLine into gTask
end mouseUp


on mouseDoubleDown
  global gTask,gStack,gActivity
  put word 2 of the clickLine into gTask
  put line gTask of field "tasks" of stack "tasks" into field "task" of stack gStack
  put line gTask of field "tasks" into gActivity
  if gActivity is empty then exit to metaCard
  --  put empty into gTask
  hide this stack
  choose browse tool
end mouseDoubleDown
        	 6             Administration  Lunch  Phone calls       `    @   7      Modify Rate Ex  mon mouseUp
  global gTask, gStack, gRate
  if the hilitedlines of field "tasks" > 0 then
    put the hilitedlines of field "tasks" into gTask
  end if
  
  if gRate is empty then put 0 into gRate
  
  if gTask is empty then
    put the number of lines of field "tasks" into temp
    switch temp
    case 0
      answer information "Nothing to modify."
      exit mouseUp
    case 1
      put 1 into gTask
      break
    default
      answer information "First select an Activity."
      exit mouseUp
    end switch
  end if
  put line gtask of field "tasks" of stack "tasks" into origTask
  put item 1 of origTask into task
  put 25 into maxLength
  if gRate is empty then put 0 into gRate
  
  if item 2 of origTask is empty then
    answer question "Do you want to add a rate per hour or a flat rate for this Activity?" with "None" or "Flat Rate" or "Per Hour"
  else
    answer question "Do you want to change the rate for this activity?" with "None" or "Flat Rate" or "Per Hour" or "Leave as is"
  end if
  put it into which
  
  if which is "leave as is" then
    put  item 2 of origTask into zRate
  else
    if which is "None" then
      put 0 into zRate
    else
      if which is "Per Hour" then
        if offset("/hr",item 2 of origTask)>0 then
          put item 2 of origTask into gRate
          delete char offset("/hr",item 2 of origTask) to length(gRate) of gRate
        end if
        ask "Enter the rate per hour for this Activity." with gRate
        if it is empty then
          put 0 into zRate
        else
          put checkNumber (it) into gRate -- in stack script
          put gRate & "/hr" into zRate
        end if
      else
        if which is "Flat rate" then
          if offset("/hr",item 2 of origTask)>0 then
            put item 2 of origTask into zRate
            delete char offset("/hr",item 2 of origTask) to length(zRate) of zRate
          else
            put item 2 of origTask into zRate
          end if
          ask "Enter the flat rate." with zRate --"00.00"
        end if
        if it is empty or it is 0 then
          put 0 into zRate
        else
          put checkNumber (it) into zRate
        end if
      end if
    end if
  end if
  
  if zRate is 0 then
    put task into line gTask of field "tasks"
  else
    put task & comma & zRate into line gTask of field "tasks"
  end if
  set the hilitedLines of field "tasks" to gTask
  
  put line gTask of field "tasks" into newTask
  repeat with i = 1 to the number of cards of stack "records"
    if field "task" of card i of stack "records" is origTask then
      put newTask into field "task" of card i of stack "records"
    end if
  end repeat
  
  sort field "tasks"
  
  repeat with i = 1 to the number of lines of  field "tasks"
    if line i of field "tasks" is newTask then
      set the hilitedLines of field "tasks" to i
      put i into gTask
      exit mouseUp
    end if
  end repeat
end mouseUp
   dd CornflowerBlue      s             	        	expenses  
on openCard
  global gExpense
  if field "expenses" = empty then exit openCard
  if gExpense is empty then
    set the hilitedlines of field "expenses" to 1
    put 1 into gExpense
  end if
  set the hilitedlines of field "expenses" to gExpense
end openCard

on arrowKey which
  global gExpense
  put the number of lines of field "expenses" into numLines
  if which is up then
    if gExpense is 1 then
      put numLines into gExpense
    else
      subtract 1 from gExpense
    end if
  end if
  if which is down then
    if gExpense is numLines then
      put 1 into gExpense
    else
      add 1 to gExpense
    end if
  end if
  set the hilitedlines of field "expenses" to gExpense
end arrowKey

on selectExpense
  global gExpense,gStack,gDollarSign
  if  line gExpense of field "expenses" is empty then
    set the hilitedlines of field "expenses" to 0
    exit to metaCard
  end if
  put line gExpense of field "expenses" of stack "expenses" into field "expense" of stack gStack
  if gStack <> "reports" then
    if item 2 of line gExpense of field "expenses" <> empty then
      put gDollarSign & item 2 of line gExpense of field "expenses" into field "expense amount" of stack gStack
    end if
    go stack gStack
    addExpenses
  else
    set the hilite of button "Show expenses" of group "options" of stack "reports" to true
    set the visible of button "expense" of group "sort" of stack "reports" to true
    go stack "reports"
  end if
  -- put empty into gExpense
  hide stack "expenses"
end selectExpense

on returnKey
  checkFocus
end returnKey

on enterKey
  checkFocus
end enterKey

on closeStack
  save this stack
end closeStack

on checkFocus
  global gExpense
  
  if word 3 of the focusedObject is the id of button "Create Expense" then
    send mouseUp to button "Create Expense"
  else
    if gExpense is empty then
      send mouseUp to the focusedObject
    else
      send mouseUp to button "Choose Expense"
    end if
  end if
end checkFocus
    
LightSkyBlue    " ^,         	Expenses      U Arial   U Arial   U 
Helvetica   U 
Helvetica   W Arial   W 
Helvetica       	@          ^,                  
   expensesbg  	h          6                    `    @   7      Create Expense Ex  _on mouseUp
  global gExpense,gDollarSign
  put 25 into maxLength
  ask "Enter the type of the new expense."
  if it is empty then exit mouseUp
  if length(it)> maxLength then
    ask "Enter a name for this expense that is "&maxLength&" characters or less." with char 1 to maxLength of it
    if it is empty then exit mouseUp
    if length(it)>maxLength then exit mouseUp
  end if
  put it into newExpense
  repeat until offset(comma,newExpense)=0
    put ";" into char offset(comma,newExpense) of newExpense
  end repeat
  
  if gDollarSign = "$" then set the numberformat to 0.00
  ask "If there is a fixed amount for this expense, " & return & "enter it here."
  if it is not empty then
    put it into zdollars
    repeat with x = 1 to length(gDollarSign)
      if not(char 1 of zdollars is a number) AND (char 1 of zdollars <> ".") then
        delete char 1 of zdollars
      end if
    end repeat
    put (the number of chars of zdollars) into lastChar
    if not(char lastChar of zdollars is a number) then
      delete char lastChar of zdollars
    end if
    if not(zdollars is a number) then
      answer error "Problem converting field Expense Amount to a number."
    else
      put zdollars + 0.00 into item 2 of newExpense
    end if
  end if
  
  repeat with i = 1 to the number of lines of  field "expenses"
    if line i of field "expenses" is newExpense then
      answer information "You have already created this expense type."
      exit mouseUp
    end if
  end repeat
  
  put the number of lines of field "expenses" + 1 into temp
  put newExpense into line temp of field "expenses"
  sort field "expenses"
  
  repeat with i = 1 to the number of lines of  field "expenses"
    if line i of field "expenses" is newExpense then
      set the hilitedLines of field "expenses" to i
      put i into gExpense
      exit mouseUp
    end if
  end repeat
  
end mouseUp
           dd CornflowerBlue     j              	        Delete Expense Ex  qon mouseUp
  global gExpense, gStack
  if the hilitedlines of field "expenses" > 0 then
    put the hilitedlines of field "expenses" into gExpense
  end if
  if gExpense is empty then
    put the number of lines of field "expenses" into temp
    switch temp
    case 0
      answer information "Nothing to delete."
      exit mouseUp
    case 1
      put 1 into gExpense
      break
    default
      answer information "First select an Expense to delete."
      exit mouseUp
    end switch
  end if
  put line gExpense of field "expenses" of stack "expenses" into temp
  answer warning "After deleting this expense type, you will no longer " & return & "be able to generate reports on " &quote & temp & quote& "." with "Cancel" or "Delete"
  if it is "Cancel" then exit mouseUp
  delete line gExpense of field "expenses" of stack "expenses"
  put empty into gExpense
end mouseUp
   dd CornflowerBlue                   	        Choose Expense Mx  on mouseUp
  global gExpense
  if the hilitedlines of field "expenses" > 0 then
    put the hilitedlines of field "expenses" into gExpense
  end if
  
  if gExpense is empty then
    put the number of lines of field "expenses" into temp
    switch temp
    case 0
      answer information "First create an Expense."
      exit mouseUp
    case 1
      put 1 into gExpense
      break
    default
      answer information "First select or create an Expense."
      exit mouseUp
    end switch
  end if
  selectExpense
end mouseUp
   dd CornflowerBlue     8  %            		        No Expense Ex  on mouseUp
  global gExpense,gStack
  put empty into field "expense" of stack gStack
  if gStack is "reports" then
    set the hilite of button "Show expenses" of group "options" of stack gStack to false
    set the disabled of button "expense" of group "sort" of stack gStack to true
  else
    send mouseUp to button "+" of stack gStack
  end if
  put empty into gExpense
  hide this stack
end mouseUp
   dd CornflowerBlue                   	     
   instruction 	         
 J (           ;Create an expense or select one from the list on the left   &and then click a button on the right.    
Close Window Ex   +on mouseUp
  close this stack
end mouseUp
   dd CornflowerBlue                   	        Modify Expense Ex  	on mouseUp
  global gExpense,gDollarSign
  if the hilitedlines of field "expenses" > 0 then
    put the hilitedlines of field "expenses" into gExpense
  end if
  
  if gExpense is empty then
    put the number of lines of field "expenses" into temp
    switch temp
    case 0
      answer information "Nothing to modify."
      exit mouseUp
    case 1
      put 1 into gExpense
      break
    default
      answer information "First select an Expense."
      exit mouseUp
    end switch
  end if
  put line gExpense of field "expenses" of stack "expenses" into origExpense
  
  put 25 into maxLength
  ask "Enter the new name for this expense." with item 1 of origExpense
  if it is empty then exit mouseUp
  if length(it)> maxLength then
    ask "Enter a name for this expense that is " & maxLength & " characters or less." with char 1 to  maxLength of it
    if it is empty then exit mouseUp
    if length(it)> maxLength then exit mouseUp
  end if
  put it into checkItems
  repeat until offset(comma,checkItems)=0
    put ";" into char offset(comma,checkItems) of checkItems
  end repeat
  --  put checkItems into expense
  
  if gDollarSign = "$" then set the numberformat to 0.00
  ask "If there is a fixed amount for this expense, " & return & "enter it here." with item 2 of origExpense
  if it is not empty then
    put it into zdollars
    repeat with x = 1 to length(gDollarSign)
      if not(char 1 of zdollars is a number) AND (char 1 of zdollars <> ".") then
        delete char 1 of zdollars
      end if
    end repeat
    put (the number of chars of zdollars) into lastChar
    if not(char lastChar of zdollars is a number) then
      delete char lastChar of zdollars
    end if
    if not(zdollars is a number) then
      answer error "Problem converting field Expense Amount to a number."
      exit  mouseUp
    end if
    put zdollars + 0.00 into item 2 of checkItems
  end if
  
  put checkItems into line gExpense of field "expenses"
  put checkItems into newExpense
  repeat with i = 1 to the number of cards of stack "records"
    if field "expense" of card i of stack "records" is origExpense then
      put newExpense into field "expense" of card i of stack "records"
      send mouseUp to button "+" of stack "records"
    end if
  end repeat
  
  sort field "expenses"
  
  repeat with i = 1 to the number of lines of  field "expenses"
    if line i of field "expenses" is checkItems then
      set the hilitedLines of field "expenses" to i
      put i into gExpense
      exit mouseUp
    end if
  end repeat
end mouseUp
   dd CornflowerBlue                   	     
   	expenses  	x   on mouseUp
  global gExpense
  put word 2 of the clickLine into gExpense
end mouseUp

on mouseDoubleDown
  global gExpense,gStack
  selectExpense
  put empty into gExpense
  hide stack "expenses"
end mouseDoubleDown
         6             	Itemized  Long distance call  Meal  Mileage,.33       `    @   7     e Reports  #qfunction checkItems cardNum
  if field "project" of card cardNum of stack "records" is empty \
      OR field "task" of card cardNum of stack "records" is empty \
      OR field "elapsed" of card cardNum of stack "records" is empty then
    return true
  else
    return false
  end if
end checkItems

on collectData cardnum,invoice
  global gBillHours,gNbillHours, gExpenses,gDollars,gStack,gNotes,gDollarSign
  
  put field "start date" of card cardNum of stack "records"  into zDate
  delete item 3 of zDate
  put field "project" of card cardNum of stack "records" into zProject
  
  put field "task" of card cardNum of stack "records" into zTask
  if invoice and (item 2 of zTask is empty) then
    if offset(ztask,field "task")>0 then -- include this task
      if  the hilite of button "Show Rates" is false then
        put item 1 of field "task" of card cardNum of stack "records" into zTask
      end if
    else
      put "(non-billable activity)" into zTask
    end if
  else
    if the hilite of button "Show Rates" then
      put field "task" of card cardNum of stack "records" into zTask
    else
      put item 1 of field "task" of card cardNum of stack "records" into zTask
    end if
  end if
  
  set the numberFormat to 0.00
  put field "elapsed" of card cardNum of stack "records" into eTime
  put word 1 of eTime  into taskTime -- hours
  if the hilite of button 16 then -- "round times" then
    add roundoff(word 3 of eTime/60) to taskTime -- partial hours
  else
    add (word 3 of eTime/60) to taskTime -- partial hours
  end if
  
  if the number of items of field "task" of card cardNum of stack "records" > 1 then
    put item 2 of field "task" of card cardNum of stack "records" into rate
    add taskTime to gBillHours
    if offset("/hr",rate) = 0 then -- flat rate
      add rate to gDollars
    else
      delete char offset("/hr",rate) to length(rate) of rate
      add (taskTime * rate) to gDollars
    end if
  else
    add taskTime to gNbillHours
  end if
  
  put field "expense amount" of card cardNum of stack "records" into expAmount
  repeat with x = 1 to length(expAmount)
    if char x of expAmount is "-" then
      put true into dontAdd
      delete char x of expAmount
      exit repeat
    else
      put false into dontAdd
    end if
  end repeat
  repeat with x = 1 to length(expAmount)
    if not(char 1 of expAmount is a number) AND (char 1 of expAmount <> ".") then -- delete $ signs
      delete char 1 of expAmount
    else
      exit repeat
    end if
  end repeat
  if the hilite of button "Show Expenses" AND expAmount <> empty AND expAmount <> 0 then
    if dontAdd then
      put "Expense Total = " && gDollarSign & "-" & expAmount into  zExpenseTotal
      subtract expAmount from gExpenses
    else
      put "Expense Total = " && gDollarSign & expAmount into  zExpenseTotal
      add expAmount to gExpenses
    end if
    put "Expense Type = " && field "expense" of card cardNum of stack "records" into  zExpense
  end if
  
  if field "project" <> empty then
    put zDate & tab & zTask & tab & taskTime & return into temp
  else
    put zDate & tab & zProject & tab & zTask & tab & taskTime & return into temp
  end if
  
  if (field "task notes" of card cardNum of stack "records"  <> empty) and (the hilite of button "Show Activity Notes") then
    put "Activity Notes = " & field "task notes" of card cardNum of stack "records" into gNotes
    if length(gNotes) > 100 then
      createLines
    end if
    put gNotes & return after temp
  end if
  
  if the hilite of button "Show Expenses" AND expAmount <> empty AND expAmount <> 0 then
    put zExpense & return after temp
    if field "expense notes" of card cardNum of stack "records"  <> empty then
      put  "Expense Notes = " & field "expense notes" of card cardNum of stack "records" into gNotes
      if length(gNotes) > 100 then
        createLines
      end if
      put gNotes & return after temp
      -- else
      --  put  return after temp
    end if
    put zExpenseTotal & return after temp
  end if
  
  put return after temp
  put temp after field "report" of stack "output"
end collectData


on collectExpenseData cardnum,invoice
  global gBillHours,gNbillHours, gExpenses,gDollars,gStack,gNotes,gDollarSign
  
  put field "start date" of card cardNum of stack "records"  into zDate
  delete item 3 of zDate
  put field "project" of card cardNum of stack "records" into zProject
  put field "expense amount" of card cardNum of stack "records" into expAmount
  repeat with x = 1 to length(expAmount)
    if char x of expAmount is "-" then
      put true into dontAdd
      delete char x of expAmount
      exit repeat
    else
      put false into dontAdd
    end if
  end repeat
  
  repeat with x = 1 to length(expAmount)
    if not(char 1 of expAmount is a number) AND (char 1 of expAmount <> ".") then -- delete $ signs
      delete char 1 of expAmount
    else
      exit repeat
    end if
  end repeat
  if expAmount = 0 then exit collectExpenseData
  
  --  if the hilite of button "Show Expenses" AND expAmount <> empty AND expAmount <> 0 then
  if dontAdd then
    put gDollarSign & "-" & expAmount into  zExpenseTotal
    subtract expAmount from gExpenses
  else
    put gDollarSign & expAmount into  zExpenseTotal
    add expAmount to gExpenses
  end if
  put  field "expense" of card cardNum of stack "records" into  zExpense
  
  if field "project" <> empty then
    put zDate & tab & zExpense & tab & zExpenseTotal & return into temp
  else
    put zDate & tab & zProject & tab & zExpense & tab & zExpenseTotal & return into temp
  end if
  
  
  if field "expense notes" of card cardNum of stack "records"  <> empty then
    put  "Expense Notes = " & field "expense notes" of card cardNum of stack "records" into gNotes
    if length(gNotes) > 100 then
      createLines
    end if
    put gNotes & return after temp
  end if
  
  put return after temp
  put temp after field "report" of stack "output"
end collectExpenseData

on setTabs which
  global gTabs
  if gTabs is empty then
    if which is "wide" then
      put "150,320,500" into gTabs
      set the tabStops of field "report" of card 1 of stack "output" to 150,320,500,520
      set the tabStops of field "report" of card 2 of stack "output" to 150,320,500,520
    else
      put "200,425,450" into gTabs
      set the tabStops of field "report" of card 1 of stack "output" to 200,425,450
      set the tabStops of field "report" of card 2 of stack "output" to 200,425,450
    end if
  end if
end setTabs

on createLines
  global gNotes
  repeat while the number of chars of gNotes > 0
    put 100 into tooLong
    put char 1 to tooLong of gNotes into temp2
    if offset(return,temp2) = 0 then
      repeat while the number of chars of temp2 > 0
        if char tooLong of temp2 <> space then
          delete char tooLong of temp2
          subtract 1 from tooLong
        else
          exit repeat
        end if
      end repeat
    else
      put offset(return,temp2) - 1 into tooLong
    end if
    if length(gNotes) < 100 then
      put gNotes after temp
      exit repeat
    end if
    if tooLong < 1 then
      delete char 1 of gNotes
    else
      put char 1 to tooLong of temp2 & return after temp
      delete char 1 to tooLong of gNotes
    end if
  end repeat
  put temp into gNotes
end createLines

on checkTime
  put field "start"  into startTime
  put field "end"  into endTime
  if startTime is empty or endTime is empty then exit checkTime
  convert startTime to dateItems
  convert endTime to dateItems
  
  if item 4 of startTime > item 4 of endTime then
    add 24 to item 4 of endTime -- add 24 hours
    subtract 1 from item 3 of endTime
  end if
  if item 3 of startTime > item 3 of endTime then
    put daysofmonth(item 2 of startTime,item 1of startTime) into zdays
    add zdays to item 3 of endTime -- add about 30 days
    subtract 1 from item 2 of endTime
  end if
  if item 2 of startTime > item 2 of endTime then
    add 12 to item 2 of endTime -- add 12 months
    subtract 1 from item 1 of endTime
  end if
  
  repeat with i = 1 to 5
    if (item i of startTime > item i of endTime) then
      abort
      exit to metaCard
    end if
  end repeat
end checkTime

on abort
  global gStartDate, gEndDate, gDateField, gDateStack

  if gDateField is "start" then
    put gStartDate into field "start"
  else
    put gEndDate into field "end"
  end if
  answer error "The end date is before the start date. " & return & "Please enter a new date."
end abort

function spaces howmany
  repeat with i = 1 to howmany
    put space after temp
  end repeat
  return temp
end spaces

function roundoff numb
  set the numberFormat to 0.000
  put offset(".",numb) into decPos
  put char 1 to decPos of numb into zwhole
  put char decPos  to length(numb) of numb into zparts
  put field "roundoff" into z
  put z/2 into x
  put 0 into y
  put 0 into n
  repeat while y < 1.000
    add x to y
    if zparts < y then
      return (zwhole + (y-x))
    end if
    add x to y
    add 1 to n
  end repeat
  return (zwhole + 1)
end roundoff
  w        Black  
LightSkyBlue ffffff      white       	darkgray    	 -         Invoices & Reports    
  U Arial   U Arial   U 
Helvetica   U 
Helvetica   W Arial   W 
Helvetica   W Arial   W 
Helvetica  
 U 
Helvetica  
 U Arial       	@            D  E                                      &    V  W  d  e  I  J  \  ]  ^  _   Create Report Ex  -ion mouseUp
  global gBillHours,gNbillHours, gExpenses,gDollars,gStack,gRegistered,gDollarSign
  if gRegistered is false then
    answer warning "Your trial period has expired. Please register your software."
    close this stack
    go stack "Register"
    exit mouseUp
  end if
  put 0 into gBillHours
  put 0 into gNbillHours
  put 0 into gExpenses
  put 0 into gDollars
  lock screen
  
  put field "start" of stack "reports" into startDate
  if startDate is not a date or startDate is empty then
    ask "Enter a valid Start Date." with the short date
    if it is empty then exit mouseUp
    put it into field "start" of stack "reports"
    put it into startDate
    if startDate is not a date then exit mouseUp
  end if
  
  put field "end" into endDate
  if endDate is not a date or endDate is empty then
    ask "Enter a valid End Date." with the short date
    if it is empty then exit mouseUp
    put it into field "end" of stack "reports"
    put it into endDate
    if endDate is not a date then exit mouseUp
  end if
  
  convert startDate to seconds
  convert endDate to seconds
  if endDate < startDate then
    ask "Enter an End Date that is later than the Start Date." with the short date
    if it is empty then exit mouseUp
    put it into field "end" of stack "reports"
    put it into endDate
    if endDate is not a date then exit mouseUp
  end if
  
  if field "project" is empty and not the hilite of button "all projects" then
    answer information "Report on one specific or all projects?" with "Specific" or "All Projects"
    if it is "All Projects" then
      set the hilite of button "all projects" to true
      put "All" into whichProject
    else
      send mouseUp to button "Select Project"
      exit mouseUp
    end if
  else
    if the hilite of button "all projects" then
      put "All" into whichProject
    else
      put field "project" into whichProject
    end if
  end if
  
  if field "task" is empty and not the hilite of button "all Activity" then
    answer information "Report on one specific or all activities?" with "Specific" or "All Activities"
    if it is "All Activities" then
      set the hilite of button "all Activity" to true
      put "All" into whichActivity
    else
      send mouseUp to button "Select Activities"
      exit mouseUp
    end if
  else
    if the hilite of button "all activity" then
      put "All" into whichActivity
    else
      put field "task" into whichActivity
    end if
  end if
  
  if the hilite of button "Show expenses" AND field "expense" is empty AND not the hilite of button "all expenses" then
    answer information "Report on one specific or all expenses?" with "Specific" or "All Expenses"
    if it is "All Expenses" then
      set the hilite of button "all expenses" to true
      set the visible of button "expense" of group "sort" to true
      put "All" into whichExpense
    else
      send mouseUp to button "Select Expense"
      exit mouseUp
    end if
  else
    if the hilite of button "all expenses" then
      put "All" into whichExpense
    else
      put field "expense" into whichExpense
    end if
  end if
  
  convert endDate to long date
  convert startDate to long date
  
  --## HEADER ##--
  if the hilite of button "Header" then
    put field "Header" & return & return into field "report" of stack "output"
  else
    put empty into field "report" of stack "output"
  end if
  
  if field "project" is empty then
    if the hilite of button "expense" then
      put "Expense Report for All Projects" &return after field "report" of stack "output"
    else
      put "All Project Report" &return after field "report" of stack "output"
    end if
  else
    if the hilite of button "expense" then
      put "Expense Report for Project" && whichProject &return after field "report" of stack "output"
    else
      put "Project Report for" && whichProject  & return after field "report" of stack "output"
    end if
  end if
  
  if field "task" is empty then
    put "All Activities" after field "report" of stack "output"
  else
    put "Activity = " into secondPart
    repeat with i = 1 to the number of lines of field "task"
      put item 1 of line i of field "task" & "," after secondPart
    end repeat
    delete last char of secondPart
    put secondPart  after field "report" of stack "output"
  end if
  
  if field "expense" <> empty then
    put ", Expense = " & item 1 of  whichExpense after field "report" of stack "output"
  else
    put empty into thirdPart
  end if
  
  if the hilite of button "expense" then
    put  return & return after field "report" of stack "output"
  else
    put " - Sorted by" && the hilitedButtonName of group "sort" &  return & return after field "report" of stack "output"
  end if
  
  if field "project" is empty then
    if the hilite of button "expense" then
      put  "Start Date" & tab & "Project" & tab  & "Expense"  & tab & "Amount" & return & return after field "report" of stack "output"
      setTabs "wide"
    else
      put  "Start Date" & tab & "Project" & tab  & "Activity"  & tab & "Hours"  & return & return after field "report" of stack "output"
      setTabs "wide"
    end if
  else -- project report
    if the hilite of button "expense" then
      put  "Start Date" & tab  & "Expense"  & tab & "Amount" & return & return after field "report" of stack "output"
      setTabs "short"
    else
      put  "Start Date" & tab  & "Activity"  & tab & "Hours" & return & return after field "report" of stack "output"
      setTabs "short"
    end if
  end if
  
  put 1 into sortLine
  put the hilitedButtonName of group "sort" into sortBy
  if sortBy is "Date" then put "start date" into sortBy
  if sortBy is "Activity" then put "task" into sortBy
  if sortBy is "" then
    answer error "Please specify a sort order first."
    exit to metaCard
  end if
  
  put true into nodata
  convert startDate to seconds
  convert endDate to seconds
  repeat with i = 1 to the number of cards of stack "records"
    set cursor to busy
    if checkItems(i) then next repeat
    if word 2 of field "elapsed" of card i of stack "records" <> "hrs" then next repeat
    put field "start date" of card i of stack "records" into theDate
    convert theDate to seconds
    
    if (theDate < startDate) or (theDate > endDate) then next repeat
    
    put field "project" of card i of stack "records" into theProject
    if (theProject <> whichProject) AND (whichProject <> "all") then next repeat
    
    if whichActivity is "all" then
      put field "task" of card i of stack "records" into theTask
      put false into skipcard
    else
      put true into skipcard
      put field "task" of card i of stack "records" into theTask
      repeat with j = 1 to the number of lines of whichActivity
        if theTask = line j of whichActivity then
          put false into skipcard
        end if
      end repeat
    end if
    if skipCard then next repeat
    
    if the hilite of button "Show expenses" then
      put field "expense" of card i of stack "records" into theExpense
      if (theExpense <> whichExpense) AND (whichExpense <> "all") then next repeat
      if field "expense amount" of card i of stack "records"  is empty AND the hilite of button "Expense" then next repeat --put "zzzzz" into theExpense
    end if
    
    put theDate & tab & theProject & tab & theTask & tab & theExpense & tab & i into line sortLine of zSorter
    add 1 to sortLine
    put false into nodata
  end repeat
  
  if nodata then
    answer information "There were no records found for this period."
  else
    set the itemDelimiter to tab
    sort lines of zSorter by item 1 of each
    if sortBy is "project" then
      sort lines of zSorter by item 2 of each
    end if
    if sortBy is "task" then
      sort lines of zSorter by item 3 of each
    end if
    if sortBy is "expense" then
      sort lines of zSorter by item 4 of each
    end if
    set the numberFormat to 0.00
    put false into invoice
    put item 5 of line 1 of zSorter into cardNum
    put field "start date" of card cardNum of stack "records" into zDate
    put 0 into zDollars
    put 0 into zHours
    
    repeat with n = 1 to the number of lines of zSorter
      set the itemDelimiter to tab
      put item 5 of line n of zSorter into cardNum
      if the hilite of button "Show Daily Totals" and the hilite of button "Date" then
        put field "start date" of card cardNum of stack "records" into theDate
        if theDate <> zDate then
          put "Totals for " & zDate & ":" & spaces(25) & gDollarSign & zdollars  & tab & zHours && "Hours" & return  & return after field "report" of stack "output"
          put theDate into zDate
          put 0 into zDollars
          put 0 into zHours
        end if
      end if
      
      if  the hilite of button "expense" then
        collectExpenseData cardNum, invoice
      else
        collectData cardNum, invoice
      end if
      
      if the hilite of button "Show Daily Totals"  and the hilite of button "Date" then
        set the itemDelimiter to comma
        put item 2 of field "task" of card cardNum of stack "records" into rate
        put field "elapsed" of card cardNum of stack "records" into eTime
        put word 1 of eTime  into taskTime -- hours
        if the hilite of button 16 then --"round times" then
          add roundoff(word 3 of eTime/60) to taskTime -- partial hours
        else
          add (word 3 of eTime/60) to taskTime -- partial hours
        end if
        add taskTime to zHours
        if offset("/hr",rate) = 0 then -- flat rate
          add rate to zdollars
        else
          delete char offset("/hr",rate) to length(rate) of rate
          add (taskTime * rate) to zdollars
        end if
      end if
    end repeat
    
    if the hilite of button "Show Daily Totals"  and the hilite of button "Date" then
      put "Totals for " & theDate & ":" & spaces(25) & gDollarSign & zdollars  & tab & zHours && "Hours" & return  & return after field "report" of stack "output"
    end if
    set the numberFormat to 0.00
    put gDollarSign  & gDollars into zdollars
    put gDollarSign  & gExpenses && "Expenses" into zExpenses
    if the hilite of button "Show Expenses" then
      if  the hilite of button "expense" then
        if field "project" is empty then
          put "Total Expenses:" & tab  & tab & tab & gDollarSign  & gExpenses  &  return  & return after field "report" of stack "output"
        else
          put "Total Expenses:" & tab  & tab & gDollarSign  & gExpenses  &  return  & return after field "report" of stack "output"
        end if
      else
        put "Totals for this report:" & tab & zdollars  & tab & gBillHours && "Billable Hours"  & return & return  & \
            tab & zExpenses  & tab & gNbillHours && "Non-Billable Hours" &  return  & return after field "report" of stack "output"
        put gDollarSign  & (gDollars + gExpenses) into zTotal
        put "Total including Expenses:" & tab & zTotal & return & return after field "report" of stack "output"
      end if
    else
      put "Totals for this report:" & tab & zdollars  & tab & gBillHours && "Billable Hours"  & return & return  & \
          tab & tab & gNbillHours && "Non-Billable Hours" &  return  & return after field "report" of stack "output"
    end if
    
    if the hilite of button "footer" then
      put field "footer" & return & return after field "report" of stack "output"
    end if
    
    set the title of stack "output" to "Report"
    go stack "output"
    set the vScroll of field "report" of stack "output" to 0
  end if
end mouseUp
   dd CornflowerBlue                  	        Create Invoice Ex   {on mouseUp
  global gBillHours,gNbillHours, gExpenses,gDollars,gStack,gRegistered,gDollarSign
  if gRegistered is false then
    answer warning "Your trial period has expired. Please register your software."
    close this stack
    go stack "Register"
    exit mouseUp
  end if
  put 0 into gBillHours
  put 0 into gNbillHours
  put 0 into gExpenses
  put 0 into gDollars
  
  put field "project" of stack "reports" into whichProject
  if whichProject  is empty then
    answer warning "You must select a specific project first."
    send mouseUp to button "Select Project"
    exit mouseUp
  end if
  
  put field "start" of stack "reports" into startDate
  if startDate is not a date or startDate is empty then
    set the title of stack "dates" to "Select a Start Date"
    send mouseUp to field "start date"
  end if
  
  put field "end" of stack "reports" into endDate
  if endDate is not a date or endDate is empty then
    set the title of stack "dates" to "Select an End Date"
    send mouseUp to field "end date"
  end if
  
  convert endDate to seconds
  convert startDate to seconds
  if endDate < startDate then
    answer "Enter an End Date that is later than the Start Date."
    exit mouseUp
  end if
  
  convert endDate to long date
  convert startDate to long date
  lock screen
  lock messages
  
  if field "task" is empty and (the hilite of button "all Activity" is false) then
    answer information "Report on one specific or all activities?" with "Specific" or "All Activities"
    if it is "All Activities" then
      set the hilite of button "all Activity" to true
      put "All" into whichActivity
    else
      send mouseUp to button "Select Activities"
      exit mouseUp
    end if
  else
    if the hilite of button "all activity" then
      put "All" into whichActivity
    else
      put field "task" into whichActivity
    end if
  end if
  
  if the hilite of button "Show expenses" AND field "expense" is empty AND (the hilite of button "all expenses" is false) then
    answer information "Report on one specific or all expenses?" with "Specific" or "All Expenses"
    if it is "All Expenses" then
      set the hilite of button "all expenses" to true
      set the visible of button "expense" of group "sort" to true
      put "All" into whichExpense
    else
      send mouseUp to button "Select Expense"
      exit mouseUp
    end if
  else
    if the hilite of button "all expenses" then
      put "All" into whichExpense
    else
      put field "expense" into whichExpense
    end if
  end if
  
  --## HEADER ##--
  if the hilite of button "header" then
    put field "header" & return & return into field "report" of stack "output"
  else
    put empty into field "report" of stack "output"
  end if
  setTabs "short"
  put "Invoice for" && whichProject &return& startDate && " to" && endDate&  return & return after field "report" of stack "output"
  put  "Start Date" & tab  & "Activity"  & tab & "Hours" & return & return after field "report" of stack "output"
  
  put 1 into sortLine
  put true into nodata
  convert startDate to seconds
  convert endDate to seconds
  repeat with i = 1 to the number of cards of stack "records"
    set cursor to busy
    if checkItems(i) then next repeat
    if word 2 of field "elapsed" of card i of stack "records" <> "hrs" then next repeat
    put field "start date" of card i of stack "records" into theDate
    convert theDate to seconds
    
    if (theDate < startDate) or (theDate > endDate)  then next repeat
    
    put field "project" of card i of stack "records" into theProject
    if (theProject <> whichProject) then next repeat
    
    if whichActivity is "all" then
      if item 2 of field "task" of card i of stack "records"  <> empty then
        put field "task" of card i of stack "records" into theTask
        put false into skipcard
      else
        if the hilite of button "Show expenses" then
          put false into skipCard
        else
          put true into skipcard
        end if
      end if
    else
      put true into skipcard
      put field "task" of card i of stack "records" into theTask
      repeat with j = 1 to the number of lines of whichActivity
        if theTask = line j of whichActivity then
          put false into skipcard
        end if
      end repeat
    end if
    
    if skipCard then next repeat
    
    if the hilite of button "Show expenses" then
      put field "expense" of card i of stack "records" into theExpense
      if ((theExpense <> whichExpense) AND (whichExpense <> "all")) OR (theExpense <> empty AND \
          field "expense amount" of card i of stack "records" is empty) then
        next repeat
      end if
    end if
    
    put false into nodata
    put theDate & tab & i into line sortLine of zSorter
    add 1 to sortLine
  end repeat
  
  if nodata then
    answer information "There were no records found for this time period."
  else
    set the itemDelimiter to tab
    sort lines of zSorter by item 1 of each
    set the numberFormat to 0.00
    put true into invoice
    put item 2 of line 1 of zSorter into cardNum
    put field "start date" of card cardNum of stack "records" into zDate
    put 0 into zDollars
    put 0 into zHours
    repeat with n = 1 to the number of lines of zSorter
      set the itemDelimiter to tab
      put item 2 of line n of zSorter into cardNum
      if the hilite of button "Show Daily Totals" then
        put field "start date" of card cardNum of stack "records" into theDate
        if theDate <> zDate then
          put "Totals for " & zDate & ":" & spaces(25) & gDollarSign & zdollars  & tab & zHours && "Hours" & return  & return after field "report" of stack "output"
          put theDate into zDate
          put 0 into zDollars
          put 0 into zHours
        end if
        collectData cardNum, invoice
        set the itemDelimiter to comma
        put item 2 of field "task" of card cardNum of stack "records" into rate
        put field "elapsed" of card cardNum of stack "records" into eTime
        put word 1 of eTime  into taskTime -- hours
        if the hilite of button 16 then --"round times" then
          add roundoff(word 3 of eTime/60) to taskTime -- partial hours
        else
          add (word 3 of eTime/60) to taskTime -- partial hours
        end if
        add taskTime to zHours
        if offset("/hr",rate) = 0 then -- flat rate
          add rate to zdollars
        else
          delete char offset("/hr",rate) to length(rate) of rate
          add (taskTime * rate) to zdollars
        end if
      else
        collectData cardNum, invoice
      end if
    end repeat
    
    if the hilite of button "Show Daily Totals" then
      put "Totals for " & theDate & ":" &  spaces(25) & gDollarSign & zdollars  & tab & zHours && "Hours" & return  & return after field "report" of stack "output"
    end if
    set the numberFormat to 0.00
    put gDollarSign & gDollars  into zdollars
    put gDollarSign & gExpenses into zExpenses
    
    if the hilite of button "Show Expenses" then
      put "Totals for this invoice:" & tab & zdollars  & tab & gBillHours && "Billable Hours"  & return & return  & \
          "Total Expenses:" & tab & zExpenses  & tab & gNbillHours && "Non-Billable Hours"  &  return  & return after field "report" of stack "output"
      put gDollarSign  & (gDollars + gExpenses) into zTotal
      put "Total Invoice Amount" & tab & zTotal & return & return after field "report" of stack "output"
    else
      if whichActivity <> "all" AND gNbillHours <> 0 then
        put "Totals for this invoice:" & tab & zdollars  & tab & gBillHours && "Billable Hours"  & return & return  & \
            tab  & tab & gNbillHours && "Non-Billable Hours"  &  return  & return after field "report" of stack "output"
      else
        put "Totals for this invoice:" & tab & zdollars  & tab & gBillHours && "Hours" & return  & return after field "report" of stack "output"
      end if
    end if
    
    if the hilite of button "footer" then
      put field "footer" & return & return after field "report" of stack "output"
    end if
    
    unlock screen with visual effect plain
    set the title of stack "output" to "Invoice"
    go stack "output"
    set the vScroll of field "report" of stack "output" to 0
  end if
end mouseUp
           dd CornflowerBlue    
              	     
   Start  	x  on mouseUp
  global gDateField,gDateStack
  global gStartDate
  put field "start" into gStartDate
  
  if field "start" is empty then
    ask "Enter a Start Date" with the date
  else
    ask "Enter a Start Date" with field "start"
  end if
  if it is empty then exit mouseUp
  if offset(",",it)=0 AND offset("/",it)=0 then
    answer warning "All dates must be in the format dd/mm/yy. Try again."
    exit mouseUp
  else
    put it into field "start"
  end if
  
  if it is not a date then
    ask "You entered an invalid Start Date. Try again." with the date
    if it is empty then exit mouseUp
    if it is not a date then
      ask "You entered an invalid Start Date. Try again." with the date
      if it is empty then
        exit mouseUp
      end if
    else
      put it into field "start"
    end if
  else
    put it into field "start"
  end if
  if field "end" is not empty then
    put "start" into gDateField
    checkTime
  end if
end mouseUp
        
  b                      
   End  	x  pon mouseUp
  global gDateField,gDateStack,gEndDate

  put field "end" into gEndDate
  
  if field "end" is empty then
    ask "Enter an End Date" with the date
  else
    ask "Enter an End Date" with field "end"
  end if
  if it is empty then exit mouseUp
  if offset(",",it)=0 AND offset("/",it)=0 then
    answer warning "All dates must be in the format dd/mm/yy. Try again."
    exit mouseUp
  else
    put it into field "end"
  end if
  
  if it is not a date then
    ask "You entered an invalid End Date. Try again." with the date
    if it is empty then exit mouseUp
    if it is not a date then
      ask "You entered an invalid End Date. Try again." with the date
      if it is empty then
        exit mouseUp
      end if
    else
      put it into field "end"
    end if
  else
    put it into field "end"
  end if
  put "end" into gDateField
  checkTime
end mouseUp
        
  b                
    startDate label 	          x d            Start Date 
   endDate label 	           d            	End Date    options   i              Options  D    dd CornflowerBlue      t              	   	        Show Rates @E    dd CornflowerBlue      j              	        Show Activity Notes @E    dd CornflowerBlue                   	       Show Daily Totals @E    dd CornflowerBlue                   	      U Show Expenses @E  on mouseUp
  if the hilite of me then
    set the disabled of button "expense" of group "sort" to false
    set the hilite of button "all expenses" to true
  else
    set the disabled of button "expense" of group "sort" to true
    if the hilite of button "expense" then
      set the hilite of button "expense" of group "sort" to false
      set the hilite of button "date" of group "sort" to true
    end if
    set the hilite of button "all expenses" to false
    put empty into field "expense"
  end if
end mouseUp
   dd CornflowerBlue    *               	       X #Round off times to              hr @E    dd CornflowerBlue    h               	     
  Y 	roundoff  	x   Mon mouseUp
  ask "Please enter a number less than 1.01" with field "roundoff"
  if it is empty then exit mouseUp
  if it < 1.01 then
    if it  < .01 then
      put .01 into field "roundoff"
    else
      put it into field "roundoff"
    end if
  else
    answer error "Try again with a number less than 1.01"
  end if
end mouseUp
        f !          .25        ' Header @E    dd CornflowerBlue    ? T              	       ( Footer @E    dd CornflowerBlue    T T              	       0 	Add/Edit Ex  
 on mouseUp
  lock screen
  show group "header"
  put space after field "header"
  select last char of field "header"
  unlock screen with visual "barn door open"
end mouseUp
   dd CornflowerBlue    Z? I              	       1 	Add/Edit Ex  
 on mouseUp
  lock screen
  show group "footer"
  put space after field "footer"
  select last char of field "footer"
  unlock screen with visual "barn door open"
end mouseUp
   dd CornflowerBlue    ZS I              	        Select Project ex   :on mouseUp
  send mouseUp to field "project"
end mouseUp
           dd CornflowerBlue    t       Select Project         	        Select Activities Ex   on mouseUp
  global gStack
  put the short name of this stack into gStack
  set the hilite of button "all activity" to false
  go stack "activities"
  show stack "activities"
end mouseUp
   dd CornflowerBlue                  	        Select Expense Ex   :on mouseUp
  send mouseUp to field "expense"
end mouseUp
           dd CornflowerBlue                 		     
   project  	x  oon mouseUp
  global gStack
  put the short name of this stack into gStack
  set the hilite of button "all projects" to false
  set the disabled of button "project" of group "sort" to true
  set the hilite of button "project" of group "sort" to false
  set the hilite of button "date" of group "sort" to true
  go stack "projects"
  show stack "projects"
end mouseUp
                     
   task  	x   on mouseUp
  global gStack
  put the short name of this stack into gStack
  set the hilite of button "all activity" to false
  go stack "activities"
  show stack "activities"
end mouseUp
           9            )    `    @ s   7 
   expense  	x  oon mouseUp
  global gStack
  put the short name of this stack into gStack
  set the hilite of button "all expenses" to false
  set the disabled of button "expense" of group "sort" to true
  set the hilite of button "expense" of group "sort" to false
  set the hilite of button "date" of group "sort" to true
  go stack "expenses"
  show stack "expenses"
end mouseUp
                       
All Expenses @e   on mouseUp
  put empty into field "expense"
  if the hilite of me then
    set the hilite of button "Show expenses" of group "options" to true
    set the disabled of button "expense" of group "sort" to false
  end if
end mouseUp
   dd CornflowerBlue    ! 4      All          	        
All Activity @e   6on mouseUp
  put empty into field "task"
end mouseUp
   dd CornflowerBlue      4      All          	       
All projects @e   on mouseUp
  put empty into field "project"
  if the hilite of me then
    set the disabled of button "project" of group "sort" to false
  end if
end mouseUp
   dd CornflowerBlue      4      All          	     
   
instruction2 	            h           To create a report, select a start date, an end date, select a Project, Activity and Expense (optional), choose any Options and a Sort Order, then click on Create Report.     sort   i        4  D  ! Date @D    dd CornflowerBlue    K @              	  	       " Project @D    dd CornflowerBlue    ^ L              	   	       # 	Activity @D    dd CornflowerBlue   "K j              	   	       $ Sort Order  D    dd CornflowerBlue    8 t              	     % Expense @D    dd CornflowerBlue   "^ j              	   	     
  & 
instruction1 	            p         }To create an invoice, select a start date, an end date, select a Project, choose any Options, then click on Create Invoice.   9You may also create a header or footer for your invoice.         D Edit Ex  
 8on mouseUp
  send mouseUp to field "Start"
end mouseUp
   dd CornflowerBlue    | | (              	       E Edit Ex  
 6on mouseUp
  send mouseUp to field "end"
end mouseUp
   dd CornflowerBlue    |  (              	       I header   a         4L
  5 cover 	`       
 8zD          
  * Header  )`        h                        +    `    @ j    
  3 
instruction3 	          Tt N         Enter information that you want to appear at the top of your invoice here (i.e., Company Name, Address, Invoice Number, etc.). If you want to save a header for future use, click the Save as... button. Click Import to include a previously saved header.   F Save as... Ex  on mouseUp
  ask file "Save this header as..." with "header.txt"
  if the result is "Cancel" then exit mouseUp
  put checkExt(it) into fileName
  open file fileName for write
  if the result is empty then
    write field "header" to file fileName
    close file fileName
  else
    answer "There was a problem saving this file." & return & the result & return & sysError()
  end if
end mouseUp
   dd CornflowerBlue     X i              	       G 
Import... Ex  on mouseUp
  answer file "Select a header file to import." with "header.txt"
  if the result is "Cancel" then exit to metacard
  put it into fileName
  open file fileName for read
  if the result is empty then
    lock screen
    read from file fileName until eof
    put it into field "header"
    close file fileName
  else
    answer "There was a problem opening this file." & return & the result & return & sysError()
  end if
end mouseUp
   dd CornflowerBlue    X i              	       H Close Ex  on mouseUp
  lock screen
  if field "header" = space then
    put empty into field "header"
  end if
  if field "header" <> empty then
    set the hilite of button "header" to true
  end if
  hide group "header"
  unlock screen with visual "barn door close"
end mouseUp
   dd CornflowerBlue   X \             	     
  S title           ` >             Edit Header   J footer   a         4L
  K cover 	`       
 8zD          
  L footer  )`        h             M    `    @ j      O Save as... Ex  on mouseUp
  ask file "Save this footer as..." with "footer.txt"
  if the result is "Cancel" then exit mouseUp
  put checkExt(it) into fileName
  open file fileName for write
  if the result is empty then
    write field "footer" to file fileName
    close file fileName
  else
    answer "There was a problem saving this file." & return & the result & return & sysError()
  end if
end mouseUp
   dd CornflowerBlue     X i              	       P 
Import... Ex  on mouseUp
  answer file "Select a footer file to import." with "footer.txt"
  if the result is "Cancel" then exit to metacard
  put it into fileName
  open file fileName for read
  if the result is empty then
    lock screen
    read from file fileName until eof
    put it into field "footer"
    close file fileName
  else
    answer "There was a problem opening this file." & return & the result & return & sysError()
  end if
end mouseUp
   dd CornflowerBlue    X i              	       Q Close Ex  on mouseUp
  lock screen
  if field "footer" = space then
    put empty into field "footer"
  end if
  if field "footer" <> empty then
    set the hilite of button "footer" to true
  end if
  hide group "footer"
  unlock screen with visual "barn door close"
end mouseUp
   dd CornflowerBlue   X \             	     
  4 
instruction4 	          Tt N         Enter information that you want to appear at the bottom of your invoice here  (i.e., Payment Terms,  Name and Address, etc.). If you want to save a footer for future use, click the Save as... button. Click Import to include a previously saved footer. 
  R title           ` >             Edit Footer   V Today Ex  
 on mouseUp
  global gStartDate,gDateField
  put field "start" into gStartDate
  if field "end" is empty then
    put the date into field "end"
  end if
  put the date into field "Start"
  put "start" into gDateField
  checkTime
end mouseUp
   dd CornflowerBlue    R | (              	       W Today Ex  
 on mouseUp
  global gEndDate,gDateField
  put field "end" into gEndDate
  put "End" into gDateField
  put the date into field "end"
  checkTime
end mouseUp
   dd CornflowerBlue    R  (              	       \ Help Ux  
on mouseUp
  visual effect plain
  get the loc of stack "records"
  if the loc of stack "help" = it then
    add 395 to item 1 of it
    set the loc of stack "help" to it
  end if
  go card "About Invoices & Reports" of stack "Help"
  show stack "help"
end mouseUp
   dd CornflowerBlue    
 H             	       ] A&E Tracker Ex   @on mouseUp
  close this stack
  topLevel "records"
end mouseUp
   dd CornflowerBlue    \              	       ^ Quit Ux   on mouseUp
  put the substacks of stack "main" into temp
  repeat with i = 1 to the number of lines of temp
    close stack line i of temp
  end repeat

  save this stack
  quit
end mouseUp
   dd CornflowerBlue     H             	       _ Save Ux   *on mouseUp
  save this stack
end mouseUp
   dd CornflowerBlue   < H              	       d Choose Ex  
-on mouseUp
  global gDateField,gDateStack,gStartDate,gEndDate
  put field "start" into gStartDate
  put field "end" into gEndDate
  put "start" into gDateField
  put the short name of this stack into gDateStack
  set the title of stack "dates" to "Select a Start Date"
  go stack "dates"
end mouseUp
   dd CornflowerBlue    p  4              	       e Choose Ex  
*on mouseUp
  global gDateField,gDateStack,gEndDate,gStartDate
  put field "start" into gStartDate
  put field "end" into gEndDate
  put "End" into gDateField
  put the short name of this stack into gDateStack
  set the title of stack "dates" to "Select an End Date"
  go stack "dates"
end mouseUp
   dd CornflowerBlue    p  4              	        Help  	on closeStack
  set the locktext of field "main" to true
  set the traversalOn of  field "main"  to false
end closeStack

on exportHTML
  global gHelpText
  
  set cursor to busy
  
  repeat while offset("&amp;",gHelpText) > 0
    put offset("&amp;",gHelpText) into firstchar
    put "&" into char firstchar to (firstChar + 4) of gHelpText
  end repeat
  
  -- add name tags
  put "<FONT color="& quote & "#FF0000" & quote & "><B>" into astring
  put "<FONT color="& quote & "#FF0000" & quote & ">" into bstring
  put length(astring) into al
  put length("</B></FONT>") into cl
  repeat while offset(astring,gHelpText) > 0
    put offset(astring,gHelpText) into a
    put char a to (a+256) of gHelpText into temp
    put offset("</B></FONT>",temp) into c
    -- put char (a+al) to (c-1) of temp into zname
    put char (al + 1) to (c-1) of temp into zname
    put length(zname) into zl
    put bstring & "<A NAME=" & quote & zname & quote & "></A><B>" & zname & "</B></FONT>" into char a to (a + al + cl + zl) of gHelpText
  end repeat
  
  -- delete <group> and add <a href> tags
  repeat with x = 1 to 2
    if x = 1 then
      put "<FONT color="& quote&"#0000FF"&quote&"><GROUP><U><B>" into astring
      put "</B></U></GROUP></FONT>" into zstring
    else
      put "<FONT color="& quote&"#0000FF"&quote&"><U><GROUP><B>" into astring
      put "</B></GROUP></U></FONT>" into zstring
    end if
    put "<FONT color="& quote&"#0000FF"&quote&"><U><B><A HREF=" into bstring
    put "</A></B></U></FONT>" into cstring
    put length(astring) into al
    put length(cstring) into cl
    put length(zstring) into zl
    
    repeat while offset(astring,gHelpText) > 0
      put offset(astring,gHelpText) into a
      put char a to (a+256) of gHelpText into temp
      put offset(zstring,temp) into c
      put char (al + 1) to (c-1) of temp into zname
      put length(zname) into bl
      if last char of zname is "." then
        delete last char of zname
        put bstring & quote & "#" & zname & quote & ">" & zname & "." & cstring into char a to (a + al + bl + zl ) of gHelpText
      else
        if char (c + zl ) of temp is "." then
          put bstring & quote & "#" & zname & quote & ">" & zname & "." & cstring into char a to (a + al + bl + zl ) of gHelpText
        else
          put bstring & quote & "#" & zname & quote & ">" & zname & cstring & space into char a to (a + al + bl + zl) of gHelpText
        end if
      end if
    end repeat
  end repeat
end exportHTML
  w        Black  
LightSkyBlue ffffff      white       	darkgray    Fw             Help      U Arial  
 U 
Helvetica   U 
Helvetica   U 
Helvetica   W 
Helvetica  @W 
Helvetica  PW 
Helvetica  U 
Helvetica  @U 
Helvetica  W 
Helvetica   U 
Helvetica   W 
Helvetica   W 
Helvetica   W 
helvetica  @U 
helvetica  @W 
helvetica  PW 
helvetica    About Help   	@          w       	Tutorial   	@          w       A&E Tracker   	@          w       About Invoices & Reports   	@          w       Preferences   	@          w       Keyboard Shortcuts   	@          w      & About Activities & Rates   	@          w    ' About Activity Notes   	@          w    ( About Expense Notes   	@          w    ) About Expenses   	@          w    * About Projects   	@          w    + Adding a New Activity   	@          w    , Adding a New Activity Rate   	@          w    - Adding a New Expense Type   	@          w    . Adding a New Project   	@          w    / Adding a New Record   	@          w    0 Adding Expenses   	@          w    1 Adjusting the Date   	@          w    2 Adjusting the Time   	@          w    3 Background Color   	@          w     Button Colors   	@          w    5 Changing Activities   	@          w    6 Changing Expense Types   	@          w    7 Changing Projects   	@          w    8 Changing Rates   	@          w    9 Choose Activity   	@          w    : Choose Date   	@          w    ; Choose Expense   	@          w    < Choose Project   	@          w    = Clear Expenses   	@          w    > Collapse Window   	@          w    ? Create Activity   	@          w    @ Create Expense   	@          w    A Create Invoice   	@          w    B Create Project   	@          w    C Create Report   	@          w    D Default Settings   	@          w    E Delete Activity   	@          w    F Delete Expense   	@          w    G Delete Project   	@          w    H Deleting Records   	@          w    I 
Edit Date   	@          w    K Edit Expense $   	@          w    L 
Edit Time   	@          w     Edit Total Time   	@          w     Expense Reports   	@          w    M Exporting Records   	@          w     
First Record   	@          w     Font...   	@          w    O Footer   	@          w    P Footer Add/Edit   	@          w    Q 	Go Timer   	@          w    R 
Go to Record   	@          w    S Header   	@          w    T Header Add/Edit   	@          w    U Help   	@          w    V Highlight Color   	@          w    W Importing Records   	@          w     Last Record   	@          w    Z Look and Feel   	@          w    [ Modify Activity   	@          w    \ Modify Expense   	@          w    ] Modify Project   	@          w    ^ Modify Rate   	@          w    _ Monetary Symbol   	@          w     Next Record   	@          w    a No Expense   	@          w    b 	Now Time   	@          w    c Pause Timer   	@          w     Prev Record   	@          w     	Printing   	@          w    f Quick Check   	@          w    g Quit   	@          w    h 	Record #   	@          w    i 
Registration   	@          w    j Report Options   	@          w     Restart Timer   	@          w    l Restore Window   	@          w    m Round Off Times   	@          w     Save As...   	@          w    n Save Record   	@          w    o Searching Records   	@          w    p Select Activities   	@          w    q Show Activity Notes   	@          w    r Show Daily Totals   	@          w    s Show Expenses   	@          w    t Show Rates   	@          w    u Sort Order   	@          w    v Sorting Records   	@          w    w Start Timer   	@          w    x Stop Timer   	@          w     Tabs   	@          w    y Time Format   	@          w    z 
Today's Date   	@          w    { Visual Effects   	@          w     Help Index   	@          w    !             Invoices & Reports   	P Bon openCard
  go to card "About Invoices & Reports"
end openCard
           w     help   i          t
   main  	x  on mouseUp
  if the optionKey is down then
    set the locktext of me to false
    set the traversalOn of me to true
    exit mouseUp
  end if
  if the textstyle of the clickChunk contains "group" then
    put the clickText into temp
    if last char of temp is "." then delete last char of temp
    if there is a card temp then
      push card
      go card temp
    end if
  end if
end mouseUp
         Xl(         About Help 
  @        
  
  @          ,Welcome to Activity & Expense Tracker Help. 
 @        Black    +   New in this version of Activity & Expense Tracker, is an extensive Help Index. Listed in the index are all the features, fields and buttons of A&E Tracker. (Buttons are things you click on and fields contain text.) 
       C
 @        Black  C 

     M    kPrintable versions of this help system are available at: http://about-the-web.com/aetracker/download.shtml   You can also click the Save as... button at the bottom of this Help window, to export the help topic you are currently viewing. Or you can export all of the help topics. You can save the text as either a .txt file or an .html file. You can view the .html file, complete with all formatting, by opening it in your browser. You can open the .txt  file, for reading or printing, in your favorite word processor. 
       
      

     ! 
 @      Blue   Y
    A W   The Search Help button at the bottom of this Help window will search for occurrences of a particular word or phrase in any of the help topics. 
       
      
        
         [Click blue underlined text to go directly to that Help topic (except for this example ;-). 
       
  @       
      @  
         Bolded words (like this) in this Help system indicate buttons or fields. (Again, buttons are things you click on and fields are where text is entered or displayed.) Blue text (like this) highlights important information. 
       
      	
      
  @       7   [You can easily return to the previous topic by clicking the Back to Previous Topic button. 
       <
     < 
     R   
        Each "record" in Activity & Expense Tracker consists of the name of the project, the type of activity, the start and stop dates, and start and stop times, the total time, plus any expenses and notes. You can use the activity timer to automatically add time information to the record, or add all the information manually. You can add new records or edit the information for any record at any time.    \Use the buttons at the top of this Help window to learn more about the following subjects:  
       #
     # 
     ' 4   SThe A&E Tracker window is where you add Project, Activity and Expense information. 
       
  @       
      C   The Invoices & Reports window is where you can generate Invoices or Reports on Projects, Activities and Expenses. You can print these out or save them to a text file for importing into a word processor or other programs. 
       
  @       
         The Preferences window is where you can change background and button colors, time formats, and the general "look and feel" of the program. You can also change the monetary symbol if you want it to be different than $. 
       
  @       
         jAlmost every button in this program has a keyboard shortcut. For more information see Keyboard Shortcuts. 
       V
  @      V 
     h    IThere's an extensive tutorial available by clicking the Tutorial button. 
       8
  @      8 
     @    rThe newest version of this software will always be available at http://about-the-web.com/aetracker/download.shtml 
 @      Blue    q   wYour comments, suggestions and bug reports are always welcome. Please send your email to: aetracker@about-the-web.com. 
       Z
 @      Red  Z 
     u    #Thank you for using this software,    Garth Catterall-Heart  !SpiritWorks Software Development  PO Box 216  Redwood Valley, CA 95470      	Tutorial 
  @          
  @          \Here's a quick tutorial for those just getting started with the Activity & Expense Tracker. 
 @        Black    [  \Each "record" in Activity & Expense Tracker consists of the name of the project, the type of activity, the start and stop dates, and start and stop times, the total time, plus any expenses and notes. You can use the activity timer to automatically add time information (also referred to as data) to the record, or add all the information manually.    To create a timed record: 
  @          Start by clicking Add/Select Project in the A&E Tracker window. Click on Create Project. Enter the name of your project. This could be a client's name or something general like "Needle Work". If you will have several projects for the same client, you will want to add a number to the name. You will be dividing your project into various activities, so don't confuse these two terms. It might be helpful to make a list of activities first. After entering a new project name, click Choose Project to transfer it to the A&E Tracker window. 
       
      
     $ 
  @      + 
     > 
    I 
    X 
     pp
    
    
  @      
       Next, click Add/Select Activity. Click on Create Activity. Here you will enter the type of activity you will be doing for the project. Some examples might be Writing, Phone Calls, Answering Mail, and whatever your main task or activity is. If you will be exporting Activity & Expense Tracker records, to be combined with those of other users, see Exporting records for more information. 
       
      
      
     * 
     9"
  @     [ 
    l   
        After entering the name of the activity type, you will be asked for a rate for that activity. The choices are None (you will not be billing for this activity), Per Hour (you will be billing a per hour rate for this activity) or Flat Rate (you will be billing a set amount of money for this activity). Choose one and then enter the amount if applicable. You may create several activities with the same names, but different rates. Commas are converted to semicolons. After entering a new activity type, click Choose Activity to transfer it to the A&E Tracker window. You may add notes about the activity at any time into the Activity Notes field. 
       n
     n 
     r -
      	
      ;
      

     
    
   
 
 @     ! 
  @     - 
   3 3
    f 	
    o 
    }    Click on the Start Timer button. The Start Timer button changes to two buttons, Stop and Pause. Also, the End Date field is hidden and a Current Time field is displayed. 
       

     
 
      8
     P 
     T 
     Y 
     ^ +
      
         
       While the timer is running, you may add notes and record any expenses. You can't change dates or times while the timer is running though. The timer will continue to run, even after quitting the program or shutting down the computer, until you click the Stop button. You can also work in other applications while the timer is running, although the Current Time and Total Time fields will not be updated until you switch back to A&E Tracker. 
       
 @      Blue   s
 @      Blue   
 @      Blue  
    	 R
    [ 
    g 
    l 

    v A  
        QWhen you click the Pause button, it changes to a Go button. Click Go to restart the timer. After pausing the timer, "n/a" is entered into the Stop Time field to remind you that the total time is actually an accumulation of several periods of time. When you are finished with an activity, click on the Stop button to complete the record. 
       
      
      
     1 
     3 
     B 
     D J
     
      
     $
      r
    - 
    1   
         Adding Expenses: 
  @          
  @         @To add an expense, click on the Add/Select Expense button. Click Create Expense. Enter the name for the type of expense such as Mileage, Toll Charge, Postage, etc. After entering the name of the type of expense, you will be asked if there is a set amount associated with this type of expense. If there is not, enter 0.  
        
       
     2 
     A 
     O   
         You may create several expense types with the same names, but different amounts. Commas are converted to semicolons. After entering a new expense type, click Choose Expense to transfer it to the A&E Tracker window. 
       
      
      
  @       
        An expense type may or may not have a fixed amount. For instance, a FedEx package may generally be the same amount, so you would want to enter that amount when prompted to do so after clicking Create Expense. On the other hand, an expense type such as Lunch would not have a fixed amount, so you would enter the amount into the expense notes field. For more information see About Expense Notes. 
       
      
      
  @     v    0To add a record and enter information manually: 
  @        /   If you want to add a record for an activity that happened at some other time, click the Add button. Enter the Start Date, Start Time, Total Time, Project and Activity/Rate fields, and any expenses and/or notes. 
       X
     X 
     [ 
     n 

     x 
     z 

      
      

      
      
      
      

      '   The End Time, and End Date fields are optional. Use the Today buttons to enter the current date and the Now buttons to enter the current time. For more information see Adjusting the Time and Adjusting the Date. 
       
      
      
      
      
     8 
     = +
     h 
     k =
  @       
      
  @       
         The Start Date, Start Time, Total Time, Project and Activity/Rate fields are required. No reports will be generated for records missing this information. 
       
      

      
      

      
      

     & 
     ( 
     / 
     4 

     A X  
         Other features: 
  @          
  @          You can collapse the record window so that only the top portion (which shows the date, time, project and activity) is visible, by clicking the Collapse button (which has an up arrow with a bar). The Collapse button then changes to a Restore button.  
       
      
      0
      
      
      
      	  
         jTo restore the window to its original size, click the Restore button (which has a down arrow with a bar). 
       6
     6 
     = ,  Click the Quick Check button to find out how many hours you have worked on an activity (or all activities) for a particular project and the total billable amount. No expenses are included in this amount. The project, activity and end date are all automatically filled in for you. You can change the start date, end date, project or activity in the resulting window. Click the First button to enter the start date of the first record with the selected Project/Activity combination. Click the Last button to enter the start date of the last record with the selected Project/Activity combination. Click the All button to get totals on all activities. Click Recalculate to get new totals after making changes. 
       

     
 
      
  @       (
      
    x 
    } n
     
     m
    \ 
    _ /
     
     (  qYou can use the arrow buttons to go to the first, previous, next or last record. (These buttons are hidden when you first open A&E Tracker because there are no other records available to go to.) The First Record and Prev Record buttons are hidden on the first record. The Last Record and Next Record buttons are hidden on the last record. You can also use the arrow keys to move from one record to the next or previous record. The number of the current record appears in the Record # field. You can also go directly to any record by clicking on the record # field. A dialog will ask you what record number you want to go to. 
       Q
     Q v
      
      
      
      4
     
     
      
    $ /
 @      Blue S X
     0
     
        Search for text in any record by clicking the Search button. You can search for the first part of a word (partial words) or one or more whole words. If capitalization matters, click the "case sensitive" button. 
       .
     . 
     4   
         ]Sort all the records by clicking the Sort button. You can sort by Date, Project or Activity. 
       %
     % 
     ) 
     B 
     F 
     H 
     O 
     S 	   Delete one or all of the records by clicking the Delete button. You will be asked which records you want to delete. For more information see Deleting Records. 
       1
     1 
     7 V
  @         You may want to export the records by clicking Export. You can then import the data into a spreadsheet or word processing program. You can export the data for archiving purposes too. You can Import the saved data back into Activity & Expense Tracker at any time. You will want to export your data when updating to a newer version of Activity & Expense Tracker. For more information see Exporting Records and Importing Records. 
       /
     / 
     5 
      
      
  @      
     
  @      
       
         To access the Preferences window, click the Prefs button. You can change the highlight, button and background colors, time format, etc. For more information see Preferences. 
       ,
     , 
     1 p
  @          To register Activity & Expense Tracker, click the Register button. Read the instructions for getting a registration number. Once you receive your number, fill in your full name and the registration number. 
       2
     2 
     :    You can save or print out reports on any Project, Activity or Expense type by clicking the Invoices & Reports button. See Invoices & Reports for more information. 
       Z
     Z 
     m 

  @      z 
         The Save button saves your data. All records are saved automatically when going to another record or when you Quit the program. 
       
      
      f
     n 
     r 
  
         5To access the help system, click on the Help button. 
       (
     ( 
     ,    \For more information, check the Help Index or any of the buttons at the top of this window. 
        
 @        Black    

     * 1  
         You can use the Save As... button below, to save any or all of the text in the help system, as either a .txt or .html file, for reading or printing. Saving the text in .html format allows you to view the formatted help text in your web browser. 
       
      
      z
 @      Blue   _  
               Keyboard Shortcuts 
  @          
  @          /Almost every button has a keyboard equivalent. 
 @        Black    .  
  @          Shortcuts are indicated by the letter of the button that is underlined. Just press the letter on your keyboard to activate the button.    cIf a keyboard shortcut does not work, try pressing the tab key and then the shortcut letter again. 
  @        b   If you are typing notes, many of the following shortcuts will not work unless you also hold down the Alt key (or Command key on the Macintosh).   CYou can also use the Tab key to move between most of the buttons and editable fields of each window. (Buttons are things you click on, fields are places where text is entered or displayed.) Buttons will appear with a dotted rectangle when they are active. Then you can press the return or enter key to activate the button.    In any field that you can type in, you can also use the standard Cut (Ctrl - x), Copy (Ctrl - c) and Paste (Ctrl - v) keyboard shortcuts.    A&E Tracker window shortcuts: 
 @        Black    
      
 Add/Select Project - t  Add/Select Activity - v  Add/Select Expense - x  Quick Check - c  Start Timer -s  Stop Timer -s  Pause Timer - p  Go (restart timer) - g  Next record - Right arrow  Previous record - Left arrow  Add - a  Delete - d  Search - h  	Sort - o  Import - m  Export - e  
Prefs - f  
Register - r  	Help - h  Invoices & Reports -i  	Quit - q    Quick Check window shortcuts: 
        Select Project - t  Select Activity - v  Recalculate - r  Close Window - c    %Invoices & Reports window shortcuts: 
       $ Select Project - t  Select Activity - v  Select Expense - x  Create Invoice - i  Create Report - r  	Help - h  A&E Tracker - a  	Quit - q  	Save - s    Add/Projects window shortcuts: 
        Choose Project - t  Create Project - r  Modify Project - m  Delete Project - d  Close Window - c  'Move up in list of projects - Up arrow  +Move down in list of projects - Down arrow    Add/Activity window shortcuts: 
        Choose Activity - v  Create Activity - r  Modify Activity - m  Modify Rate - o  Delete Activity - d  Close Window - c  )Move up in list of Activities - Up arrow  -Move down in list of Activities - Down arrow    ,Activities window shortcuts: (from Reports) 
       + Choose Activities - v  Close Window - c  e(The arrow keys do not work in this window because it is possible to select more than one activity.)    Add/Expense window shortcuts: 
        Choose Expense - x  Create Expense - r  Modify Expense - m  No Expense - n  Delete Expense - d  Close Window - c  'Move up in list of Expenses - Up arrow  +Move down in list of Expenses - Down arrow    Help window shortcuts: 
        About Help - a  A&E Tracker - e  Keyboard Shortcuts- k  
Tutorial - t  Invoice & Reports - i  Preferences - p  Help Index - h  Back to Previous Topic - b  Search Help - s  Close Window - c          A&E Tracker 
  @          
  @          aThe A&E Tracker window is where you will add all your project, activity and expense information. 
 @        Black    `  Each "record" in Activity & Expense Tracker consists of the name of the project, the type of activity, the start and stop dates, and start and stop times, the total time, plus any expenses and notes. You can use the activity timer to automatically add time information to the record, or add all the information manually. You can add new records or edit the information for any record at any time.    Dates and Times 
  @          
  @          The Start Date, Total Time, Project and Activity/Rate fields are required. No reports will be generated for records missing this information. 
       
      

      
      

      
      
     # 
     ( 

     5 X  The Start Date field is automatically filled in. If it is incorrect, you can click on the field, or the Edit button, to enter another date. To enter the current date, click on the Today button. You can also use the date chooser by clicking Choose. See Choose Date for more information. You can go directly to the first record with a particular date by clicking the Start Date label. 
       
      

      Z
     h 
     l H
      
      7
      
      
  @       
     
     O
    m 

    w   The End Date field is optional. You can click on the field, or the Edit button, to enter another date if the end date is different than the start date. To enter the current date, click on the Today button. You can also use the date chooser by clicking Choose. 
       
      
      7
     C 
     G y
      
      7
      
       
        XThe Start Time field is automatically filled in. If it is incorrect for some reason, you can click on the field, or the Edit button, to enter another time. To enter the current time, click on the Now button. You may also adjust the start time by using the small up and down arrows. You can not adjust times or dates while the timer is running. 
       
      

      j
     x 
     | H
      
      S
  @      <
    V   [When you stop the timer, the End Time field is automatically filled in. If it is incorrect for some reason, or you are filling out the record manually, you can click on the field, or the Edit button, to enter another time. To enter the current time, click on the Now button. You may also adjust the end time by using the small up and down arrows. 
       
      
     % 
      
      H
     
    
 P  
        When you stop the timer, the Total Time field is automatically filled in. If it is incorrect for some reason, or you are filling out the record manually, you can click on the field, or the Edit button, to enter another total time. You will be asked if you want to clear the end date and end time. This is because it would be hard to know which of these fields to change when the total time field is changed. To maintain all the fields, change the end date, the start time or the end time. The Total Time field will be updated automatically. 
       
      

     ' 
      
     ,
     

     %  
         Projects and Activities 
  @          
  @          Click the Add/Select Project button to add, modify, delete or select a previously entered project name. Be sure to click the Choose Project button after adding or selecting a project. For more information see About Projects. 
       

     
 
      a
     } 
      F
  @         Click the Add/Select Activity button to add, delete or select an activity, or change a previously entered activity and its (hourly or flat) rate. Click Create Activity to add an activity name and its rate. You may create several activities with the same names, but different rates. Click Modify Activity to change the name of an existing activity. Click Modify Rate to change the rate of an existing activity. Commas are automatically converted to semicolons. Be sure to click the Choose Activity button after adding or selecting an activity. You may also want to add notes about the activity. For more information see About Activities & Rates. 
       

     
 
      {
      
      y
      
    / 3
    b 
    m ,
  @      2
     
     
     {
  @     k   
  @          Timer Operation 
  @          Click the Start Timer button to start the timer. Several things will happen when you do this. The Start Timer button will be replaced with a Stop and a Pause button. The End Date field will be replaced by a current time field. "Total Time" will be replaced with "Timer Running". None of the date or time fields are editable when the timer is running. If the record already contains a total time, you will be asked if you want to restart the timer or create a new record.  
       

     
 
      x
      
      
      
      

      
      e
  @      F
    ] z  
        )The timer will continue running, even if you quit the program or shut down your computer, until you click the Stop button. You can also work in other applications while the timer is running, although the Current Time and Total Time fields will not be updated until you switch back to A&E Tracker. 
  @        {
     { Q
      
      
      

      A  *When the Pause button is clicked, "Timer Running" becomes "Timer Paused" and the Pause button changes to Go. Clicking Go restarts the timer. After pausing the timer, "n/a" is entered into the Stop Time field to remind you that the total time is actually an accumulation of several periods of time. 
       	
     	 
      h
     v 
     x H
      	
      `   oClicking the Stop button, stops the timer, enters the End Date and End Time, and hides the current time field. 
       

     
 
      ]  
         Other Features 
  @           Click the Collapse button to reduce the size of the window for easier placement on your screen. Use the Restore button to expand the window to its normal size. 
       

     
 
      V
     h 
     o 0  Click the Quick Check button to find out how many hours you have worked on an activity (or all activities) for a particular project and the total billable amount. No expenses are included in this amount. The project, activity and end date are all automatically filled in for you. You can change the start date, end date, project or activity in the resulting window. Click the First button to enter the start date of the first record with the selected Project/Activity combination. Click the Last button to enter the start date of the last record with the selected Project/Activity combination. Click the All button to get totals on all activities. Click Recalculate to get new totals after making changes. 
       

     
 
      
  @       )
      
    x 
    } n
     
     m
    \ 
    _ /
     
     (  
         Adding Expenses 
  @          
  @         3Click the Add/Select Expense button to add, delete, modify or select a previously entered expense type. Each expense type can have a specific amount of money that will be added to the Expense $ field. You may create several expense types with the same names, but different amounts. Commas are converted to semicolons. Be sure to click the Choose Expense button after adding or selecting an expense type. You can clear a previously entered expense type by clicking the No Expense button. A record can have expense notes and amounts without having an expense type. 
       

     
 
     7
    S 
    a s
     

     	
  @      K  ]An expense type may or may not have a fixed amount. For instance, a FedEx package may generally be the same amount, so you would want to enter that amount when prompted to do so after clicking Create Expense. On the other hand, an expense type such as Lunch would not have a fixed amount, so you would enter the amount into the expense notes field. 
       
      
        You may also want to add notes about the expense and the amount of other expenses. To add multiple expenses, just list them in the Expense Notes field with their amounts, then click on the + button. The total will appear in the Expense $ field. You may edit the Expense $ field directly, by clicking the field or the Edit button. To subtract a number in the Expense Notes field, put a minus sign ("-") before the number. Here are some correct examples: 
       
      

      -
      
      &
      	
      P
    = 
    A  $123.50 books -33.50 discount  )stamps 34.20 envelopes 5.79 rebate -1.00    pNumbers need to have a space before and after them. Avoid using dollar signs. Here are some incorrect examples: 
  @        2
     2 *
     \ 	
     e 
 
$123.50books  -$33.50 discount  stamps USD34.20    If you want to use a number in the Expense Notes field that does not get added to the Expense $ field, precede the number with the # character (i.e., item #12345). 
       #
     # 

     0 &
     V 	
     _ D  	You may also multiply expenses. To do this the expense type must include an amount to be multiplied. For example, the Mileage expense type has a default multiplier of .33 ($0.33 per mile). To compute the expense amount for 123 miles, enter *123 into the expense notes field and click the + button. The * (shift 8) symbol indicates that the following number is to be multiplied by the expense type's amount and added to any other numbers in the expense notes field. There must not be a space between the * and the number. 
       
      
    !    \To clear the Expense, Expense Notes, and Expense $ fields, click the Clear expenses button. 
       E
     E 
     S   You can use the arrow buttons to go to the first, previous, next or last record. The number of the current record appears in the Record # field. The First Record and Prev Record buttons are hidden on the first record. The Last Record and Next Record buttons are hidden on the last record. You can also use the arrow keys to move from one record to the next or previous record. You can also go directly to any record by clicking on the record number field. A dialog will ask you what record number to go to. 
  @        P
     P 1
      
      
      
      
      
      4
      
      
      
       
         0Adding, Deleting, Searching and Sorting Records 
  @        /  Click on the Add button to create a new record. You will be asked if you want to duplicate some or all of the information on the current record. The choices are: "Just Project & Activity", "With Notes" and "Clear All". With Notes copies all the information from the current record (except dates and times) to a new record. Clear All copies none of the information from the current record. The current date and time will be automatically filled in. Edit the new record with new project, activity and expense information, as you wish. 
       

     
 
      
      

      ]
    B 

    L   <You may delete one or all of the records by clicking the Delete button. You will be asked if you want to delete just the record you are on, all records, or just those older than a certain date. If you choose the last option you will be asked for a date. You may want to export the records, before deleting them all. 
       9
     9 
     ?    Search for text in any record by clicking Search. You can search for the first few characters of a word or complete words. You may also limit your search to words with the exact capitalization as the word you enter, by clicking "case sensitive". 
       *
     * 
     0   
        You can sort records by clicking the Sort button. You will be asked if you want to sort by Date, Activity, or Project. If you choose Activity or Project, all records will be sorted by date first and then by either Activity or Project. All records are renumbered after sorting. 
       %
     % 
     ) 2
     [ 
     _ 
     a 
     i 
     n 
     u   
         Import and Exporting Records 
  @           You can import or export the records to a tab delimited text file by clicking the Import or Export button. There are several reasons you might want to do this: 
       R
     R 
     X 
     \ 
     b =  
        1) If you work in a small office or workgroup, each person can keep track of their own time and expenses, then export their records and send the file to an administrator. They will then be able to import the data and generate reports and invoices for the whole group.    2) Rather than archiving the whole program, you might want to export all the records and just archive the much smaller text file.    3) When updating to a newer version of the program, you should export all your records and then import them into the new version.    V4) If you wanted to export the records to a spreadsheet or a word processing program.    There are two separate files exported. The first is called records.txt with contains the data for all the records. You can change this name if you wish. Be sure to make a note of its location.  
       ;
 @      Red  ; 
     F S
 @      Blue   (  The second file which contains all your project, activity and expense types is called paetypes.txt. This step is optional and you can change the name or location of this file as well. If you have exported records that use all of your project and activity names and expense types, this step is unnecessary because all of these names will automatically be read in when you import the data. It is only if you have spent a lot of time entering activity and expense types that you have not yet used, that this step is important. 
       V
 @      Red  V 
     b   You can export only records for a specific project, or records that are newer or older than a certain date. See Exporting Records for more information. 
       p
  @      p 
        
         Other Buttons 
  @        
   The Prefs button brings up the Preferences window, where you can change Background colors and Button colors as well as the Time Format and Monetary Symbol. For more information see Preferences. 
       
      
     	 
  @       
     1 
  @       
         /The Help button brings you to the Help window. 
       
      
      
  @      " 
     -    JThe Invoices & Reports button takes you to the Invoices & Reports window. 
       
      
      
  @      / 
     H    mThe Save button saves your data. All records are saved automatically when going to another record or window. 
       
      
      d   6The Quit button saves the data and quits the program. 
       
      
      -         Invoices & Reports 
  @          
  @          You can generate several different types of reports. These include Invoices, Project Reports, Activity Reports and Expense Reports. 
 @        Black      
  @          	Invoices 
  @          
  @          Invoices can be generated for one project at a time. You can include any of the options provided (see below). You must specify a Start Date, End Date and select a project, by clicking the Select Project button, before clicking the Create Invoice button. 
       
      

      
      
      '
      
      
      
        To create an invoice that includes all activities, click the All button next to the activity field. Invoices, by default, do not include non-billable activities. To include these, click the Select Activities button and choose all the activities you want included in your invoice. 
       =
     = 
     @ #
  @      c >
      
      
      H  
        Expenses associated with non-billable activities will appear in the invoice if Show Expenses has been checked. To include all expenses, click the All button next to the expense field. To include specific expenses, click the Select Expense button. Expenses are optional and the Show Expenses button must be checked to have expenses show up in your invoice. You can create invoices with or without header or footer information such as company names, addresses, terms, etc. For more information see below. 
       O
     O 

     \ 6
      
      K
      
      	
  @       
  @      

  @     " A
    c   
         Reports 
  @          You can create a Report with any of the options provided, for any or all projects, activities or expenses, from the start to end dates, by clicking the Create Report button. You must specify a Start Date, End Date, and one or more Projects and Activities before generating your report. To get a report on all projects, click the All button next to the project field. You can also select a specific project by clicking on the Select Project button. To get a report on all activities, click the All button next to the activity field. You can also select one or more activities by clicking on the Select Activities button. To get a report on all expenses, click the All button next to the expense field. You can also select a specific expense by clicking on the Select Expense button. Expenses are optional and the Show Expenses button must be checked to have expenses show up in your report. You can create reports with or without header or footer information such as company names, addresses, terms, etc. 
       
      

      	
  @       
  @       
  @       
  @       

  @       F
     ,
    I 
    L ]
     
     6
     
     b
    R 
    c 4
     
     ]
     
     '
    , 

    9    Options 
  @          
  @         All Options apply to either a report or an invoice. Click the checkbox next to the option to enable it. The Show Rates option will display all hourly or fixed rates associated with an activity. Show Activity Notes displays all activity notes. Show Daily Totals creates daily billable amount and time totals in the report or invoice. Show Expenses displays expense types, notes and amounts. Round off times to (percent) hr, rounds off all activity times. When selected, the default is .25 hours, but you can change this number by clicking the adjoining field (i.e., enter 1 to round times to the nearest hour, .5 to the nearest half hour, etc.). 
       
      
      (
  @      3 4
     g 
     l 

     v L
      
      
      
     I
    M 

    Z +
      
       To enter Header and Footer information, click the appropriate Add/Edit button. Click the Header button and/or the Footer button to include the header or footer in your invoice or report. You may save the header or footer to a text file by clicking Save As... and then import the header or footer later by clicking the Import... button. This way you can keep a separate file for each client. Click the Close button to hide the fields that appear for editing. 
       	
     	 
      
      
      $
     > 
     F 
     Y 
     _ 
     r 
     x 
      

     <
    > 
    F K
     
     3  6Sort Order applies only to reports. You can sort the report by Date, Project, Activity or Expense. You can only sort by Expense if the Show Expenses button is clicked. You can only sort by Project if the All projects button is checked. Daily totals do not appear in reports sorted by anything other than date. 
       

     
 5
     ? 
     C 
     E 
     L 
     N 
     V 
     Z 
     a &
      

      8
      
      f  
         To create an Activity Report, Choose All Activities, click on the Activity Sort order radio button and any of the options, then click Create Report. 
       %
     % 
     ( 
     B 
     J <
      

        
         To create an Expense Report, Choose All expenses, click on the Expense Sort order radio button and any of the options, then click Create Report. Expense Reports only contain expense information. 
       $
     $ 
     ' 
     ? 
     F <
      

      
  @       1  
  @          To create a Project Report, Choose All projects, click on the Project Sort order radio button and any of the options, then click Create Report. 
       #
     # 
     & 
     > 
     E <
      

         &Invoice or Report output modification 
  @        %  
  @         fAfter generating a report or invoice, you can make changes to its content, directly in the report window. You can then Print the report or invoice, or save it to a text file by clicking the Save as... button. You can then open this text file in your word processor or import it into another program. You may also want to save reports for archiving purposes. 
       w
     w 
     | B
      

      d
  @     , 9  
  @         Before printing you may want to adjust the font, size or line height of the report or invoice text by clicking the Font... button. Choose a new font by clicking its name in the font list. Change the font size by clicking one of the pt size radio buttons. Not all fonts are available in all sizes, so you may not notice a change. Click the line height field to enter a new number. The minimum line height is equal to the text size plus one (i.e., if the text size = 14 then the minimum line height = 15). 
       s
     s 
     z
    | {  
  @         (After adjusting the font, size or line height, you may need to also adjust the lines per page that get printed, by clicking the lines per page field. Double check to make sure all lines of your report are being printed after adjusting the font, size or line height of the report or invoice text. 
  @        
        
        You can also set the tab stops of the report or invoice text by clicking the Font... button and then the Tab button. You will be given the choices of Wide, Medium, Narrow and Custom. The custom option allows you to specify exact numbers for the three tab stops in pixels. Some experimentation will probably be necessary. Make minor changes to each of the three numbers to see what the effects are. Tabs may need to be readjusted after each report or invoice has been generated. 
       
      .
     M 
     T 
     i 
     l *
      
      
      
      
      
      
      
      
 @      Blue  O   VClose the report or invoice window by clicking on Close Window when you are finished. 
       2
     2 
     >    Other Buttons 
  @        
   /The Help button brings you to the Help window. 
       
      
      
  @      " 
     -    <The A&E Tracker button takes you to the A&E Tracker window. 
       
      
      
  @      ( 
     :    mThe Save button saves your data. All records are saved automatically when going to another record or window. 
       
      
      d   6The Quit button saves the data and quits the program. 
       
      
      -     Preferences 
  @          
  @          JThere are several preferences you can set for Activity & Expense Tracker. 
 @        Black    I   TTo access the Preferences window, click the Prefs button in the A&E Tracker window. 
       @
  @      @ 
     R   FThe Look and Feel defaults to Windows 95, but if you like one of the other choices better, you can choose it here. In Windows 95 mode, the shortcut for the button is indicated by an underlined letter in the button's name. In Macintosh mode, the keyboard shortcuts are not visible. For more information see Keyboard Shortcuts. 
       
      
      e
     v 

      a
      	
      H
  @     2 
    D    jThe Time Format defaults to AM/PM, but if you would want times displayed in 24 hour format, click 24 Hrs. 
       
      
      Z  You can change the Background color from the Preferences window. Choose a color from the Background Color list. The background color will automatically change to the new color. You can use the up and down arrow keys to change the colors after selecting the first one. 
       
      
     # 

  @      - 
     ?   You can change the Button colors from the Preferences window. Choose a color from the Button Colors list. The button colors will automatically change to the new color. You can use the up and down arrow keys to change the colors after selecting the first one. 
       
      

       

  @      * 
     <    rPlay around with these two groups of selections until you find a color combination that is pleasing to your eyes.   You can also change the Highlight color from the Preferences window. Choose a color from the Highlight Color list. The highlight color will automatically change to the new color. You can use the up and down arrow keys to change the colors after selecting the first one. 
       
      
     ' 

  @      1 
     C   NYou can set the Monetary Symbol to something other than the dollar sign ($), if you use a different one, by clicking the Change button. You will be asked for a new symbol. You can use any character or up to 3 letters for the monetary symbol. The new symbol will be displayed on the A&E Tracker window and in all invoices and reports. 
       
      
      
  @      
    , !   WClick the Default Settings button to return all settings back to their default values. 
       

     
 
      <         Tabs 
 @      Red      You can also set the tab stops of the report or invoice text by clicking the Font... button and then the Tab button. You will be given the choices of Wide, Medium, Narrow and Custom. The custom option allows you to specify exact numbers for the three tab stops in pixels. Some experimentation will probably be necessary. Make minor changes to each of the three numbers to see what the effects are. Tabs may need to be readjusted after each report or invoice has been generated. 
       
      .
     M 
     T 
     i 
     l *
      
      
      
      
      
      
      
      
 @      Blue  O  
 @      Blue      See also Printing. 
 @        Black    	
 @      Blue  	 
         xx    	Printing 
  @           You can print invoices or reports by clicking on the Print button in the Report window or Invoice window, after generating a report or invoice. 
       5
     5 
     : 
  @      I 

     V 
  @      Z 
     h '   You can modify the font face, size, line height and the number of lines printed per page, by clicking the Font... button in the Report or Invoice window, after generating a report or invoice.  
       j
     j 
     q O  To change the font face of the report or invoice, just click on the name of the new font. The report or invoice will be updated automatically. To change the font size of the report or invoice, just click on the new size. (Some fonts may not be available in all sizes.) The report will be updated automatically. To change the line height, just click on the field and enter a new number. The minimum line height is equal to the text size plus one (i.e., if the text size = 14 then the minimum line height = 15). 
       
      .
       Changing the font face, size or line height may require you to change the number of lines printed on each page. Before submitting reports or invoices to others, you will want to make sure that all the lines of the report or invoice are being printed. If they are not all being printed, or there is extra space at the bottom of the page, you will want to experiment with the lines per page setting. To change the lines per page settings, just click on the field and enter a new number. 
       p
 @      Blue  p 
        You can also set the tab stops of the report or invoice text by clicking the Font... button and then the Tab button. You will be given the choices of Wide, Medium, Narrow and Custom. The custom option allows you to specify exact numbers for the three tab stops in pixels. Some experimentation will probably be necessary. Make minor changes to each of the three numbers to see what the effects are. Tabs may need to be readjusted after each report or invoice has been generated. 
       
      .
     M 
     T 
     i 
     l *
      
      
      
      
      
      
      
      
 @      Blue  O      ] Modify Project 
  @          To modify a project name, click the Add/Select Project button. Then select a project name to modify and click the Modify Project button. You will be asked for a new name. All records with the old project name will be updated with the new name. For more information see About Projects. 
       $
     $ 
     6 <
     r 
      +
  @       I
      
  @     
         1 Adjusting the Date 
  @          
The Start and End Dates can be adjusted several ways. If you want to enter today's date, click the Today button above the start or end field. If you want to edit the date field, click on the Edit button or the field itself. A dialog box will ask you for a new date. 
       c
     c 
     h W
      
      F  
Another method is to click the Choose button. A new window will open that allows you to select a new date by clicking the year, the month and then the date from a calendar interface. Clicking on a date closes the window and enters that date into the current record. 
       
      
     %    If you enter an end date that is before the start date, or a start date that is after the end date, 0 hrs 0 mins will be displayed in the Total Time field. 
       
      

           xxx   & About Activities & Rates 
  @          WYou can enter any number of activities into Activity & Expense Tracker. Each activity can have a rate associated with it. This can either be an hourly rate or a flat rate. Activities that have no rate associated with them, will not be included in invoices, since they can not accrue billable time. For more information see Invoices & Reports. 
      C
  @     C    Click the Add/Select Activity button to add, modify, delete or select an activity type and its associated rate. For more information see Adding a New Activity. 
       

     
 
      l
  @       
        You can specify different rates for similar activities if you wish. For instance, you might bill administrative time to one project, but not another, so you would have one administrative activity with no rate and another with a rate. You might also charge less per hour to non-profit groups, so you would want to have similar activities with different hourly rates. For more information see Adding a New Activity Rate. 
      
  @      
       MYou may find that creating more than a couple of dozen activities makes it hard to find the one you're looking for, so don't get carried away with too many activity types. You may want to use the Activity Notes field to distinguish between similar activities with the same hourly rate. For more information see About Activity Notes. 
      7
  @     7 
    K    Activities may be created, but then not used for some reason. Be aware that only activities that are used are exported with their records. If you have unused activity types, be sure to export the project, activity and expense types when asked. For more information see Exporting Records. 
      

  @     
 
             h 	Record # 
  @          %Each Record in Activity & Expense Tracker has a number. This number may change when you add or delete records. You can go directly to a particular record by clicking the Record # field or label. Or you can use the arrow buttons to go the First Record, Prev Record, Next Record or Last Record. 
       8
  @      8 6
     n <
      
      <
  @       
      
  @       
     
  @     	 
     
  @      
    #    The First Record and Prev Record buttons are hidden on the first record. The Last Record and Next Record buttons are hidden on the last record. You can also use the arrow keys to move from one record to the next or previous record.  
          See also Visual Effects. 
       	
 @      Blue  	    Last Record 
  @           |Go the last record (the record with the highest number) by clicking the Last button (the one with the right arrow and bar). 
       H
     H 
     L /   GThe Last Record and Next Record buttons are hidden on the last record. 
       F     Next Record 
  @           yGo the next record (the record with the next highest number) by clicking the Next button (the one with the right arrow). 
       M
     M 
     Q '   The Last Record and Next Record buttons are hidden on the last record. You can also use the arrow keys to move from one record to the next or previous record.  
            Prev Record 
  @           {Go the previous record (the record with the next lowest number) by clicking the Prev button (the one with the left arrow). 
       P
     P 
     T &   The First Record and Prev Record buttons are hidden on the first record. You can also use the arrow keys to move from one record to the next or previous record.  
            
First Record 
  @           |Go the first record (the record with the lowest number) by clicking the First button (the one with the left arrow and bar). 
       H
     H 
     M .  
         IThe First Record and Prev Record buttons are hidden on the first record. 
       H        j Report Options 
  @           {You can generate a Report or Invoice with any of the Options provided. Click the checkbox next to the option to enable it. 
       5
     5 
     < >  JThe Show Rates option will display all hourly or fixed rates associated with an activity. Show Activity Notes displays all activity notes. Show Daily Totals creates daily billable amount and time totals in the report or invoice. Show Expenses displays expense types, notes and amounts. Round off times to (percent) hr, rounds off all activity times. When selected, the default is .25 hours, but you can change this number by clicking the adjoining field (i.e., enter 1 to round times to the nearest hour, .5 to the nearest half hour, etc.). For more information see Invoices & Reports. 
       
      

      L
     Z 
     m 
      
      I
      

      ,
     
    = 
  @     6    You can also include headers and footers in your report or invoice. See Footer Add/Edit and Header Add/Edit for more information. 
       H
  @      H 
     W 
  @      \ 
     k         ^ Modify Rate 
  @          iTo add or change an activities rate, click the Add/Select Activity button. Select an activity to modify, then click the Modify Rate button. You will be asked for a new rate for the activity. The choices are Hourly, Flat or None. If you choose Flat Rate, enter the amount you want billed for that activity regardless of the amount of time spent on the activity. 
       /
     / 
     B 6
     x 
      L
      
      
      
      
      
      
      	
      l   If you want the activity to be non-billable, click None. Activities that have no rate associated with them, will not be included in invoices, since they can not accrue billable time. See Invoices & Reports for more information. 
       3
     3 
     7 
  @       
         3For more information see About Activities & Rates. 
       
  @       
     1         U Help 
  @           Clicking the Help button at the bottom of the Invoices & Invoices & Reports window takes you to the Invoices & Reports help topic.  
       

     
 
      (
  @      9 
     R 
  @      d 
     v 
  
         jClicking the Help button at the bottom of the A&E Tracker window takes you to the A&E Tracker help topic. 
       

     
 
      
  @      . 
     @ 
  @      R 
     ]   
         jClicking the Help button at the bottom of the Preferences window takes you to the Preferences help topic. 
       

     
 
      
  @      . 
     @ 
 @      Blue  R 
     ]    There are Help button in a few other places which give you a quick hint about the functionality or limitations of that feature.   ? Create Activity 
  @           You can enter any number of activities into Activity & Expense Tracker. Each activity can have a rate associated with it. This can either be an hourly rate or a flat rate.   |To add an activity, click the Add/Select Activity button. Then click the Create Activity button. You will be asked for a name for the new activity. Then you will be asked for a rate. The choices are Hourly, Flat or None. If you choose Flat Rate, enter the amount you want billed for that activity regardless of the amount of time spent on the activity. If you will be exporting Activity & Expense Tracker records, to be combined with those of other users, it is important that everyone be using the same set of activity types (and Project names), so that reports can be accurately generated. See Exporting records for more information. 
       
      
     1 
     I 
     X o
      
      
      
      
      
      
      

     `
  @     T 
    e    If you want the activity to be non-billable, click None. Activities that have no rate associated with them, will not be included in invoices, since they can not accrue billable time. See Invoices & Reports for more information. 
       3
     3 
     7 
  @       
         STo enter the new activity on the current record, click the Choose Activity button. 
       ;
     ; 
     J    3For more information see About Activities & Rates. 
       
  @       
     1         , Adding a New Activity Rate 
  @          KTo add or change an activity's rate, click the Add/Select Activity button. Then click the Modify Rate button. You will be asked for a new rate for the activity. The choices are Hourly, Flat or None. If you choose Flat Rate, enter the amount you want billed for that activity regardless of the amount of time spent on the activity. 
       .
     . 
     B 
     Z 
     e L
      
      
      
      
      
      
      

      l   If you want the activity to be non-billable, click None. Activities that have no rate associated with them, will not be included in invoices, since they can not accrue billable time. See Invoices & Reports for more information. 
       3
     3 
     7 
  @       
         3For more information see About Activities & Rates. 
       
  @       
     1         + Adding a New Activity 
  @           You can enter any number of activities into Activity & Expense Tracker. Each activity can have a rate associated with it. This can either be an hourly rate or a flat rate.   |To add an activity, click the Add/Select Activity button. Then click the Create Activity button. You will be asked for a name for the new activity. Then you will be asked for a rate. The choices are Hourly, Flat or None. If you choose Flat Rate, enter the amount you want billed for that activity regardless of the amount of time spent on the activity. If you will be exporting Activity & Expense Tracker records, to be combined with those of other users, it is important that everyone be using the same set of activity types (and Project names), so that reports can be accurately generated. See Exporting records for more information. 
       
      
     1 
     I 
     X 
      	
     `
  @     T 
    e    If you want the activity to be non-billable, click None. Activities that have no rate associated with them, will not be included in invoices, since they can not accrue billable time. See Invoices & Reports for more information. 
       3
     3 
     7 
  @       
         STo enter the new activity on the current record, click the Choose Activity button. 
       ;
     ; 
     J    3For more information see About Activities & Rates. 
       
  @       
     1         x Stop Timer 
  @        
   Stop the timer by clicking the Stop button. The Stop button will then change back to Start Timer. The End Time, End Date and Total Time fields will be automatically filled in. For more information see Start Timer. 
       
      
     # 

     0 
     4 !
     U 
     ` 
     f 
     n 
     p 
     x 
     } 

      B
  @               w Start Timer 
  @          Start the timer by clicking the Start Timer button. (If the record already contains a total time, you will be asked if you want to restart the timer or create a new record.) The Start Timer button will then change to two buttons, labeled Stop and Pause. Also, the End Date field will be replaced by a Current Time field. None of the date or time fields are editable when the timer is running. You can add notes, expenses, create new records and even quit the program while the timer is running.  
        
       
     + 
      
      1
      
      
      
      
     
     
    - 
    9 
  @     A F
     h  
        sThe timer will continue running until you click the Pause or Stop button. The timer will continue running, even if you quit the program or shut down your computer, until you click the Stop button. You can also work in other applications while the timer is running, although the Current Time and Total Time fields will not be updated until you switch back to A&E Tracker. 
       4
     4 
     9 
     = 
     A 	
  @      J {
      Q
     
    " 
    ' 

    1 A  
  @         You may have timers for several activities running at the same time. Normally you will want to pause (or stop) one activity's timer before starting another one. When you click the Pause button, it changes to Go. Click the Go button to restart the timer. After pausing the timer, "n/a" is entered into the Stop Time field, to remind you that the total time is actually an accumulation of several periods of time. 
       
      
      
      
      
      
      Q
    1 	
    : a   If you already have time information on the record, you will be asked if you want to restart the timer or create a new record. Selecting Restart Timer will restart the timer. Selecting New Record will create a duplicate record and then start the timer. 
       
      

      #
      

      9    * About Projects 
  @          wYou can enter any number of projects into Activity & Expense Tracker. If you have several clients, you may want to use the client's name for the project name. If you work on different projects for the same client, you will want to combine the client and project name somehow. Project names are limited to 25 characters, but commas and other special characters are permitted.    To choose a project, click the Add/Select Project button. Then select a project name and click the Choose Project button. You may also double-click on the project name. 
       
      
     1 2
     c 
     q 7  To create a project name, click the Add/Select Project button. Then click the Create Project button and enter a name. The maximum length for project names is 32 characters. To transfer the new project name to the current record, click the Choose Project button. 
       $
     $ 
     6 
     N 
     ] 
      
         To modify a project name, click the Add/Select Project button. Then select a project name to modify and click the Modify Project button. You will be asked for a new name. All records with the old project name will be updated with the new name. 
       $
     $ 
     6 <
     r 
      *
  @       H
         To delete a project name, click the Add/Select Project button. Then select a project name to delete and click the Delete Project button. You will no longer be able to create reports for that project. For more information see Invoices & Reports. 
       $
     $ 
     6 <
     r 
      	
  @       >
      
  @       
               Button Colors 
  @        
   You can change the button colors from the Preferences window. Click the Prefs button, then choose a color from the Button Colors list. The button colors will automatically change to the new color. 
       *
  @      * 
     < 
     H 
     M &
     s 

      D        ( About Expense Notes 
  @           You can add notes about the expense and the amount of other expenses. To add multiple expenses, just list them in the Expense Notes field with their amounts, then click on the + button. The total will appear in the Expense $ field. 
       v
     v 

      -
      
      &
      	
        When you click the + button, if the expense type has an associated amount (or Expense Amount), you will be asked if you want to add the amounts (numbers) in the Expense Notes field to the Expense Amount. If you choose Just Notes, only the numbers in the Expense Notes field will be added to the Expense $ field. If you choose Yes, the numbers in the Expense Notes field will be added to the Expense $ field. If you choose No, just the Expense Amount will be added to the Expense $ field. 
       
      
      
      

      ,
      

      C
    ' 	
    0 
    F 
    I >
     	
     
     
     /
     

        UYou may edit the Expense $ field directly, by clicking the field or the Edit button. 
       
      	
      .
     H 
     L    {To subtract a number in the Expense Notes field, put a minus sign ("-") before the number. Here are some correct examples: 
       
      
     ) Q $123.50 books -33.50 discount  )stamps 34.20 envelopes 5.79 rebate -1.00    Numbers need to have a space before and after them. Avoid using dollar signs or equal symbols. Here are some incorrect examples: 
  @        ^
     ^ 
     m 	
     v 
 
$123.50books  -$33.50 discount  stamps USD34.20    If you want to use a number in the Expense Notes field that does not get added to the Expense $ field, precede the number with the # character (i.e., item #12345). 
       #
     # 

     0 &
     V 	
     _ D  You may also multiply expenses. To do this the expense type must include an Expense Amount to be multiplied. For example, the Mileage expense type has a default multiplier of .33 ($0.33 per mile). To compute the expense $ for 123 miles, enter *123 into the expense notes field and click the + button. The * (shift 8) symbol indicates that the following number is to be multiplied by the expense type's amount and added to any other numbers in the expense notes field. There must not be a space between the * and the number.    Expense notes and totals are included in reports and invoices if the Show Expenses option is checked on the Invoices & Reports window.  
       E
     E 

     R 
  @      l 
         \To clear the Expense, Expense Notes, and Expense $ fields, click the Clear expenses button. 
       D
     D 
     S    When Expense Notes are exported, all line endings are converted to " | " characters, so that importing into spreadsheets and databases is possible. 
         
            [ Modify Activity 
  @          To modify an activity's name, click the Add/Select Activity button. Then select an activity type to modify and click the Modify Activity button. You will be asked for a new name. After clicking OK, all records containing the old activity name will be updated with the new activity name. 
       (
     ( 
     ; >
     y 
      +
  @       k        M Exporting Records 
  @          3You can export the records to a text file by clicking the Export button. You will be asked if you want export All records or just Specific ones. If you choose All then all records will be exported. Records are exported in a tab delimited format, so they can be easily imported into many other applications. 
       :
     : 
     @ .
     n 
     y 	
      
      
      
      $
 @      Blue   l   If you choose Specific you will then be asked if you want to export Old records, New records or Project records. If you click the Project button, only records for the project on the current record will be exported. 
       
      
      .
     D 
     G 

     Q 
     T 
     ` 
     g 
      
      M   If you choose New, you will be asked to enter a date. Only records newer than that date will be exported. Using this feature allows you to export just the records for the last week (for example) so that they can be sent to an administrator for importing. 
       
      
        
         If you choose Old, you will also be asked to enter a date. Only records older than that date will be exported. This feature is useful if you want to delete old records, but want to export and archive them first. 
       
      
        
         If there are no records found to be exported, you will see a message to that effect, but a file will still be written to disk. To avoid confusion, you may want to delete that file. 
         
         You can export records which have their timer running. However, when these records are imported again, the timer will be paused at the time it was exported. The note "timer running or paused" is added to the exported record. 
       
      :   <There are several reasons you might want to export records: 
  @        ;1) If you work in a small office or workgroup, each person can keep track of their own time and expenses, then export their records and send the file to an administrator. They will then be able to import the data and generate reports and invoices for the whole group. If you will be exporting Activity & Expense Tracker records, to be combined with those of other users, it is important that everyone be using the same set of activity types (and Project names), so that reports can be more accurately generated. More about this below. 
      
 @      Blue  
         2) Rather than archiving the whole program, you might want to export all (or some of) the records and just archive the much smaller text file.    3) When updating to a newer version of the program, you should export all your records and then import them into the new version.   K4) If you wanted to export the records to a spreadsheet or a word processing program. When Activity Notes and Expense Notes are exported, all line endings are converted to " | " characters, so that importing into spreadsheets and databases is possible. If you import into a word processor, you may want to remove these characters. 
       V
 @      Blue  V 
      N   Exported Records files: 
  @         There are two separate files exported. The first is called records.txt which contains the data for all the records in a tab delimited format. You can change this name if you wish. Be sure to make a note of its location. 
       ;
  @      ; 
     F n
  @       '  
  @         
The second file, which contains all your project, activity and expense types is called paetypes.txt. This step is optional and you can change the name or location of this file as well. If you have exported records that use all of your project and activity names and expense types, this step is unnecessary because all of these names will automatically be read in when you import the data. It is only if you have spent a lot of time entering activity and expense types that you have not yet used, that this step is important. 
       W
  @      W 
     c  `Another good reason to use the paetypes option, is if you will be combining records from several different users. The administrator should create a set of Project Names, Activity Types and Expenses that they can export as a paetypes file. Then each user can import the master paetypes file so that the administrator can generate more accurate reports.          Expense Reports 
  @           In the Invoices & Reports window, if the Expense Sort Order is clicked, an Expense Report will be generated that only contains expense information. For more information see Invoices & Reports. 
       
  @       
       	
     ) 
     0 
  @      H J
      
  @       
              F Delete Expense 
  @          To delete an expense type, click the Add/Select Expense button. Then select an expense type to delete and click the Delete Expense button. You will no longer be able to create expense reports for that expense type. For more information see Expense Reports. 
       %
     % 
     7 =
     t 
      n
  @       
              ) About Expenses 
  @           An "expense type" consists of a name for the expense and (optionally) an amount for the expense. You can create as many expense types as you want. You can also modify and delete expense types.   To choose an expense type, click the Add/Select Expense button. Then select an expense type and click the Choose Expense button. You may also double-click on the expense type. If there is an amount for the expense, it will be entered into the Expense $ field. If there are numbers in the Expense Notes field, you will be asked if you want to add the expense amount to the expense notes numbers. For more information see About Expense Notes. 
       %
     % 
     7 3
     j 
     x {
      	
      $
      

    - w
  @      
       yTo create an expense type, click the Add/Select Expense button. Then click the Create Expense button and enter a name. You will then be asked if there is a fixed amount to be associated with the new expense type. If the amount of this expense type will always be the same, enter an amount and then click the OK button. If the expense amount will vary, click the Cancel button. 
       %
     % 
     7 
     O 
     ] 
    4 
    6 4
    j 
    p   >To modify an expense type, click the Add/Select Expense button. Then select an expense type to modify and click the Modify Expense button. You will be asked for a new name. Enter a new name, or if the name is to remain the same click the OK button. All records with the old expenses name will be updated with the new name. You will then be asked if there is a fixed amount to be associated with the expense type. If you want to add or change the amount of this expense, enter an amount and then click the OK button. If the expense amount will vary, click the Cancel button. 
       %
     % 
     7 =
     t 
      l
      
      
  @       I
    A 
    / 
    5   If you have previously entered an expense type and notes and then want to clear the expense type but not the notes, click the Add/Select Expense button. Then click the No Expense button. To clear the Expense, Expense Notes, and Expense $ fields, click the Clear expenses button. 
       ~
     ~ 
      
      

      N
      
       To delete an expense type, click the Add/Select Expense button. Then select an expense type to delete and click the Delete Expense button. You will no longer be able to create expense reports for that expense type. For more information see Expense Reports. 
       $
     $ 
     7 =
     t 
      n
  @       
               Font... 
  @          
         Before printing you may want to adjust the font, size or line height of the report or invoice text by clicking the Font... button. Choose a new font by clicking its name in the font list. 
       s
     s 
     z A  
         Change the font size by clicking one of the pt size radio buttons. Not all fonts are available in all sizes, so you may not notice a change.  
         
         Click the line height field to enter a new number. The minimum line height is equal to the text size plus one (i.e., if the text size = 14 then the minimum line height = 15). 
       3
     3 {  
  @         (After adjusting the font, size or line height, you may need to also adjust the lines per page that get printed, by clicking the lines per page field. Double check to make sure all lines of your report are being printed after adjusting the font, size or line height of the report or invoice text. 
  @        
        
        You can also set the tab stops of the report or invoice text by clicking the Font... button and then the Tab button. You will be given the choices of Wide, Medium, Narrow and Custom. The custom option allows you to specify exact numbers for the three tab stops in pixels. Some experimentation will probably be necessary. Make minor changes to each of the three numbers to see what the effects are. Tabs may need to be readjusted after each report or invoice has been generated. 
       
      .
     M 
     T 
     i 
     l *
      
      
      
      
      
      
      
      
 @      Blue  O  
                { Visual Effects 
  @          MIn earlier versions of this program, there was a visual effect that helped to indicate the movement from one record to another in the A&E Tracker window when using the arrow keys. Some people found this effect annoying or slow. Other people thought is was great. So you may now choose to turn it On or Off in the Preferences window. 
       
  @       
      
    ( 
    * 
    . 
    1 
  @     9 
    K    See also Record #. 
       	
 @      Blue  	 	  z 
Today's Date 
  @           rTo easily enter today's date into a record, click the Today button above either the Start Date or End Date field. 
       6
     6 
     ; 
     T 

     ^ 
     b 
     j    aYou can go directly to the first record with a particular date by clicking the Start Date label. 
       O
     O 

     Y     y Time Format 
  @           In the Preferences window, you can set the Time Format to either 24 Hr or AM/PM. Times previously entered will not be modified, but all new times entered will be in the new format. 
       
  @       
      
     + 
     7 }        u Sort Order 
  @        
  (You can sort reports (only) by Date, Activity, Project (if the All Projects button is selected) or Expenses (if All Expenses button is selected) by clicking the appropriate button in the Sort Order section of the Invoices & Reports window. Click the radio button next to the option to enable it. 
       
      
     # 
     % 
     - 
     / 
     6 -
     c 
     k P
      

      
  @       
      9   8For information on sorting records see Sorting Records. 
       '
  @      '     v Sorting Records 
  @          /You can sort records by clicking the Sort button in the A&E Tracker window. You will be asked if you want to sort by Date, Activity, or Project. If you choose Activity or Project, all records will be sorted by date first and then by either Activity or Project. All records are renumbered after sorting. 
       %
     % 
     ) 
  @      8 
     J +
     u 
     y 
     { 
      
      
      
  @       L
      
      
      
      
     +        m Round Off Times 
  @          You can round off times in reports and invoices by clicking the Round off times to (percent) hr button in the Invoices & Invoices & Reports window. When selected, the default is .25 hours, but you can change this number by clicking the adjoining field (i.e., enter 1 to round times to the nearest hour, .5 to the nearest half hour, etc.). Click the checkbox next to the option to enable it. 
       @
     @ 
     _ 
  @      y 
              o Searching Records 
  @          You can search records for particular text by clicking the Search button. A dialog will ask for a partial or whole word to search for. You can find the beginning of a word or phrase by using the partial words option. To find an exact word or phrase, use the whole words option. 
       ;
     ; 
     A 
      

      2
     
    
    You can also specify that you want your search to be case sensitive (i.e., a search for "UNIX" will not find "unix"). Click the checkbox next to this option to enable it. 
       5
     5 
     C g   aYou can go directly to the first record with a particular date by clicking the Start Date label. 
       O
     O 

     Y     t Show Rates 
  @        
   You can show activity rates in reports and invoices by clicking the Show Rates button in the Invoices & Invoices & Reports window. Click the checkbox next to the option to enable it. 
       D
     D 

     N 
  @      h 
      5        s Show Expenses 
  @        
   You can include expense information in reports and invoices by clicking the Show Expenses button in the Invoices & Invoices & Reports window. Click the checkbox next to the option to enable it. 
       L
     L 

     Y 
  @      s 
      5        r Show Daily Totals 
  @           You can include daily totals in reports and invoices by clicking the Show Daily Totals button in the Invoices & Reports window. Click the checkbox next to the option to enable it. 
       E
     E 
     V 
  @      e 
     ~ 5        q Show Activity Notes 
  @           You can include activity notes in reports and invoices by clicking the Show Activity Notes button in the Invoices & Reports window. Click the checkbox next to the option to enable it. 
       G
     G 
     Z 
  @      i 
      5        p Select Activities 
  @           To select an activity, click the Add/Select Activity button. Then choose an activity and click the Choose Activity button. You may also double-click on the activity to automatically enter it into the current record. 
       !
     ! 
     4 /
     c 
     r e        n Save Record 
  @           You can save all the data in the record window by clicking the Save button. All data is saved automatically when going to another record or when quitting the program. 
       ?
     ? 
     C c         Save As... 
  @        
   :There are several places you will see Save As... buttons. 
       &
     & 

     0 	  You can use the Save as... button at the bottom of this window, to export the help topic you are currently viewing. Or you can export all of the help topics. You can save the text as either a .txt file or an .html file. You can view the .html file, complete with all formatting, by opening it in your browser. You can open the .txt  file, for reading or printing, in your favorite word processor. See About Help for more information about printable versions of this Help system. 
       
      

      
 @      Blue   Y
    5 \
  @      

     C   In the Report or Invoice window, the Save as... button saves the text of the report or invoice to a text file. You may want to save reports or invoices for archiving purposes. 
       %
     % 

     / @
  @      o @   In the Edit Header and Footer dialogs, there is a Save as... button that allows you to save the header or footer as a text file so you can import it again later. For more information see Invoices & Reports. 
       2
     2 

     < 
  @       
              l Restore Window 
  @           You can collapse the record window, so that only the top portion (which shows the date, time, project and activity) is visible, by clicking the Collapse button (which has an up arrow with a bar). The Collapse button then changes to a Restore button. 
       
      
      0
      
      
      
         To restore the window to its original configuration, click the Restore button (which has a down arrow with a bar). The Restore button then changes to a Collapse button. 
       ?
     ? 
     F 1
     w 
     ~ 
      
              T Header Add/Edit 
  @          To enter header information, click the Add/Edit button. Click the Header button to include the header in your invoice or report. You may save the header to a text file by clicking Save As... and then import the header later by clicking the Import... button. This way you can keep a separate header file for each client. Click the Close button to hide the fields that appear for editing. 
       '
     ' 
     / 
     B 
     H l
      

      2
      	
      Q
    J 
    O 3   You can use this feature as a simple text editor if you wish. Just import any text file (or type a new one) and then click Save as.. to give it any name you want.       P Footer Add/Edit 
  @          To enter footer information, click the Add/Edit button. Click the Footer button to include the footer in your invoice or report. You may save the footer to a text file by clicking Save As... and then import the footer later by clicking the Import... button. This way you can keep a separate footer file for each client. Click the Close button to hide the fields that appear for editing. 
       '
     ' 
     / 
     B 
     H l
      

      2
      	
      Q
    J 
    O 3   You can use this feature as a simple text editor if you wish. Just import any text file (or type a new one) and then click Save as.. to give it any name you want.   i 
Registration 
  @           To register Activity & Expense Tracker, click the Register button. Read the instructions for getting a registration number. Once you receive your number, fill in your full name and the registration number. 
       2
     2 
     :    HYou can also review the License Agreement from the Registration window. 
       
      
     )         g Quit 
  @          You can quit (or exit) the program at any time by clicking the Quit button. All data will be saved before quitting and timers will continue to run after quitting and even if you shut down your computer. You may also type Alt + Q (or Command + Q on the Macintosh) to quit. 
       ?
     ? 
     C         f Quick Check 
  @          Click the Quick Check button to find out how many how hours you have worked on an activity (or all activities) for a particular project and the total billable amount. No expenses are included in this amount. The project, activity and end date are all automatically filled in for you. You can change the start date, end date, project or activity in the resulting window. Click the All button to get totals on all activities. Click the First button to enter the start date of the first record with the selected Project/Activity combination. Click the Last button to enter the start date of the last record with the selected Project/Activity combination. Click the Recalculate button after making changes to get new totals. 
       

     
 
      
  @       (
      
    | 
     3
     
     n
    % 
    ) m
     
     /         Restart Timer 
  @        
   Restart the timer by clicking the Go button. The Go button changes to a Pause button, so you can pause the timer again. For more information see Start Timer. 
       "
     " 
     $ $
     H 
     M D
  @         
         oIf you stop the timer and then want to restart it, click the Start Timer button and choose Restart when asked. 
       =
     = 
     H 
     [ 
     b       c Pause Timer 
  @           Pause the timer by clicking the Pause button. The Pause button changes to a Go button so that you can start the timer again. For more information see Start Timer. 
        
       
     % '
     L 
     N H
  @               b 	Now Time 
  @           You can easily enter the current time by clicking the Now button. This button also enters the current date into the appropriate date field. 
       6
     6 
     9 R        a No Expense 
  @        
  If you have previously entered an expense type and notes and then want to clear the expense type but not the notes, click the Add/Select Expense button. Then click the No Expense button. To clear the Expense, Expense Notes, and Expense $ fields, click the Clear expenses button. 
       ~
     ~ 
      
      

      N
      
             _ Monetary Symbol 
  @          In the Preferences window, you can set the Monetary Symbol to something other than the dollar sign ($). Click the Prefs button in the A&E Tracker window, then click the Change button. You will be asked for a new symbol. You can use any character or up to 3 letters for the monetary symbol. The new symbol will be displayed on the A&E Tracker window above the Expense $ field and in all invoices and reports. 
       
  @       
      
     + 
     : 8
     r 
     w 
  @       
      
      
      
 @      Red J 
    \ 
    g 	
    p '        \ Modify Expense 
  @          STo modify an expense type, click the Add/Select Expense button. Then select an expense type to modify and click the Modify Expense button. You will be asked for a new name. Enter a new name, or if the name is to remain the same click the OK button. You will then be asked if there is a fixed amount to be associated with the expense type. If you want to add or change the amount of this expense, enter an amount and then click the OK button. If the expense amount will vary, click the Cancel button. All records with the old expense name and amount will be updated with the new name and amount. 
       %
     % 
     7 =
     t 
      l
      
      
     
     4
     
     	
  @      ^        Z Look and Feel 
  @        
  aIn the Preferences window, the Look and Feel defaults to Windows 95, but if you like one of the other choices better, you can choose it here. In Windows 95 mode, the shortcut for the button is indicated by an underlined letter in the button's name. In Macintosh mode, the keyboard shortcuts are not visible. For more information see Keyboard Shortcuts. 
       
  @       
      
      

     , e
      

      a
      	
     H
  @     M 
    _         W Importing Records 
  @          You can import previously exported records by clicking the Import button in the A&E Tracker window. First you will be asked if you want to Delete all existing records before importing or Add the imported records to the existing ones. You then will be asked to locate a records.txt file to import. You will also be asked if you want to import additional project, activity and expense types. If you answer Yes, you be asked to locate a paetypes.txt file to import. This step is optional. 
       ;
     ; 
     A 
  @      P 
     b )
      
      *
      
      O
  @     
 
     |
     
     
  @      
     '   @There are a couple of reasons you might want to import records: 
  @        ?1) If you work in a small office or workgroup, each person can keep track of their own time and expenses, then export their records and send the file to an administrator. They will then be able to import the data and generate reports and invoices for the whole group.  2) When updating to a newer version of the program, you should export all your records and then import them into the new version.    ,See Exporting Records for more information. 
       
  @       
          V Highlight Color 
  @           You can change the highlight color from the Preferences window. Click the Prefs button in the A&E Tracker window, then choose a color from the Highlight Color list. The highlight color will automatically change to the new color. 
       ,
  @      , 
     > 
     J 
     O 
  @      ^ 
     p 
      
      F        S Header 
  @           eYou can include a custom Header in your report or invoice. For more information see Header Add/Edit. 
       
      
      5
  @      T 
     c         R 
Go to Record 
  @           LYou can go directly to any record by clicking the Record # field or label.  
       2
     2 
     :    fYou can also go directly to the first record with a particular date by clicking the Start Date label. 
       T
     T 

     ^       Q 	Go Timer 
  @           Restart the timer by clicking the Go button. The Go button changes to a Pause button so that you can pause the timer again. For more information see Start Timer. 
       "
     " 
     $ $
     H 
     M H
  @               O Footer 
  @           eYou can include a custom Footer in your report or invoice. For more information see Footer Add/Edit. 
       
      
      5
  @      T 
     c          Edit Total Time 
  @          You can edit the Total Time directly by clicking the Edit button or directly on the field. If there is already an End Time you will be asked if you want to clear the End Date and Time. This is because the end time will no longer be relevant if you change the total time. If you want the end time to remain the same, answer No and then adjust the Start Time instead of the Total Time. The Total Time must be in the format # hrs # mins (note the spaces and abbreviations). 
       
      

      
     5 
     9 9
     r 
     z ,
      
      
    C 
    E 
    Z 

    d  
     

     H        L 
Edit Time 
  @        	  The Start and End Times can be adjusted several ways. If you want to enter the current time, click the Now button above the start or end field. If you want to edit the time field, click on the Edit button or the field itself. A dialog box will ask you for a new time. 
       g
     g 
     j W
      
      F  2Another method is to click the small up or down arrows next to the time field. You can increase or decrease the hours with the first set of buttons, and increase or decrease the minutes with the second set of buttons. You can hold down the mouse button on any of these arrows to get continuous adjustment.    If you enter an end time that is before the start time, or a start time that is after the end time, 0 hrs 0 mins will be displayed in the Total Time field. 
       
      

          K Edit Expense $ 
  @           You can add an amount to the Expense $ field directly by clicking the Edit button or directly on the field. This will replace any previous amount. 
       
      	
     &  
     F 
     J H   2See also About Expense Notes and Adding Expenses. 
       	
  @      	 
      
  @      ! 
     0         0 Adding Expenses 
  @           An "expense type" consists of a name for the expense and (optionally) an amount for the expense. You can add as many expense types as you want. You can also modify and delete expense types.   yTo create an expense type, click the Add/Select Expense button. Then click the Create Expense button and enter a name. You will then be asked if there is a fixed amount to be associated with the new expense type. If the amount of this expense type will always be the same, enter an amount and then click the OK button. If the expense amount will vary, click the Cancel button. 
       %
     % 
     7 
    O 
    ] 
     q 
   4 
   6 *
    ` 

    j 
    p   To choose an expense type, click the Add/Select Expense button. Then select an expense type and click the Choose Expense button. You may also double-click on the expense type. If there is an amount for the expense, it will be entered into the Expense $ field. If there are numbers in the Expense Notes field, you will be asked if you want to add the expense amount to the expense notes numbers.  
       %
     % 
     7 3
     j 
     x {
      	
      $
     

   - -
    Z 1   You can list additional expenses in the Expense Notes field. Then add the expenses in the Expense Notes field to the Expense $ field by clicking the + button (between the Expense Notes and Expense $ fields). For more information see About Expense Notes. 
       (
     ( 

     5 %
     Z 

     g 
     u 	
     ~ 
      
      S
  @       
              I 
Edit Date 
  @        	  
The Start and End Dates can be adjusted several ways. If you want to enter today's date, click the Today button above the start or end field. If you want to edit the date field, click on the Edit button or the field itself. A dialog box will ask you for a new date. 
       c
     c 
     h W
      
      F  Another method is to click the Choose button. A new window will open that allows you to select a new date by clicking the year, the month and then the date from a calendar interface. Clicking on a date, closes the window and enters that date into the current record. 
       
      
     %    If you enter an end date that is before the start date, or a start date that is after the end date, 0 hrs 0 mins will be displayed in the Total Time field. 
       
      

          H Deleting Records 
  @          You can delete some or all records by clicking the Delete button. You will be asked if you want to delete Just this one record, Older records or All records. If you choose Older then you will be asked for a date. This feature is useful when you have many old records that you do not need to keep. You will probably want to export the old records first. See Exporting Records for more information. 
       3
     3 
     9 1
     j 

     w 	
      
      
      
      
  @     e 
    v         G Delete Project 
  @           To delete a project name, click the Add/Select Project button. Then select a project name to delete and click the Delete Project button. You will no longer be able to create reports for that project. 
       $
     $ 
     6 ;
     q 
      G        E Delete Activity 
  @           To delete an activity type, click the Add/Select Activity button. Then select an activity type to delete and click the Delete Activity button. You will no longer be able to create reports for that activity type. 
       &
     & 
     9 >
     w 
     } 
     ~ 
      M        D Default Settings 
  @           }If you want to return the settings in the Preferences window to their default state, just click the Default Settings button. 
       *
  @      * 
     < (
     d 
     t    See also Preferences. 
       	
  @      	     C Create Report 
  @        
   cTo generate a report, click the Create Report button. For more information see Invoices & Reports. 
        
       

     - "
  @      O 
     a         B Create Project 
  @          /To create a project name, click the Add/Select Project button. Then click the Create Project button and enter a name. The maximum length for project names is 32 characters. To transfer the new project name to the current record, click the Choose Project button. For more information see About Projects. 
       $
     $ 
     6 
     N 
     \ 
      
      "
  @              A Create Invoice 
  @           fTo generate an invoice, click the Create Invoice button. For more information see Invoices & Reports. 
       "
     " 
     1 !
  @      R 
     d         @ Create Expense 
  @          yTo create an expense type, click the Add/Select Expense button. Then click the Create Expense button and enter a name. You will then be asked if there is a fixed amount to be associated with the new expense type. If the amount of this expense type will always be the same, enter an amount and then click the OK button. If the expense amount will vary, click the Cancel button. 
       %
     % 
     7 
     O 
     ] 
    4 
    6 4
    j 
    p    )For more information see About Expenses. 
       
  @       
     '         > Collapse Window 
  @           You can collapse the record window so that only the top portion (which shows the date, time, project and activity) is visible, by clicking the Collapse button (which has an up arrow with a bar). The Collapse button then changes to a Restore button. 
       
      
      0
      
      
      
         jTo restore the window to its original size, click the Restore button (which has a down arrow with a bar). 
       6
     6 
     = ,        = Clear Expenses 
  @           \To clear the Expense, Expense Notes, and Expense $ fields, click the Clear expenses button. 
       

     
 
      
      

     # 
     ) 	
     2 
     E 
     S    )For more information see About Expenses. 
       
  @       
     '         < Choose Project 
  @           To choose a project, click the Add/Select Project button. Then select a project name and click the Choose Project button. You may also double-click on the project name to add it directly to the current record. For more information see About Projects. 
       
      
     2 1
     c 
     q z
  @               ; Choose Expense 
  @          To choose an expense type, click the Add/Select Expense button. Select an expense type and then click the Choose Expense button. You may also double-click on the expense type. If there is an amount for the expense, it will be entered into the Expense $ field. If there are numbers in the Expense Notes field, you will be asked if you want to add the expense amount to the expense notes numbers. 
       $
     $ 
     7 3
     j 
     x {
      	
      $
      

    - ]   AFor more information see About Expenses and About Expense Notes. 
       
  @       
     ' 
  @      , 
     ?         : Choose Date 
  @          3One method for changing a date, is to click the Choose button above the date field. A new window will open that allows you to select a new date by clicking the year, the month and then the date from a calendar interface. Clicking on a date closes the window and enters that date into the appropriate field. 
       0
     0 
     6   	If you enter an end date that is before the start date, or a start date that is after the end date, 0 hrs 0 mins will be displayed in the Total Time field, or if you are on the Invoices & Reports window or the Quick Check window, you will be notified of the error. 
       
      

      
 @      Red   
      
 @      Red   
      $      9 Choose Activity 
  @           To choose an activity, click the Add/Select Activity button. Then select an activity and click the Choose Activity button. You can also double-click the activities name to add it to the current record. 
       !
     ! 
     4 /
     c 
     r W  
         In the Invoices & Reports window, there is a Choose Activities button. This takes you to a window where you can choose several activities to include in in your a report or invoice. You can't add, change or delete activities from this window. 
       
  @       
       

     - 
     >         8 Changing Rates 
  @          iTo add or change an activities rate, click the Add/Select Activity button. Select an activity to modify, then click the Modify Rate button. You will be asked for a new rate for the activity. The choices are Hourly, Flat or None. If you choose Flat Rate, enter the amount you want billed for that activity regardless of the amount of time spent on the activity. 
       /
     / 
     B 6
     x 
      L
      
      
      
      
      
      
      	
      l  You can specify different rates for similar activities if you wish. For instance, you might bill administrative time to one project, but not another, so you would have one administrative activity with no rate and another with a rate. You might also charge less per hour to non-profit groups, so you would want to have similar activities with different hourly rates. For more information see Adding a New Activity Rate. 
      
  @      
             7 Changing Projects 
  @           To add a new project name to the current record, click the Add/Select Project button. Then select the new name and then click the Choose Project button. You may also double-click on the project name to add the project to the current record. 
       ;
     ; 
     M 5
      
      `  ITo change projects, click the Add/Select Project button. If you want to modify an existing name, select the project to be changed, click the Modify Project button and enter a new name. The maximum length for project names is 32 characters. To transfer the new project name to the current record, click the Choose Project button. 
       
      
     0 ]
      
      
    2 
    @         6 Changing Expense Types 
  @          To add an expense type to the current record, click the Add/Select Expense button. Then select the name of the expense type and click the Choose Expense button. You may also double-click on the expense name which will automatically add it to the current record. 
       8
     8 
     J @
      
      m  >To modify an expense type, click the Add/Select Expense button. Then select an expense type to modify and click the Modify Expense button. You will be asked for a new name. Enter a new name, or if the name is to remain the same click the OK button. All records with the old expenses name will be updated with the new name. You will then be asked if there is a fixed amount to be associated with the expense type. If you want to add or change the amount of this expense, enter an amount and then click the OK button. If the expense amount will vary, click the Cancel button. 
       %
     % 
     7 =
     t 
      l
     
     5
    % 
    
    
     $
    / 
    5         5 Changing Activities 
  @          
To add a new activity name to the current record, click the Add/Select Activity button. Then select the name of the new activity and click the Choose Activity button. You may also double-click on the activity name which will automatically add it to the current record. 
      <
    < 
    O %
     t 
      
      n  zTo modify an activities name, click the Add/Select Activity button. Then select an activity type to modify and click the Modify Activity button. You will be asked for a new name. After clicking OK, all records containing the old activity name will be updated with the new activity name. To transfer the new activity name to the current record, click the Choose Activity button. 
       (
     ( 
     ; >
     y 
      :
     
     /
      o
    b 
    q    6See also About Activities & Rates and Changing Rates. 
       	
  @      	 
     ! 
  @      & 
     4         3 Background Color 
  @           You can change the background color from the Preferences window. Click the Prefs button, then choose a color from the Background Color list. The background color will automatically change to the new color. 
       -
  @      - 
     ? 
     K 
     P &
     v 
      G        2 Adjusting the Time 
  @          The Start and End Times can be adjusted several ways. If you want to enter the current time, click the Now button above the start or end field. If you want to edit the time field, click on the Edit button or the field itself. A dialog box will ask you for a new time. 
       g
     g 
     j W
      
      F  2Another method is to click the small up or down arrows next to the time field. You can increase or decrease the hours with the first set of buttons, and increase or decrease the minutes with the second set of buttons. You can hold down the mouse button on any of these arrows to get continuous adjustment.    If you enter an end time that is before the start time, or a start time that is after the end time, 0 hrs 0 mins will be displayed in the Total Time field. 
       
      

          / Adding a New Record 
  @          To add a new record, click the Add button in the A&E Tracker window. You will be asked if you want to duplicate the current record with or without notes. There are three choices. If you choose Just Project & Activity, only the current project and activity information will be copied onto the new record. If you choose With Notes, then the activity and expense notes will be copied to the new record also. If you choose Clear All, then none of the information from the current record will be copied and a blank record will be created. 
       
      
     " 
  @      1 
     C ~
      
      f
    > 

    H [
     	
     i        . Adding a New Project 
  @          >To add a new project, click the Add/Select Project button. Next click the Create Project button. Enter the name for the new project. The maximum length for project names is 32 characters. To transfer the new project name to the current record, click the Choose Project button. For more information see About Projects. 
        
       
     2 
     J 
     X 
      
     "
  @     .         - Adding a New Expense Type 
  @           An "expense type" consists of a name for the expense and (optionally) an amount for the expense. You can add as many expense types as you want. You can also modify and delete expense types.   To choose an expense type, click the Add/Select Expense button. Then select an expense type and click the Choose Expense button. You may also double-click on the expense type to add it directly to the current record. If there is an amount for the expense, it will be entered into the Expense $ field. If there are numbers in the Expense Notes field, you will be asked if you want to add the expense amount to the expense notes numbers. For more information see About Expense Notes. 
       %
     % 
     7 3
     j 
     x 
     	
    % $
    I 

    V w
  @        yTo create an expense type, click the Add/Select Expense button. Then click the Create Expense button and enter a name. You will then be asked if there is a fixed amount to be associated with the new expense type. If the amount of this expense type will always be the same, enter an amount and then click the OK button. If the expense amount will vary, click the Cancel button. 
       %
     % 
     7 
     O 
     ] 
    4 
    6 4
    j 
    p         ' About Activity Notes 
  @           You can add notes about the Activity in the Activity Notes field. They can be of any length and can be printed as part of your invoices or reports. For more information see Show Activity Notes. 
       ,
     , 
     : s
  @       
        
         When Activity Notes are exported, all line endings are converted to " | " characters, so that importing into spreadsheets and databases is possible. 
                  Preferences 
          There are several preferences you can set for Activity & Expense Tracker. Start by clicking the Prefs button in the record window.   FThe Look and Feel defaults to Windows 95, but if you like one of the other choices better, you can choose it here. In Windows 95 mode, the shortcut for the button is indicated by an underlined letter in the button's name. In Macintosh mode, the keyboard shortcuts are not visible. For more information see Keyboard Shortcuts.    iThe Time Format defaults to AM/PM but if you would want times displayed in 24 hour format, click 24 Hrs.    You can change the background color from the Preferences Window. Choose a color from the Background Color list. The background color will automatically change to the new color.    You can change the button colors from the Preferences Window. Choose a color from the Button Colors list. The button colors will automatically change to the new color.    rPlay around with these two groups of selections until you find a color combination that is pleasing to your eyes.    You can also change the highlight color from the Preferences Window. Choose a color from the Highlight Color list. The highlight color will automatically change to the new color.   =You can set the Monetary Symbol to something other than the dollar sign ($), if you use a different one, by clicking the Change button. You will be asked for a new symbol. You can use any character or up to 3 letters for the monetary symbol. The new symbol will be displayed on the records screen and in all reports.    WClick the Default Settings button to return all settings back to their default values.             	`    @ _ Y &   
 About Help Ux   Ion mouseUp
  lock screen
  push card
  go card "About Help"
end mouseUp
   dd CornflowerBlue      l             	        A&E Tracker Ex   Jon mouseUp
  lock screen
  push card
  go card "A&E Tracker"
end mouseUp
   dd CornflowerBlue    {  a             	        Keyboard Shortcuts Ex   Oon mouseUp
  lock screen
push card
  go card "Keyboard Shortcuts"
end mouseUp
   dd CornflowerBlue      ~             	        	Tutorial Ex   Eon mouseUp
  lock screen
push card
  go card "Tutorial"
end mouseUp
   dd CornflowerBlue     " P             	        Invoices & Reports Ex   Uon mouseUp
  lock screen
push card
  go card "About Invoices & Reports"
end mouseUp
   dd CornflowerBlue    ` "              	       
 Preferences Ex   Oon mouseUp
  lock screen
push card
  go card the short name of me
end mouseUp
   dd CornflowerBlue     " f             	        Help Index Ex   Gon mouseUp
  lock screen
push card
  go card "Help Index"
end mouseUp
   dd CornflowerBlue     <              	       } Back to Previous Topic Ex   on mouseUp
  pop card into temp
  if temp is empty or NOT (temp contains "help") then
    go card "Help Index"
  else
    go temp
  end if
end mouseUp
   dd CornflowerBlue     <              	        Search Help Ex  on mouseUp
  global gFindStack,gFoundOne
  put false into gFoundOne
  put the short name of this stack into gFindStack
  get the loc of stack "main"
  if the loc of stack "atFind" = it then
    add 220 to item 1 of it
    add 75 to item 2 of it
    set the loc of stack "atFind" to it
  end if
  go card 1 of stack "atFind"
  show stack "atFind"
  select text of field "find" of stack "ATfind"
end mouseUp
           dd CornflowerBlue     l             	        Save as... Ex  on mouseUp
  
  answer question "Save all topics or just this one?" with "Just this one" or "All"
  if it is "Just this one" then
    put the short name of this card into temp
    put "one" into howMany
  else
    put "all" into howMany
  end if
  
  answer question "Save as text or html?" with "Text" or "HTML" or "Cancel"
  if it is "Cancel" then exit mouseUp
  if it is "Text" then put ".txt" into fType
  else put ".html" into fType
  
  if howMany is "one" then
    ask file "Save this help topic as..." with temp &"_help" & fType
  else
    ask file "Save all help topics as..." with "HelpText" & fType
  end if
  if the result is "Cancel" then exit mouseUp
  put it into fileName
  open file fileName for write
  if the result <> empty then
    answer "There was a problem saving this file." & return & the result & return & sysError()
    exit mouseUp
  end if
  
  if fType is ".html" then
    put "<html>" & return & "<head> " & return & "<title>Activity & Expense Tracker Help</title>" & return & "</head>" & return & "<body  bgcolor="& quote&"#ffffff"& quote&">" & return into startHtml
    write startHtml to file fileName
  end if
  
  if howMany is "All" then
    repeat with i = 1 to the number of cards - 2
      exportText i,fType,fileName
      if fType is ".txt" then
        write "=====================================================" & return & return to file fileName
      end if
    end repeat
  else
    put the number of this card into n
    exportText n,fType,fileName
  end if
  
  if fType is ".html" then
    put return & "</body>" & return & "</html> " & return into endHtml
    write endHtml to file fileName
  end if
  
  close file fileName
end mouseUp

on exportText n,fType,fileName
  global gHelpText
  if the short name of card n is "Help Index" then
    put  "Index" into theField
  else
    put  "Main" into theField
  end if
  
  if fType is ".txt" then
    put field theField of card n into gHelpText
    repeat while last char of gHelpText is return
      delete last char of gHelpText
    end repeat
    write gHelpText & return & return to file fileName
  else
    put the htmltext of  field theField of card n into gHelpText
    exportHTML
    write gHelpText & "<p>&nbsp;<p>"  & return to file fileName
  end if
end exportText
   dd CornflowerBlue     Q              	        
Close Window Ex   @on mouseUp
  close this stack
  choose browse tool
end mouseUp
   dd CornflowerBlue     y             	           K        	  p          K        ^             K        y  d          K           j          K                    K        
   T    
  ! index  	x  on mouseUp
  if the optionKey is down then
    set the locktext of me to false
    set the listbehavior of me to false
    set the traversalOn of me to true
  else
    put line (the hilitedLine of me) of field "index" into temp
    push card
    go card temp
  end if
end mouseUp
         Xl(           About Activities & Rates  About Activity Notes  About Expense Notes  About Expenses  About Invoices & Reports  About Projects  Adding a New Activity  Adding a New Activity Rate  Adding a New Expense Type  Adding a New Project  Adding a New Record  Adding Expenses  Adjusting the Date  Adjusting the Time  Background Color  Button Colors  Changing Activities  Changing Expense Types  Changing Projects  Changing Rates  Choose Activity  Choose Date  Choose Expense  Choose Project  Clear Expenses  Collapse Window  Create Activity  Create Expense  Create Invoice  Create Project  Create Report  Default Settings  Delete Activity  Delete Expense  Delete Project  Deleting Records  
Edit Date  Edit Expense $  
Edit Time  Edit Total Time  Expense Reports  Exporting Records  
First Record  Font...  Footer  Footer Add/Edit  	Go Timer  
Go to Record  Header  Header Add/Edit  Help  Highlight Color  Importing Records  Last Record  Look and Feel  Modify Activity  Modify Expense  Modify Project  Modify Rate  Monetary Symbol  Next Record  No Expense  	Now Time  Pause Timer  Preferences  Prev Record  	Printing  Restart Timer  Quick Check  Quit  	Record #  
Registration  Report Options  Restore Window  Round Off Times  Save As...  Save Record  Searching Records  Select Activities  Show Activity Notes  Show Daily Totals  Show Expenses  Show Rates  Sort Order  Sorting Records  Start Timer  Stop Timer  Tabs  Time Format  
Today's Date  Visual Effects   "    	`    @ ` Y & 
   title 	H          ;h            Help Index 
   instruction 
         h @            *Click a topic below for more information.    New Button EpGon mouseUp
sort this stack by field "main"
  beep
end mouseUp


  repeat with i = 1 to the number of cards
    put empty into field "main" of card i
  end repeat

repeat with i = 1 to the number of lines of field index
  if there is a card line i of field index then next repeat
  else answer line i of field index
end repeat
          `              	        Export EpJon mouseUp
global gHelpText
  open file "helptext.html" for write
  repeat with i = 1 to the number of cards --lines of zlist
    put the htmltext of field "main" of card i into gHelpText
    exportHTML 
    write gHelpText & "<p>&nbsp;<p>"  & return to file "helptext.html"
  end repeat
  close file "helptext.html"
end mouseUp
        D ` ,             	        Import Ep	on mouseUp
  
  answer file "Select a  helptext.html file to import." with "helptext.html"
  if the result is "Cancel" then exit to metacard
  put it into fileName
  open file fileName for read
  --  lock screen
  read from file fileName until eof
  put it into allText
  close file fileName
  
  put "adding group close tags"
  put "</B></U></FONT>" into zstring
  repeat while offset(zstring,allText) > 0
    set cursor to busy
    put offset(zstring,allText) into firstchar
    put "</B></U></GROUP></FONT>" into char firstchar to (firstChar + length(zstring)-1) of allText
  end repeat
  
  put "adding group open tags"
  put "<FONT color="& quote&"#0000FF"&quote&"><U><B>" into zstring
  repeat while offset(zstring,allText) > 0
    set cursor to busy
    put offset(zstring,allText) into firstchar
    put "<FONT color="& quote&"#0000FF"&quote&"><GROUP><U><B>" into char firstchar to (firstChar + length(zstring)-1) of allText
  end repeat
  
  repeat with i = 1 to the number of cards
    put empty into cardText
    put "working on card" && i && "of" && the number of cards
    set cursor to busy
    put offset("<p>&nbsp;",allText) +2 into lastChar
    put char 1 to lastChar of allText into cardText
    delete char 1 to (lastChar+length("<p>&nbsp;")-1) of allText
    
    repeat while offset(return,cardText) > 0
      put offset(return,cardText) into firstchar
      delete char firstchar of cardText
    end repeat
    
    repeat while offset("  ",cardText) > 0
      delete char offset("  ",cardText) of cardText
    end repeat
    
    repeat while char 1 to 3 of cardText is "<p>"
      delete char 1 to 3 of cardText
    end repeat
    
    if char 1 of cardText is ">" then delete char 1 of cardText
    if char 1 of cardText <> "<" then put "<" before cardText
  --  answer cardText with "OK" or "Cancel" --**
 --   if it is "cancel" then exit mouseUp --**
    set the htmltext of  field "main" of card i to cardText
  end repeat
  
end mouseUp

put "<p>" & return & "<p>" & return & "<p>" & return into cardEnd
put "<p><p><p><p>" & return into cardEnd2

repeat while offset(cardEnd,allText) > 0
  set cursor to busy
  put offset(cardEnd,allText) into firstchar
  put "<p>&nbsp;" into char firstchar to (firstChar + length(cardEnd)) of allText
end repeat

repeat while offset(cardEnd2,allText) > 0
  set cursor to busy
  put offset(cardEnd2,allText) into firstchar
  put "<p>&nbsp;" into char firstchar to (firstChar + length(cardEnd2)) of allText
end repeat
put "<p>&nbsp;"  after allText
         ` 8             	        prefs  Qon openCard
  global gVeffect
  if gVeffect then
    set the hilite of button "On" to true
    set the hilite of button "Off" to false
  else
    set the hilite of button "On" to false
    set the hilite of button "Off" to true
  end if
  
  if the backgroundcolor of stack "records" is "lightSkyBlue" then
    set the hilitedlines of field "bgcolor" to 18
  else
    repeat with i = 1 to the number of lines of field "bgcolor"
      if line i of field "bgcolor" is the backgroundcolor of stack "records" then
        set the hilitedlines of field "bgcolor" to i
        exit repeat
      end if
    end repeat
  end if
  
  if the backgroundcolor of button 1 is "cornflowerBlue" then
    set the hilitedlines of field "btncolors" to 3
  else
    repeat with i = 1 to the number of lines of field "btncolors"
      if line i of field "btncolors" is the backgroundcolor of button 1 then
        set the hilitedlines of field "btncolors" to i
        exit repeat
      end if
    end repeat
  end if
  
  if the hilitecolor is "darkBlue" then
    set the hilitedlines of field "hilitecolor" to 5
  else
    repeat with i = 1 to the number of lines of field "hilitecolor"
      if line i of field "hilitecolor" is the hilitecolor then
        set the hilitedlines of field "hilitecolor" to i
        exit repeat
      end if
    end repeat
  end if
end openCard

    
LightSkyBlue    	 -         Preferences      U 
Helvetica   U Arial   U 
Helvetica  
 U 
Helvetica       IP
on clearStack
  
  repeat with i = 1 to 3
    put empty into field i of stack "reports"
  end repeat
  repeat with i = 6 to 8
    put empty into field i of stack "reports"
  end repeat
  put empty into field "header" of stack "reports"
  put empty into field "footer" of stack "reports"
  put ".25" into field "roundoff" of stack "reports"
  repeat with i = 8 to 29
    set the hilite of button i of stack "reports" to false
  end repeat
  set the hilite of button "all activity" of stack "reports" to true
  set the hilite of button "show activity notes" of stack "reports" to true
  set the hilite of button "show daily totals" of stack "reports" to true
  set the hilite of button "date" of stack "reports" to true
  set the disabled of button "project" of group "sort" of stack "reports" to true
  set the disabled of button "expense" of group "sort" of stack "reports" to true
  put empty into field "report" of stack "output"
  set textfont of field "report" of stack "output" to "Arial"
  set textsize of field "report" of stack "output" to "12"
  put 16 into field "lHeight" of stack "output"
  put 42 into field "lines" of stack "output"
  repeat with i = 1 to 6
    set the hilite of button i of group "sizes" of stack "output" to false
  end repeat
  set the hilite of button "12 pt" stack "output" to true
  hide group "font" of stack "output"
  
  put empty into field "projects" of stack "projects"
  put "Administration" & return & "Lunch" & return & "Phone calls" into field "tasks" of stack "tasks"
  put "Itemized" & return & "Long distance call" & return &  "Meal" & return & "Mileage,.33" into field "expenses" of stack "expenses"
  
  put the topLeft of stack "records" into topLoc
  put the loc of stack "records" into stackLoc
  put the substacks of stack "main" into temp
  repeat with i = 1 to the number of lines of temp
    --  repeat with n = 1 to the number of fields of stack (line i of temp) --**
    --    set the textFont of field n of stack (line i of temp) to "Helvetica"
    --  end repeat
    if line i of temp is "records" then next repeat
    if line i of temp is "output" or line i of temp is "invoice" then
      set the topLeft of stack line i of temp to topLoc
    else
      set the loc of stack line i of temp to stackLoc
    end if
    close stack line i of temp
  end repeat
  
  repeat with x = 1 to 6
    put empty into field x of stack "quickcheck"
  end repeat
  put empty into field "name" of stack "Register"
  put empty into field "registration" of stack "Register"
  put empty into field "temp" of stack "Register"
  put empty into field "Find" of stack "atFind"
  set the lockText of field "text" of stack "Register" to true
  set the lockText of field "readme" of stack "Register" to true
  set the traversalOn of field "main" of stack "Help" to false
  set the lockText of field "main" of stack "Help" to true
  
  send mouseUp to button "Default Settings" of stack "prefs"
  
  put "Total Time" into field "elabel" of stack "records"
  hide field "start items" of stack "records"
  hide field "end items" of stack "records"
  show button "Start timer" of stack "records"
  hide button "Stop" of stack "records"
  show group "edate" of stack "records"
  if the short name of button 10 of stack "records" is "Go" then
    set the name of button 10 of stack "records" to "Pause"
  end if
  hide button "Pause" of stack "records"
  
  put empty into field "firstdate" of stack "main"
  send mouseUp to button "delete" of stack "records"
  save stack "main"
end clearStack

on mouseUp
  -- trap
end mouseUp
               9  :  <  G  u  |                                          
  9 label1 	         	 I t            Look and Feel 
  : label2          x I             Background Color   < 
Close Window Ex   @on mouseUp
  close this stack
  topLevel "records"
end mouseUp
   dd CornflowerBlue   u    
traversal  false            	     
  G label3          I ~            
Button Color 
  u label4 	         	  t            Time Format   | timeFormat              t <  } AM/PM `D     hon mouseUp
  set twelveHourTime to true
  answer information "The time is now" && the time
end mouseUp
   dd CornflowerBlue   
  l    
traversal  false             	    ~ 24 Hrs `D     ion mouseUp
  set twelveHourTime to false
  answer information "The time is now" && the time
end mouseUp
   dd CornflowerBlue   
 l    
traversal  false             	      
LooknFeel      Mon mouseUp
  set the lookAndFeel to the hilitedButtonName of me
end mouseUp
         ` t X   Motif `D    dd CornflowerBlue   
 d l    
traversal  false             	      Windows 95 `D    dd CornflowerBlue   
  l    
traversal  false             	     
Macintosh `D    dd CornflowerBlue   
  l    
traversal  false             	         K          I l p         K           l \      bgrect   K         v I           K         I        Help Ux   on mouseUp
  visual effect plain
  get the loc of stack "main"
  if the loc of stack "help" = it then
    add 400 to item 1 of it
    set the loc of stack "help" to it
  end if
  go card "preferences" of stack "Help"
  show stack "help"
end mouseUp
   dd CornflowerBlue    o    
traversal  false            	        Default Settings Ux  on mouseUp
  global gDollarSign,gVeffect,gBgColor,gBtnColor,gHlColor
  put empty into gBgColor
  put empty into gBtnColor
  put empty into gHlColor
  if the optionKey is down then
    version
    clearStack
  end if
  repeat with i = 1 to the number of buttons
    set the hilite of button i to false
  end repeat
  set the hilite of button "Windows 95" to true
  set the hilite of button "AM/PM" to true
  set the hilite of button "On" to false
  set the hilite of button "Off" to true
  put false into gVeffect
  -- set the backgroundcolor of stack "main" to "LightSkyBlue"
  put the substacks of stack "main" into temp
  repeat with i = 1 to the number of lines of temp
    set the backgroundcolor of stack line i of temp to "LightSkyBlue"
  end repeat
  put "$" into field "symbol"
  put "$" into gDollarSign
  set the lookAndFeel to "Windows 95"
  set twelveHourTime to true
  set the hilitecolor to "darkblue"
  put "darkblue" into field "hColor"
  put "Expense" && "$" into field "ExpenseLabel" of stack "records"
  
  if the backgroundcolor of btn 1 <> "CornflowerBlue" then
    put the substacks of stack "main" into temp
    repeat with i = 1 to the number of lines of temp
      repeat with n = 1 to the number of btns of stack (line i of temp)
        set the backgroundcolor of btn n of stack (line i of temp) to "CornflowerBlue"
      end repeat
    end repeat
  end if
  openCard
end mouseUp
   dd CornflowerBlue        
traversal  false            	     
   bgColor  )x  on mouseUp
  global gBgColor
  put the hilitedlines of me into gBgColor
  setBgColor
end mouseUp

on arrowKey which
  global gBgColor
  if gBgColor is empty then
    put the hilitedlines of me into gBgColor
  end if
  put the number of lines of me into numLines
  if which is "up" then
    if gBgColor > 1 then
      subtract 1 from gBgColor
    end if
  end if
  if which is "down" then
    if gBgColor < numLines then
      add 1 to gBgColor
    end if
  end if
  setBgColor
  pass arrowkey
end arrowKey

on setBgColor
  global gBgColor
  put line gBgColor of me into zcolor
  put the substacks of stack "main" into temp
  repeat with i = 1 to the number of lines of temp
    set the backgroundcolor of stack line i of temp to zcolor
  end repeat
end setBgColor
        { a |            Aquamarine  
Burlywood  CornflowerBlue  Cyan  	DarkGray  DeepSkyBlue  ForestGreen  Gold  Gray  Green  HotPink  	Lavender  
LightBlue  LightGreen  
LightPink  LightSalmon  LightSeaGreen  
LightSkyBlue  LightYellow  
LimeGreen  Magenta  
MistyRose  Orange  Orchid  Pink  Plum  Red  
RoyalBlue  Salmon  Sienna  
SteelBlue  
Turquoise  Violet  Wheat  WhiteSmoke  Yellow       	`    @   b   
   
btnColors  )x  n
on mouseUp
  global gBtnColor
  put the hilitedlines of me into gBtnColor
  setBgColor
end mouseUp

on arrowKey which
  global gBtnColor
  if gBtnColor is empty then
    put the hilitedlines of me into gBtnColor
  end if
  put the number of lines of me into numLines
  if which is "up" then
    if gBtnColor > 1 then
      subtract 1 from gBtnColor
    end if
  end if
  if which is "down" then
    if gBtnColor < numLines then
      add 1 to gBtnColor
    end if
  end if
  setBgColor
  pass arrowkey
end arrowKey

on setBgColor
  global gBtnColor
  put line gBtnColor of me into zcolor
  
  put the substacks of stack "main" into temp
  repeat with i = 1 to the number of lines of temp
    repeat with n = 1 to the number of btns of stack (line i of temp)
      set the backgroundcolor of btn n of stack (line i of temp) to zcolor
    end repeat
  end repeat
end setBgColor
        a |            Aquamarine  
Burlywood  CornflowerBlue  Cyan  	DarkGray  DeepSkyBlue  ForestGreen  Gold  Gray  Green  HotPink  	Lavender  
LightBlue  LightGreen  
LightPink  LightSalmon  LightSeaGreen  
LightSkyBlue  LightYellow  
LimeGreen  Magenta  
MistyRose  Orange  Orchid  Pink  Plum  Red  
RoyalBlue  Salmon  Sienna  
SteelBlue  
Turquoise  Violet  Wheat  WhiteSmoke  Yellow       	`    @ s b         i         r     hcrect   K        v     
   hiliteColor  )x  on mouseUp
  global gHlColor
  put the hilitedlines of me into gHlColor
  setBgColor
end mouseUp

on arrowKey which
  global gHlColor
  if gHlColor is empty then
    put the hilitedlines of me into gHlColor
  end if
  put the number of lines of me into numLines
  if which is "up" then
    if gHlColor > 1 then
      subtract 1 from gHlColor
    end if
  end if
  if which is "down" then
    if gHlColor < numLines then
      add 1 to gHlColor
    end if
  end if
  setBgColor
  --pass arrowkey
end arrowKey

on setBgColor
  global gHlColor
  put line gHlColor of me into zcolor
  set the hilitecolor to zcolor
  put zColor into field "hColor"
  openCard
end setBgColor
        |  |            Aquamarine  
Burlywood  CornflowerBlue  Cyan  	DarkBlue  	DarkGray  DeepSkyBlue  ForestGreen  Gold  Gray  Green  HotPink  	Lavender  
LightBlue  LightGreen  
LightPink  LightSalmon  LightSeaGreen  
LightSkyBlue  LightYellow  
LimeGreen  Magenta  
MistyRose  Orange  Orchid  Pink  Plum  Red  
RoyalBlue  Salmon  Sienna  
SteelBlue  
Turquoise  Violet  Wheat  WhiteSmoke  Yellow       	`    @  !   
   label3 	          x            Highlight Color 
   version 7  
 *on mouseUp
  topLevel "main"
end mouseUp
       N # ?            v2.0.2 
   top_bg 6`    @    ,                  K         < l \   
   label7 	         
> i            Visual Effects    visualEffects            X t <   On `D     Con mouseUp
  global gVeffect
  put true into gVeffect
end mouseUp
   dd CornflowerBlue   
\ l    
traversal  false             	      Off `D     Don mouseUp
  global gVeffect
  put false into gVeffect
end mouseUp
   dd CornflowerBlue   
x l    
traversal  false             	  
   hColor  !`       |          	darkblue      
   
Symbol label         	 |            Monetary Symbol       K         `   
   Symbol  x   on mouseUp
  global gDollarSign
  put field "symbol" into zword
  ask "Enter a new monetary symbol." with zWord
  if it is empty then exit mouseUp
  put it into zword
  if length (it) > 3 then
    answer error "Symbol can't be more than 3 characters. Please try again."
    exit mouseUp
  else
    put zword into field "symbol"
    put zword into gDollarSign
    put "Expense" && zword into field "ExpenseLabel" of stack "records" 
    put "Expense" && zword into field "ExpenseLabel" of stack "main" 
  end if
end mouseUp
       -$ 4          $    Change Ux   9on mouseUp
  send mouseUp to field "symbol"
end mouseUp
   dd CornflowerBlue  G T    
traversal  false            	        	a&e logo   T *on mouseUp
  topLevel "main"
end mouseUp
        	 
 !  v3bxyxbmmւHsAC  AC|Bl%%##""RR  mm$$##!!oo""!!
_a  _aehhDn    

  ``  {{QQqq##  88  o699  ;;"RR  vv    	ZZ	



  	!!  VVhh44  `aFGfha_SWh``  RR  JJ  !!          !!##    
##  HH  YY  ƃ  !!99    KK  nn  ::    33ee    HH``  nn  RR  JJee  ]]    nn  KK!!      $%gig_a\  PP  vv  މ  ""  ss  OO  CCss    22    MM  GG

  uu  у\\  ,,oo  ""    ``  oo  ߃    HH  Â  MM܉  EE          ``  

!!  PP      12hjh]`\      oott;;  ZZ``WW  LLPPSSJJ!!    JJ  pp  ZZ``WW  LLPPSSJJՂ  
""  KK  }}      ނ  Ƃ  
HH!!  hh    MMQQTTWWmm      JJ  ނ  66OORRTTIIׂ  QQ݂  ==  ك  uu  oott;;  ނ  ݃    MMQQTTWWmm  QQhh  ""!!00    23JLJilg##  xxHH  ܂  99WW  !!  11    pp  WW  xx  XX  

      !!Â    !!    WW  MM  
    ''OOނ  ߂  SSނ    77  

  ܂  99ނ      MM  OO  	WW^ɸ  	;=:  ł  <<PP  ee  !!  ̂  xx77  jjqq  ee  	    ''    //  !!  QQ]]ffVV  qq  66  ==    ق  //gg߂  
__UU߂  SS߂  88YYcciiGG    	  PP  ߂  99  	  66  TT``ggVV  qqd|qsln	moxzEHFywhqaa  >>  ""  nn  !!    ܂  qq  nn  	̃  RR  nn((    ((  ؃  22!!  

    55  
  KK  ߇  ߂  SS߉   &&vv  ??UU  ++""  ߅      <Ry¿DGEwwlx    ee!!  qq  
!!  WW  
uu  ,,qq  qq  //    VV  ii  


  		!!  77  	    
  CC  AA߂  

߂  SS߈  LL    ݂!!  ߃    SS  	  442Kvc`Uaba<><yynx҉  LL  qq  
!!  ނ  
EE  qq  qq  jj    dd    
Ǆ  bb!!    	MM  ƃ    RR  ߂  ߂  SS߂  
''  ##ۂ    XXLL  ߂  		>>    	MM  LLaa  Qk??9FE<~|v=?>>@:]\Q}~rw
77  VVDD  ΂  ;;qq  !!    qq  qq  oo    TT        &&  !!    OO  ̄  
HH  ߂  
߂  SS߂    77  ς  ;;ނ      OO  PP  RR	lWdu1-"995ukċ  Â  ;;

  66  {{qq  !!  ă  ??qq  qq  qq    JJ!!    RRbbllqq88  AA  **!!    UUaahhkkllnnrr    RR  HHyyTT  ߂  88ZZddjjkklloo߂  SS߂  ee      zz

  66  {{ނ  ɂ  ,,  UUaahhkkllnnrr  SSȂ  Kn><2yuu      pp  !!    pp  pp  pp  ć  ``55    eeЂ    
{{!!          މ  ffނ  RRނ  ߂  [[``  >>^^    ܂  ww  ~~    TT  Kv=AEJE5z    @@  
ss    ߃  TT        XX  ۋ  ]]Ń    xx  ۉ  ۂ  nnӃ  ff  aa  ]]aa  aa  KKރ  dd    qq@@  ss``  [[ԃ  00ى  ۂ    tywr	ق:Ԇԅ؅'	نuuqqppqq	
؄
/  mmllkk!!SS  {{Ȇ  qq	    
  ""'dd         !!    ##%%uu  ""OOcc  ##  $$  !!MM
  

yyƄ  66$$  !!  tt  tttt  xxŅ  
  ##
##ww  MMRR    rr
    vv  88    rruu  ""!!wwą        !!  $$  ""ee  ss  ""!!        ss^^  ^^$$##ww  MMww$$  ##  hhww88  vv  ""  $$  !!  rr    ""  bb0dd      HH##mm    jj7##      WW  kkNN      hh  qq  11  !""  qq      dd!!  

mm  DD  FFoo  ]]  pp  ߂  

  """".hh  qq    ww  

  !!  VV  ""  qq  EEll!!  !!  .--  11  gg  22  dd  KK
  aabbddڄ  NN    ""hh̓  ddrr!!ll  //WWss  -  ee  bbcc  jj        !!mm??    ##22  ,,  ??XX[[ق  mm  MMmm  aa    ss    !!  
ll  pp  ??  mm  ~~    !!mmjj  PP  DD\\ZZ    ,,ZZ    	    @@CC8    ll  HH

dd    rrnn##  __YYII  __  aa    ccJJ    mm  jj  zz!!ۂ!!ll  ??    [[(  00  vv  LL  kk  mm        /qq  qq    xx

  //]]  ,,  !!llyy  
    177  qq  \\  __    [[  ZZ             LL    KKZZ    NNss      ˃  jj  .""  ee  ??  rr  oo    ss""߂""nn  pp    !!qq  
--ii  aa  ii  CCll  pp      LL  !!  rr  rr  aa    cc  pp  ``  00!!nn    Ƅ  77  @@  bb##  ""  !!
  qq8؂)Â5҂
҂!ڂ/&ނ

*&
	
	
	      
   instruction 	         6            HClick on, or tab to a field, then use the arrow keys to select a color.    	Register      
LightSkyBlue    	 -         	Register      U Arial  
 U 
Helvetica   U Arial  
 U Arial   U 
Helvetica   U 
Helvetica   W 
Helvetica  U 
Helvetica       I@                                    
   text  	h          D(         This version of Activity & Expense Tracker is shareware. To continue using this software after 30 days, please send a money order (in US dollars) for $35 along with your full name and either a mailing address or an e-mail address to: 
       9
     9 `
      P   Garth Catterall-Heart  !SpiritWorks Software Development  PO Box 216  Redwood Valley, CA 95470    iFor Site License information, contact the author at the address above or at aetracker@about-the-web.com.    >You may also pay by credit card or other methods by going to: 
 @      Red    = 2http://about-the-web.com/aetracker/register.shtml 
 @      Red    1   After payment is received you will be issued a registration number which will allow you to continue using the software and entitle you to Activity & Expense Tracker updates as they become available.    rThe newest version of this software will always be available at http://about-the-web.com/aetracker/download.shtml    lYour comments, suggestions and bug reports are always welcome. Please email to aetracker@about-the-web.com.    #Thank you for using this software.              	`    @ y E &    
Close Window Ex  on mouseUp
  global gRegistered
  set the name of button 2 to "License Agreement"
  hide field "readme"
  if gRegistered is "Tutorial" then
    answer question "Would you like to start by viewing the tutorial?" with "No" or "Yes"
    lock screen
    if it is "yes" then
      close this stack
      get the loc of stack "records"
      add 395 to item 1 of it
      set the loc of stack "help" to it
      --  topLevel "help"
      go card "tutorial" of stack "Help"
      show stack "help"
    else
      close this stack
      topLevel "records"
      send "setArrows" to stack "records"
    end if
    put 30 into gRegistered
  else
    close this stack
    topLevel "records"
    send "setArrows" to stack "records"
  end if
  unlock screen with visual plain
end mouseUp
   dd CornflowerBlue                 	     
   
registration  )x  $on openField
  put field "name" into temp
  if temp is empty then
    answer information "Please enter your full name exactly as registered first."
    exit openField
  end if
end openField

on closeField
  put field "name" into temp
  repeat with i = 1 to the number of words of temp
    put char 1 of word i of temp after checkReg
  end repeat
  put 0 into regNum
  repeat with i = 1 to the number of chars of temp
    add chartonum(char  i of temp) to regNum
  end repeat
  put regNum & "-" after checkReg
  put char 1 to offset("-",field "registration" ) of field "registration" into checkField
  if checkField = checkReg then
    put "registered" into field "firstdate" of card 1 of stack "main"
    save this stack
  else
    answer warning "That registration number is invalid. Please double-check " & return & " both the user name and number. Both are case sensitive."
    put empty into field "registration"
  end if
end closeField

on returnInField
  send closeField to me
end returnInField

on enterInField
  send closeField to me
end enterInField
                         
   instruction 	                      %Enter your registration number here. 
   name  )x  xon openField
  pass openField
end openField

on closeField
  global gRegistered
  if field "name" is "(temp)" then
    if field "temp" is empty then
      put the date into field "temp"
      put the date into field "firstdate" of card 1 of stack "main"
      put "Expires soon." into field "registration"
      put 7 into gRegistered
    end if
    exit closeField
  end if
  if the optionKey is "up" then exit closeField
  put field "name" into temp
  if temp is empty then
    answer "Please enter your full name exactly as registered first."
    exit closeField
  end if
  repeat with i = 1 to the number of words of temp
    put char 1 of word i of temp after checkReg
  end repeat
  put 0 into regNum
  repeat with i = 1 to the number of chars of temp
    add chartonum(char  i of temp) to regNum
  end repeat
  put regNum & "-10250" after checkReg
  put "registered" into field "firstdate" of card 1 of stack "main"
  put checkReg into field "registration"
  put true into gRegistered
  save this stack
end closeField

on returnInField
  send closeField to me
end returnInField

on enterInField
  send closeField to me
end enterInField
        x            
   
instruction1 	         x             Enter your full name here. 
   temp  !`        h                
   readme  !h          Dh         1Thanks for Installing Activity & Expense Tracker 
       0   Please read the terms of the License Agreement below. If you do not agree to the terms, close this window and quit the program. 
 @      Red       License Agreement 
         PLEASE READ THIS SOFTWARE LICENSE AGREEMENT ("THE LICENSE") BEFORE USING ACTIVITY & EXPENSE TRACKER AND ANY ACCOMPANYING FILES ("THE SOFTWARE"). THE SOFTWARE IS A PROPRIETARY PRODUCT OF SPIRITWORKS SOFTWARE DEVELOPMENT ("THE AUTHOR") AND IS PROTECTED BY COPYRIGHT LAW. BY USING THE SOFTWARE, YOU ARE AGREEING TO BE BOUND BY THE TERMS OF THIS LICENSE. IF YOU DO NOT AGREE TO THE TERMS OF THIS LICENSE, YOU MUST PROMPTLY DISPOSE OF ANY COPIES OF THE SOFTWARE IN YOUR POSSESSION.    1. License 
       
9The Software is licensed, not sold, to you by the Author. All copies and distributions of the Software which this License authorizes you to make are also governed by the terms of this License. All rights pertaining to the Software that are not expressly granted to you in this License are retained by the Author.   6In the thirty (30) days following the date on which you first installed the Software on one or more of the computers owned by you, and prior to the date on which you purchase the Software ("The Evaluation Period"), the Author grants you a non-exclusive right to use the Software on any computers owned by you.    Following the expiration of the Evaluation Period, you may continue to use the Software provided that you purchase one of the following options:    ma) A single user license for each computer on which you have installed the Software ("Single User License").    b) A license for each computer in your organization ("Site License"). Please contact the author for site licensing information at aetracker@about-the-web.com.   <The purchase of a Single User License gives you the right to continue to use the Software following the expiration of the Evaluation Period on a single computer owned by you. If you would like to use the Software on more than one computer, you must purchase multiple Single User Licenses or purchase a Site License.   }The purchase of a Site License gives you the right to continue to use the Software following the expiration of the Evaluation Period on any computer owned by you or your organization. Members, employees, or agents of your organization who use the Software are also governed by the terms of this License and you agree to inform them of the restrictions and rights contained herein.   Upon purchase of a Single User License, Site License, or at the discretion of the Author, you will be provided with a registration code ("The Registration Code"). After you enter the Registration Code into the Software, as described in the documentation accompanying the Software, the altered version of the Software ("The Registered Software"), will no longer display occasional messages. Prior to your entry of this Registration Code, the Software is considered unregistered ("The Unregistered Software").        
2. Ownership 
       Ownership of the legal rights, titles, and interest in the Software remains solely with the Author. These rights may include copyrights, trademarks, trade secrets, and other rights as applicable. You may not decompile, reverse engineer, disassemble, modify, rent, lease, loan, sublicense, distribute, duplicate, create derivative works based on the Software, or transmit the Software over a network except as expressly permitted under the terms of this License.    73. Duplication & Distribution of Unregistered Software 
       6 Prior to the expiration of the Evaluation Period, and in accordance with the other terms of this License, the Author grants you the non-exclusive right to duplicate and install the Unregistered Software on any computer.   Unless expressly prohibited by the Author, such as may be the case with non-public pre-release versions of the Software, the Unregistered Software may be distributed through the internet, electronic bulletin boards, and other computer networks, or from person to person.   Whenever the Unregistered Software is distributed, all files accompanying the Unregistered Software (the documentation, the Installer, and any other accompanying files) must be distributed along with the Unregistered Software. The accompanying files and the Unregistered Software must be distributed intact and in their original form, without modification and without exception. If the Unregistered Software and all accompanying files are contained in a single Installer program, only that Installer may be distributed.   Distributors of the Unregistered Software may not sell, charge for, or otherwise demand payment for the Unregistered Software for their own profit, or otherwise misrepresent or misconstrue the terms of the License under which the Software may be purchased by the end user.   With the consent of the Author, CD-ROM distributors may charge end users for those costs associated with the distribution of the material upon which the Unregistered Software is recorded, such as the costs associated with materials, postage, packaging, or labor. CD-ROM distributors may not attempt to make a direct profit from such charges. With the consent of the Author, CD-ROM distributors may provide end users with copies of the Unregistered Software free-of-charge for the purpose of promoting or marketing another product by which the distributors hope to make a profit (such as a magazine), as long as the other terms of this License with respect to the distribution of the Unregistered Software are met.    94. Duplication & Distribution of the Registered Software 
       8 The Author grants the purchaser of a Single User License the right to make two (2) copies of the Registered Software for their own personal archival purposes, for as many computers as they have purchased Single User Licenses.   The purchaser of a Single User License may duplicate the Registered Software and install it on a computer different from the computer for which the Single User License was purchased, provided that the Registered Software on the original computer is then promptly deleted.    The purchaser of a Site License may duplicate and install the Registered Software on any machine governed by the terms of the Site License as detailed in section one (1) of this License.    You may not distribute the Registered Software in any other way, including but not limited to any computer-readable material, floppy disk, CD-ROM, computer network, electronic bulletin-board service, or the Internet.   The Registration Code may not be distributed in any way, including but not limited to any computer-readable material, floppy disk, CD-ROM, computer network, electronic bulletin board service, the Internet, oral, written, or signed communication, telephone, telegraph, or fax machine. You may store the Registration Code for your own personal use for the purpose of reinstalling the Software as necessary on the computer or computers governed by the terms of this License.    )5. Warranty and limitations of liability 
       (%THE SOFTWARE IS PROVIDED "AS IS". USE THE SOFTWARE AT YOUR OWN RISK. THE AUTHOR MAKES NO WARRANTIES AS TO PERFORMANCE, MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR ANY OTHER WARRANTIES WHETHER EXPRESSED OR IMPLIED. NO ORAL OR WRITTEN COMMUNICATION FROM OR INFORMATION PROVIDED BY THE AUTHOR OR SPIRITWORKS SOFTWARE DEVELOPMENT SHALL CREATE A WARRANTY. UNDER NO CIRCUMSTANCES SHALL THE AUTHOR OR SPIRITWORKS SOFTWARE DEVELOPMENT BE LIABLE FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES RESULTING FROM THE USE, MISUSE, OR INABILITY TO USE THE SOFTWARE, EVEN IF THE AUTHOR HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. THESE EXCLUSIONS AND LIMITATIONS MAY NOT APPLY IN ALL JURISDICTIONS. YOU MAY HAVE ADDITIONAL RIGHTS AND SOME OF THESE LIMITATIONS MAY NOT APPLY TO YOU.    In no event shall the Author's total liability to you for actual damages, from any cause whatsoever and regardless of the form of the action, whether in contract, product liability, tort (including negligence), or otherwise, exceed US $35.    
6. Export 
       	 You agree to comply with the laws and regulations of the United States of America and other countries regarding the export of computer software as those laws and regulations pertain to the Software governed by this License.    7. Governing law 
        hThis License shall be governed by the laws of the State of California and the United States of America.    8. Severability 
       JIf for any reason a court of competent jurisdiction finds any provision of this License, or portion thereof, to be unenforceable, that provision of the License shall be enforced to the maximum extent permissible so as to effect the intent of the parties, and the remainder of this License shall continue in full force and effect.    9. Amendments 
       
This License constitutes the entire agreement between the parties with respect to the use of the Software and supersedes any prior agreements or understandings. No amendment to this License will be binding unless agreed to and signed by the Author in writing.      Copyrights 
 @      Red    
   Activity & Expense Tracker(TM)  >2000 Garth Catterall-Heart, SpiritWorks Software Development  All Rights Reserved Worldwide    qYour comments and suggestions are always welcome. You may e-mail them to aetracker@about-the-web.com or mail to:  Garth Catterall-Heart  !SpiritWorks Software Development  PO Box 216  Redwood Valley, CA 95470  $http://about-the-web.com/aetracker/         	`    @ y E f    License Agreement Ex   on mouseUp
  if the visible of field "readme" then
    set the name of me to "License Agreement"
    hide field "readme"
  else
    set the name of me to "Close License Agreement"
    show field "readme"
  end if
end mouseUp
   dd CornflowerBlue                   	        	a&e logo   T uon mouseUp
  global gReturnStack
  put the short name of this stack into gReturnStack
  topLevel "main"
end mouseUp
         
 !  v3bxyxbmmւHsAC  AC|Bl%%##""RR  mm$$##!!oo""!!
_a  _aehhDn    

  ``  {{QQqq##  88  o699  ;;"RR  vv    	ZZ	



  	!!  VVhh44  `aFGfha_SWh``  RR  JJ  !!          !!##    
##  HH  YY  ƃ  !!99    KK  nn  ::    33ee    HH``  nn  RR  JJee  ]]    nn  KK!!      $%gig_a\  PP  vv  މ  ""  ss  OO  CCss    22    MM  GG

  uu  у\\  ,,oo  ""    ``  oo  ߃    HH  Â  MM܉  EE          ``  

!!  PP      12hjh]`\      oott;;  ZZ``WW  LLPPSSJJ!!    JJ  pp  ZZ``WW  LLPPSSJJՂ  
""  KK  }}      ނ  Ƃ  
HH!!  hh    MMQQTTWWmm      JJ  ނ  66OORRTTIIׂ  QQ݂  ==  ك  uu  oott;;  ނ  ݃    MMQQTTWWmm  QQhh  ""!!00    23JLJilg##  xxHH  ܂  99WW  !!  11    pp  WW  xx  XX  

      !!Â    !!    WW  MM  
    ''OOނ  ߂  SSނ    77  

  ܂  99ނ      MM  OO  	WW^ɸ  	;=:  ł  <<PP  ee  !!  ̂  xx77  jjqq  ee  	    ''    //  !!  QQ]]ffVV  qq  66  ==    ق  //gg߂  
__UU߂  SS߂  88YYcciiGG    	  PP  ߂  99  	  66  TT``ggVV  qqd|qsln	moxzEHFywhqaa  >>  ""  nn  !!    ܂  qq  nn  	̃  RR  nn((    ((  ؃  22!!  

    55  
  KK  ߇  ߂  SS߉   &&vv  ??UU  ++""  ߅      <Ry¿DGEwwlx    ee!!  qq  
!!  WW  
uu  ,,qq  qq  //    VV  ii  


  		!!  77  	    
  CC  AA߂  

߂  SS߈  LL    ݂!!  ߃    SS  	  442Kvc`Uaba<><yynx҉  LL  qq  
!!  ނ  
EE  qq  qq  jj    dd    
Ǆ  bb!!    	MM  ƃ    RR  ߂  ߂  SS߂  
''  ##ۂ    XXLL  ߂  		>>    	MM  LLaa  Qk??9FE<~|v=?>>@:]\Q}~rw
77  VVDD  ΂  ;;qq  !!    qq  qq  oo    TT        &&  !!    OO  ̄  
HH  ߂  
߂  SS߂    77  ς  ;;ނ      OO  PP  RR	lWdu1-"995ukċ  Â  ;;

  66  {{qq  !!  ă  ??qq  qq  qq    JJ!!    RRbbllqq88  AA  **!!    UUaahhkkllnnrr    RR  HHyyTT  ߂  88ZZddjjkklloo߂  SS߂  ee      zz

  66  {{ނ  ɂ  ,,  UUaahhkkllnnrr  SSȂ  Kn><2yuu      pp  !!    pp  pp  pp  ć  ``55    eeЂ    
{{!!          މ  ffނ  RRނ  ߂  [[``  >>^^    ܂  ww  ~~    TT  Kv=AEJE5z    @@  
ss    ߃  TT        XX  ۋ  ]]Ń    xx  ۉ  ۂ  nnӃ  ff  aa  ]]aa  aa  KKރ  dd    qq@@  ss``  [[ԃ  00ى  ۂ    tywr	ق:Ԇԅ؅'	نuuqqppqq	
؄
/  mmllkk!!SS  {{Ȇ  qq	    
  ""'dd         !!    ##%%uu  ""OOcc  ##  $$  !!MM
  

yyƄ  66$$  !!  tt  tttt  xxŅ  
  ##
##ww  MMRR    rr
    vv  88    rruu  ""!!wwą        !!  $$  ""ee  ss  ""!!        ss^^  ^^$$##ww  MMww$$  ##  hhww88  vv  ""  $$  !!  rr    ""  bb0dd      HH##mm    jj7##      WW  kkNN      hh  qq  11  !""  qq      dd!!  

mm  DD  FFoo  ]]  pp  ߂  

  """".hh  qq    ww  

  !!  VV  ""  qq  EEll!!  !!  .--  11  gg  22  dd  KK
  aabbddڄ  NN    ""hh̓  ddrr!!ll  //WWss  -  ee  bbcc  jj        !!mm??    ##22  ,,  ??XX[[ق  mm  MMmm  aa    ss    !!  
ll  pp  ??  mm  ~~    !!mmjj  PP  DD\\ZZ    ,,ZZ    	    @@CC8    ll  HH

dd    rrnn##  __YYII  __  aa    ccJJ    mm  jj  zz!!ۂ!!ll  ??    [[(  00  vv  LL  kk  mm        /qq  qq    xx

  //]]  ,,  !!llyy  
    177  qq  \\  __    [[  ZZ             LL    KKZZ    NNss      ˃  jj  .""  ee  ??  rr  oo    ss""߂""nn  pp    !!qq  
--ii  aa  ii  CCll  pp      LL  !!  rr  rr  aa    cc  pp  ``  00!!nn    Ƅ  77  @@  bb##  ""  !!
  qq8؂)Â5҂
҂!ڂ/&ނ

*&
	
	
	      
   top_bg 6`    @    ,            
   version 7  
 uon mouseUp
  global gReturnStack
  put the short name of this stack into gReturnStack
  topLevel "main"
end mouseUp
       Y # 3            v2.0.2 
   
copyright    
       / 5L          @ 2000, Garth Catterall-Heart, SpiritWorks Software Development    
Print Dialog    w        Black  
LightSkyBlue ffffff      white       	darkgray              
Print Dialog      U 
Helvetica       	@                       
   
instructions               L          #Select a destination for printing.      
   printer  9h            P4                
   file  9h            n4                 i         ,  `   Default Printer @D     on mouseUp
  set the disabled of field "printer" to true
  set the disabled of field "file" to true
  set the label of button "print" to "Print"
end mouseUp
   dd CornflowerBlue     0 |              	  	        Specify Printer @D     on mouseUp
  set the disabled of field "printer" to false
  set the disabled of field "file" to true
  select last char of field "printer"
  set the label of button "print" to "Print"
end mouseUp
   dd CornflowerBlue     P |              	      Postscript file @D     on mouseUp
  set the disabled of field "printer" to true
  set the disabled of field "file" to false
  select last char of field "file"
  set the label of button "print" to "Save"
end mouseUp
   dd CornflowerBlue     p t              	      Print mx    on mouseUp
  if field "report" of stack "output" is empty then
    beep
    exit mouseUp
  end if
  set the printrotated to true
  set the printmargins to 50,50,50,50
  if the hilite of btn 3 then
    put field "Postscript file" into zFile
    if zFile is empty then exit mouseUp
    set the printCommand to "mv %s zFile" --$HOME/certificate.ps"
  else
    if the hilite of btn 1 then
      set the printCommand to "lp -c %s"
    else
      put field "Specify Printer" into zPrinter
      if zPrinter is empty then exit mouseUp
      set the printCommand to "lp -c %s -P zPrinter"
    end if
  end if
  
  put field "report" of stack "output"  into zText
  put line 1 of field "report" of stack "output"  into zheader
  put 1 into pageNum
  lock screen
  repeat while length(zText)>0
    if pageNum > 1 then
      put zHeader && "- page" && pageNum & return & return & line 1 to 26 of zText into field "report" of card 2 of  stack "output"
    else
      put line 1 to 26 of zText into field "report" of card 2 of  stack "output"
    end if
    print card 2 of stack "output"
    print break
    delete line 1 to 26 of zText
    add 1 to pageNum
  end repeat
  close printing
  close this stack
end mouseUp
   dd CornflowerBlue   P  p      Print          	        Cancel Ex     +on mouseUp
  close this stack
end mouseUp
   dd CornflowerBlue      p              	       a Ask Dialog   ron openCard
end openCard

on preOpenCard
end preOpenCard

on closeCard
end closeCard

on openStack
end openStack
    
LightSkyBlue    1 @                     U 
Helvetica       	P
;on doresize
  local twidth, iwidth
  put the width of this stack into twidth
  set the width of field 1 to twidth - 64
  set the left of field 1 to 48
  set the width of field 2 to twidth - 64
  set the left of field 2 to 48
  set the top of field 2 to the bottom of field 1
  set the top of button 1 to the height of field 1 div 2 - 8
  put (twidth - 120 ) div 3 into iwidth
  put iwidth into twidth
  set the default of button 2 to false
  repeat with i = 2 to the number of buttons
    set the left of button i to twidth
    set the bottom of button i to the height of this stack - 12
    add the width of button i + iwidth to twidth
  end repeat
  set the default of button 2 to true
end doresize

on star
  local tstring
  put empty into tstring
  repeat with i = 1 to the number of characters in field 3
    put "*" after tstring
  end repeat
  put tstring into field 2
end star

on preOpenStack
  local twidth
  set the itemDelimiter to numToChar(0)
  if word 2 of item 1 of the dialogData is "password"
  then set the fieldmode of me to "password"
  else set the fieldmode of me to "plain"
  if item 2 of the dialogData is empty
  then set the title of this stack to space
  else set the title of this stack to item 2 of the dialogData
  put item 3 of the dialogData into field 1
  put max(the formattedWidth of field 1 + 64,\
      the formattedWidth of field 2 + 64, 320) into twidth
  set the width of this stack to twidth
  set the height of field 1 to the formattedHeight of field 1
  set the top of field 1 to 8
  set the height of this stack to (the height of field 1) + 100
  doresize
  if the fieldmode of me is not "plain" then
    put item 4 of the dialogData into field 3
    star
  else put item 4 of the dialogData into field 2
  set the dialogData to numToChar(0)
  set the itemDelimiter to comma
  set the icon of button 1 to item itemOffset(the lookAndFeel,"Motif,Macintosh,Windows 95") of "330,994,998"
end preOpenStack

on keyDown which
  local tpos
  if the name of the target contains "field" and the fieldmode of me is not "plain" then
    put the selectedChunk into tpos
    put which into character (word 2 of tpos) to (word 4 of tpos) of field 3
    star
    select after character (word 2 of tpos) of field 2
  else pass keyDown
end keyDown

on deleteKey
  if the fieldmode of me is not "plain"
  then deleteone
  else pass deleteKey
end deleteKey

on backspaceKey
  if the fieldmode of me is not "plain"
  then deleteone
  else pass backspaceKey
end backspaceKey

on deleteone
  local tpos
  put word 2 of the selectedChunk into tpos
  put empty into character (tpos - 1) of field 3
  star
  select before character (tpos - 1) of field 2
end deleteone

on commandKeyDown which
  if the fieldmode of me is not "plain"
  then
    local tpos
    switch which
    case "D"
      put word 2 of the selectedChunk into tpos
      put empty into character tpos of field 3
      star
      select before character tpos of field 1
      break
    case "H"
      deleteone
      break
    default
      pass commandKeyDown
    end switch
  else pass commandKeyDown
end commandKeyDown

on openField
  select the text of the target
end openField

on resizeStack
  doresize
end resizeStack

on returnInField
  click at the loc of button "OK"
end returnInField

on closeStack
  put empty into field 1
  put empty into field 2
  put empty into field 3
end closeStack
          @    
fieldmode  plain  a    _  \  ]  `
                0                  \ OK Lx     on mouseUp
  switch the fieldmode of this card
  case "plain"
    get field 2
    break
  case "clear"
    get field 3
    break
  case "password"
    get mcencrypt(field 3)
    break
  end switch
  set the dialogData to it
  close this stack
end mouseUp
   dd CornflowerBlue    B \ 4             	     ] Cancel Dx     +on mouseUp
  close this stack
end mouseUp
   dd CornflowerBlue     \ <             	   
  _   h           0 (              
  `   
!h           b 8 |             a New Button BH      dd CornflowerBlue      $ (          	      Answer Dialog   on resizeStack
end resizeStack

on openStack
end openStack

on preOpenCard
end preOpenCard

on openCard
end openCard

on closeCard
end closeCard
    
LightSkyBlue        macintoshIcons  992,993,994,995motifIcons  328,329,330,331windows95Icons  996,997,998,999                U 
Helvetica       	P*on preOpenStack
  local dtype, foffset, oldwidth, bwidth, twidth, iwidth, theight, curx, nchoices
  set the itemDelimiter to numToChar(0)
  if word 2 of item 1 of the dialogData is "plain" then
    hide button 1
    put 0 into foffset
  else
    show button 1
    switch the lookAndFeel
    case "Motif"
      get the motifIcons of this stack
      break
    case "Macintosh"
      get the macintoshIcons of this stack
      break
    default
      get the windows95Icons of this stack
    end switch
    put word 2 of item 1 of the dialogData into dtype
    set the itemDelimiter to comma
    set the icon of button "icon" to item itemOffset(dtype, "error,information,question,warning") of it
    set the itemDelimiter to numToChar(0)
    put 40 into foffset
  end if
  if item 2 of the dialogData is empty
  then set the title of this stack to space
  else set the title of this stack to item 2 of the dialogData
  put item 3 of dialogData into field 1
  get item 4 of dialogData
  if it is empty then get "OK"
  put the number of lines in it into nchoices
  put 32 into bwidth
  if nchoices > the number of buttons - 1
  then put the number of buttons - 1 into nchoices
  repeat with i = 2 to nchoices + 1
    show button i
    set the name of button i to line nchoices + 2 - i of it
    set the width of button i to the formattedWidth of button i + 24
    add the width of button i + 32 to bwidth
  end repeat
  set the dontWrap of field 1 to true
  put max(the formattedWidth of field 1 + foffset + 16, bwidth) into twidth
  if twidth > 600 then
    put 600 into twidth
    set the width of field 1 to twidth - foffset + 16
    set the dontWrap of field 1 to false
  end if
  put the width of this stack into oldwidth
  set the width of this stack to twidth
  put the formattedHeight of field 1 + 68 into theight
  if theight > 400 then
    set the vScrollbar of field 1 to true
    put 400 into theight
  else set the vScrollbar of field 1 to false
  set the height of this stack to theight
  set the height of field 1 to theight - 68
  set the top of button 1 to the height of field 1 div 2 - 12
  set the topLeft of field 1 to foffset + 8, 8
  put (twidth - bwidth) div (nchoices + 1) + 32 into iwidth
  put iwidth into curx
  if the lookAndFeel is "Macintosh" then
    repeat with i = nchoices + 1 down to 2
      set the left of button i to round(curx)
      add the width of button i + iwidth to curx
      set the bottom of button i to the height of this stack - 16
    end repeat
  else
    repeat with i = 2 to nchoices + 1
      set the left of button i to round(curx)
      add the width of button i + iwidth to curx
      set the bottom of button i to the height of this stack - 16
    end repeat
  end if
  set the default of button 2 to true
  set the dialogData to empty
end preOpenStack

on closeStack
  repeat with i = 3 to the number of buttons
    hide button i
  end repeat
  set the default of button 2 to false
end closeStack

on mouseUp
  if the name of the target contains "button" then
    set the dialogData to the short name of the target
    close this stack
  end if
end mouseUp
              z                
     H           0 h D           5This record is missing information about the project  ) and will not be included in any report.  6All records must designate a Project and an Activity.   z icon BX     on mouseUp
end mouseUp
   dd CornflowerBlue      , (         	      
Fix later Dh      dd CornflowerBlue      Z R            	      Delete Record Dh      dd CornflowerBlue     Z z            	      Fix now Dh      dd CornflowerBlue   , Z P            	      All Dh      dd CornflowerBlue   | 6 /            	      y Dh      dd CornflowerBlue     4 '            	      x Dh      dd CornflowerBlue    i 4 '            	      w Dh      dd CornflowerBlue      4 )            	     	 atFind      
LightSkyBlue    ' T          Find      U 
Helvetica   U 
Helvetica   W 
Helvetica    
Find Card   	PHon ATFind
  global gFoundOne,gString,gFindStack
  local thilited, tstring
  set the cursor to watch
  put the hilitedButton of group 1 into thilited
  put field "Find" into tstring
  if field "Find" <> gString then put false into gFoundOne
  put tstring into gString
  
  set the caseSensitive to the hilite of button "case sensitive"
  set the defaultStack to gFindStack
  if thilited is 1
  then find tstring
  else if thilited is 2
  then find whole tstring
  
  if the result is empty then put true into gFoundOne
  if the result is "not found" and gFoundOne then
    answer information "No more found."
  else
    if the result is "not found" then
      answer information "Not found."
    end if
  end if
end ATFind

on openCard
  global gFoundOne
  put false into gFoundOne
end openCard

on returnInField
  ATFind
end returnInField
           T               	   Type             =     partial words  D      dd CornflowerBlue     A h             	      whole words  D      dd CornflowerBlue    p A j             	     Search Lx   !on mouseUp
  ATFind
end mouseUp
   dd CornflowerBlue     _ t            	      Help Dx  on mouseUp
  answer information "You can search for the first part of a word," & return \
& "or search for one or more whole words. " & return &\
"You may want to move the search window so that " & return &\ 
"you can see all the fields in the window being searched."
end mouseUp
   dd CornflowerBlue     _ T            	   
   Find  )`         D              case sensitive  D      dd CornflowerBlue     A x             	   
   instruction 	         H            4Enter a partial or whole word, or a phrase to find.   	 Close Dx   (on mouseUp
hide this stack
end mouseUp
   dd CornflowerBlue     _ T            	      output   2on closeStack
  hide group "font"
end closeStack
  w        Black  
LightSkyBlue ffffff      white       	darkgray    	 -         Report    G  U Arial   U Arial   W Arial   U 
Helvetica  
 U 
Helvetica  
 U Arial   U 
Helvetica   U 
AGaramond   U AGaramond Bold   U AGaramond SemiboldItalic   U Arial Black   U 	Percival   U 	Palatino   U OldCentury   U 	New York   U Poster  
 U AGaramond SemiboldItalic   U AGaramond SemiboldItalic   U AGaramond Bold   U Arial  	 U Arial   U Arial   U Arial   U Block   U Chicago   U Chicago   U 	Charcoal  
 U 	Charcoal   U 	Charcoal   U AGaramond Semibold   U AGaramond Italic   U AGaramond BoldItalic  
 U AGaramond BoldItalic   U AGaramond BoldItalic   U AGaramond BoldItalic   U AGaramond BoldItalic   U AGaramond Semibold   U Arial Black   U 
.Keyboard   U Andale Mono   U AGaramond Italic   U 
Arial Narrow   U 
AGaramond   U AGaramond Bold   U Block   U Bookman Old Style   U Broadway BT   U 	Capitals   U 	Capitals   U Block  
 U Block  
 U 
Calligrapher  
 U 	Capitals   U Cornerstone   U Geneva   U GarthGraphic ExtraBold   U Herald   U Impact   U Metro   U 
Arial Narrow   U Andale Mono  	 U 
AGaramond   U 
AGaramond   U 
Helvetica   U Arial Rounded MT Bold   U Arial Black  	 U Arial Black   U Andale Mono   U AGaramond Italic   U 
AGaramond   U AGaramond SemiboldItalic       	@                         print   	@            
   report )x   
on commandKeyDown which
  if which is "a" then
    select text of field "report"
  else
    pass commandKeyDown
  end if
end commandKeyDown
         h 
 
 
 
    @          `    @ c  y       a    @  
W     Print Ex  on mouseUp
  if (the platform contains "Mac") or (the platform contains "Win") then
    answer printer
    if the result is "Cancel" then
      exit to metaCard
    end if
    --  set the printrotated to true
    set the printmargins to 50,50,50,50
    open printing with dialog
    if the result is "Cancel" then
      exit to metaCard
    end if
  else
    --   set the printCommand to "lp -c %s"
    --  open printing
    topLevel "Print Dialog"
    show stack "Print Dialog"
    exit mouseUp
  end if
  put field "report" of stack "output"  into zText
  put field "lines" into zLines
  put line 1 of field "report" of stack "output"  into zheader
  put 1 into pageNum
  lock screen
  set the height of this stack to 720
  repeat while length(zText)>0
    if pageNum > 1 then
      put zHeader && "- page" && pageNum & return & return & \
          line 1 to zLines of zText into field "report" of card 2 of  stack "output"
    else
      put line 1 to zLines of zText into field "report" of card 2 of  stack "output"
    end if
    print card 2 of stack "output"
    print break
    delete line 1 to zLines of zText
    add 1 to pageNum
  end repeat
  close printing
  set the height of this stack to 450
end mouseUp
   dd CornflowerBlue    ( i             	        Save as... Ex  on mouseUp
  put the title of stack "output" & ".txt" into temp
  ask file "Save this report as..." with temp
  if the result is "Cancel" then exit mouseUp
  put checkExt(it) into fileName
  open file fileName for write
  if the result is empty then
    write field "report" of stack "output" to file fileName
    close file fileName
  else
    answer "There was a problem saving this file." & return & the result & return & sysError()
  end if
end mouseUp
   dd CornflowerBlue     i             	        
Close Window Ex   @on mouseUp
  close this stack
  topLevel "reports"
end mouseUp
   dd CornflowerBlue                 	     
   report )h         
 
 
 
    @   All Project Report - page 3    KActivity Notes = brother ad code changes, add new ad & button to all pages    6Sunday, October 22	SmallBusinessDepot	Daily News	1.00    >Monday, October 23	SmallBusinessDepot	Misc. Site Changes	1.50  &Activity Notes = remove brother blurb    7Tuesday, October 24	SmallBusinessDepot	Daily News	0.00    6Totals for this report:	$1550.00	31.00 Billable Hours    		0 Non-Billable Hours        Font... Ex  ~on mouseUp
  lock screen
  put the fontNames into field "fonts"
  sort field "fonts"
  repeat with i = 1 to the number of lines of field "fonts"
    if the textfont of field "report" is line i of field "fonts" then
      set the hilitedlines of field "fonts" to i
      exit repeat
    end if
  end repeat
  show group "font"
  unlock screen with visual barn door open
end mouseUp
   dd CornflowerBlue   8 i             	        font   a       ( P4   font bg E`  dd CornflowerBlue   , H,             	       
 bgrect   K@            2 <    
    fonts  )x   won mouseUp
  put the hilitedlines of me into temp
  set the textfont of field "report" to line temp of me
end mouseUp
       <              
.Keyboard  
AGaramond  AGaramond Bold  AGaramond BoldItalic  AGaramond Italic  AGaramond Semibold  AGaramond SemiboldItalic  Andale Mono  Arial  Arial Black  
Arial Narrow  Arial Rounded MT Bold  Bauer Bodoni Bold BT  Bauer Bodoni Bold Italic BT  Bauer Bodoni BT  Bauer Bodoni Italic BT  Biorst  Block  Bookman Old Style  Bookman Old Style Bold  Broadway BT  
Calligrapher  	Capitals  	Charcoal  Chicago  Comic Sans MS  Cooper Black BT  Cooper Bold BT  Cooper Bold Italic BT  Cooper Light BT  Cooper Light Italic BT  Copperplate Gothic Bold BT   Copperplate Gothic Condensed BT  Cornerstone  
Cotillion  Courier  Courier New  Diner  Diploma  
Emerald Isle  FifthAvenue  	Fillmore  Fitzgerald  Friz Quadrata  Gadget  
GarthGraphic  GarthGraphic Black  GarthGraphic Bold  GarthGraphic BoldCondensed  GarthGraphic BoldItalic  GarthGraphic Condensed  GarthGraphic ExtraBold  GarthGraphic Italic  Geneva  Georgia  Heather  
Helvetica  Herald  Impact  Mariah  Market  Metro  Moderne  
Moderne-Demi  Moderne-DemiOblique  Moderne-Oblique  Monaco  Monotype Sorts  
Monotype.com  	MT Extra  	New York  NuptialScript  OldCentury  	Palatino  	Percival  	Pickwick  Playbill BT  Poster  PressWriter Symbols  Pythagoras  Quill  	Scribble  Sedona  	Sherwood  
Signature  
Signboard  	Standout  Steamer  
Storybook  Subway  Symbol  Times  Times New Roman  Transistor  
Trebuchet MS  University Roman Bold BT  University Roman BT  VAG Rounded BT  Verdana  	Webdings  
Wingdings  Zapf Dingbats       	`    @        Close Ex   bon mouseUp
lock screen
  hide group "font"
unlock screen with visual barn door close
end mouseUp
   dd CornflowerBlue   @ L              	     
   inst 	        4             +Pick a font face and size for your report.   
 sizes   i   on mouseUp
  set the textSize of field "report" to word 1 of the hilitedButtonName of me
  put the textHeight of field "report" into field "lheight"
end mouseUp
       $  @    9 pt @D  dd CornflowerBlue   (  8              	   	        10 pt @D  dd CornflowerBlue   (  8              	      11 pt @D  dd CornflowerBlue   (  8              	      12 pt @D  dd CornflowerBlue   (  8              	    	 14 pt @D  dd CornflowerBlue   ( 8              	      16 pt @D  dd CornflowerBlue   (* 8              	   
   label4 	         t            Lines per page 
   label3 	        8h  ,           PAfter making changes you may need to adjust the lines printed per page (below). 
   label2 	        $@ B ,           Line Height 
   lheight  7)x  on mouseUp
  put field "lheight" into temp
  put the hilitedButtonName of group "sizes" into tsize
  ask "Enter a new line height > " & tsize &"." with temp
  if it is empty or it is not a number or it < tsize then
    answer information "You must enter a number larger than the font size."
    exit mouseUp
  end if
  put it into field "lheight"
  set the textHeight of field "report" to it
end mouseUp
       ,h '            16 
   lines  7)x   on mouseUp
  put field "lines" into temp
  ask "How many lines per page would you like to print?" with temp
  if it is empty or it is not a number then exit mouseUp
  put it into field "lines"
end mouseUp
       , '            42    Tabs Ex  on mouseUp
  global gTabs
  answer question "Set the tab stops of the report field to" with "Wide" or "Medium" or "Narrow" or "Custom"
  switch it
  case "narrow"
    put "150,325,500" into gTabs
    set the tabstops of field "report" to gTabs
    break
    
  case "medium"
    put "165,350,525" into gTabs
    set the tabstops of field "report" to gTabs
    break
    
  case "wide"
    put "200,400,550" into gTabs
    set the tabstops of field "report" to gTabs
    break
    
  case "Custom"
    ask "Set the tab stops of the report field to" with gTabs
    if it is empty then exit mouseUp
    put true into flag
    repeat with i = 1 to 3
      if item i of it is a number then
        put true into flag
      else
        put false into flag
      end if
    end repeat
    if flag then
      set the tabstops of field "report" to it
      put it into gTabs
    end if
  end switch
end mouseUp
   dd CornflowerBlue    4              	     	      activities   on openCard
  put field "tasks" of stack "tasks" into  field "tasks"
end openCard

on returnKey
  checkFocus
end returnKey

on enterKey
  checkFocus
end enterKey

on closeStack
  save this stack
end closeStack

on checkFocus
    send mouseUp to button "Choose Activities"
end checkFocus
            
LightSkyBlue    " ^,         Activities      U Arial   U Arial   U 
Helvetica   U 
helvetica   W Arial   W 
Helvetica       	@          ^,        
   tasks #	x   \on mouseUp
  global gTasks
  put the hilitedlines of field "tasks" into gTasks
end mouseUp
         8             Administration  Daily News,50.00/hr  Events Update,50.00/hr  Lunch  Misc. Site Changes,50.00/hr  Newsletter,50.00/hr  Phone calls  Programming,50.00/hr       `    @   9      Choose Activities Mx  
on mouseUp
  global gTasks, gStack
  if the hilitedlines of field "tasks" > 0 then
    put the hilitedlines of field "tasks" into gTasks
  end if
  if gTasks is empty then
    answer information "First select or create an Activity."
    exit mouseUp
  end if
    put empty into field "task" of stack gStack
  repeat with i = 1 to the number of items of gTasks
    put line (item i of gTasks) of field "tasks" into line i of field "task" of stack gStack
  end repeat
  put empty into gTasks
  close this stack
end mouseUp
   dd CornflowerBlue     :  %            	     
   instruction 	         
 J 6           ZSelect one or more activities from the list on the left and then click Choose Activities.    
Close Window Ex   +on mouseUp
  close this stack
end mouseUp
   dd CornflowerBlue                   	        quickcheck  on checkDate
  put field "start date" into startDate
  if field "end date" is empty then
    put startDate into field "end date"
  end if
  put field "end date" into endDate
  if startDate is empty or endDate is empty then exit checkDate
  
  convert startDate to dateItems
  convert endDate to dateItems
  
  if item 4 of startDate > item 4 of endDate then
    add 24 to item 4 of endDate -- add 24 hours
    subtract 1 from item 3 of endDate
  end if
  if item 3 of startDate > item 3 of endDate then
    put daysofmonth(item 2 of startDate,item 1of startDate) into zdays
    add zdays to item 3 of endDate -- add about 30 days
    subtract 1 from item 2 of endDate
  end if
  if item 2 of startDate > item 2 of endDate then
    add 12 to item 2 of endDate -- add 12 months
    subtract 1 from item 1 of endDate
  end if
  
  repeat with i = 1 to 3
    if (item i of startDate > item i of endDate) then
      abortqc
      exit to metaCard
    end if
  end repeat
end checkDate

on abortqc
  global gStartDate, gEndDate, gDateField

  if gDateField is "start date" then
    put gStartDate into field "start date"
  else
    put gEndDate into field "end date"
  end if
  answer error "The end date is before the start date. " & return & "Please enter a new date."
end abortqc
            
LightSkyBlue    " A^         Quick Check      U Arial   U Arial   U 
Helvetica   U 
helvetica   W Arial   W 
Helvetica  
 U 
Helvetica       	@          ^          
                        	                   Recalculate Mx  on mouseUp
  global gDollarSign, gNodata, gDollars, gBillHours
  put 0 into gBillHours
  put 0 into gDollars
  put field "start date"  into startDate
  if startDate is a date then
    convert startDate to seconds
  end if
  put field "end date" into endDate
  if endDate is a date then
    convert endDate to seconds
  end if
  put field "project" into whichProject
  if whichProject is empty  then
    answer information "You need to select a project."
    exit mouseUp
  end if
  put field "task" into whichTask
  if whichTask is empty and not the hilite of button "all activity" then
    answer information "You need to select an activity."
    exit mouseUp
  end if
  if whichProject is empty then exit mouseUp
  
  put true into gNodata
  put "records" into zstack
  repeat with cardnum = 1 to the number of cards of stack "records"
    set cursor to busy
    checkRecord cardnum, zstack,whichProject,whichTask,startDate,endDate
  end repeat
  
  if gNodata then
    put 0 && "hrs" && 0 && "mins" into  field "time"
    put gDollarSign  & 0 into field "money"
    answer information "There were no records found for this period."
  else
    set the numberFormat to 0.00
    put gDollarSign  & gDollars into field "money"
    put offset(".",gBillHours) into decPoint
    put char 1 to (decPoint -1) of gBillHours into zhours
    put char decPoint to length(gBillHours) of gBillHours into temp
    put round(60 * temp) into zmins
    set the numberFormat to 0
    put zhours && "hrs" && zmins && "mins" into  field "time"
  end if
end mouseUp

on checkRecord cardnum, zstack,whichProject,whichTask,startDate,endDate
  global gDollarSign, gNodata, gDollars, gBillHours
  put field "elapsed" of card cardnum of stack zstack into eTime
  put field "start date" of card cardnum of stack zstack into theDate
  if word 2 of eTime <> "hrs" then exit checkRecord
  convert theDate to seconds
  
  --if (startDate <> "all" and endDate <> "all") and (theDate < startDate) or (theDate > endDate) then exit checkRecord
  if startDate <> "first" and theDate < startDate then exit checkRecord
  if  theDate > endDate then exit checkRecord
  put field "task" of card cardnum of stack zstack into theTask
  put field "project" of card cardnum of stack zstack into theProject
  
  if theProject <> whichProject then exit checkRecord
  if theTask <> whichTask AND not the hilite of button "all activity" then exit checkRecord
  
  put false into gNodata
  set the numberFormat to 0.00
  put word 1 of eTime  into taskTime -- hours
  add (word 3 of eTime/60) to taskTime -- partial hours
  add taskTime to gBillHours
  
  if the number of items of field "task" of card cardnum of stack zstack > 1 then
    put item 2 of field "task" of card cardnum of stack zstack into rate
    if offset("/hr",rate) = 0 then -- flat rate
      add rate to gDollars
    else
      delete char offset("/hr",rate) to length(rate) of rate
      add (taskTime * rate) to gDollars
    end if
  else
    add 0 to gDollars
  end if
end checkRecord
   dd CornflowerBlue                  	        
Close Window Ex   +on mouseUp
  close this stack
end mouseUp
   dd CornflowerBlue                  	     
   label1          M  `            Start Date 
   label2a          M l            	End Date 
   start date  	x  ]on mouseUp
  global gStartDate
  put field "start date" into temp
  put temp into gStartDate
  convert temp to short date
  ask "Enter a Start Date" with temp
  if it is empty then exit mouseUp
  if offset(",",it)=0 AND offset("/",it)=0 then
    answer "Enter dates in the format dd/mm/yy."
    --  ask "All dates must be in the format dd/mm/yy or as follows." with the long date
    exit mouseUp
  end if
  if it is not a date then
    ask "You entered an invalid Start Date. Try again." with the date
    if it is empty then exit mouseUp
    if it is not a date then
      ask "You entered an invalid Start Date. Try again." with the date
      if it is empty or it is not a date then
        exit mouseUp
      end if
    end if
  end if
  put it into temp
  convert temp to long date
  put temp into field "start date"
  checkDate "start date"
end mouseUp
        T             
   	end date  	x  Zon mouseUp
  global gEndDate
  put field "end date" into gEndDate
  put field "end date" into temp
  convert temp to short date
  ask "Enter an End Date" with temp
  if it is empty then exit mouseUp
  if offset(",",it)=0 AND offset("/",it)=0 then
    answer "Enter dates in the format dd/mm/yy."
    --  ask "All dates must be in the format dd/mm/yy or as follows." with the long date
    exit mouseUp
  end if
  if it is not a date then
    ask "You entered an invalid End Date. Try again." with the date
    if it is empty then exit mouseUp
    if it is not a date then
      ask "You entered an invalid End Date. Try again." with the date
      if it is empty or it is not a date then
        exit mouseUp
      end if
    end if
  end if
  put it into temp
  convert temp to long date
  put temp into field "end date"
  checkDate "end date"
end mouseUp
        T-               Today  Ex  
 on mouseUp
  global gStartDate
  put field "Start date" into gStartDate
  put the long date into field "Start date"
  checkDate  "Start date"
end mouseUp
   dd CornflowerBlue      *              	        Today  Ex  
 on mouseUp
  global gEndDate
  put field "end date" into gEndDate
  put the long date into field "end date"
  checkDate "end date"
end mouseUp
   dd CornflowerBlue     *              	        Edit  Ex  
 =on mouseUp
  send mouseUp to field "Start date"
end mouseUp
   dd CornflowerBlue     &              	        Edit  Ex  
 ;on mouseUp
  send mouseUp to field "end date"
end mouseUp
   dd CornflowerBlue    &              	     
  	 label2 	         NM             ,Total Time                           Amount 
  
 time  	`       T] y           
   money  	`       ] W           
   label3          M  l            Project 
   project  	x   uon mouseUp
  global gStack
  put "quickcheck" into gStack
  go stack "projects"
  show stack "projects"
end mouseUp
        T                Select Project  ex   on mouseUp
  global gStack
  put the short name of this stack into gStack
  go stack "projects"
  show stack "projects"
end mouseUp
           dd CornflowerBlue            Add/Select Project         	        Select Activity  ex   on mouseUp
  global gStack
  put the short name of this stack into gStack
  set the hilite of button "all activity" of stack "quickcheck" to false
  go stack "tasks"
  show stack "tasks"
end mouseUp
   dd CornflowerBlue            Add/Select Activity         	     
   label5          M  l            Activity/Rate 
   task  	x   on mouseUp
  global gStack
  put "quickcheck" into gStack
  set the hilite of button "all activity" of stack "quickcheck" to false
  go stack "tasks"
  show stack "tasks"
end mouseUp
        T             
   instruction            X x         Here is a quick check of how much time you've spent on a particular activity. Running timers are eligible to be included in the totals. Choose a project and an activity  
       N
 @        Black  N 9
      " >(or choose all activities), then specify start and end dates.  ]After making changes, click the Recalculate button. Expenses are not include in this report. 
       4
     4 (        
All Activity @e   6on mouseUp
  put empty into field "task"
end mouseUp
   dd CornflowerBlue    %  0      All          	        First  Ex  
:on mouseUp
  --  global gStartDate
  --  put field "Start date" into gStartDate
  put 1 into sortLine
  put true into notfound
  repeat with i = 1 to the number of cards of stack "records"
    set cursor to busy
    if checkItems(i) then next repeat
    if word 2 of field "elapsed" of card i of stack "records" <> "hrs" then next repeat
    if field "project" of card i of stack "records" <> field "project" then next repeat
    if (field "task" of card i of stack "records" <> field "task") AND NOT the hilite of button "all activity" then next repeat
    put field "start date" of card i of stack "records" into theDate
    convert theDate to seconds
    put theDate & tab & i into line sortLine of zSorter
    put false into notfound
    add 1 to sortLine
  end repeat
  
  set the itemDelimiter to tab
  sort lines of zSorter by item 1 of each
  
  if notfound then
    answer information "No matching records found."
  else
    put item 2 of line 1of zSorter into zcard
    put field "start date" of card zcard of stack "records" into field "start date"
  end if
end mouseUp
   dd CornflowerBlue     *              	        Choose Ex  
\on mouseUp
  global gDateField,gDateStack,gStartDate,gEndDate
  put field "end date" into gEndDate
  put field "start date" into gStartDate
  put "start date" into gDateField
  put "start date" into gWhichfield
  put short name of this stack into gDateStack
  set the title of stack "dates" to "Select a Start Date"
  go stack "dates"
end mouseUp
   dd CornflowerBlue      2              	     	      Choose Ex  
5on mouseUp
  global gDateField,gDateStack,gEndDate,gStartDate
  put field "start date" into gStartDate
  put field "end date" into gEndDate
  put "end date" into gDateField
  put short name of this stack into gDateStack
  set the title of stack "dates" to "Select an End Date"
  go stack "dates"
end mouseUp
   dd CornflowerBlue     2              	     	      Last  Ex  
Xon mouseUp
  --  global gStartDate
  --  put field "Start date" into gStartDate
  put 1 into sortLine
  put true into notfound
  repeat with i = 1 to the number of cards of stack "records"
    set cursor to busy
    if checkItems(i) then next repeat
    if word 2 of field "elapsed" of card i of stack "records" <> "hrs" then next repeat
    if field "project" of card i of stack "records" <> field "project" then next repeat
    if (field "task" of card i of stack "records" <> field "task") AND NOT the hilite of button "all activity" then next repeat
    put field "start date" of card i of stack "records" into theDate
    convert theDate to seconds
    put theDate & tab & i into line sortLine of zSorter
    put false into notfound
    add 1 to sortLine
  end repeat
  
  set the itemDelimiter to tab
  sort lines of zSorter by item 1 of each
  
  if notfound then
    answer information "No matching records found."
  else
    put item 2 of line (the number of lines of zSorter) of zSorter into zcard
    put field "start date" of card zcard of stack "records" into field "end date"
  end if
end mouseUp
   dd CornflowerBlue    0 *              	     	     4 dates  'on openStack
  global gYear,gMonth,gDay
  put the date into temp
  convert temp to dateItems
  if gYear is empty then
    put item 1 of temp into gYear
    set the hilitedbuttonName of group "year" to gYear
  end if
  if gMonth is empty then
    put item 2 of temp into gMonth
    send mouseUp to field ("m" & gMonth)
  end if
  put item 3 of temp into gDay
  if gMonth is item 2 of temp then
    repeat with i = 1 to 42
      if field ("day" & i) is gDay then
        set the textstyle of word 1 of field ("day" & i) to "bold"
        set the textstyle of word 1 of field ("day" & i) to "underline"
        set the textcolor of word 1 of field ("day" & i) to "red"
        exit repeat
      end if
    end repeat
  end if
end openStack

on setDate which
  global gYear,gMonth, gDateField,gDateStack
  if field which is empty then exit setDate
  put which into temp
  if char 1 of which is "m" then
    delete char 1 of temp
    put the hilitedbuttonName of group "year" into gYear
    put temp into gMonth
    setMonth gMonth,gYear
  end if
  if char 1 of which is "y" then
    delete char 1 of temp
    put temp into gYear
    setMonth gMonth,gYear
  end if
  if char 1 of which is "d" then
    put field which into zday
    put the date into temp
    convert temp to dateItems
    put gYear into item 1 of temp
    put gMonth into item 2 of temp
    put zday into item 3 of temp
    if gDateStack is "records" then
      convert temp to long date
      put temp into field gDateField of stack gDateStack
      send checkTime to stack "records"
    end if
    if gDateStack is "quickcheck" then
      convert temp to long date
      put temp into field gDateField of stack gDateStack
      send checkDate to stack gDateStack
    end if
    if gDateStack is "reports" then
      convert temp to short date
      put temp into field gDateField of stack gDateStack
      send checkTime to stack "reports"
    end if
    close this stack
  end if
  
end setDate

on setMonth zmonth,zyear
  
  put daysofmonth (zmonth, zyear) into zdays
  put zyear into item 1 of temp
  put zmonth into item 2 of temp
  put ",1,1,1,1,1" after temp
  convert temp to long date
  -- answer temp
  put word 2 of temp && zyear into field "month"
  -- answer word 1 of temp && zdays
  put word 1 of temp into firstDay
  delete last char of firstday
  switch firstDay
  case "sunday"
    put 1 into startNum
    break
  case "monday"
    put 2 into startNum
    break
  case "tuesday"
    put 3 into startNum
    break
  case "wednesday"
    put 4 into startNum
    break
  case "thursday"
    put 5 into startNum
    break
  case "friday"
    put 6 into startNum
    break
  case "saturday"
    put 7 into startNum
    break
  default
    put 0 into startNum
    break
  end switch
  
  repeat with i = 1 to startNum
    put empty into field ("day" & i)
  end repeat
  
  put the date into temp
  convert temp to dateItems
  put item 1 of temp into tYear
  put item 3 of temp into tDay
  
  repeat with i = 1 to zdays
    put i into field ("day" & startNum)
    if zMonth is item 2 of temp AND i = tDay AND tYear = zYear then
      set the textstyle of word 1 of field ("day" & startNum) to "bold"
      set the textstyle of word 1 of field ("day" & startNum) to "underline"
      set the textcolor of word 1 of field ("day" & startNum) to "red"
    else
      set the textstyle of word 1 of field ("day" & startNum) to "plain"
      set the textcolor of word 1 of field ("day" & startNum) to "black"
    end if
    add 1 to startNum
  end repeat
  
  repeat with i = startNum to 42
    put empty into field ("day" & i)
  end repeat
end setMonth
  w          
LightSkyBlue    white        g h e         Select a Start Date          U 
helvetica  
 U 
helvetica   W 
helvetica   W 
helvetica   U 
helvetica  
 W 
helvetica  
U 
helvetica       	@           e                                                           	  
      
                                         !  "  #  $  %  &  '  (  )  *  0  2  4
   month  +h          t           November 2000      
   h1  +x   #on mouseUp
setDate h1
end mouseUp
                    S      
   h2  +x   #on mouseUp
setDate h2
end mouseUp
        +            M 
   h3  +x   #on mouseUp
setDate h3
end mouseUp
        C            T 
   h4  +x   #on mouseUp
setDate h4
end mouseUp
        [            W 
   h5  +x   #on mouseUp
setDate h5
end mouseUp
        s            T 
   h6  +x   #on mouseUp
setDate h6
end mouseUp
                    F 
   h7  +x   #on mouseUp
setDate h7
end mouseUp
                    S 
   day3  +x   %on mouseUp
setDate day3
end mouseUp
        C             
   day4  +x   %on mouseUp
setDate day4
end mouseUp
        [            1 
 @        black    
   day5  +x   %on mouseUp
setDate day5
end mouseUp
        s            2 
 @        black    
   day6  +x   %on mouseUp
setDate day6
end mouseUp
                    3 
 @        black    
   day7  +x   %on mouseUp
setDate day7
end mouseUp
                    4 
 @        black    
   day1  +x   %on mouseUp
setDate day1
end mouseUp
                     
   day2  +x   %on mouseUp
setDate day2
end mouseUp
        +             
   day10  +x   &on mouseUp
setDate day10
end mouseUp
        C            7 
 @        black    
   day11  +x   &on mouseUp
setDate day11
end mouseUp
        [            8 
 @        black    
   day12  +x   &on mouseUp
setDate day12
end mouseUp
        s            9 
 @        black    
   day13  +x   &on mouseUp
setDate day13
end mouseUp
                    10 
 @        black    
    day14  +x   &on mouseUp
setDate day14
end mouseUp
                    11 
 @        black    
   day8  +x   %on mouseUp
setDate day8
end mouseUp
                    5 
 @        black    
   day9  +x   %on mouseUp
setDate day9
end mouseUp
        +            6 
 @        black    
   day17  +x   &on mouseUp
setDate day17
end mouseUp
        C            14 
 @        black    
   day18  +x   &on mouseUp
setDate day18
end mouseUp
        [            15 
 @        black    
   day19  +x   &on mouseUp
setDate day19
end mouseUp
        s            16 
 @        black    
   day20  +x   &on mouseUp
setDate day20
end mouseUp
                    17 
 @        black    
   day21  +x   &on mouseUp
setDate day21
end mouseUp
                    18 
 @      red    
   day15  +x   &on mouseUp
setDate day15
end mouseUp
                    12 
 @        black    
  	 day16  +x   &on mouseUp
setDate day16
end mouseUp
        +            13 
 @        black    
  
 day24  +x   &on mouseUp
setDate day24
end mouseUp
        C            21 
 @        black    
   day25  +x   &on mouseUp
setDate day25
end mouseUp
        [            22 
 @        black    
   day26  +x   &on mouseUp
setDate day26
end mouseUp
        s            23 
 @        black    
  
 day27  +x   &on mouseUp
setDate day27
end mouseUp
                    24 
 @        black    
   day28  +x   &on mouseUp
setDate day28
end mouseUp
                    25 
 @        black    
   day22  +x   &on mouseUp
setDate day22
end mouseUp
                    19 
 @        black    
   day23  +x   &on mouseUp
setDate day23
end mouseUp
        +            20 
 @        black    
   day31  +x   &on mouseUp
setDate day31
end mouseUp
        C           28 
 @        black    
   day32  +x   &on mouseUp
setDate day32
end mouseUp
        [           29 
 @        black    
   day33  +x   &on mouseUp
setDate day33
end mouseUp
        s           30 
 @        black    
   day34  +x   &on mouseUp
setDate day34
end mouseUp
                    
   day35  +x   &on mouseUp
setDate day35
end mouseUp
                    
   day29  +x   &on mouseUp
setDate day29
end mouseUp
                   26 
 @        black    
   day30  +x   &on mouseUp
setDate day30
end mouseUp
        +           27 
 @        black    
   day38  +x   &on mouseUp
setDate day38
end mouseUp
        C            
   day39  +x   &on mouseUp
setDate day39
end mouseUp
        [            
   day36  +x   &on mouseUp
setDate day36
end mouseUp
                    
   day37  +x   &on mouseUp
setDate day37
end mouseUp
        +            
   day40  +x   &on mouseUp
setDate day40
end mouseUp
        s            
   day41  +x   &on mouseUp
setDate day41
end mouseUp
                    
   day42  +x   &on mouseUp
setDate day42
end mouseUp
                    
   m1  +x   #on mouseUp
setDate m1
end mouseUp
         @           Jan 
    m3  +x   #on mouseUp
setDate m3
end mouseUp
        K @           Mar 
  ! m4  +x   #on mouseUp
setDate m4
end mouseUp
        g @           Apr 
  " m5  +x   #on mouseUp
setDate m5
end mouseUp
         @           May 
  # m6  +x   #on mouseUp
setDate m6
end mouseUp
         @           June 
  $ m2  +x   #on mouseUp
setDate m2
end mouseUp
        / @           Feb 
  % m8  +x   #on mouseUp
setDate m8
end mouseUp
        / X           Aug 
  & m9  +x   #on mouseUp
setDate m9
end mouseUp
        K X           Sep 
  ' m7  +x   #on mouseUp
setDate m7
end mouseUp
         X           July 
  ( m10  +x   $on mouseUp
setDate m10
end mouseUp
        g X           Oct 
  ) m11  +x   $on mouseUp
setDate m11
end mouseUp
         X           Nov 
  * m12  +x   $on mouseUp
setDate m12
end mouseUp
         X           Dec   0 year   i         #    - 2000 @D   (on mouseUp
  setDate y2000
end mouseUp
   dd CornflowerBlue     ' 4              	  	       . 2001 @D   (on mouseUp
  setDate y2001
end mouseUp
   dd CornflowerBlue    N ' 4              	   	       / 2002 @D   (on mouseUp
  setDate y2002
end mouseUp
   dd CornflowerBlue     ' 4              	   
  2 inst 	         	              !Click on a year, month and date.   4 Cancel Ex   +on mouseUp
  close this stack
end mouseUp
   dd CornflowerBlue    ,@              	        Moved Icons      
LightSkyBlue                             	@              H      	@              I      	@              J      	@              K      	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@              ?  	    	@              @      	@              A  
    	@              B  H i328  	D     ffffff             0 0       S  8 `    %       B  "    
     0     _   8 p p   q 9   p x ?     W        p @ H @ D @ B @ A @ @@ @            c  ?   6 σ? ?  ?       I i329  	D     ffffff             0 0       Q                       a                       U                        u                            J i330  	D    ffffff             0 0       b     0          ` `              b             x            \              p    @ @ @     {     ? > < <     ~                 K i331  	D     ffffff             0 0       `                           k                         ` @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @  @ @ @                                       	D        ``    ``    Ș``  Ș  0000``     0 0        
  6
7o$$$$$ | | |  "         _          @ @ @ @ @ @ @ @ @ @ @ @ @ @ @      @                             @        @  @      o   	  	  	  I  I  I  I  I  I! @" 5        @  0     i   @ @ @ @ @ @ @           ?             @        ??          	D   
          Ș  @@@@@@  Ș``          ````      0000``     0 0       23" P" P" PB$" `w PB" `
q	 PB" vw
 PB" `qwh	P"" pwP" qwP" qwhP"
 WUWUWUwhP" whP" whP" WUWUWwhP" whP" whP" WUWUw	hP"BD whP" whP" WUuUuUwhP" wP" wP" `wh	P"D vh P" `f	 P" P" P" P D PU           	D   
          Ș  @@@@@@  Ș``          ````      0000``     0 0       23" P" P" PB$" `w PB" `
q	 PB" vw
 PB" `qwh	P"" pwP" qwP" qwUuwhP" wWuwUwhP" wWuwUwhP" wUwhP" wWuwhP" wUwhP" wWuwhP" wWuw	hP"BD whP" wWuwhP" wWuwhP" wP" wP" `wh	P"D vh P" `f	 P" P" P" P D PU           	D                  Ș``  @@@@@@  PPPPPP     0 0          @ `   0    0   a C Â  
@`  0  0 `@      X  @    H   @    @    @   @       |        0 0 8 ,8 ,< \< \> > ? |? |?????    j                 @ @              : @         @     ?      @ @     
 ?              ? ?     ??        	D  xx            xx||xx       0 0              @     @ @ @         @ @ @        @        |    B?>????>?      e                   8 x   ` ?     P @  > | | ?     ? | | >  @    ~    ??  ?          	D  xx||xx                       0 0                 @ @        @ @     < x    <     8     H      @  @ @  @              }    ??????&??????????       @    C                 p @                  @             `        ??  ?    x 8          	D  xx||xx                       0 0                 @ @        @ @     < x    <     8     [        (    @  $   @                |    *?????       @    p @                  @             `    D   0 < <                 ??  ?    x 8          	D  xx||                  xx||xx     0 0       z         @ @                 @ @     @            ? ?  p p (x x | | ~ ~   ???    K   @           @             @ @                    @  @                  |   0             ` ` 0 0                  ? ?       ???     icon 1   	d                0 0       j       `  `  `              Y                    m                      icon 1   	d                0 0       e           ` `  `          T                   h                    ? i319  	D                0 0       ] R @ A@ A@ B@ B@ DD @H @H @P @P @H @H @D @DB@ B@ A@ A @     X   :             _  J               @ i320  	D                0 0       d   
 
   #   @ @   @ @   #   
 
      R       ? ?   ? ?          b       ? ?       ? ?           A i321  	D                0 0       d ` ` P P H H Ă         ă H H P P ` `    R     0 0 8         8 0 0        b ` ` p p x x           x x p p ` `     B i322  	D                0 0       \ W   A  A  !  !     	  	      	  	     !  !  A  A        X      "          \ W                 Cursors       
LightSkyBlue                    U 
Helvetica       	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                 	    	@                 
    	@                   c5   	D               0 0       d    Ă Nw     @A@``   0 p 08 8     ^  8    < 8> > O?  ">߀ > ?     `  ǂ  p     j     w    0??         c11   	D               0 0       [  
  5 [       @   A   H 0      J   
 $ p       > | x       [    ?        ?              c12   	D               0 0       Y >    
   ?  0 @   A          .       > | x p    Y >    
       ?              c16  	D               8 8     K  ! A A        ? 0     2   > > ~ ~          B
D? 
P 
   ?B           c17   	D               8 8     I 0   p x< ~    ~ x< p   0     <                A?P 
   ?B         c18   	D               8 8     K 0 ?        A A !      2       ~ ~ > >      B
D? 
P 
   ?B         c19   	D               8 8     K  ? _ O      O _ ?      -   0 x< | ~ | x< 0      B
D? 
P 
   ?B         c20   	D               8 8     K  ! A A        ? 0     2   > > ~ ~          B
D? 
P 
   ?B         c21   	D               8 8     I 0   p x< ~    ~ x< p   0     <                B
D? 
P 
   ?B         c22   	D               8 8     K 0 ?        A A !      2       ~ ~ > >      B
D? 
P 
   ?B         c23   	D               8 8     K  ? _ O      O _ ?      -   0 x< | ~ | x< 0      B
D? 
P 
   ?B         c1   	D               8 8     B         @     	     7 @ ` p x | ~   | l L      J   ` p X p E 0E     E       c8   	D               8 8     J 	 	 	 	 	 	 踂  * 
 ` 0       G       @ gP wԂ ?         C   5  %%%%?   