// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "WinExp.h"
#include "MainFrm.h"
#include "Doc.h"
#include "ViewTree.h"
#include "ViewList.h"
#include "Defines.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_CLOSE()
	ON_COMMAND(ID_LARGE_ICONS, OnLargeIcons)
	ON_COMMAND(ID_LIST, OnList)
	ON_COMMAND(ID_SMALL_ICONS, OnSmallIcons)
	ON_COMMAND(ID_DETAILS, OnDetails)
	ON_COMMAND(ID_REFRESH_LIST, OnRefreshList)
	ON_COMMAND(ID_RESET_TREE, OnResetTree)
	ON_COMMAND(ID_UP, OnUp)
	ON_UPDATE_COMMAND_UI(ID_UP, OnUpdateUp)
	//}}AFX_MSG_MAP
	// Global help commands
	ON_COMMAND(ID_HELP_FINDER, CFrameWnd::OnHelpFinder)
	ON_COMMAND(ID_HELP, CFrameWnd::OnHelp)
	ON_COMMAND(ID_CONTEXT_HELP, CFrameWnd::OnContextHelp)
	ON_COMMAND(ID_DEFAULT_HELP, CFrameWnd::OnHelpFinder)
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	m_pSmallImageList = NULL;
	m_pNormalImageList = NULL;
	m_pStateImageList = NULL;

	// load bitmaps for drive types & desktop - ten images
	m_pNormalImageList = new CImageList();
	m_pSmallImageList = new CImageList();
	// 32x32 pixels, 8 of them
	m_pNormalImageList->Create(32, 32, TRUE, 8, 4);
	// 16x16 pixels, 8 of them
	m_pSmallImageList->Create(16, 16, TRUE, 8, 4);
/*
#define IDI_REMOVE                      300
#define IDI_FIXED                       301
#define IDI_REMOTE                      302
#define IDI_CD                          303
#define IDI_DESKTOP                     304
#define IDI_FOLDCLS                     305
#define IDI_FOLDOPEN                    306
#define IDI_DOC                         307
*/
	// the 8 images have conseq resource numbers
	//	see resource.h
	HICON hIcon;
	CWinApp * pApp = AfxGetApp();
	for (int i = IDI_REMOVE; i <= IDI_DOC; i++)  
	{
		hIcon = pApp->LoadIcon((UINT) i);
		m_pNormalImageList->Add(hIcon);
		m_pSmallImageList->Add(hIcon);
		::DeleteObject(hIcon);
	}

	// load icons for states
	m_pStateImageList = new CImageList();
	// 8x8 pixels, 2 of them
	m_pStateImageList->Create(8, 8, TRUE, 2, 1);
	// the 8 images have conseq resource numbers
	//	see resource.h
	for (i = IDI_STATE0; i <= IDI_STATE1; i++)  
	{
		hIcon = AfxGetApp()->LoadIcon(i);
		m_pStateImageList->Add(hIcon);
		::DeleteObject(hIcon);
	}
}

CMainFrame::~CMainFrame()
{
	if (m_pNormalImageList)
	{
		delete m_pNormalImageList;
	}
	if (m_pSmallImageList)
	{
		delete m_pSmallImageList;
	}
	if (m_pStateImageList)
	{
		delete m_pStateImageList;
	}
}

/////////////////////////////////////////////////////////////////////////////
int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	if (!m_wndToolBar.Create(this) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	// TODO: Remove this if you don't want tool tips or a resizeable toolbar
	m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);

	// TODO: Delete these three lines if you don't want the toolbar to
	//  be dockable
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);

	return 0;
}

/////////////////////////////////////////////////////////////////////////////
BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	// fix the caption
	DWORD x = 0;
	x |= FWS_ADDTOTITLE;
	cs.style &= ~x;
	
	// size the window
	float fClientWidth = (float)0.75;// think of this as a percentage  of the screen that the
									// client will consume
	int hr = ::GetSystemMetrics(SM_CXSCREEN);
	int vr = ::GetSystemMetrics(SM_CYSCREEN);
	cs.cx = (int)((float)hr * fClientWidth);  // consume fClientWidth% of the x pixels
	cs.cy = (int)((float)vr * fClientWidth);  // consume fClientWidth% of the y pixels
	cs.x  = (hr - cs.cx)/2;  // centers the window
	cs.y  = (vr - cs.cy)/2;  // centers the window

	// call the base class and return
	BOOL b = CFrameWnd::PreCreateWindow(cs);
	return(b);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers
BOOL CMainFrame::OnCreateClient(LPCREATESTRUCT lpcs, 
								CCreateContext* pContext) 
{
	// may want to read Q99562 and Q141334
	if (m_wndSplitter.CreateStatic(this,1,2)) 
	{
		CRect rect;
		GetClientRect(&rect);
		CSize sizeTree = rect.Size();

		sizeTree.cx = rect.Width()/4; 

		if (m_wndSplitter.CreateView(PANE_ROW_ZERO, eTreeWinPane, RUNTIME_CLASS(CViewTree),
										sizeTree, pContext))
		{
			if (m_wndSplitter.CreateView(PANE_ROW_ZERO, eListWinPane, RUNTIME_CLASS(CViewList),
										CSize(0,0), pContext))
			{
				return TRUE;	
			}
		}
	}

	return FALSE;
	//return CFrameWnd::OnCreateClient(lpcs, pContext);
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnClose() 
{
	//get the tree view, clean out the tree strings, save sizes
	CViewTree * pTreeView = (CViewTree*)m_wndSplitter.GetPane(PANE_ROW_ZERO, eTreeWinPane);
	ASSERT(pTreeView != NULL);
	pTreeView->OnCloseCleanTree();

	//get the list view, possibly save col widths
	CViewList * pListView = (CViewList*)m_wndSplitter.GetPane(PANE_ROW_ZERO, eListWinPane);
	ASSERT(pListView != NULL);
	CListCtrl& cTheList = pListView->GetListCtrl();
	DWORD dwStyle = ::GetWindowLong(cTheList.m_hWnd, GWL_STYLE); 
	DWORD dwMask = dwStyle & LVS_TYPEMASK;
	if (dwMask == LVS_REPORT)
	{
		pListView->SaveColumnWidths();
	}
	AfxGetApp()->WriteProfileInt("WinExp", "ListStyle", dwMask);

	CFrameWnd::OnClose();
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnLargeIcons() 
{
	AdjustStyle(LVS_ICON);
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnSmallIcons() 
{
	AdjustStyle(LVS_SMALLICON);
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnList() 
{
	AdjustStyle(LVS_LIST);
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnDetails() 
{
	AdjustStyle(LVS_REPORT);
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::AdjustStyle(DWORD dwNewStyle)
{
	CViewList * pListView = (CViewList*)m_wndSplitter.GetPane(PANE_ROW_ZERO, eListWinPane);
	ASSERT(pListView != NULL);
	pListView->AdjustStyle(dwNewStyle);
}

/////////////////////////////////////////////////////////////////////////////
// pass in FILE_ATTRIBUTE_DIRECTORY for nType to get folders, 0 to get files
void CMainFrame::FindSubItems(CString sPath, CPtrList* pList, DWORD dwType)
{  
/*
#define FILE_ATTRIBUTE_READONLY         0x00000001
#define FILE_ATTRIBUTE_HIDDEN           0x00000002
#define FILE_ATTRIBUTE_SYSTEM           0x00000004
#define FILE_ATTRIBUTE_DIRECTORY        0x00000010
#define FILE_ATTRIBUTE_ARCHIVE          0x00000020
#define FILE_ATTRIBUTE_NORMAL           0x00000080
#define FILE_ATTRIBUTE_TEMPORARY        0x00000100
*/

	CString sTemp;
	CString sMyPath = sPath; // internal copy - source does not end in backslash
    sMyPath += "\\*"; // now search for any directory
	WIN32_FIND_DATA result;
	HANDLE retval = ::FindFirstFile(sMyPath, &result);
	if (retval != INVALID_HANDLE_VALUE)
	{
		DWORD dwFilter;
		dwFilter = result.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY;
		if	(result.cFileName[0] != '.'  && 
			(dwFilter == dwType))
		{
			SUBITEM * pSubItem = new SUBITEM;
			ASSERT(pSubItem);
			//TRACE("found sub dir %s under cwd\n", result.name);
			// make strings like Explorer - no directory
			//	is ever displayed in all CAPS
			sTemp = result.cFileName;
			sTemp.MakeUpper();
			if (sTemp == result.cFileName)
			{
				sTemp.MakeLower();
				sTemp.SetAt(0,*result.cFileName);
				strcpy(pSubItem->szName, (const char *)sTemp);
			}
			else
			{
				strcpy(pSubItem->szName, result.cFileName);
			}
			
			pSubItem->dwHighDateTime = result.ftLastWriteTime.dwHighDateTime;
			pSubItem->dwLowDateTime = result.ftLastWriteTime.dwLowDateTime;
			pSubItem->nFileSizeHigh = result.nFileSizeHigh;
			pSubItem->nFileSizeLow = result.nFileSizeLow;

			pList->AddTail(pSubItem);
		}	
		while (::FindNextFile(retval, &result))
		{
			dwFilter = result.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY;
			if (result.cFileName[0] != '.'  && 
			   (dwFilter == dwType))
			{		
				SUBITEM * pSubItem = new SUBITEM;
				ASSERT(pSubItem);
				//TRACE("found sub dir %s under cwd\n", result.name); 
				sTemp = result.cFileName;
				sTemp.MakeUpper();
				if (sTemp == result.cFileName)
				{
					sTemp.MakeLower();
					sTemp.SetAt(0,*result.cFileName);
					strcpy(pSubItem->szName, (const char *)sTemp);
				}
				else
				{
					strcpy(pSubItem->szName, result.cFileName);
				}

				pSubItem->dwHighDateTime = result.ftLastWriteTime.dwHighDateTime;
				pSubItem->dwLowDateTime = result.ftLastWriteTime.dwLowDateTime;
				pSubItem->nFileSizeHigh = result.nFileSizeHigh;
				pSubItem->nFileSizeLow = result.nFileSizeLow;

				pList->AddTail(pSubItem);
			}	
		}
		::FindClose(retval);
	}
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnRefreshList() 
{
	CViewList * pListView = (CViewList*)m_wndSplitter.GetPane(PANE_ROW_ZERO, eListWinPane);
	ASSERT(pListView != NULL);
	pListView->RefreshList();
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnResetTree() 
{
	CViewTree * pTreeView = (CViewTree*)m_wndSplitter.GetPane(PANE_ROW_ZERO, eTreeWinPane);
	ASSERT(pTreeView != NULL);
	pTreeView->ResetTree();
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUp() 
{
	CViewTree * pTreeView = (CViewTree*)m_wndSplitter.GetPane(PANE_ROW_ZERO, eTreeWinPane);
	ASSERT(pTreeView != NULL);

	CTreeCtrl& cTheTree = pTreeView->GetTreeCtrl();

	HTREEITEM hItem = cTheTree.GetSelectedItem();

	HTREEITEM hItemParent = cTheTree.GetParentItem(hItem);

	cTheTree.SelectItem(hItemParent);	
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateUp(CCmdUI* pCmdUI) 
{
	CViewList * pListView = (CViewList*)m_wndSplitter.GetPane(PANE_ROW_ZERO, eListWinPane);
	ASSERT(pListView != NULL);
	CString sPath = pListView->m_sPath;
	int nFind;
	nFind = sPath.Find("\\");
	if (nFind != -1)
	{
		pCmdUI->Enable();
	}
	else
	{
		pCmdUI->Enable(FALSE);
	}
}
