  
' Granite.
' Blend the input image with a granite pattern.
' For a better and faster result use a 24 bit output.

' Input:	4-8-24 bit
' Output:	4-8-24 bit (24 reccomended)

' Author:	Andrea Benoni			 rev:	1.2


string	inpFile,mskFile,outFile
DevCon	Ibmp,Mbmp
RGB	pix
float  	x,y,L

inpFile="testi.bmp"			' Input file
outFile="testo.bmp"		' Output file
mskFile="granito.bmp"		' Pattern file

Ibmp=LoadImage(inpFile)
Mbmp=LoadImage(mskFile)

For y=0 to Ibmp.Height-1
   For x=0 to Ibmp.Width-1
      pix=GetPixel(Mbmp,x,y)
      L=.40+(.60/255*pix.Lum)
      pix=GetPixel(Ibmp,x,y)			' get a pixel from input image
      pix.Red=pix.Red*L   			' modify RGB
      pix.Green=pix.Green*L
      pix.Blue=pix.Blue*L
      SetPixel(Ibmp,x,y,pix)			' put pixel to output image
   Next x
   if(y%10=0)	
      Preview(Ibmp,"Output",5,5,Ibmp.Width+10,Ibmp.Height+30)	
   endif
Next y
SaveImage(Ibmp,outFile)
