  ' Extract outline from an image

' Input:	8bit	Gray
' Output:	8bit

' Author:	Andrea Benoni		rev:	1.2

 
string    	inpFile,outFile
DevCon	Ibmp,Obmp
RGB	pix,pio,pia
float  	x,y

inpFile="testi.bmp"			' static input file name
outFile="testo.bmp"		' output file

Ibmp=LoadImage(inpFile)
Obmp=CreateImage(Ibmp.Width,Ibmp.Height,8)	' create a 16 grays image

' Orizontal computation

For y=0 to Ibmp.Height-1
  pio=GetPixel(Ibmp,x,y)

  For x=1 to Ibmp.Width-1
      pia=GetPixel(Ibmp,x,y)
      pix.Lum=min(abs(pia.Lum-pio.Lum)*6,255)
      if(pix.Lum<128)
         pix.Lum=0
      endif
      pio=pia
      SetPixel(Obmp,x,y,pix)
   Next x
   DspWhile("Shadow",100/Ibmp.Height*y)
   Preview(Obmp,"Output",5,5,Ibmp.width+25,Ibmp.height+30)
Next y

' Vertical computation

For x=1 to Ibmp.Width-1
  pio=GetPixel(Ibmp,x,y)

  For y=0 to Ibmp.Height-1
      pia=GetPixel(Ibmp,x,y)
      pix.Lum=min(abs(pia.Lum-pio.Lum)*6,255)
      if(pix.Lum<128)
         pix.Lum=0
      endif
      pio=pia
      pia=GetPixel(Obmp,x,y)
      pix.Lum=max(pix.Lum,pia.Lum)
      SetPixel(Obmp,x,y,pix)
   Next y
   DspWhile("Shadow",100/Ibmp.Width*x)
   Preview(Obmp,"Output",5,5,Ibmp.width+25,Ibmp.height+30)
Next x

SaveImage(Obmp,outFile)
DspMes("End")


