  
' Sphere1 (Rain).
 
' Input:	1-4-8-24 bit
' Output:	idem

' Author:	Andrea Benoni			 rev:	1.2


string    	inpFile,outFile
DevCon	Ibmp,Obmp
RGB	pix
float  	r,a,x,y,per,rs,rad,i,xr,yr,Li

inpFile="Testi.bmp"			' input file
outFile="Testo.bmp"			' output file

Ibmp=LoadImage(inpFile)
Obmp=CreateImage(Ibmp.Width,Ibmp.Height,24)

for y=0 to Ibmp.Height
   for x=0 to Ibmp.Width
       pix=GetPixel(Ibmp,x,y)
       SetPixel(Obmp,x,y,pix)
   next x
   DspWhile("Creating 24 bit image",100/Ibmp.Height*y)
next y

rad=6.28/50

for i=1 to 100
  xr=Rand(Ibmp.Width-32)+16
  yr=Rand(Ibmp.Height-32)+16
  per=rand(16)+16  
  DspWhile("Rain",i)
  For r=0 to per
     rs=sin(1.57/per*r)*per
     Li=1.3-(.6/per*r)
     For a=0 to 50
        x=sin(rad*a)
        y=cos(rad*a)
        pix=GetPixel (Obmp,x*r+xr,y*r+yr)
        pix.Red=min(255,pix.Red*Li)
        pix.Green=min(255,pix.Green*Li)
        pix.Blue=min(255,pix.Blue*(Li+.2))
        SetPixel (Obmp,x*rs/4+xr,y*rs/4+yr,pix)
     Next a
   Next r
   Preview(Obmp,"Immagine",2,5)
Next i


Preview(Ibmp,"Immagine",2,5)
SaveImage(Ibmp,outFile)
DspMes("Ok")