//*********************************************************************
//
//  CRCP.C - Example usage of Winsock RCP32.DLL
//
//
//  Winsock RCP32.DLL Copyright (c) 1994 Denicomp Systems
//
// 
//  Usage:
//
//     CRCP [-r] [-a] [-c] [-h] source dest
//
//  Where:
//     -r   - Recursively copy subdirectories
//     -a   - Perform ASCII end-of-line conversion (CR/LF to LF or vice versa)
//     -c   - Preserve case of filenames when using wildcards or -r
//     -h   - Copy hidden files when using wildcards or -r
//     -s   - Substitute '_' for spaces in filenames
//   source - Source host/file specification
//    dest  - Destination host/file specification
//
//  NOTE: Do not combine options after a hyphen; specify each separately.
//        For example, use "-r -a", not "-ra".
//
//  This program will copy the file specified in source to the destination
//  specified.  Either the source or the destination must contain a host name
//  as part of the filename.  The format is:
//
//    [user@]host:[filespec]
//
//   Where "user" is a user on the "host", "host" is a valid host name, and
//   "filespec" is either a directory, filename, or wildcard pattern.
//
//  The directory containing Winsock RCP32.DLL must be in your PATH or
//  RCP32.DLL must reside in the Windows directory.
//
//*********************************************************************

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>

#include "rcp32.h"

char errmsg[256];

int main (int argc, char *argv[])
{
	HANDLE hConsole;
	int a, result, rflag = 0, aflag = 0, cflag = 0, hflag = 0, sflag = 0;

	// check if Win32s, if so, display notice and terminate
	if( GetVersion() & 0x80000000 && (GetVersion() & 0xFF) ==3)
	{
	  MessageBoxA(NULL,
		      "This application cannot run on Windows 3.1.\n"
		      "This application will now terminate.",
		      "CRCP",
		      MB_OK | MB_ICONSTOP | MB_SETFOREGROUND );
	  return(1);
	}

	// Open the current console input buffer
	if ((hConsole = CreateFile("CONOUT$", GENERIC_WRITE | GENERIC_READ,
            	        	   FILE_SHARE_READ | FILE_SHARE_WRITE, 0L,
				   OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL,
				   0L)) == INVALID_HANDLE_VALUE )
	{
	  printf("\nError: Unable to open console.\n");
	  return(-1);
	}

	// Need at least two arguments
	if (argc < 3)
	{
	  printf("\nUsage: %s [-r][-a][-c] source dest\n",argv[0]);
	  return(-1);
	}

	// Examine command line arguments
	for(a = 1; a <= argc; a++)
	{
	  if (strcmp(argv[a],"-r") == 0)	// -r: Recursive flag
	    rflag = 1;
	  else if (strcmp(argv[a],"-a") == 0)	// -a: Ascii flag
	         aflag = 1;
	  else if (strcmp(argv[a],"-c") == 0)	// -c: Preserve case flag
	         cflag = 1;
	  else if (strcmp(argv[a],"-h") == 0)	// -h: Copy hidden files
	         hflag = 1;
	  else if (strcmp(argv[a],"-s") == 0)	// -s: Replace spaces with '_'
	         sflag = (int)'_';
	  else if (argv[a][0] == '-')		// Others are invalid
	       {
		 printf("Invalid option: %s\n",argv[a]);
		 return(-1);
	       }
	       else				// Found first filename
		 break;
	}

	printf("Copying %s to %s\n",argv[a],argv[a+1]);
	result = WinsockRCP2(argv[a],argv[a+1],rflag,aflag,cflag,hflag,sflag,
			     errmsg,sizeof(errmsg));

	if (result < 0)
	  printf("Remote Copy Was Not Successful.\nError: %d - %s\n", result,
		 errmsg);
	else
	  if (result == 1)
	    printf("Remote Copy Successful\n%d File Copied\n",result);
	  else
	    printf("Remote Copy Successful\n%d Files Copied\n",result);

	return(0);
}

