
/***************************************************************/
/*Copyright (c) by Continocean Tech Inc. 	       	       */
/*12 Mountain Ave., Montville, New Jersey, USA 07045           */
/*All rights reserved. No part of this work covered by the     */
/*copyright hereon may be reproduced or used in any form or by */
/*any means----graphic, electronic, or mechanical, including   */
/*photocopying, recording, taping, or information storage and  */
/*retrieval systems----without written permission of 	       */
/*Continocean Tech inc.					       */
/***************************************************************/


#ifndef _COMPLEX_H
#define _COMPLEX_H	1	//prevent multiple #includes


#define J j_imag()
void printw(char *fmt, ...);

class Complex{
protected:
	double re, im;
public:

  double           real() const;
  double           imag() const;

                   Complex();
		   Complex(const Complex& y);
                   Complex(double r, double i=0);

                  ~Complex();

  Complex&         operator =  (const Complex& y);

	friend Complex operator +(const Complex&, const Complex&);
	friend Complex operator -(const Complex&, const Complex&);
	friend Complex operator -(const Complex&);
	friend Complex operator *(const Complex&, double);
	friend Complex operator *(double, const Complex&);
	friend Complex operator *(const Complex&, const Complex&);
	friend Complex operator /(const Complex&, const Complex&);
	friend Complex operator /(double, const Complex&);
	friend Complex operator /(const Complex&, double);
	friend Complex operator ~(const Complex&);  //conjugate
	friend int operator ==(const Complex&, const Complex&); 
	friend int operator !=(const Complex&,const Complex&); 
	friend Complex exp(const Complex&);
	friend double abs(const Complex&);
	friend double normsq(const Complex&); //re*re+im*im
	friend double phase(const Complex&); //phase()=arg() between (0,2*PI)
	friend double arg(const Complex&); //phase()=arg() between (0,2*PI)
	friend Complex pow(const Complex&, double);
	friend Complex pow(const Complex&, int);
	friend double real(const Complex&);
	friend double imag(const Complex&);
	friend void printf(const Complex&);
	friend void printw(const Complex&);
	friend void fprintf(FILE *fp,const Complex&);
	friend void fscanf(FILE *fp, Complex &a);  //Usage:fscanf(fp,a);
	friend Complex j_imag();
};

void printw(void);
void printw(int x);
void printw(float x);
void printw(double x);
void printw(char x);

void fprintf(FILE *fp);
void fprintf(FILE *fp, int x);
void fprintf(FILE *fp, float x);
void fprintf(FILE *fp, double x);
void fprintf(FILE *fp, char x);



void fscanf(FILE *fp, int &x);
void fscanf(FILE *fp, float &x);
void fscanf(FILE *fp, double &x);
void fscanf(FILE *fp, char &x);

#endif


