/***************************************************************/
/*Copyright (c) by Continocean Tech Inc. 	       	       */
/*12 Mountain Ave., Montville, New Jersey, USA 07045           */
/*All rights reserved. No part of this work covered by the     */
/*copyright hereon may be reproduced or used in any form or by */
/*any means----graphic, electronic, or mechanical, including   */
/*photocopying, recording, taping, or information storage and  */
/*retrieval systems----without written permission of 	       */
/*Continocean Tech inc.					       */
/***************************************************************/

#ifndef _CMAT_H
#define _CMAT_H	1	//prevent multiple #includes


#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <stdarg.h>

#include "complex.h"
#include "cmatrix.h"
#include "matrix.h"
#include "imatrix.h"

#include "smatrix.h"

#include "matrixn.h"
#include "cmatrixn.h"
#include "imatrixn.h"

#include "binary.h"
#include "sbinary.h"

#include "win.h"

#ifdef __STDC__
#  define PTR void *
//#  define NULL (void *) 0
#else
#  define PTR char *
//#  define NULL 0
#endif


long int crandom ();
void srandom (unsigned int x);
PTR initstate (unsigned int seed, PTR arg_state, unsigned long n);
PTR setstate (PTR arg_state);

double bessi0(double x);
double bessi1(double x);
double convol(double t,double c[]);
double convolf3(double x,double c[]);
double convolfn3(double x,double c[]);
double convolf1(double t,double c[]);
double convolf2(double t,double c[]);
void corr(int n,double x[],double y[],double r[]);
void corrnorm(int n,double x[],double y[],double r[]);
void error(char *x);
double fact(int n);
void funcd(double x,double *f,double *df);
//double integral(double (*func)(),double a,double b,double length);
double integralp(double (*func)(double,double []),double a,double b,double c[],double length);
double qgaussp1(double (*func)(double,double []),double a,double b,double c[]);
float marstat(float c[]);
float margauss(float c[]);
float marray(float c[]);
double **mat(int nrl, int nrh, int ncl, int nch);
void meanvar(double *mean,double *var,double c[]);
double PDFMV(double x,double c[]);
double meanvarfym(double x,double c[]);
double meanvarfymn(double x,double c[]);
double meanvarfyv(double x,double c[]);
double meanvarfyvn(double x,double c[]);
float norm(float mm,float v);
void perform(float *al,float *nf,float *d,float *alc,float *nfc,float *dc,int ms,int m);
void performp(float *al,float *nf,float *d,float *alc,float *nfc,float *dc,float (*DETECT)(),float (*func)(),float c[]);
void phasecontinue(double p[],int n);//data in p[1]...p[n]
void phasefollow(double p1[], double p2[], int n);//data in p[1]...p[n]
double powi(double x,int n);
double qc0(double a);
double gaus(double x);
//double qgauss(double  (*func)(),double a,double b);
float  ray(float m,float v);
double funcray( double al, double c[]);
double tailp(double (*func)(double,double []),double a,double c[]);
double qgausstail(double (*func)(double,double []),double a,double b,double c[],double tm);
double tailpfx(double x,double (*func)(double,double []),double c[],double tm);
double integralptail(double (*func)(double,double []),double a,double b,double c[],double length,double tm);

double integral(double (*func)(double),double a,double b,double length);
double qgauss1(double  (*func)(double),double a,double b);
double tail(double (*func)(double),double a);
void fft(matrix &data, matrix &sp_freq, matrix & sp_amp, matrix &sp_phase, int n, float Ts);


class Complex;
class matrix;
class cmatrix;
class imatrix;

matrix unitary(int);
Complex **matcmatrix(int nrl, int nrh, int ncl, int nch);
double **matmatrix(int nrl, int nrh, int ncl, int nch);
matrix identity(int n);



void is54encod(int a,int &c0,int &c1);
void is54decodh(imatrix &y, imatrix &a, int n);
void is54decods(matrix &y, matrix &cs, imatrix &a, int n);
void is54decodsm(matrix &y, matrix &cs, imatrix &a, int n);
void interlr(matrix &x,matrix &y,int m,int n);
void is54deintr(matrix &xi,matrix &x1,matrix &x2,int n);
void is54deint(cmatrix &xi,cmatrix &x1,cmatrix &x2,int n);
void is54deintb(imatrix &xi,imatrix &x1,imatrix &x2,int n);
void is54interlb(imatrix &x1,imatrix &x2,imatrix &xi,int n);
void is54interl(cmatrix &x1,cmatrix &x2,cmatrix &xi,int n);
void demult(cmatrix&xm, cmatrix &x,cmatrix &y, int n,int kt);
void cvench(int a,int &c0,int &c1);
void cvdecods(cmatrix &y,cmatrix &cs, imatrix &a, int n);
void cvdecodh(imatrix &y, imatrix &a, int n);
void interl(cmatrix &x,cmatrix &y,int m,int n);
void interlb(imatrix &x,imatrix &y,int m,int n);
//void primaldh(imatrix &y, imatrix &a, int n,int mnp);
void mult(cmatrix &x,cmatrix &y, cmatrix&xm,int n,int kt);
Complex qpidqpskmod(int a2, int a1, const Complex& x1);
void qpidqpskdem(const Complex& y, const Complex& y1, int& a2, int& a1);
Complex qpiqpskmod(int a2, int a1);
void qpiqpskdem(const Complex &x,int &a2, int &a1);
Complex dqpskmod(int a2, int a1, const Complex& x1);
void dqpskdem(const Complex& y, const Complex& y1, int& a2, int& a1);
void lpf(double fmT,int n, matrix &h);
int pnenc(int n);
int pndec(int n, int x);
Complex qpskmod(int a2, int a1);
void qpskdem(const Complex &x,int &a2, int &a1);
void shaping(matrix &g, float T, int N, float beta);
int vtb3mlse(Complex &yk,Complex &c0, Complex &c1,
            Complex &c2, int nd, int init_fl=0);
Complex ray_fade(float fm, float T, int k, int N=8);
Complex jakes(float fm, float T, int k, int N=8);
float sa(float x);
float sinc(float x);
float rcos_sr(float b, float T, float step, int k);
void spectrum(float (*func)(float),matrix &sp_freq, matrix & sp_amp, matrix &sp_phase, int n, float T);
//float func(float x){ }
//T=function period, from 0 to T
//n=pow(2,r)=number of points in FFT, dimension of freq, amp and phase is n/2
//sampling-rate=T/n


#endif

