
/***************************************************************/
/*Copyright (c) by Continocean Tech Inc. 	       	       */
/*12 Mountain Ave., Montville, New Jersey, USA 07045           */
/*All rights reserved. No part of this work covered by the     */
/*copyright hereon may be reproduced or used in any form or by */
/*any means----graphic, electronic, or mechanical, including   */
/*photocopying, recording, taping, or information storage and  */
/*retrieval systems----without written permission of 	       */
/*Continocean Tech inc.					       */
/***************************************************************/


#ifndef _MATRIX_H
#define _MATRIX_H	1	//prevent multiple #includes





#include "win.h"

class cmatrix;
class imatrix;
void printw(char *fmt, ...);
double round_max(double &max_x);
double round_min(double &min_x);

class matrix{
	friend class cmatrix;
protected:
	 int		M;			// number of rows
	 int		N;			// number of columns
	 double		*X;


public:

	 matrix ();
	 matrix (int m, int n=1);
	 matrix (const matrix &a);
	 matrix (const imatrix &a);
	~matrix ();


	 matrix&	operator  = (const matrix& a);
	 double&        operator () (int i,int j) const;
	 double&        operator () (int i) const;

	friend matrix operator +(const matrix&, const matrix&);
	friend matrix operator -(const matrix&, const matrix&);
	friend matrix operator -(const matrix&);
	friend matrix operator *(double, const matrix&);
	friend matrix operator *(const matrix&, double);
	friend matrix operator *(const matrix&, const matrix&);
	friend double **array(const matrix& a);	//make matrix a(m,n) into array aa[][] for
						//faster addressing.
	friend matrix operator /(const matrix&, const matrix&);  
	friend matrix operator /(double,const matrix&);  
	friend matrix operator /(const matrix&, double);  

	friend matrix operator |(const matrix&, const matrix&);  //or
	friend matrix operator &(const matrix&, const matrix&);  //and
	friend matrix operator ^(const matrix&, const matrix&);  //X-or

	friend int operator ==(const matrix&, const matrix&);  
	friend int operator !=(const matrix&, const matrix&);  

	friend double abs(const matrix &a); //sqrt(sum a(i,j)*a(i,j)) 
	friend double normsq(const matrix &a); //sum a(i,j)*a(i,j) 
	friend double det(const matrix &a); 
	friend matrix diag(const matrix &a); 
	friend matrix init(matrix& a, double x ...);
	friend matrix identity(int); 
	friend matrix joinr(const matrix &a, const matrix &b); //right join matrices a,b as (a b)
	friend matrix joinr(const matrix &a, double b); //right join row-vector a 
						  //with double b as (a b)
	friend matrix joinr(double a, const matrix & b); //right join double a 
						  //with row-vector b as (a b)
	friend matrix joind(const matrix &a, const matrix &b);
	friend matrix joinl(const matrix &a, const matrix &b); //lower join matrices a,b as |a|
						   //				|b|	
	friend matrix joinl(const matrix &a, double b);  //lower join column-vector a   |a|
						   //with double b as	 	  |b|
	friend matrix joinl(double a, const matrix& b);  //lower join double a with    |a|
						   //column-vector b as		 |b|
	friend void phasecontinue(const matrix& p);
	friend void phasefollow(const matrix& p1,const matrix& p2);
	//p1 follows p2.

	friend matrix shiftl(const matrix&);//shift left
	friend matrix shiftr(const matrix&);//shift right
	friend matrix shiftu(const matrix&);//shift up
	friend matrix shiftd(const matrix&);//shift down
	friend matrix sub(const matrix& a, int m1, int n1, int m2, int n2);//Take submatrix	
				//beginning at a(m1,n1) and ending at a(m2,n2)
	friend matrix TT(const matrix&);  //transpose
	friend void printf(const matrix &a);  //Usage:printf(a)
	friend void printw(const matrix &a);  //Usage:printf(a)
	friend void fprintf(FILE *fp,const matrix &a);  //Usage:fprintf(fp,a)
	friend void fscanf(FILE *fp, matrix &a);  //Usage:fscanf(fp,a)

	friend double Max(matrix &a);
	friend double Min(matrix &a);
	friend double Max(matrix &a, double &y_max, int &i_max, int &j_max);
	friend double Min(matrix &a, double &y_min, int &i_min, int &j_min);

	friend matrix convol(matrix &x, matrix &y);

	friend void plot(matrix &a);
	friend void plot(matrix &a, matrix &b);
	friend void plot(matrix &a, matrix &b1, matrix &b2);
	friend void plot(matrix &a, matrix &b1, matrix &b2, matrix &b3);
	friend void plot(matrix &a, matrix &b1, matrix &b2, matrix &b3, matrix &b4);
	friend void plot(matrix &a, matrix &b1, matrix &b2, matrix &b3, matrix &b4, matrix &b5);

	friend matrixn corr(matrix& x, matrix& y);
	friend matrixn corrnorm(matrix &x, matrix &y);

};/*end of class*/



#endif 	

