// =========================================================================
//       LEdit wrapper for Microsoft MFC 2.5 & 3.0 (16-/32-bit Windows)
//       ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//       Version 1.08
//       (c) 1996-1996 Andrey B. Yastrebov
//       Nobody can modify this file without written permission of author
//
//       Limitations of current version:
//       Summary length of all editing files: min(ca 60M,your memory)
//       Maximum line length: 8K
//
//       Windows      is a trademark of Microsoft corp.
//
//       If you have some questions please contact:  xor@hawk.usr.pu.ru
// =========================================================================
#include "stdafx.h"
#include "lemfc.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#define COMMAND_LIST case ID_EDIT_UNDO: cmd = EC_EDITUNDO; break; \
					 case ID_EDIT_REDO: cmd = EC_EDITREDO; break; \
					 case ID_EDIT_CLEAR: cmd = EC_EDITCLEAR; break; \
					 case ID_EDIT_CLEAR_ALL: cmd = EC_TOOLSCLEARALL; break; \
                     case ID_EDIT_CUT: cmd = EC_EDITCUT; break; \
                     case ID_EDIT_COPY: cmd = EC_EDITCOPY; break; \
                     case ID_EDIT_PASTE: cmd = EC_EDITPASTE; break; \
                     case ID_EDIT_FIND: cmd = EC_SEARCHFIND; break; \
                     case ID_EDIT_REPEAT: cmd = EC_SEARCHNEXT; break; \
                     case ID_EDIT_REPLACE: cmd = EC_SEARCHREPLACE; break; \
                     case ID_EDIT_SELECT_ALL: cmd = EC_EDITSELECTALL; break; \
                     case EC_FILENEW: \
                     case EC_FILEOPEN: \
                     case EC_FILEREOPEN: \
                     case EC_FILESAVE: \
                     case EC_FILESAVEAS: \
                     case EC_EDITUNDO: \
                     case EC_EDITREDO: \
                     case EC_EDITCUT: \
                     case EC_EDITCOPY: \
                     case EC_EDITPASTE: \
                     case EC_EDITDUPLICATE: \
                     case EC_EDITCLEAR: \
                     case EC_SEARCHFIND: \
                     case EC_SEARCHREPLACE: \
                     case EC_SEARCHNEXT: \
                     case EC_SEARCHLINE: \
                     case EC_SEARCHBOOKMARK: \
                     case EC_SEARCHSETBOOKMARK: \
                     case EC_TOOLSCHANGEFONT: \
                     case EC_TOOLSCLEARALL: \
                     case EC_TOOLSCLEARUNDOBUFFER: \
                     break; // Do nothing

/////////////////////////////////////////////////////////////////////////////
// CLEdit

IMPLEMENT_DYNCREATE(CLEdit, CWnd)

CLEdit::CLEdit()
{
  LVer();
}

WNDPROC* 
CLEdit::GetSuperWndProcAddr()
{
   static WNDPROC NEAR pfnSuper;
   return &pfnSuper;
}

BOOL 
CLEdit::Create(DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID)
{
   return CWnd::Create(LEDIT_CLASS, NULL, dwStyle, rect, pParentWnd, nID);
}


CLEdit::~CLEdit()
{
  DestroyWindow();
}


BEGIN_MESSAGE_MAP(CLEdit, CWnd)
	//{{AFX_MSG_MAP(CLEdit)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

HANDLE
CLEdit::GetText()
{
  HANDLE Result = ::GlobalAlloc(GMEM_MOVEABLE,GetTextLength()+1);
  if (Result)
	 {
		char far* Buf = (char far*) ::GlobalLock(Result);
		if (Buf)
		  {
			 if (! GetText(Buf))
				{
				  ::GlobalUnlock(Result);
				  ::GlobalFree(Result);
				  Result = 0;
				}
			 else ::GlobalUnlock(Result);
		  }
		else
		  {
			 ::GlobalFree(Result);
			 Result = 0;
		  }
	 };
  return Result;
}

void
CLEdit::SetText(HANDLE hGlobal)
{
  char far* Buf = (char far*) ::GlobalLock(hGlobal);
  if (Buf) SetText(Buf);
  ::GlobalUnlock(hGlobal);
}

HANDLE
CLEdit::GetSelText()
{
  HANDLE Result = ::GlobalAlloc(GMEM_MOVEABLE,GetTextLength()+1);
  if (Result)
	 {
		char far* Buf = (char far*) ::GlobalLock(Result);
		if (Buf)
		  {
			 if (! GetSelText(Buf))
				{
				  ::GlobalUnlock(Result);
				  ::GlobalFree(Result);
				  Result = 0;
				}
			 else ::GlobalUnlock(Result);
		  }
		else
		  {
			 ::GlobalFree(Result);
			 Result = 0;
		  }
	 };
  return Result;
}

void
CLEdit::SetSelText(HANDLE hGlobal)
{
  char far* Buf = (char far*) ::GlobalLock(hGlobal);
  if (Buf) SetSelText(Buf);
  ::GlobalUnlock(hGlobal);
}                          

void
CLEdit::SetSyntax(char far* syntax, int flags)
{
  char far* Sx;
  int W = 0;       
  SYNTAX Syntax[256];
  if (*syntax != 0)
	 {
		for (Sx = syntax;(*Sx != 0) && (W < 254);Sx++)
		switch (*Sx)
		  {
			 case '0':
				{
				  Syntax[W].cFirst = 1;
				  Syntax[W].cSecond = 1;
				  W++;
				  break;
				}
			 case '1':
				{
				  if (*(Sx+1) == 0)
					 break;
				  Sx++;
				  Syntax[W].cFirst = *Sx;
				  Syntax[W].cSecond = 0;
				  W++;
				  break;
				}
			 case '2':
				{
				  if (*(Sx+1) == 0)
					 break;
				  if (*(Sx+2) == 0)
					 {
						Sx++;
						break;
					 }
				  Sx++;
				  Syntax[W].cFirst = *Sx;
				  Sx++;
				  Syntax[W].cSecond = *Sx;
				  W++;
				  break;
				}
		  }
	 }
  SetSyntax(Syntax,W,flags);
}

void
CLEdit::SetSelection(long StartLine,short int StartPosition, long EndLine,
  short int EndPosition)
{
  LEDITPOSITION Pos;
  Pos.StartLine = StartLine;
  Pos.StartPosition = StartPosition;
  Pos.EndLine = EndLine;
  Pos.EndPosition = EndPosition;
  SetSelection(Pos);
}

BOOL
CLEdit::IsSelection()
{
  LEDITPOSITION Pos;
  GetSelection(Pos);
  return (Pos.StartPosition != Pos.EndPosition) ||
			(Pos.StartLine != Pos.EndLine);
}

void
CLEdit::SetScrollBars(BOOL horzScrollBar, BOOL vertScrollBar)
{
  SetHorzScrollBar(horzScrollBar);
  SetVertScrollBar(vertScrollBar);
}

void
CLEdit::SetHorzScrollBar(BOOL horzScrollBar)
{
  (horzScrollBar) ?
	SendMessage(EM_SETMETRICS,0,SendMessage(EM_GETMETRICS) | 0x10000L)
   :SendMessage(EM_SETMETRICS,0,SendMessage(EM_GETMETRICS) & 0xFFFEFFFFL);
}

void
CLEdit::SetVertScrollBar(BOOL vertScrollBar)
{
  (vertScrollBar) ?
	SendMessage(EM_SETMETRICS,0,SendMessage(EM_GETMETRICS) | 0x20000L)
   :SendMessage(EM_SETMETRICS,0,SendMessage(EM_GETMETRICS) & 0xFFFDFFFFL);
}

void
CLEdit::SetExtraSpacing(short horzSpacing, short vertSpacing)
{
  SetHorzScrollBar(horzSpacing);
  SetVertScrollBar(vertSpacing);
}

void
CLEdit::SetExtraHorzSpacing(short horzSpacing)
{
   SendMessage(EM_SETMETRICS,0,(SendMessage(EM_GETMETRICS)
     & 0xFFFFFFF0L) | (horzSpacing & 0xF));
}

void
CLEdit::SetExtraVertSpacing(short vertSpacing)
{
   SendMessage(EM_SETMETRICS,0,(SendMessage(EM_GETMETRICS)
     & 0xFFFFFF0FL) | ((vertSpacing >> 4) & 0xF));
}
/////////////////////////////////////////////////////////////////////////////
// CLEditView

IMPLEMENT_DYNCREATE(CLEditView, CView)

CLEditView::CLEditView()
{     
   LVer();
   m_clrBackColor = GetSysColor(COLOR_WINDOW);
   m_clrForeColor = GetSysColor(COLOR_WINDOWTEXT);
   m_clrBackColorSelected = GetSysColor(COLOR_HIGHLIGHT);
   m_clrForeColorSelected = GetSysColor(COLOR_HIGHLIGHTTEXT);
   m_bUseMemoryDC = FALSE;
}

CLEditView::~CLEditView()
{
    ASSERT(m_hWnd == NULL);
}

BEGIN_MESSAGE_MAP(CLEditView, CView)
	//{{AFX_MSG_MAP(CLEditView)
    ON_WM_CREATE()
    ON_WM_CTLCOLOR()
    ON_MESSAGE(EM_CTLCOLOR, OnEmCtlColor)
    ON_MESSAGE(EM_CTLCOLOREX, OnEmCtlColorEx)
    ON_MESSAGE(EM_DRAW, OnEmDraw)
    ON_MESSAGE(EM_FINDBRACE, OnEmFindBrace)
    ON_MESSAGE(EM_WORDCLICK, OnEmWordClick)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
	// Standard Print commands (print only - not preview)
END_MESSAGE_MAP()

const DWORD CLEditView::dwStyleDefault =
	AFX_WS_DEFAULT_VIEW |
	WS_HSCROLL | WS_VSCROLL |
	ES_SMALLINDENT;
	
WNDPROC* 
CLEditView::GetSuperWndProcAddr()
{
	static WNDPROC NEAR pfnSuper;
	return &pfnSuper;
}

/////////////////////////////////////////////////////////////////////////////
// CLEditView message handlers

// class name for control creation
static char BASED_CODE szClassName[] = LEDIT_CLASS;

int 
CLEditView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
    if (CView::OnCreate(lpCreateStruct) == -1)
        return -1;
    
    SendMessage(EM_SETRUNTIMEFLAGS,EMP_16_AS32);
    SendMessage(EM_EX_SETHANDLE,EC_DEFAULT_LEDIT_ID,(UINT)GetSafeHwnd());
    return 0;
}

HBRUSH 
CLEditView::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
    // TODO: Add your message handler code here and/or call default
    pDC->SetBkColor(m_clrBackColor);
    pDC->SetTextColor(m_clrForeColor);
    return 0;
}

LRESULT 
CLEditView::OnEmCtlColor(WPARAM wp, LPARAM lp)
{
    CDC* pDC = CDC::FromHandle((HDC) wp);
    pDC->SetBkColor(m_clrBackColorSelected);
    pDC->SetTextColor(m_clrForeColorSelected);
    return 0;
}

LRESULT 
CLEditView::OnEmDraw(WPARAM wp, LPARAM lp)
{
  HDC DC = (HDC) wp;
  LRESULT LResult = 0;
  HDC MemDC;
  HBITMAP BitMap;
  RECT Attr;

  GetClientRect(&Attr);

  // Involve bitmap if needed
  if ( m_bUseMemoryDC )
	 {
		MemDC = ::CreateCompatibleDC(DC);
		if ( MemDC )
		  {
			 BitMap = ::CreateCompatibleBitmap(DC,Attr.right,Attr.bottom);
			 if ( BitMap )
				{
				  // Set result to return
				  LResult = (int) BitMap;

				  // Select the bitmap in MemDC and retrieve
				  // the handle of previous bitmap
				  BitMap = (HBITMAP) ::SelectObject(MemDC,BitMap);

				  // Bind all drawing to MemDC
				  DC = MemDC;
				}
			 else
				{
				  // We need not MemDC if we haven't got any bitmap
				  ::DeleteDC(MemDC);
				  MemDC = 0;
				}
		  }
	 }
  else MemDC = 0;

  // Call User Function Draw(DC)
  {
    CDC* pDC = CDC::FromHandle(DC);
    OnDrawBehind(pDC);
  }

  // Delete memory DC if it exists
  if ( MemDC )
	 {
		SelectObject(MemDC,BitMap);
		DeleteDC(MemDC);
	 }

  // Return value that was prepared
  return LResult;
}

LRESULT 
CLEditView::OnEmCtlColorEx(WPARAM wp, LPARAM lp)
{
  WORDDESC far* pWD = (WORDDESC far*) lp;
  CDC* pDC = CDC::FromHandle((HDC) wp);
  OnControlHighlight(*pWD,pDC);
  return 0;
}

LRESULT 
CLEditView::OnEmFindBrace(WPARAM wp, LPARAM lp)
{
  WORDDESC far* pWD = (WORDDESC far*) lp;
  return (OnFindBrace(*pWD));
}

LRESULT 
CLEditView::OnEmWordClick(WPARAM wp, LPARAM lp)
{
  if (lp == 0)
    return 0;
  WORDDESC far* pWD = (WORDDESC far*) lp;
  return (OnWordClick(*pWD));
}
      
////////////////////////////////////
// Target for all the messages
//            
#ifdef WIN32
#define NOTIFY_CODE HIWORD(wParam)         
#else
#define NOTIFY_CODE HIWORD(lParam)
#endif                 
                 
LRESULT 
CLEditView::WindowProc(UINT message, WPARAM wParam, LPARAM lParam)
{                                    
if (message == WM_COMMAND)             
{                
  unsigned short cmd = LOWORD(wParam);
  switch (cmd)
  {           
    default:
      return CView::WindowProc(message, wParam, lParam);
    case EC_DEFAULT_LEDIT_ID:
      switch (NOTIFY_CODE)
      {
        case EN_CHANGE: 
          {                 
            CDocument* Doc = GetDocument();
            if (Doc)
              Doc->SetModifiedFlag(GetLEditCtrl().IsModified(15));
            OnChange();
            break;
          }
        case EN_HSCROLL:
          OnHorzScroll();
          break;
        case EN_VSCROLL:
          OnVertScroll(); 
          break;
        case EN_NEWFILE:
          OnNewFile();
          break;
        case EN_NEWFONT:
          OnNewFont();
          break;
        case EN_INSERTMODE:
        case EN_OVERWRITEMODE:
          OnChangeMode();
          break;
        case EN_GOINGTOCLOSE:
          return OnGoingToClose();
        case EN_STOREFILE:
          return OnAskIfStoreFile();
        case EN_FILEERROR:
          return OnFileError();
        case EN_CLIPBOARD:
          return OnClipboardError();
        case EN_MAXTEXT:
          return OnMaxText();
        case EN_ERRSPACE:
          return OnSpaceError();
      }
      return CMD_DOITYOURSELF;
    COMMAND_LIST // Translates cmd as needed. Catch up all the
                 // command handled. Others go to default.
  }          
  return DefWindowProc(WM_COMMAND,cmd,0);
}
else
  return CView::WindowProc(message, wParam, lParam);
}

BOOL CLEditView::OnCmdMsg(UINT nID, int nCode, void* pExtra,
        AFX_CMDHANDLERINFO* pHandlerInfo)
{                       
  if (nCode == CN_UPDATE_COMMAND_UI)
  {
    unsigned short cmd = nID;
    switch (cmd)
    {  
       default:
         return CView::OnCmdMsg(nID,nCode,pExtra,pHandlerInfo); 
       COMMAND_LIST // Translates cmd as needed. Catch up all the
                 // command handled. Others go to default.
    }
    CCmdUI* CmdUI = (CCmdUI*) pExtra;
    CmdUI->Enable(SendMessage(EM_CANEXECUTECOMMAND,cmd) != 0);
    return TRUE;
  
  }
  else if (nCode == CN_COMMAND)
  {
    unsigned short cmd = nID;
    switch (cmd)
    {
       default:
         return CView::OnCmdMsg(nID,nCode,pExtra,pHandlerInfo); 
       COMMAND_LIST // Translates cmd as needed. Catch up all the
                 // command handled. Others go to default.
    }
    SendMessage(WM_COMMAND,cmd);
    return TRUE;
  }
  else return CView::OnCmdMsg(nID,nCode,pExtra,pHandlerInfo);
}


BOOL 
CLEditView::PreCreateWindow(CREATESTRUCT& cs)
{
	ASSERT(cs.lpszClass == NULL);
	cs.lpszClass = szClassName;

	// map default CView style to default CEditView style
	if (cs.style == AFX_WS_DEFAULT_VIEW)
		cs.style = dwStyleDefault;

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CLEditView document like functions

void CLEditView::DeleteContents()
{
	ASSERT_VALID(this);
	ASSERT(m_hWnd != NULL);
	GetLEditCtrl().Clear();
	GetLEditCtrl().ClearModify(15);
	CDocument* Doc = GetDocument();
	if (Doc)
	  Doc->SetModifiedFlag(FALSE);
	ASSERT_VALID(this);
}

void CLEditView::Serialize(CArchive& ar)
// Read and write CLEditView object to archive, with length prefix.
{
	ASSERT_VALID(this);
	ASSERT(m_hWnd != NULL);
	if (ar.IsStoring())
	{
		DWORD dwLen = GetLEditCtrl().GetTextLength();
		ar << dwLen;
		WriteToArchive(ar);
	}
	else
	{
		DWORD dwLen;
		ar >> dwLen;
		ReadFromArchive(ar, dwLen);
	}
	ASSERT_VALID(this);
}

void CLEditView::SerializeRaw(CArchive& ar)
        // Read/Write object as stand-alone file.
{
        ASSERT_VALID(this);
        if (ar.IsStoring())
        {
                WriteToArchive(ar);
        }
        else
        {
                CFile* pFile = ar.GetFile();
                ASSERT(pFile->GetPosition() == 0);
                DWORD dwFileSize = pFile->GetLength();
                ReadFromArchive(ar, dwFileSize);
        }
        ASSERT_VALID(this);
}


void CLEditView::ReadFromArchive(CArchive& ar, DWORD dwLen)
	// Read certain amount of text from the file, assume at least dwLen
	// bytes are in the file.
{
	ASSERT_VALID(this);
    DWORD pos = 0;
    HANDLE H = ::GlobalAlloc(GMEM_MOVEABLE, dwLen+1);
    if (H == 0)
		return;
    char HUGE_PTR* Pt = (char HUGE_PTR*) ::GlobalLock(H);
    if (Pt == NULL)
	  {
		 ::GlobalFree(H);
		 return;
	  }
	  
#define PART 0x4000  

    while (pos != dwLen)
	 {
		DWORD rest = 0x10000L - FP_OFF(Pt);
		rest = ((dwLen-pos) > rest) ? rest : (dwLen-pos);
		int toWrite = (rest > PART) ? PART : LOWORD(rest);
		int read = ar.Read((char far*) Pt, toWrite);
		if (read != toWrite)
		  {
			 ::GlobalUnlock(H);
			 ::GlobalFree(H);
			 return;
		  }
		Pt += toWrite;
		pos += toWrite;
	 }           
	*Pt = 0;
    GetLEditCtrl().SetText(H);
    GetLEditCtrl().EmptyUndoBuffer();
    GetLEditCtrl().ClearModify(15);
    ::GlobalUnlock(H);
    ::GlobalFree(H);
    ASSERT_VALID(this);
}

void CLEditView::WriteToArchive(CArchive& ar)
	// Write just the text to an archive, no length prefix.
{
	ASSERT_VALID(this);         
	HANDLE H = GetLEditCtrl().GetText();
    if (H == 0)
		return;
    char HUGE_PTR* Pt = (char HUGE_PTR*) ::GlobalLock(H);
    if (Pt == NULL)
		return;	 
		
	TRY {
    while (*Pt != 0)
	  {
		 char HUGE_PTR* PtX = Pt;
		 int toWrite = 0;
		 while ((*PtX != 0) && (toWrite <= PART) && ((FP_SEG(PtX) == FP_SEG(Pt))))
		   {
			 PtX++;
			 toWrite++;
		   }
		 ar.Write((char far*)Pt, toWrite);
		 Pt = PtX;
	 }
	} // TRY
	CATCH_ALL(e)
	{
		::GlobalUnlock(H);
		::GlobalFree(H);
		THROW_LAST();
		ASSERT(FALSE);
	}
	END_CATCH_ALL	
	::GlobalUnlock(H);
    ::GlobalFree(H);
    GetLEditCtrl().ClearModify(15);
	ASSERT_VALID(this);
}

/////////////////////////////////////////////////////////////////////////////
// CLEditView drawing

void CLEditView::OnPaint()
{
	Default();
}

void CLEditView::OnDraw(CDC*)
{
}

/////////////////////////////////////////////////////////////////////////////
// CLEditView "events" with implementations

void CLEditView::OnDrawBehind(CDC*)
{
}                     

void CLEditView::OnControlHighlight(WORDDESC& WD, CDC* pDC)
{
}

short CLEditView::OnFindBrace(WORDDESC& WD)
{ 
  return 0;
}

short CLEditView::OnWordClick(WORDDESC& WD)
{          
  return 0;
}
              
void CLEditView::OnChange()
{
}

void CLEditView::OnHorzScroll()
{
}

void CLEditView::OnVertScroll()
{
}

void CLEditView::OnNewFile()
{
}

void CLEditView::OnNewFont()
{
}

void CLEditView::OnChangeMode()
{
}

short CLEditView::OnGoingToClose()
{
  return CMD_DOITYOURSELF;
}
   
short CLEditView::OnAskIfStoreFile()
{
  return CMD_DOITYOURSELF;
}

short CLEditView::OnFileError()
{
  return CMD_DOITYOURSELF; 
}

short CLEditView::OnClipboardError()
{
  return CMD_DOITYOURSELF;
}

short CLEditView::OnMaxText()
{
  return CMD_DOITYOURSELF;
}

short CLEditView::OnSpaceError()
{
  return CMD_DOITYOURSELF;
}
