/*  Project leowl_2
    xor@hawk.usr.pu.ru
    Copyright  1996. Andrey B. Yastrebov. All Rights Reserved.

    SUBSYSTEM:    leowl_2.exe Application
    FILE:         leowl_2c.cpp
    AUTHOR:       Andrey B. Yastrebov


    OVERVIEW
    ========
    Source file for implementation of leowl_2MDIClient (TMDIClient).
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include <dir.h>

#include "leowl_2.h"
#include "leowl_2e.h"
#include "leowl_2c.h"


//{{leowl_2MDIClient Implementation}}


//
// Build a response table for all messages/commands handled
// by leowl_2MDIClient derived from TMDIClient.
//
DEFINE_RESPONSE_TABLE1(leowl_2MDIClient, TMDIClient)
//{{leowl_2MDIClientRSP_TBL_BEGIN}}
    EV_COMMAND(CM_MDIFILENEW, CmFileNew),
    EV_COMMAND(CM_MDIFILEOPEN, CmFileOpen),
    EV_WM_DROPFILES,
//{{leowl_2MDIClientRSP_TBL_END}}
END_RESPONSE_TABLE;

IMPLEMENT_STREAMABLE1(leowl_2MDIClient, TMDIClient);
//////////////////////////////////////////////////////////
// leowl_2MDIClient
// ===========
// Construction/Destruction handling.
leowl_2MDIClient::leowl_2MDIClient (TModule* module)
 : TMDIClient (module)
{
    SetFlag(wfStreamTop);
    sB = 0;
    leG = new TLEditGroup(this, module);
}


leowl_2MDIClient::~leowl_2MDIClient ()
{
    Destroy();
}


//////////////////////////////////////////////////////////
// leowl_2MDIClient
// ===========
// MDIClient site initialization.
void leowl_2MDIClient::SetupWindow ()
{
    // Default SetUpWindow processing.
    TMDIClient::SetupWindow ();

    // Accept files via drag/drop in the client window.
    DragAcceptFiles(TRUE);
}

void leowl_2MDIClient::OpenFile (const char *fileName)
{

    //
    // Create a MDIChild window whose client is leowl_2Edit.
    //
    leowl_2Edit* clnt = new leowl_2Edit(0, 0, fileName);
    if (clnt->Attach(leG)) MessageBeep(0);
    TMDIChild* child = new TMDIChild(*this, "", clnt);

    // Associate ICON w/ this child window.
    child->SetIcon(GetApplication(), IDI_DOC);

    // If the current active MDI child is maximize then this one should be also.
    TMDIChild *curChild = GetActiveMDIChild();
    if (curChild && (curChild->GetWindowLong(GWL_STYLE) & WS_MAXIMIZE))
        child->Attr.Style |= WS_MAXIMIZE;

    //
    // User don't need ugly Message Boxes if he simply clicked "Cancel"
    //
    try
      {
         child->Create();
      }

    catch (TWindow::TXWindow)
      {
        delete child;
        return;
      }
    clnt->SetInsertMode(sB->GetModeIndicator(TStatusBar::Overtype));
}


//////////////////////////////////////////////////////////
// leowl_2MDIClient
// ===========
// Menu File New command
void leowl_2MDIClient::CmFileNew ()
{
  OpenFile(0);
}

//////////////////////////////////////////////////////////
// leowl_2MDIClient
// ===========
// Menu File Open command
void leowl_2MDIClient::CmFileOpen ()
{
   OpenFile(
     "LEdit-Ask-User-CPP/C++ files/*.cpp/Header files/*.h/All files/*.*/");
}

void leowl_2MDIClient::EvDropFiles (TDropInfo)
{
    Parent->ForwardMessage();
}

//
// Writes the MDIClient instance to the passed opstream.
//
void
leowl_2MDIClient::Streamer::Write(opstream& os) const
{
  leowl_2MDIClient* Obj = GetObject();
  WriteBaseObject((TMDIClient*) Obj, os);
  os << Obj->leG;
}

//
// Reads an instance of TMyMDIClient from the passed ipstream.
//
void *
leowl_2MDIClient::Streamer::Read(ipstream& is, uint32 /*version*/) const
{
  leowl_2MDIClient* Obj = GetObject();
  ReadBaseObject((TMDIClient*) Obj, is);
  is >> Obj->leG;
  return Obj;
}

