VERSION 4.00
Begin VB.Form frmMatrix 
   BorderStyle     =   4  'Fixed ToolWindow
   Caption         =   "Matrix"
   ClientHeight    =   4845
   ClientLeft      =   1890
   ClientTop       =   3270
   ClientWidth     =   7485
   Height          =   5250
   Left            =   1830
   MaxButton       =   0   'False
   MDIChild        =   -1  'True
   ScaleHeight     =   4845
   ScaleWidth      =   7485
   ShowInTaskbar   =   0   'False
   Top             =   2925
   Width           =   7605
   Begin VB.TextBox txt_Result 
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   0  'None
      Height          =   4110
      Left            =   105
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   0
      Top             =   630
      Width           =   7260
   End
   Begin Threed.SSPanel SSPanel1 
      Align           =   1  'Align Top
      Height          =   480
      Left            =   0
      TabIndex        =   1
      Top             =   0
      Width           =   7485
      _Version        =   65536
      _ExtentX        =   13203
      _ExtentY        =   847
      _StockProps     =   15
      ForeColor       =   -2147483640
      BackColor       =   12632256
      Begin VB.ComboBox cmb_Function 
         Height          =   315
         Left            =   1365
         TabIndex        =   2
         Top             =   90
         Width           =   4785
      End
      Begin Threed.SSCommand cmdNP 
         Height          =   300
         Index           =   1
         Left            =   7140
         TabIndex        =   6
         Top             =   90
         Width           =   255
         _Version        =   65536
         _ExtentX        =   450
         _ExtentY        =   529
         _StockProps     =   78
         Caption         =   ">"
         BevelWidth      =   1
         Font3D          =   3
         RoundedCorners  =   0   'False
         Outline         =   0   'False
      End
      Begin Threed.SSCommand cmdNP 
         Height          =   300
         Index           =   0
         Left            =   6300
         TabIndex        =   5
         Top             =   90
         Width           =   255
         _Version        =   65536
         _ExtentX        =   450
         _ExtentY        =   529
         _StockProps     =   78
         Caption         =   "<"
         BevelWidth      =   1
         Font3D          =   3
         RoundedCorners  =   0   'False
         Outline         =   0   'False
      End
      Begin VB.Label Label2 
         Caption         =   "&Select a function"
         Height          =   255
         Left            =   90
         TabIndex        =   4
         Top             =   120
         Width           =   1275
      End
      Begin Threed.SSCommand SSCommand1 
         Default         =   -1  'True
         Height          =   300
         Left            =   6615
         TabIndex        =   3
         Top             =   90
         Width           =   465
         _Version        =   65536
         _ExtentX        =   820
         _ExtentY        =   529
         _StockProps     =   78
         Caption         =   "&Go"
         BevelWidth      =   1
         RoundedCorners  =   0   'False
         Outline         =   0   'False
      End
   End
End
Attribute VB_Name = "frmMatrix"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit
Option Base 1

Private Const Iteration = 250

Dim IsLoaded         As Integer

Dim TimerStartOk     As Integer
Dim TimerCloseOk     As Integer

Dim TimerHandle      As Integer
Dim TimerValue       As Long

Private Sub cmdNP_Click(Index As Integer)

   Call sub_NextPrev(cmb_Function, Index)

End Sub


Private Sub cmb_Function_Click()
   
   If (IsLoaded = False) Then Exit Sub
   
   Call cDisableFI(mdiT2W.Picture1)
   
   txt_Result = ""
   
   DoEvents
   
   Select Case cmb_Function.ListIndex
      Case 0
         Call TestMatrixAdd
      Case 1
         Call TestMatrixSub
      Case 2
         Call TestMatrixMul
      Case 3
         Call TestMatrixCopy
      Case 4
         Call TestMatrixCompare
      Case 5
         Call TestMatrixFill
      Case 6
         Call TestMatrixDet
      Case 7
         Call TestMatrixInv
      Case 8
         Call TestMatrixTranspose
      Case 9
         Call TestMatrixMinorCofactor
      Case 10
         Call TestMatrixSymToeplitz
   End Select

   DoEvents
   Call cEnableFI(mdiT2W.Picture1)
   
End Sub


Private Sub Form_Activate()

   mdiT2W.Label2.Caption = cInsertBlocks(mdiT2W.Label2.Tag, "" & Iteration)

End Sub

Private Sub Form_Load()

   IsLoaded = False
   
   Show

   Call sub_Load_Combo(cmb_Function, T2WDirInst + "_matrix.t2w")
   
   IsLoaded = True
   
End Sub

Private Sub SSCommand1_Click()
   
   Call cmb_Function_Click
   
End Sub







Private Sub TestMatrixAdd()

   Dim lngResult        As Long
   Dim strResult        As String
   Dim strDisplay       As String
   
   Dim i                As Integer
   Dim j                As Integer
   
   Dim TmpA             As String
   Dim TmpB             As String
   Dim TmpC             As String

   ReDim ArrayA(1 To 3, 1 To 3) As Double
   ReDim ArrayB(1 To 3, 1 To 3) As Double
   ReDim ArrayC(1 To 3, 1 To 3) As Double

   Randomize Timer

   For i = 1 To 3
      For j = 1 To 3
         ArrayA(i, j) = Int(RandI * Rnd(1))
         ArrayB(i, j) = Int(RandI * Rnd(1))
         ArrayC(i, j) = 0
         TmpA = TmpA + Format$(ArrayA(i, j), "00000  ")
         TmpB = TmpB + Format$(ArrayB(i, j), "00000  ")
      Next j
      TmpA = TmpA + vbCrLf
      TmpB = TmpB + vbCrLf
   Next i

   Call cMatrixAdd(3, ArrayA(), ArrayB(), ArrayC())

   For i = 1 To 3
      For j = 1 To 3
         TmpC = TmpC + Format$(ArrayC(i, j), "00000  ")
      Next j
      TmpC = TmpC + vbCrLf
   Next i

   strDisplay = strDisplay & "First array (A) is " & vbCrLf & vbCrLf & TmpA & vbCrLf
   strDisplay = strDisplay & "Second array (B) is " & vbCrLf & vbCrLf & TmpB & vbCrLf
   strDisplay = strDisplay & "(A) + (B) = (C) is " & vbCrLf & vbCrLf & TmpC & vbCrLf

   txt_Result = strDisplay

   'time the function

   TimerHandle = cTimerOpen()
   TimerStartOk = cTimerStart(TimerHandle)
   
   For i = 1 To Iteration
      Call cMatrixAdd(3, ArrayA(), ArrayB(), ArrayC())
   Next i
   
   mdiT2W.pnl_Timer = cTimerRead(TimerHandle)
   
   TimerCloseOk = cTimerClose(TimerHandle)

End Sub



Private Sub TestMatrixSub()

   Dim lngResult        As Long
   Dim strResult        As String
   Dim strDisplay       As String
   
   Dim i                As Integer
   Dim j                As Integer
   
   Dim TmpA             As String
   Dim TmpB             As String
   Dim TmpC             As String

   ReDim ArrayA(1 To 3, 1 To 3) As Double
   ReDim ArrayB(1 To 3, 1 To 3) As Double
   ReDim ArrayC(1 To 3, 1 To 3) As Double

   Randomize Timer

   For i = 1 To 3
      For j = 1 To 3
         ArrayA(i, j) = Int(RandI * Rnd(1))
         ArrayB(i, j) = Int(RandI * Rnd(1))
         ArrayC(i, j) = 0
         TmpA = TmpA + Format$(ArrayA(i, j), "00000  ")
         TmpB = TmpB + Format$(ArrayB(i, j), "00000  ")
      Next j
      TmpA = TmpA + vbCrLf
      TmpB = TmpB + vbCrLf
   Next i

   Call cMatrixSub(3, ArrayA(), ArrayB(), ArrayC())

   For i = 1 To 3
      For j = 1 To 3
         TmpC = TmpC + Format$(ArrayC(i, j), "00000  ")
      Next j
      TmpC = TmpC + vbCrLf
   Next i

   strDisplay = strDisplay & "First array (A) is " & vbCrLf & vbCrLf & TmpA & vbCrLf
   strDisplay = strDisplay & "Second array (B) is " & vbCrLf & vbCrLf & TmpB & vbCrLf
   strDisplay = strDisplay & "(A) - (B) = (C) is " & vbCrLf & vbCrLf & TmpC & vbCrLf

   txt_Result = strDisplay

   'time the function

   TimerHandle = cTimerOpen()
   TimerStartOk = cTimerStart(TimerHandle)
   
   For i = 1 To Iteration
      Call cMatrixSub(3, ArrayA(), ArrayB(), ArrayC())
   Next i
   
   mdiT2W.pnl_Timer = cTimerRead(TimerHandle)
   
   TimerCloseOk = cTimerClose(TimerHandle)

End Sub

Private Sub TestMatrixMul()

   Dim lngResult        As Long
   Dim strResult        As String
   Dim strDisplay       As String
   
   Dim i                As Integer
   Dim j                As Integer
   
   Dim TmpA             As String
   Dim TmpB             As String
   Dim TmpC             As String

   ReDim ArrayA(1 To 3, 1 To 3) As Double
   ReDim ArrayB(1 To 3, 1 To 3) As Double
   ReDim ArrayC(1 To 3, 1 To 3) As Double

   Randomize Timer

   For i = 1 To 3
      For j = 1 To 3
         ArrayA(i, j) = Int(RandI * Rnd(1))
         ArrayB(i, j) = Int(RandI * Rnd(1))
         ArrayC(i, j) = 0
         TmpA = TmpA + Format$(ArrayA(i, j), "00000  ")
         TmpB = TmpB + Format$(ArrayB(i, j), "00000  ")
      Next j
      TmpA = TmpA + vbCrLf
      TmpB = TmpB + vbCrLf
   Next i

   Call cMatrixMul(3, ArrayA(), ArrayB(), ArrayC())

   For i = 1 To 3
      For j = 1 To 3
         TmpC = TmpC + Format$(ArrayC(i, j), "0000000000  ")
      Next j
      TmpC = TmpC + vbCrLf
   Next i

   strDisplay = strDisplay & "First array (A) is " & vbCrLf & vbCrLf & TmpA & vbCrLf
   strDisplay = strDisplay & "Second array (B) is " & vbCrLf & vbCrLf & TmpB & vbCrLf
   strDisplay = strDisplay & "(A) * (B) = (C) is " & vbCrLf & vbCrLf & TmpC & vbCrLf

   txt_Result = strDisplay

   'time the function

   TimerHandle = cTimerOpen()
   TimerStartOk = cTimerStart(TimerHandle)
   
   For i = 1 To Iteration
      Call cMatrixMul(3, ArrayA(), ArrayB(), ArrayC())
   Next i
   
   mdiT2W.pnl_Timer = cTimerRead(TimerHandle)
   
   TimerCloseOk = cTimerClose(TimerHandle)

End Sub

Private Sub TestMatrixCopy()

   Dim lngResult        As Long
   Dim strResult        As String
   Dim strDisplay       As String
   
   Dim i                As Integer
   Dim j                As Integer
   
   Dim TmpA             As String
   Dim TmpC             As String

   ReDim ArrayA(1 To 3, 1 To 3) As Double
   ReDim ArrayC(1 To 3, 1 To 3) As Double

   Randomize Timer

   For i = 1 To 3
      For j = 1 To 3
         ArrayA(i, j) = Int(RandI * Rnd(1))
         ArrayC(i, j) = 0
         TmpA = TmpA + Format$(ArrayA(i, j), "00000  ")
      Next j
      TmpA = TmpA + vbCrLf
   Next i

   Call cMatrixCopy(3, ArrayA(), ArrayC())

   For i = 1 To 3
      For j = 1 To 3
         TmpC = TmpC + Format$(ArrayC(i, j), "00000  ")
      Next j
      TmpC = TmpC + vbCrLf
   Next i

   strDisplay = strDisplay & "First array (A) is " & vbCrLf & vbCrLf & TmpA & vbCrLf
   strDisplay = strDisplay & "(A) = (C) is " & vbCrLf & vbCrLf & TmpC & vbCrLf

   txt_Result = strDisplay

   'time the function

   TimerHandle = cTimerOpen()
   TimerStartOk = cTimerStart(TimerHandle)
   
   For i = 1 To Iteration
      Call cMatrixCopy(3, ArrayA(), ArrayC())
   Next i
   
   mdiT2W.pnl_Timer = cTimerRead(TimerHandle)
   
   TimerCloseOk = cTimerClose(TimerHandle)

End Sub

Private Sub TestMatrixCompare()

   Dim intResult        As Integer
   Dim strResult        As String
   Dim strDisplay       As String
   
   Dim i                As Integer
   Dim j                As Integer
   
   Dim TmpA             As String
   Dim TmpC             As String

   ReDim ArrayA(1 To 3, 1 To 3) As Double
   ReDim ArrayC(1 To 3, 1 To 3) As Double

   Randomize Timer

   For i = 1 To 3
      For j = 1 To 3
         ArrayA(i, j) = Int(RandI * Rnd(1))
         ArrayC(i, j) = Int(RandI * Rnd(1))
         TmpA = TmpA + Format$(ArrayA(i, j), "00000  ")
         TmpC = TmpC + Format$(ArrayC(i, j), "00000  ")
      Next j
      TmpA = TmpA + vbCrLf
      TmpC = TmpC + vbCrLf
   Next i

   intResult = cMatrixCompare(3, ArrayA(), ArrayC())

   strDisplay = strDisplay & "First array (A) is " & vbCrLf & vbCrLf & TmpA & vbCrLf
   strDisplay = strDisplay & "Second array (C) is " & vbCrLf & vbCrLf & TmpC & vbCrLf
   strDisplay = strDisplay & "Compare of (A) = (C) is " & intResult & vbCrLf & vbCrLf

   TmpA = ""
   TmpC = ""

   For i = 1 To 3
      For j = 1 To 3
         ArrayA(i, j) = Int(RandI * Rnd(1))
         ArrayC(i, j) = ArrayA(i, j)
         TmpA = TmpA + Format$(ArrayA(i, j), "00000  ")
         TmpC = TmpC + Format$(ArrayC(i, j), "00000  ")
      Next j
      TmpA = TmpA + vbCrLf
      TmpC = TmpC + vbCrLf
   Next i

   intResult = cMatrixCompare(3, ArrayA(), ArrayC())

   strDisplay = strDisplay & "First array (A) is " & vbCrLf & vbCrLf & TmpA & vbCrLf
   strDisplay = strDisplay & "Second array (C) is " & vbCrLf & vbCrLf & TmpC & vbCrLf
   strDisplay = strDisplay & "Compare of (A) = (C) is " & intResult & vbCrLf & vbCrLf

   txt_Result = strDisplay

   'time the function

   TimerHandle = cTimerOpen()
   TimerStartOk = cTimerStart(TimerHandle)
   
   For i = 1 To Iteration
      intResult = cMatrixCompare(3, ArrayA(), ArrayC())
   Next i
   
   mdiT2W.pnl_Timer = cTimerRead(TimerHandle)
   
   TimerCloseOk = cTimerClose(TimerHandle)

End Sub

Private Sub TestMatrixFill()

   Dim intResult        As Integer
   Dim strResult        As String
   Dim strDisplay       As String
   
   Dim i                As Integer
   Dim j                As Integer
   
   Dim TmpA             As String

   ReDim ArrayA(1 To 3, 1 To 3) As Double

   Randomize Timer

   intResult = cMatrixFill(3, ArrayA(), MATRIX_ZERO)

   For i = 1 To 3
      For j = 1 To 3
         TmpA = TmpA + Format$(ArrayA(i, j), "00000  ")
      Next j
      TmpA = TmpA + vbCrLf
   Next i
   
   strDisplay = strDisplay & "Matrix ZERO is " & vbCrLf & vbCrLf & TmpA & vbCrLf & vbCrLf

   TmpA = ""
   intResult = cMatrixFill(3, ArrayA(), MATRIX_UNIT)

   For i = 1 To 3
      For j = 1 To 3
         TmpA = TmpA + Format$(ArrayA(i, j), "00000  ")
      Next j
      TmpA = TmpA + vbCrLf
   Next i
   
   strDisplay = strDisplay & "Matrix UNIT is " & vbCrLf & vbCrLf & TmpA & vbCrLf
   
   txt_Result = strDisplay

   'time the function

   TimerHandle = cTimerOpen()
   TimerStartOk = cTimerStart(TimerHandle)
   
   For i = 1 To Iteration
      Call cMatrixFill(3, ArrayA(), MATRIX_ZERO)
   Next i
   
   mdiT2W.pnl_Timer = cTimerRead(TimerHandle)
   
   TimerCloseOk = cTimerClose(TimerHandle)
   
End Sub

Private Sub TestMatrixDet()

   Dim intResult        As Integer
   Dim strResult        As String
   Dim strDisplay       As String
   
   Dim i                As Integer
   Dim j                As Integer
   
   Dim det              As Double
   Dim nSize            As Integer

   Dim TmpA             As String

   ReDim ArrayA(1 To 3, 1 To 3) As Double

   Randomize Timer

   nSize = 3
   
   ReDim ArrayA(1 To nSize, 1 To nSize) As Double

   Randomize Timer

   For i = 1 To nSize
      For j = 1 To nSize
         ArrayA(i, j) = Int(RandI * Rnd(1))
         TmpA = TmpA + Format$(ArrayA(i, j), "00000  ")
      Next j
      TmpA = TmpA + vbCrLf
   Next i

   strDisplay = strDisplay & "First array (A) is " & vbCrLf & vbCrLf & TmpA & vbCrLf
   strDisplay = strDisplay & "Det of (A) = " & cMatrixDet(nSize, ArrayA()) & vbCrLf & vbCrLf

   txt_Result = strDisplay

   'time the function

   TimerHandle = cTimerOpen()
   TimerStartOk = cTimerStart(TimerHandle)
   
   For i = 1 To Iteration
      det = cMatrixDet(nSize, ArrayA())
   Next i
   
   mdiT2W.pnl_Timer = cTimerRead(TimerHandle)
   
   TimerCloseOk = cTimerClose(TimerHandle)

End Sub

Private Sub TestMatrixInv()

   Dim intResult        As Integer
   Dim strResult        As String
   Dim strDisplay       As String
   
   Dim i                As Integer
   Dim j                As Integer
   
   Dim TmpA             As String
   Dim TmpC             As String

   ReDim ArrayA(1 To 3, 1 To 3) As Double
   ReDim ArrayC(1 To 3, 1 To 3) As Double

   Randomize Timer

   intResult = cMatrixFill(3, ArrayA(), MATRIX_ZERO)
   intResult = cMatrixFill(3, ArrayC(), MATRIX_UNIT)

   For i = 1 To 3
      For j = 1 To 3
         ArrayA(i, j) = Int(RandI * Rnd(1))
         TmpA = TmpA + Format$(ArrayA(i, j), "00000  ")
      Next j
      TmpA = TmpA + vbCrLf
   Next i
   
   intResult = cMatrixInv(3, ArrayA(), ArrayC())

   If (intResult = True) Then

      For i = 1 To 3
         For j = 1 To 3
            TmpC = TmpC + Format$(ArrayC(i, j), "0.0000000  ")
         Next j
         TmpC = TmpC + vbCrLf
      Next i

   Else

      TmpC = " 'can be inverted'"

   End If

   strDisplay = strDisplay & "First array (A) is " & vbCrLf & vbCrLf & TmpA & vbCrLf
   strDisplay = strDisplay & "Inv of (A) = (C) is " & vbCrLf & vbCrLf & TmpC & vbCrLf

   TmpA = ""
   TmpC = ""

   intResult = cMatrixFill(3, ArrayA(), MATRIX_ZERO)
   intResult = cMatrixFill(3, ArrayC(), MATRIX_ZERO)

   For i = 1 To 3
      For j = 1 To 3
         TmpA = TmpA + Format$(ArrayA(i, j), "00000  ")
      Next j
      TmpA = TmpA + vbCrLf
   Next i
   
   intResult = cMatrixInv(3, ArrayA(), ArrayC())

   If (intResult = True) Then

      For i = 1 To 3
         For j = 1 To 3
            TmpC = TmpC + Format$(ArrayC(i, j), "0.0000000  ")
         Next j
         TmpC = TmpC + vbCrLf
      Next i

   Else

      TmpC = " 'can be inverted'" + vbCrLf

   End If

   strDisplay = strDisplay & "First array (A) is " & vbCrLf & vbCrLf & TmpA & vbCrLf
   strDisplay = strDisplay & "Inv of (A) = (C) is " & vbCrLf & vbCrLf & TmpC & vbCrLf

   TmpA = ""
   TmpC = ""

   intResult = cMatrixFill(3, ArrayA(), MATRIX_UNIT)
   intResult = cMatrixFill(3, ArrayC(), MATRIX_ZERO)

   For i = 1 To 3
      For j = 1 To 3
         TmpA = TmpA + Format$(ArrayA(i, j), "00000  ")
      Next j
      TmpA = TmpA + vbCrLf
   Next i
   
   intResult = cMatrixInv(3, ArrayA(), ArrayC())

   If (intResult = True) Then

      For i = 1 To 3
         For j = 1 To 3
            TmpC = TmpC + Format$(ArrayC(i, j), "0.0000000  ")
         Next j
         TmpC = TmpC + vbCrLf
      Next i

   Else

      TmpC = " 'can be inverted'" + vbCrLf

   End If

   strDisplay = strDisplay & "First array (A) is " & vbCrLf & vbCrLf & TmpA & vbCrLf
   strDisplay = strDisplay & "Inv of (A) = (C) is " & vbCrLf & vbCrLf & TmpC & vbCrLf

   txt_Result = strDisplay

   'time the function

   For i = 1 To 3
      For j = 1 To 3
         ArrayA(i, j) = Int(RandI * Rnd(1))
      Next j
   Next i

   TimerHandle = cTimerOpen()
   TimerStartOk = cTimerStart(TimerHandle)
   
   For i = 1 To Iteration
      Call cMatrixInv(3, ArrayA(), ArrayC())
   Next i
   
   mdiT2W.pnl_Timer = cTimerRead(TimerHandle)
   
   TimerCloseOk = cTimerClose(TimerHandle)

End Sub

Private Sub TestMatrixTranspose()

   Dim intResult        As Integer
   Dim strResult        As String
   Dim strDisplay       As String
   
   Dim i                As Integer
   Dim j                As Integer
   
   Dim TmpA             As String
   Dim TmpC             As String

   ReDim ArrayA(1 To 3, 1 To 3) As Double
   ReDim ArrayC(1 To 3, 1 To 3) As Double

   Randomize Timer

   For i = 1 To 3
      For j = 1 To 3
         ArrayA(i, j) = Int(RandI * Rnd(1))
         ArrayC(i, j) = 0
         TmpA = TmpA + Format$(ArrayA(i, j), "00000  ")
      Next j
      TmpA = TmpA + vbCrLf
   Next i

   Call cMatrixTranspose(3, ArrayA(), ArrayC())

   For i = 1 To 3
      For j = 1 To 3
         TmpC = TmpC + Format$(ArrayC(i, j), "00000  ")
      Next j
      TmpC = TmpC + vbCrLf
   Next i

   strDisplay = strDisplay & "First array (A) is " & vbCrLf & vbCrLf & TmpA & vbCrLf
   strDisplay = strDisplay & "Transpose of (A) = (C) is " & vbCrLf & vbCrLf & TmpC & vbCrLf

   TmpA = ""
   TmpC = ""
   
   Call cMatrixFill(3, ArrayA(), MATRIX_UNIT)

   For i = 1 To 3
      For j = 1 To 3
         TmpA = TmpA + Format$(ArrayA(i, j), "00000  ")
      Next j
      TmpA = TmpA + vbCrLf
   Next i

   Call cMatrixTranspose(3, ArrayA(), ArrayC())

   For i = 1 To 3
      For j = 1 To 3
         TmpC = TmpC + Format$(ArrayC(i, j), "00000  ")
      Next j
      TmpC = TmpC + vbCrLf
   Next i

   strDisplay = strDisplay & "First array (A) is " & vbCrLf & vbCrLf & TmpA & vbCrLf
   strDisplay = strDisplay & "Transpose of (A) = (C) is " & vbCrLf & vbCrLf & TmpC & vbCrLf

   txt_Result = strDisplay

   'time the function

   For i = 1 To 3
      For j = 1 To 3
         ArrayA(i, j) = Int(RandI * Rnd(1))
      Next j
   Next i

   TimerHandle = cTimerOpen()
   TimerStartOk = cTimerStart(TimerHandle)
   
   For i = 1 To Iteration
      Call cMatrixTranspose(3, ArrayA(), ArrayC())
   Next i
   
   mdiT2W.pnl_Timer = cTimerRead(TimerHandle)
   
   TimerCloseOk = cTimerClose(TimerHandle)

End Sub

Private Sub TestMatrixMinorCofactor()

   Dim intResult        As Integer
   Dim strResult        As String
   Dim strDisplay       As String
   
   Dim i                As Integer
   Dim j                As Integer
   
   Dim cofact           As Double
   Dim nSize            As Integer

   Dim TmpA             As String

   nSize = 3
   
   ReDim ArrayA(1 To nSize, 1 To nSize) As Double

   Randomize Timer

   For i = 1 To nSize
      For j = 1 To nSize
         ArrayA(i, j) = Int(RandI * Rnd(1))
         TmpA = TmpA + Format$(ArrayA(i, j), "00000  ")
      Next j
      TmpA = TmpA + vbCrLf
   Next i

   strDisplay = strDisplay & "Array (A) is " & vbCrLf & vbCrLf & TmpA & vbCrLf
   
   For i = 1 To 3
      For j = 1 To 3
         strDisplay = strDisplay & "CoFactor and Minor of A(" & i & "," & j & ") are " & cMatrixCoFactor(nSize, ArrayA(), i, j) & " and " & cMatrixMinor(nSize, ArrayA(), i, j) & vbCrLf
      Next j
      strDisplay = strDisplay & vbCrLf
   Next i
   
   txt_Result = strDisplay

   'time the function

   TimerHandle = cTimerOpen()
   TimerStartOk = cTimerStart(TimerHandle)
   
   For i = 1 To Iteration
      cofact = cMatrixCoFactor(nSize, ArrayA(), 1, 1)
   Next i
   
   mdiT2W.pnl_Timer = cTimerRead(TimerHandle)
   
   TimerCloseOk = cTimerClose(TimerHandle)

End Sub

Private Sub TestMatrixSymToeplitz()

   Dim intResult        As Integer
   Dim strResult        As String
   Dim strDisplay       As String
   
   Dim i                As Integer
   Dim j                As Integer
   
   Dim TmpA             As String
   Dim TmpC             As String

   ReDim ArrayA(1 To 3, 1 To 3) As Double
   ReDim ArrayC(1 To 3, 1 To 3) As Double

   Randomize Timer

   For i = 1 To 1
      For j = 1 To 3
         ArrayA(i, j) = Int(RandI * Rnd(1))
         TmpA = TmpA + Format$(ArrayA(i, j), "00000  ")
      Next j
      TmpA = TmpA + vbCrLf
   Next i

   intResult = cMatrixSymToeplitz(3, ArrayA(), ArrayC())

   For i = 1 To 3
      For j = 1 To 3
         TmpC = TmpC + Format$(ArrayC(i, j), "00000  ")
      Next j
      TmpC = TmpC + vbCrLf
   Next i

   strDisplay = strDisplay & "First array (A) is " & vbCrLf & vbCrLf & TmpA & vbCrLf
   strDisplay = strDisplay & "Symmetrical Toeplitz of (A) = (C) is " & vbCrLf & vbCrLf & TmpC & vbCrLf

   txt_Result = strDisplay

   'time the function

   For i = 1 To 1
      For j = 1 To 3
         ArrayA(i, j) = Int(RandI * Rnd(1))
      Next j
   Next i

   TimerHandle = cTimerOpen()
   TimerStartOk = cTimerStart(TimerHandle)
   
   For i = 1 To Iteration
      Call cMatrixSymToeplitz(3, ArrayA(), ArrayC())
   Next i
   
   mdiT2W.pnl_Timer = cTimerRead(TimerHandle)
   
   TimerCloseOk = cTimerClose(TimerHandle)

End Sub
