#include <windows.h>
#include "events.h"

#define DllExport __declspec( dllexport)
LRESULT CALLBACK CBTProc(int, WPARAM, LPARAM);

HANDLE hMapObject;
HHOOK *phHook;
HANDLE hRecalcEvent;
HANDLE hModule;
BOOL bInstalled;

BOOL WINAPI 
DllMain (HANDLE hDLL, DWORD dwReason, LPVOID lpReserved)
{
    BOOL bInit;
    switch (dwReason) {
	case DLL_PROCESS_ATTACH:
	    hModule = hDLL;
	    hRecalcEvent = OpenEvent(EVENT_MODIFY_STATE,FALSE,
				    RECALC_EVENT);
	    if (!hRecalcEvent) {
		return FALSE;
	    }

	    hMapObject = CreateFileMapping(
	    	(HANDLE) 0xFFFFFFFF,
		NULL,
		PAGE_READWRITE,
		0,
		sizeof(HHOOK),
		"NTRHookShMem");
	    if (!hMapObject) {
	    	return FALSE;
	    }
	    bInit = (GetLastError() != ERROR_ALREADY_EXISTS);
	    phHook = MapViewOfFile(
	    	hMapObject,
		FILE_MAP_WRITE,
		0,
		0,
		0);
	    if (!phHook) {
	    	return FALSE;
	    }
	    if (bInit) {
	    	*phHook = 0;
	    }
	    break;

	case DLL_THREAD_ATTACH:
	    break;

	case DLL_THREAD_DETACH:
	    break;

	case DLL_PROCESS_DETACH:
	    /* If we were the ones who called SetWindowsHookEx(), 
	     * then Unhook it. 
	     */

	    if (bInstalled) {
		UnhookWindowsHookEx(*phHook);
	    }
	    break;
    }

    return TRUE;
}

DllExport
int
InstallHook ()
{
    *phHook = SetWindowsHookEx( WH_CBT, CBTProc, hModule, 0);
    if (*phHook) {
	bInstalled = TRUE;
	return TRUE;
    }
    else {
	return (GetLastError());
    }
}


DllExport
int
UnInstallHook ()
{
    BOOL bResult;
    bResult = UnhookWindowsHookEx(*phHook);
    if (bResult) {
	*phHook = 0;
	return 0;
    }
    else {
	return (GetLastError());
    }
}

/****************************************************************
  WH_CBT hook procedure
 ****************************************************************/

LRESULT CALLBACK CBTProc(nCode, wParam, lParam)
int nCode;
WPARAM wParam;
LPARAM lParam;

{

    if (nCode < 0)  /* do not process message */
        return CallNextHookEx(*phHook, nCode, wParam, lParam);


    switch (nCode) {
        case HCBT_ACTIVATE:
            break;

        case HCBT_CLICKSKIPPED:
            break;

        case HCBT_CREATEWND:
            break;

        case HCBT_KEYSKIPPED:
            break;

        case HCBT_MOVESIZE:
        case HCBT_MINMAX:
        case HCBT_DESTROYWND:
	    SetEvent(hRecalcEvent);
            break;

        case HCBT_QS:
            break;

        case HCBT_SETFOCUS:
            break;

        case HCBT_SYSCOMMAND:

            break;

        default:
            break;
    }

    return CallNextHookEx(*phHook, nCode, wParam, lParam);
}

