// version 0.03 minor not-really-a-bug fixed with WaitForSingleObject
// version 0.02 added logging out when shell process ends
// version 0.01 initial release

#include "string.h"
#include "stdafx.h"
#include "process.h"
#include "conio.h"
#define MAXBUF 512

int main(int argc, char *argv[]) {
    HKEY hKey;
    DWORD  retCode1, retCode2, disp, size;
    if (argc == 1) { // read the registry and run the shell
        BYTE buffer[MAXBUF];
        char *buffptr;
        char shellname[MAXBUF];
 
        buffptr = (char *) buffer;
        size = MAXBUF;
        shellname[0] = 0x00;
 
        // read the existing value from the registry, if possible
        retCode1  = RegOpenKeyEx (HKEY_CURRENT_USER, "Software\\Public Domain\\SetShell", 0,  KEY_ENUMERATE_SUB_KEYS | KEY_EXECUTE | KEY_QUERY_VALUE, &hKey);
        retCode1 |= RegQueryValueEx(hKey, "Name", NULL, NULL, buffer, &size);
  
        if (retCode1 == ERROR_SUCCESS) 
            strcat(shellname, buffptr);
        else
            strcat(shellname, "progman.exe"); // use progman as a default if the registry read failed
 
        RegCloseKey(hKey);
 
        STARTUPINFO st;
        st.cb               = sizeof (STARTUPINFO);
        st.lpReserved       = 0;
        st.lpDesktop        = NULL;
        st.lpTitle          = NULL;
        st.dwX              = 0;
        st.dwY              = 0;
        st.dwXSize          = 0;
        st.dwYSize          = 0;
        st.dwXCountChars    = 0;
        st.dwYCountChars    = 0;
        st.dwFillAttribute  = 0;
        st.dwFlags          = 0;
        st.wShowWindow      = 0;
        st.cbReserved2      = 0;
        st.lpReserved2      = 0;
        PROCESS_INFORMATION pinfo;
        retCode1 = CreateProcess(NULL, shellname, NULL, NULL, FALSE, CREATE_NEW_CONSOLE, NULL, NULL, &st, &pinfo);
        HANDLE hProc;
        if (retCode1 == FALSE) {
            // try to run progman instead
            retCode1 = CreateProcess(NULL, "progman.exe", NULL, NULL, FALSE, DETACHED_PROCESS, NULL, NULL, &st, &pinfo);
            if (retCode1 == FALSE) {
                printf("Could not run Progman.exe!\n");
				while (!kbhit()); // give someone a chance to read the message
				exit(1);
            } else {
                hProc = pinfo.hProcess;
                CloseHandle(pinfo.hThread);
            }
        } else {
			hProc = pinfo.hProcess;
            CloseHandle(pinfo.hThread);
        }
        FreeConsole();	// detach from console window, so it can close
        if (WaitForSingleObject(hProc, INFINITE) != WAIT_FAILED)
            ExitWindows(0,0);
        CloseHandle(hProc);
    } else if (argc == 2) { // update the registry
        retCode1 = RegCreateKeyEx (HKEY_CURRENT_USER, "Software\\Public Domain\\SetShell", 0,  "", REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &disp);
        retCode2 = RegSetValueEx(hKey, "Name", 0, REG_SZ, (unsigned char*) argv[1], strlen(argv[1])+1);
  
        if (retCode1 == ERROR_SUCCESS) 
            RegCloseKey(hKey);
        if (retCode2 != ERROR_SUCCESS)
            printf("Could not change registry!\n");
    } else 
        printf("SetShell with no arguments runs the shell,\nSetShell with one argument updates the registry to remember\n the argument as the name of the shell to execute ");
 
    return 0;
}
