#if ! defined( NETWORK_USER_CLASS_HEADER )

/*
** Author: Samuel R. Blackburn
** CI$: 76300,326
** Internet: sammy@sed.csc.com
**
** You can use it any way you like.
*/

#define NETWORK_USER_CLASS_HEADER

class CNetworkFileInformation : public CObject
{
   DECLARE_SERIAL( CNetworkFileInformation )

   private:

      void m_Initialize( void );

   public:

      CNetworkFileInformation();
      CNetworkFileInformation( FILE_INFO_3 *information_p );
      virtual ~CNetworkFileInformation();

      DWORD   ID;
      DWORD   Permissions;
      DWORD   NumberOfLocks;
      CString PathName;
      CString UserName;

      virtual void Copy( FILE_INFO_3 *source );
      virtual void Empty( void );
      virtual void Serialize( CArchive& archive );
};

class CNetworkFiles : public CNetwork
{
   DECLARE_SERIAL( CNetworkFiles )

   private:

      void m_Initialize( void );

   protected:

      DWORD m_ErrorCode;

      /*
      ** Workstation information variables
      */

      FILE_INFO_3 *m_103InformationBuffer;

      /*
      ** File Information enumeration variables
      */

      DWORD m_103ResumeHandle;
      DWORD m_103CurrentEntryNumber;
      DWORD m_103NumberOfEntriesRead;
      DWORD m_103TotalNumberOfEntries;

   public:

      CNetworkFiles();
      CNetworkFiles( LPCTSTR machine_name );
      virtual ~CNetworkFiles();

      virtual void  Close( void );
      virtual BOOL  Enumerate( void );
      virtual DWORD GetErrorCode( void ) const;
      virtual BOOL  GetNext( CNetworkFileInformation& information );
      virtual void  Serialize( CArchive& archive );
};

#endif // NETWORK_USER_CLASS_HEADER
