#if ! defined( NETWORK_CLASS_HEADER )

/*
** Author: Samuel R. Blackburn
** CI$: 76300,326
** Internet: sammy@sed.csc.com
**
** You can use it any way you like as long as you don't try to sell it.
**
** Any attempt to sell WFC in source code form must have the permission
** of the original author. You can produce commercial executables with
** WFC but you can't sell WFC.
**
** Copyright, 1995, Samuel R. Blackburn
**
** $Workfile: $
** $Revision: $
** $Modtime: $
*/

#define NETWORK_CLASS_HEADER

class CNetwork : public CObject
{
   DECLARE_SERIAL( CNetwork )

   protected:

      LPWSTR m_WideMachineName;

      CString m_MachineName;

      DWORD m_ErrorCode;

   public:

      enum NetworkType //  From WINNETWK.H
      {
         MSNet     = WNNC_NET_MSNET,
         LanMan    = WNNC_NET_LANMAN,
         Netware   = WNNC_NET_NETWARE,
         Vines     = WNNC_NET_VINES,
         TenNet    = WNNC_NET_10NET,
         Locus     = WNNC_NET_LOCUS,
         SunPcNFS  = WNNC_NET_SUN_PC_NFS,
         LanStep   = WNNC_NET_LANSTEP,
         NineTiles = WNNC_NET_9TILES,
         Lantastic = WNNC_NET_LANTASTIC,
         AS400     = WNNC_NET_AS400,
         FtpNFS    = WNNC_NET_FTP_NFS,
         PathWorks = WNNC_NET_PATHWORKS,
         LifeNet   = WNNC_NET_LIFENET,
         PowerLan  = WNNC_NET_POWERLAN,
         BWNFS     = WNNC_NET_BWNFS,
         Cogent    = WNNC_NET_COGENT,
         Farallon  = WNNC_NET_FARALLON,
         AppleTalk = WNNC_NET_APPLETALK
      };

      CNetwork( LPCTSTR machine_name = NULL );
      virtual ~CNetwork();

      virtual void    Close( void );
      virtual DWORD   GetErrorCode( void ) const;
      virtual LPCTSTR GetMachineName( void );
      virtual void    Open( LPCTSTR machine_name = NULL );
      virtual void    Serialize( CArchive& archive );
      operator LPCWSTR() const { return( m_WideMachineName ); }
      operator LPWSTR()  const { return( m_WideMachineName ); }

#if defined( _DEBUG )

      virtual void Dump( CDumpContext& dump_context ) const;

#endif // _DEBUG
};

#endif // NETWORK_CLASS_HEADER
