#include "wfc.h"
#pragma hdrstop

/*
** Author: Samuel R. Blackburn
** CI$: 76300,326
** Internet: sammy@sed.csc.com
**
** You can use it any way you like.
*/

void list_services( LPCTSTR );
void print_error( LPCTSTR, DWORD );
void usage( void );

int main( int argc, char *argv[] )
{
   if ( argc < 2 )
   {
      list_services( NULL );
   }
   else
   {
      if ( strcmpi( argv[ 1 ], "/?" ) == 0 )
      {
         usage();
      }
      else
      {
         list_services( argv[ 1 ] );
      }
   }

   return( EXIT_SUCCESS );
}

void list_services( LPCTSTR machine_name )
{
   CServiceControlManager manager;

   if ( manager.Open( SC_MANAGER_ENUMERATE_SERVICE, NULL, machine_name ) != TRUE )
   {
      print_error( "Can't open service control manager", manager.GetErrorCode() );
   }

   if ( machine_name == NULL )
   {
      printf( "Services Running:\n" );
   }
   else
   {
      printf( "Services Running on %s:\n", machine_name );
   }

   if  ( manager.EnumerateStatus() == TRUE )
   {
      CStringArray services;
      CStringArray display_names;
      CServiceNameAndStatus status;

      int longest_service = 0;

      while( manager.GetNext( status ) == TRUE )
      {
         if ( status.ServiceStatus.dwCurrentState == SERVICE_RUNNING )
         {
            services.Add( status.lpServiceName );
            display_names.Add( status.lpDisplayName );

            if ( strlen( status.lpServiceName ) > longest_service )
            {
               longest_service = strlen( status.lpServiceName );
            }
         }
      }

      /*
      ** Now sort them for easy reading
      */

      BOOL sorted = FALSE;
      int here    = 0;
      int last_element = services.GetUpperBound();

      while( sorted == FALSE )
      {
         sorted = TRUE;
         here   = 0;

         while( here < last_element )
         {
            if ( services[ here ].CompareNoCase( services[ here + 1 ] ) > 0 )
            {
               CString temp_string;

               temp_string = services[ here ];
               services[ here ] = (LPCTSTR) services[ here + 1 ];
               services[ here + 1 ] = (LPCTSTR) temp_string;

               temp_string = display_names[ here ];
               display_names[ here ] = (LPCTSTR) display_names[ here + 1 ];
               display_names[ here + 1 ] = (LPCTSTR) temp_string;

               sorted = FALSE;
            }

            here++;
         }
      }

      here = 0;

      while( here <= last_element )
      {
         printf( "%-*s \"%s\"\n", longest_service, (LPCTSTR) services[ here ], (LPCTSTR) display_names[ here ] );
         here++;
      }
   }
   else
   {
      print_error( "Can't enumerate status\n", manager.GetErrorCode() );
   }
}

void usage( void )
{
   printf( "Show active services on a machine. Samuel R. Blackburn\n\n" );
   printf( "Service [[/?][machine_name]]\n\n" );
   printf( "Examples:\n" );
   printf( "\"service /?\"         displays this screen\n" );
   printf( "\"service\"            shows active services on this your machine\n" );
   printf( "\"service Enterprise\" shows active services on the machine named Enterprise\n" ); 
}

void print_error( LPCTSTR message, DWORD error_code )
{
   LPVOID message_buffer = (LPVOID) NULL;

   FormatMessage( FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
                  NULL,
                  error_code,
                  MAKELANGID( LANG_ENGLISH, SUBLANG_ENGLISH_US ),
        (LPTSTR) &message_buffer,
                  0,
                  NULL );

   if ( message_buffer != NULL )
   {
      printf( "%s\nError is %s\n", message, (LPCTSTR) message_buffer );

      LocalFree( message_buffer );
   }
   else
   {
      printf( "%s\nError Code is %d\n", message, error_code );
   }
}
