#include <wfc.h>
#pragma hdrstop

/*
** Author: Samuel R. Blackburn
** CI$: 76300,326
** Internet: sammy@sed.csc.com
**
** You can use it any way you like as long as you don't try to sell it.
**
** Any attempt to sell WFC in source code form must have the permission
** of the original author. You can produce commercial executables with
** WFC but you can't sell WFC.
**
** Copyright, 1995, Samuel R. Blackburn
**
** $Workfile: $
** $Revision: $
** $Modtime: $
*/

#if defined( _DEBUG )
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#if defined( _DEBUG )
#define new DEBUG_NEW
#endif

CSystemTime::CSystemTime()
{
   Empty();
}

CSystemTime::CSystemTime( const CSystemTime& source )
{
   Copy( source );
}

CSystemTime::CSystemTime( const SYSTEMTIME * source )
{
   Copy( source );
}

CSystemTime::~CSystemTime()
{
   Empty();
}

LONG CSystemTime::Compare( const CSystemTime& source )
{
   if ( wYear < source.wYear )
   {
      return( (-1) );
   }

   if ( wYear > source.wYear ) 
   {
      return( 1 );
   }

   if ( wMonth < source.wMonth )
   {
      return( (-1) );
   }

   if ( wMonth > source.wMonth ) 
   {
      return( 1 );
   }

   if ( wDay < source.wDay )
   {
      return( (-1) );
   }

   if ( wDay > source.wDay ) 
   {
      return( 1 );
   }

   if ( wHour < source.wHour )
   {
      return( (-1) );
   }

   if ( wHour > source.wHour ) 
   {
      return( 1 );
   }

   if ( wMinute < source.wMinute )
   {
      return( (-1) );
   }

   if ( wMinute > source.wMinute ) 
   {
      return( 1 );
   }

   if ( wSecond < source.wSecond )
   {
      return( (-1) );
   }

   if ( wSecond > source.wSecond ) 
   {
      return( 1 );
   }

   if ( wMilliseconds < source.wMilliseconds )
   {
      return( (-1) );
   }

   if ( wMilliseconds > source.wMilliseconds ) 
   {
      return( 1 );
   }

   return( 0 );
}

void CSystemTime::Copy( const CSystemTime& source )
{
   Copy( (const SYSTEMTIME *) &source );
}

void CSystemTime::Copy( const SYSTEMTIME * source )
{
   ASSERT( source != NULL );

   if ( source == (const SYSTEMTIME *) NULL )
   {
      Empty();
      return;
   }

   wYear         = source->wYear;
   wMonth        = source->wMonth;
   wDay          = source->wDay;
   wDayOfWeek    = source->wDayOfWeek;
   wHour         = source->wHour;
   wMinute       = source->wMinute;
   wSecond       = source->wSecond;
   wMilliseconds = source->wMilliseconds;
}

void CSystemTime::Copy( const CFileTime& source )
{
   Copy( (const FILETIME *) &source );
}

void CSystemTime::Copy( const FILETIME * source )
{
   ASSERT( source != NULL );

   if ( source == (const FILETIME *) NULL )
   {
      Empty();
      return;
   }

   SYSTEMTIME system_time;

   if ( ::FileTimeToSystemTime( source, &system_time ) == TRUE )
   {
      Copy( &system_time );
   }
   else
   {
      Empty();
   }
}

void CSystemTime::Empty( void )
{
   wYear         = 0;
   wMonth        = 0;
   wDay          = 0;
   wDayOfWeek    = 0;
   wHour         = 0;
   wMinute       = 0;
   wSecond       = 0;
   wMilliseconds = 0;
}

CSystemTime CSystemTime::GetTheCurrentTime( void )
{
   SYSTEMTIME system_time;

   ::GetSystemTime( &system_time );

   return( CSystemTime( &system_time ) );
}

/*
** Operators
*/

CSystemTime& CSystemTime::operator = ( const CSystemTime& source )
{
   Copy( source );
   return( *this );
}

CSystemTime& CSystemTime::operator = ( const CFileTime& source )
{
   Copy( source );
   return( *this );
}

BOOL CSystemTime::operator == ( const CSystemTime& source )
{
   if ( Compare( source ) == 0 )
   {
      return( TRUE );
   }
   else
   {
      return( FALSE );
   }
}

BOOL CSystemTime::operator > ( const CSystemTime& source )
{
   if ( Compare( source ) > 0 )
   {
      return( TRUE );
   }
   else
   {
      return( FALSE );
   }
}

BOOL CSystemTime::operator < ( const CSystemTime& source )
{
   if ( Compare( source ) < 0 )
   {
      return( TRUE );
   }
   else
   {
      return( FALSE );
   }
}

#if defined( _DEBUG )

void CSystemTime::Dump( CDumpContext& dump_context ) const
{
   LPCTSTR months[ 12 ] = { "(January)",
                            "(February)",
                            "(March)",
                            "(April)",
                            "(May)",
                            "(June)",
                            "(July)",
                            "(August)",
                            "(September)",
                            "(October)",
                            "(November)",
                            "(December)"
                          };

   LPCTSTR days[ 7 ] = { "(Sunday)",
                         "(Monday)",
                         "(Tuesday)",
                         "(Wednesday)",
                         "(Thursday)",
                         "(Friday)",
                         "(Saturday)"
                       };

   dump_context << "a CSystemTime at " << (VOID *) this << "\n{\n";
   dump_context << "   wYear is " << wYear << "\n";
   dump_context << "   wMonth is " << wMonth;

   if ( wMonth > 0 && wMonth < 13 )
   {
      dump_context << " " << months[ wMonth - 1 ] << "\n";
   }
   else
   {
      dump_context << " (Invalid)\n";
   }

   dump_context << "   wDayOfWeek is " << wDayOfWeek;

   if ( wDayOfWeek < 7 )
   {
      dump_context << " " << days[ wDayOfWeek ] << "\n";
   }
   else
   {
      dump_context << " (Invalid)\n";
   }

   dump_context << "   wDay is " << wDay << "\n";
   dump_context << "   wHour is " << wHour << "\n";
   dump_context << "   wMinute is " << wMinute << "\n";
   dump_context << "   wSecond is " << wSecond << "\n";
   dump_context << "   wMilliseconds is " << wMilliseconds << "\n";
   dump_context << "}\n";
}

#endif
