#include <wfc.h>
#pragma hdrstop

/*
** Author: Samuel R. Blackburn
** CI$: 76300,326
** Internet: sammy@sed.csc.com
**
** You can use it any way you like as long as you don't try to sell it.
**
** Any attempt to sell WFC in source code form must have the permission
** of the original author. You can produce commercial executables with
** WFC but you can't sell WFC.
**
** Copyright, 1995, Samuel R. Blackburn
**
** $Workfile: $
** $Revision: $
** $Modtime: $
*/

#if defined( _DEBUG )
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#define new DEBUG_NEW
#endif

CTalkingSocket::CTalkingSocket()
{
   m_Initialize();
}

CTalkingSocket::CTalkingSocket( const CString& a_host_name, const CString& p_name )
{
   m_Initialize();

   SetAddress( a_host_name );
   SetPort( p_name );
}

CTalkingSocket::CTalkingSocket( const CString& address, const short p_number )
{
   m_Initialize();

   SetAddress( address );
   SetPort( p_number );
}

CTalkingSocket::~CTalkingSocket()
{
   TRACE( "Destroying a TALKING_SOCKET object\n" );
}

#if defined( _DEBUG )

void CTalkingSocket::Dump( CDumpContext &dump_context ) const
{
   CSimpleSocket::Dump( dump_context );
}

#endif // _DEBUG

void CTalkingSocket::m_Initialize( void )
{
   ASSERT_VALID( this );

   TRACE( "Initializing a TALKING_SOCKET object\n" );
}

/*
** The Socket manipulation routines
*/

BOOL CTalkingSocket::Open( void )
{
   ASSERT_VALID( this );

   if ( Address.IsEmpty() )
   {
      /*
      ** We don't have an address
      */

      return( FALSE );
   }

   SOCKADDR_IN server_address;

   /*
   ** Create the socket
   */

   m_SocketID = ::socket( AF_INET, SOCK_STREAM, 0 );

   if ( m_SocketID == INVALID_SOCKET )
   {
      return( FALSE );
   }

   /*
   ** Now fill in a socket address structure with the necessary information about the remote
   ** server node (remote node IP address and port for incoming connections) and attempt to
   ** connect to the server. This connect call will block until the remote server has accepted
   ** the connection or the connection request times out.
   */

   server_address.sin_family      = AF_INET;
   server_address.sin_port        = m_PortNumberInNetworkByteOrder;
   server_address.sin_addr.s_addr = ::inet_addr( (const char *) Address );

   int connection_status = 0;

   connection_status = ::connect( m_SocketID, (LPSOCKADDR) &server_address, sizeof( server_address ) );

   if ( connection_status == SOCKET_ERROR )
   {
      m_ErrorCode = ::WSAGetLastError();

      TRACE( "CTalkingSocket::Open(), connect failed at line %d of %s error #%d, address = %s, port number %d\n",
             __LINE__, 
             __FILE__,
             m_ErrorCode,
             (const char *) Address,
             ::ntohs( m_PortNumberInNetworkByteOrder ) );

      Close();
      return( FALSE );
   }

   m_hFile = (UINT) m_SocketID;
    
   return( TRUE );
}

#pragma warning( disable : 4100 )

BOOL CTalkingSocket::Open( const char * a, UINT port_number, CFileException *perror )
{
   ASSERT_VALID( this );
   ASSERT( a != NULL );

   if ( a == NULL )
   {
      m_ErrorCode = ERROR_INVALID_PARAMETER;
      return( FALSE );
   }

   SetAddress( a );
   SetPort( (short) port_number );

   return( Open() );
}

#pragma warning( default : 4100 )

BOOL CTalkingSocket::Open( const CString& a, const short p )
{
   ASSERT_VALID( this );
   ASSERT( p > 0 );

   SetAddress( a );
   SetPort( p );

   return( Open() );
}

BOOL CTalkingSocket::Open( const CString& _host_name, const CString& _port_name )
{
   ASSERT_VALID( this );

   SetAddress( _host_name );
   SetPort( _port_name );

   return( Open() );
}
