#include "test.h"
#pragma hdrstop

void test_CNetworkConnections( LPCTSTR machine_name )
{
   CNetworkConnections connections( machine_name );

   CNetworkConnectionInformation connection_information;

   if ( connections.Enumerate( "data" ) == TRUE )
   {
      printf( "Network Connections Information:\n" );

      while( connections.GetNext( connection_information ) == TRUE )
      {
         printf( " ID            - %d\n",               connection_information.ID            );
         printf( " Type          - %d\n",               connection_information.Type          );
         printf( " NumberOfUsers - %d\n",               connection_information.NumberOfUsers );
         printf( " NumberOfOpens - %d\n",               connection_information.NumberOfOpens );
         printf( " Time          - %d\n",               connection_information.Time          );
         printf( " UserName      - \"%s\"\n", (LPCTSTR) connection_information.UserName      );
         printf( " NetName       - \"%s\"\n", (LPCTSTR) connection_information.NetName       );
      }
   }
   else
   {
      DWORD error_code = connections.GetErrorCode();

      CString error_message;

      Convert_NERR_Code_to_String( error_code, error_message );

      printf( "CNetworkConnections.Enumerate( CNetworkConnectionInformation ), ErrorCode == %d \"%s\"\n", error_code, (LPCTSTR) error_message );
   }
}

