#include "test.h"
#pragma hdrstop

void test_CNetworkFiles( LPCTSTR machine_name )
{
   CNetworkFiles network_files( machine_name );

   CNetworkFileInformation network_files_information;

   if ( network_files.Enumerate() == TRUE )
   {
      printf( "Network Files Information:\n" );

      while( network_files.GetNext( network_files_information ) == TRUE )
      {
         printf( " ID            - %d\n",               network_files_information.ID            );
         printf( " PathName      - \"%s\"\n", (LPCTSTR) network_files_information.PathName      );
         printf( " UserName      - \"%s\"\n", (LPCTSTR) network_files_information.UserName      );
         printf( " Permissions   - %d\n",               network_files_information.Permissions   );
         printf( " NumberOfLocks - %d\n",               network_files_information.NumberOfLocks );
      }
   }
   else
   {
      DWORD error_code = network_files.GetErrorCode();

      CString error_message;

      Convert_NERR_Code_to_String( error_code, error_message );

      printf( "CNetworkFiles.Enumerate( CNetworkFileInformation ), ErrorCode == %d \"%s\"\n", error_code, (LPCTSTR) error_message );
   }
}

