#include <windows.h>
#include <direct.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <stdio.h>
#include <commdlg.h>
#include "cryptic.h"

#define MAXPATH 255
#define MAXREAD 8192

HINSTANCE hInst;

char szAppName[] = "CRYPTIC";
char szTitle[]   = "Cryptic";


/*****+************************************************************/
/*             WinMain - the application entry point              */
/******************************************************************/

int APIENTRY WinMain(HINSTANCE hInstance,
							HINSTANCE hPrevInstance,
							LPSTR lpzCmdLine,
							int nCmdShow)
{
	MSG msg;
	HANDLE hAccelTable;

	if (!hPrevInstance)
	{
		if (!InitApplication(hInstance))
		{
			return (FALSE);
		}
	}

	if (!InitInstance(hInstance, nCmdShow, lpzCmdLine))
	{
		return (FALSE);
	}

	hAccelTable = LoadAccelerators (hInstance, szAppName);

	while (GetMessage(&msg, NULL, 0, 0))
	{
		if (!TranslateAccelerator (msg.hwnd, hAccelTable, &msg))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
	return (msg.wParam);

}	//end of WinMain

/******************************************************************/
/*          InitApplication - intializing the application         */
/******************************************************************/

BOOL InitApplication(HINSTANCE hInstance)
{
	WNDCLASS  wc;

	wc.style         = CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc   = (WNDPROC) WndProc;
	wc.cbClsExtra    = 0;
	wc.cbWndExtra    = 0;
	wc.hInstance     = hInstance;
	wc.hIcon         = LoadIcon (hInstance, szAppName);
	wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
	wc.lpszMenuName  = MAKEINTRESOURCE( IDM_MAIN );
	wc.lpszClassName = szAppName;

	return (RegisterClass(&wc));

}	//end of InitApplication

/******************************************************************/
/*         InitInstance - initializing the window instance        */
/******************************************************************/

BOOL InitInstance(HINSTANCE hInstance, int nCmdShow, LPSTR lpzCmdLine)
{
	HWND hWnd;

	hInst = hInstance;

	hWnd = CreateWindow(
		szAppName,
		szTitle,
		WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | 	WS_CLIPCHILDREN,
		CW_USEDEFAULT, 0,
		725,500,
		NULL,
		NULL,
		hInstance,
		lpzCmdLine
							);

	if (!hWnd)
	{
		return (FALSE);
	}

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	return (TRUE);
}	//end of InitInstance

/******************************************************************/
/*                WndProc - the window procedure                  */
/******************************************************************/

LRESULT CALLBACK WndProc(	HWND hWnd, UINT message,
									UINT uParam, LPARAM lParam)
{
	int	wmId, wmEvent, wmHctl;
	HDC	hDC, hMemDC, hLineDC;
	HMENU	hMenu;
	PAINTSTRUCT	ps;
	HBITMAP hBitmap;
	static	HPEN	hOrgPen, hRedPen, hGreenPen;
	static	HBRUSH	hBrush;
	static	HCURSOR	hSaveCursor;
	static	HCURSOR	hHourGlass;
	LPSTR	p32AgentBuffer;
	LPSTR	p32KeyBuffer = NULL;
	HANDLE	hAgentBuffer;
	HANDLE	hRotorFile;
	HANDLE	hAgentFile;
	HANDLE	hSourceFile;
	HANDLE	hTargetFile;
	HANDLE	hTempFile;
	static OPENFILENAME ofn_Agent, ofn_Source, ofn_Target;
	static HWND hWndSourceFile;
	static HWND hWndSourceDir;
	static HWND hWndSourceDrive;
	static HWND hWndTargetFile;
	static HWND hWndAgentFile;
	static HWND hWndKey;
	static char	szAgentPath[_MAX_PATH];
	static char	szSourcePath[_MAX_PATH];
	static char	szTargetPath[_MAX_PATH];
	static char	szHelpFile[MAXPATH];
	static char	dirBuffer[255];
	enum boolean {encode=1, decode=0, true=1, false=0, on=1, off=0, yes=1, no=0};
	enum boolean direction = decode;
	enum boolean rotor_found = no;
	enum boolean agentFileFound = no;
	enum boolean sourceFileFound = no;
	enum boolean targetFileFound = no;
	enum boolean keyFound = no;
	enum boolean sourceEOF = false;
	enum boolean encrypt = yes;
	enum boolean decrypt = no;
	static enum boolean agent_active = yes;
	static enum boolean show_key = yes;
	UINT	bumpPoint[52];
	UINT	bumpPoint_Hold;
	UINT	rotorIndex[127]; // Rotor index pointer
	UINT	rotorLength[127]; // Rotor length
	UINT	rotorCount;
	UINT	dirBufferLength = 256;
	UINT	dirBufferLengthFound;
	UINT	fileSize;
	UINT	sourceFileLength, agentFileLength, agentLineLength, keyLength, rotorNameLength;
	UINT	bytesRead, bytesWritten;
	UINT	i, j, k, l, m, n;
	UINT	passes;
	BOOL	pass_sw = 0;
	BOOL	t_pass_sw = 0;
	BOOL	bFileRead;
	char	szAgentPathx[_MAX_PATH];
	char	szBuffer[MAXPATH];
	char	agentLine[256];
	char	agentLineCopy[256];
	char	*p, *px;
	char	szTempName[_MAX_PATH];
	char	szTempPath[_MAX_PATH];
	char	*p32RotorName[127]; // Rotor name
	char	*p32RotorFileName[127]; // Rotor file name
	unsigned char	*p32RotorData[127]; // Rotor data
	unsigned char	charBuffer[1];
	unsigned char	ch;
	unsigned char	uk;

	union intbyte
	{
		UINT	index_int[128];
		unsigned char	index_byte[512];
	} rotorStart; // Rotor start point


// Process message
	switch (message)
	{

//----------------------------------------------------------------------------------
		case WM_CREATE:

			hWndAgentFile = CreateWindow
				("EDIT",
				NULL,
				WS_CHILD | WS_VISIBLE | WS_BORDER |
				ES_LEFT | ES_AUTOHSCROLL,
				0,
				0,
				0,
				0,
				hWnd,
				(HMENU) ID_AGENTFILE,
				(HANDLE)GetWindowLong(hWnd, GWL_HINSTANCE),
				NULL
				);

			hWndSourceFile = CreateWindow
				("EDIT",
				NULL,
				WS_CHILD | WS_VISIBLE | WS_BORDER |
				ES_LEFT | ES_AUTOHSCROLL,
				0,
				0,
				0,
				0,
				hWnd,
				(HMENU) ID_SOURCEFILE,
				(HANDLE)GetWindowLong(hWnd, GWL_HINSTANCE),
				NULL
				);

			hWndTargetFile = CreateWindow
				("EDIT",
				NULL,
				WS_CHILD | WS_VISIBLE | WS_BORDER |
				ES_LEFT | ES_AUTOHSCROLL,
				0,
				0,
				0,
				0,
				hWnd,
				(HMENU) ID_TARGETFILE,
				(HANDLE)GetWindowLong(hWnd, GWL_HINSTANCE),
				NULL
				);

			hWndKey = CreateWindow
				("EDIT",
				NULL,
				WS_CHILD | WS_VISIBLE | WS_BORDER |
				WS_HSCROLL | WS_VSCROLL |
				ES_LEFT | ES_MULTILINE |
				ES_AUTOHSCROLL | ES_AUTOVSCROLL,
				0,
				0,
				0,
				0,
				hWnd,
				(HMENU) ID_KEY,
				(HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE),
				NULL
				);

			CreateWindow("BUTTON", "Agent File",
				WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
				310,40,100,50, hWnd, (HMENU) IDB_AGENTFILE,
				(HANDLE)GetWindowLong(hWnd, GWL_HINSTANCE),
				NULL);

			CreateWindow("BUTTON", "Source File",
				WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
				60,180,100,50, hWnd, (HMENU) IDB_SOURCEFILE,
				(HANDLE)GetWindowLong(hWnd, GWL_HINSTANCE),
				NULL);

			CreateWindow("BUTTON", "Target File",
				WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
				560,180,100,50, hWnd, (HMENU) IDB_TARGETFILE,
				(HANDLE)GetWindowLong(hWnd, GWL_HINSTANCE),
				NULL);

			CreateWindow("BUTTON", "ENCODE",
				WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
				310,107,100,50, hWnd, (HMENU) IDB_ENCRYPT,
				(HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE),
				NULL);

			CreateWindow("BUTTON", "DECODE",
				WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
				310,167,100,50, hWnd, (HMENU) IDB_DECRYPT,
				(HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE),
				NULL);

			FileInitialize(hWnd,&ofn_Agent);
			ofn_Agent.lpstrFile = szAgentPath;
			ofn_Agent.Flags = OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_READONLY;
			FileInitialize(hWnd,&ofn_Source);
			ofn_Source.lpstrFile = szSourcePath;
			ofn_Source.Flags = OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_READONLY;
			FileInitialize(hWnd,&ofn_Target);
			ofn_Target.lpstrFile = szTargetPath;
			ofn_Target.Flags = OFN_OVERWRITEPROMPT | OFN_NOREADONLYRETURN | OFN_HIDEREADONLY;

			hHourGlass = LoadCursor(NULL, IDC_WAIT);
			hRedPen	=	CreatePen(PS_SOLID, 2, 0x000000FF);
			hGreenPen	=	CreatePen(PS_SOLID, 2, 0x0000FF00);
			hBrush = CreateSolidBrush(GetSysColor(COLOR_WINDOW));

			dirBufferLengthFound = GetCurrentDirectory(dirBufferLength,dirBuffer);
			strcpy(szHelpFile, dirBuffer);
			strcat(szHelpFile, "\\cryptic.hlp");

			break;

//----------------------------------------------------------------------------------


		case WM_SIZE:


			MoveWindow(hWndAgentFile,
				260,10,200,25,
				TRUE);

			MoveWindow(hWndSourceFile,
				10,150,200,25,
				TRUE);

			MoveWindow(hWndTargetFile,
				510,150,200,25,
				TRUE);

			MoveWindow(hWndKey,
				30,300,650,75,
				TRUE);

			break;

//----------------------------------------------------------------------------------

		case WM_LBUTTONDOWN:
			SetFocus (hWnd);
			break;
//----------------------------------------------------------------------------------


		case WM_RBUTTONDOWN:
			break;
//----------------------------------------------------------------------------------

		case WM_PAINT:

			hDC = BeginPaint(hWnd,&ps);
         hMemDC = CreateCompatibleDC(hDC);
         hBitmap = LoadBitmap(hInst, "CRYPTIC");
         SelectObject(hMemDC, hBitmap);
         BitBlt(hDC,0,0,725,500,hMemDC,0,0,SRCCOPY);
         DeleteDC(hMemDC);
         DeleteObject(hBitmap);
			SelectObject(hDC, GetStockObject(SYSTEM_FONT));
			SetTextColor(hDC, RGB(240,230,0));
			SetBkColor(hDC, RGB(0,0,180));
			dirBufferLengthFound = GetCurrentDirectory(dirBufferLength,dirBuffer);
			strcpy(szBuffer, "Current Directory = ");
			strcat(szBuffer, dirBuffer);
			TextOut(hDC,10,430,szBuffer,strlen(szBuffer));
			hOrgPen = SelectObject(hDC, hGreenPen);
			MoveToEx(hDC, 220, 163, NULL);
			LineTo(hDC, 480, 163);
			EndPaint(hWnd,&ps);

			break;

//----------------------------------------------------------------------------------

		case WM_CTLCOLOREDIT:

			if ((HWND)lParam == hWndKey)
			{
				if (show_key == no)
				{
					SetTextColor((HDC)uParam, GetSysColor(COLOR_WINDOW));
				}
				else
				{
					SetTextColor((HDC)uParam, GetSysColor(COLOR_WINDOWTEXT));
				}

				return((DWORD)hBrush);
			}

			break;

//----------------------------------------------------------------------------------

		case WM_COMMAND:

			wmId    = LOWORD(uParam);
			wmEvent = HIWORD(uParam);
			wmHctl  = lParam;

			hMenu = GetMenu(hWnd);

			switch (wmId)
			{

//----------------------------------------------------------------------------------
				case IDM_HELP:

					WinHelp(hWnd, szHelpFile, HELP_CONTENTS, 0L);
					return 0L;


					break;

//----------------------------------------------------------------------------------
				case ID_AGENTFILE:

					switch (wmEvent)
					{

						case EN_KILLFOCUS:
							SendMessage(hWndAgentFile, WM_GETTEXT, _MAX_PATH, (LONG) szAgentPath);
							break;

					}

					break;


//----------------------------------------------------------------------------------

				case ID_SOURCEFILE:

					switch (wmEvent)
					{

						case EN_KILLFOCUS:
							SendMessage(hWndSourceFile, WM_GETTEXT, _MAX_PATH, (LONG) szSourcePath);
							break;

					}

					break;

//----------------------------------------------------------------------------------

				case ID_TARGETFILE:

					switch (wmEvent)
					{

						case EN_KILLFOCUS:
							SendMessage(hWndTargetFile, WM_GETTEXT, _MAX_PATH, (LONG) szTargetPath);
							break;

					}

					break;

//----------------------------------------------------------------------------------

				case IDM_SHOW_KEY:

					if (GetMenuState(hMenu, IDM_SHOW_KEY, 	MF_BYCOMMAND) == MF_CHECKED)
					{
						CheckMenuItem(hMenu, IDM_SHOW_KEY, MF_UNCHECKED);
						show_key = no;
					}
					else
					{
						CheckMenuItem(hMenu, IDM_SHOW_KEY, MF_CHECKED);
						show_key = yes;
					}

					break;

//----------------------------------------------------------------------------------

				case ID_KEY:

					switch (wmEvent)
					{

						case EN_KILLFOCUS:
							break;

					}

					break;

//----------------------------------------------------------------------------------

				case IDB_AGENTFILE:

					if (agent_active == yes)
					{
						GetOpenFileName(&ofn_Agent);
						SendMessage(hWndAgentFile, WM_SETTEXT, 0L, (LONG) szAgentPath);
						InvalidateRect(hWnd, NULL, FALSE);
						UpdateWindow(hWnd);
					}

					break;

//----------------------------------------------------------------------------------

				case IDB_SOURCEFILE:

					GetOpenFileName(&ofn_Source);
					SendMessage(hWndSourceFile, WM_SETTEXT, 0L, (LONG) szSourcePath);
					InvalidateRect(hWnd, NULL, FALSE);
					UpdateWindow(hWnd);

					break;

//----------------------------------------------------------------------------------

				case IDB_TARGETFILE:

					GetSaveFileName(&ofn_Target);
					SendMessage(hWndTargetFile, WM_SETTEXT, 0L, (LONG) szTargetPath);
					InvalidateRect(hWnd, NULL, FALSE);
					UpdateWindow(hWnd);

					break;
//----------------------------------------------------------------------------------

				case IDM_AGENT:

					if (GetMenuState(hMenu, IDM_AGENT, 	MF_BYCOMMAND) == MF_CHECKED)
					{
						CheckMenuItem(hMenu, IDM_AGENT, MF_UNCHECKED);
						agent_active = no;
//						Beep(440,100);
					}
					else
					{
						CheckMenuItem(hMenu, IDM_AGENT, MF_CHECKED);
						agent_active = yes;
					}

					break;
//----------------------------------------------------------------------------------

				case IDM_MAKE_AGENT:

					DialogBox(hInst, MAKEINTRESOURCE(MAKE_AGENT), hWnd, (DLGPROC)Make_agent);

					break;

//----------------------------------------------------------------------------------
				case IDM_MAKE_ROTORS:

					DialogBox(hInst, MAKEINTRESOURCE(MAKE_ROTORS), hWnd, (DLGPROC)Make_rotors);

					break;

//----------------------------------------------------------------------------------
				case IDM_DIRECTORY:

					DialogBox(hInst, MAKEINTRESOURCE(SET_DIRECTORY), hWnd, (DLGPROC)Change_directory);
					InvalidateRect(hWnd, NULL, FALSE);
					UpdateWindow(hWnd);

					break;

///----------------------------------------------------------------------------------

				case IDB_ENCRYPT:

					direction = encode;
					encrypt = yes;
					sourceFileFound = no;
					agentFileFound = no;
					sourceEOF = false;
					rotor_found = no;
					rotorCount = 0;
					keyFound = no;
					pass_sw = 0;
					t_pass_sw = 0;

					SetCapture(hWnd);
					hSaveCursor = SetCursor(hHourGlass);

					// get Source

					hSourceFile = CreateFile(szSourcePath, GENERIC_READ,
						FILE_SHARE_READ, NULL,
						OPEN_EXISTING, FILE_ATTRIBUTE_READONLY | FILE_FLAG_SEQUENTIAL_SCAN, NULL);

					if (hSourceFile == INVALID_HANDLE_VALUE)
					{
			      	CloseHandle(hSourceFile);
	               SetCursor(hSaveCursor);
   	            ReleaseCapture();
						MessageBox(hWnd, "CreateFile Failure", "Source File", MB_ICONEXCLAMATION | MB_OK);
						break;
					}
					else
					{
						sourceFileFound = yes;
						sourceFileLength = GetFileSize(hSourceFile, NULL);
					}

					// get Target

					if (strcmp(szTargetPath,"") == 0)
					{
			      	CloseHandle(hSourceFile);
						SetCursor(hSaveCursor);
   	            ReleaseCapture();
						MessageBox(hWnd, "blank target file name ", "Target File", MB_ICONEXCLAMATION | MB_OK);
						break;
					}


					hTargetFile = CreateFile(szTargetPath, GENERIC_WRITE,
						FILE_SHARE_READ, NULL,
						CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);

					if (hTargetFile == INVALID_HANDLE_VALUE)
					{
			      	CloseHandle(hSourceFile);
			      	CloseHandle(hTargetFile);
						SetCursor(hSaveCursor);
   	            ReleaseCapture();
						MessageBox(hWnd, "CreateFile Failure", "Target File", MB_ICONEXCLAMATION | MB_OK);
						break;
					}
					else
					{
						targetFileFound = yes;
					}

					CloseHandle(hTargetFile);

               // process Agent file
					if (agent_active == yes)
					{
						// define storage for rotors (half Meg.)
						hAgentBuffer = HeapCreate(0, 0x80000L, 0);

						// get Agent
						if (szAgentPath[0] != '\0')
						{
							hAgentFile = CreateFile(szAgentPath, GENERIC_READ | GENERIC_WRITE,
								FILE_SHARE_READ, NULL,
								OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

							if (hAgentFile == INVALID_HANDLE_VALUE)
							{
								agentFileFound = no;
								encrypt = no;
					      	CloseHandle(hSourceFile);
					      	CloseHandle(hTargetFile);
								CloseHandle(hAgentFile);
								HeapDestroy(hAgentBuffer);
								SetCursor(hSaveCursor);
   	 			         ReleaseCapture();
								MessageBox(hWnd, "CreateFile Failure", "Agent File", MB_ICONEXCLAMATION | MB_OK);
								break;
							}
							else
							{
								agentFileFound = yes;
								agentFileLength = GetFileSize(hAgentFile, NULL);
								p32AgentBuffer = (LPSTR)HeapAlloc(hAgentBuffer, HEAP_ZERO_MEMORY, agentFileLength);
								ReadFile(hAgentFile, p32AgentBuffer, agentFileLength, &bytesRead, NULL);
								CloseHandle(hAgentFile);

								// scramble rotor starts
								srand((unsigned)time(NULL));
								for (i = 0; i < 512; i++)
								{
									rotorStart.index_byte[i] = rand() % 256;
								}
							}
						}
						else
						{
							agentFileFound = no;
						}

						// Process Agent file
						if (agentFileFound == yes)
						{
							j = 0; // indexes lines from Agent file
							k = 0; // tracks rotors

							for (i = 0; i < agentFileLength; i++) // i indexes agent file character
							{
								agentLine[j] = p32AgentBuffer[i];
								if (agentLine[j] == '\n')
								{
									agentLine[j] = '\0';
									agentLineLength = strlen(agentLine);
									strcpy(agentLineCopy, agentLine);
									j = 0;
									p = strstr(agentLine,"ROTOR_");
									if ((p != NULL) && (p == agentLine))
									{
										rotor_found = yes;
										// get rotor name
										rotorNameLength = strcspn(agentLine, "=");
										p32RotorName[k] = (char *)HeapAlloc(hAgentBuffer, HEAP_ZERO_MEMORY, rotorNameLength+1);
										strncpy(p32RotorName[k], agentLine, rotorNameLength);
										strcat(p32RotorName[k], "");

										// get rotor file name
										px=strtok(agentLine,"=");

										// open rotor file and copy name and contents to memory
										if (px)
										{
											px = strtok(NULL," ");

											hRotorFile = CreateFile(px,
												GENERIC_READ,
												FILE_SHARE_READ, NULL,
												OPEN_EXISTING,
												FILE_ATTRIBUTE_READONLY | FILE_FLAG_SEQUENTIAL_SCAN,
												NULL);

											if (hRotorFile == INVALID_HANDLE_VALUE)
											{
									      	CloseHandle(hSourceFile);
									      	CloseHandle(hTargetFile);
												CloseHandle(hAgentFile);
												CloseHandle(hRotorFile);
												HeapDestroy(hAgentBuffer);
												strcpy(szBuffer, "CreateFile Failure: ");
												strcat(szBuffer, px);
												SetCursor(hSaveCursor);
				   	 			         ReleaseCapture();
												MessageBox(hWnd, szBuffer, "Rotor File", MB_ICONEXCLAMATION | MB_OK);
												break;
											}
											else
											{
												// load rotor name into memory
												p32RotorFileName[k] = (char *)HeapAlloc(hAgentBuffer, HEAP_ZERO_MEMORY,  strlen(px)+1) ;
												strncpy(p32RotorFileName[k], px, strlen(px));
												strcat(p32RotorFileName[k], "");

												// load the rotor into memory
												fileSize = GetFileSize(hRotorFile, NULL);
												rotorLength[k] = LOWORD(fileSize);
												p32RotorData[k] = (unsigned char *)HeapAlloc(hAgentBuffer, HEAP_ZERO_MEMORY, rotorLength[k]+1);
												ReadFile(hRotorFile, p32RotorData[k], fileSize, &bytesRead, NULL);
												CloseHandle(hRotorFile);
											}

											px=strtok(NULL,"=");
											if (px)
											{
												px=strtok(NULL," ");
												if (px)  //extract start points
												{
													rotorIndex[k] = rotorStart.index_int[k] = atoi(px);
												}
											}
										}

										k++;
									}
									else
									{
										p=strstr(agentLineCopy,"PASSES_");
										if (p != NULL && p == agentLineCopy)
										{
											px=strtok(agentLineCopy,"=");
											if (px)
											{
												px=strtok(NULL," ");
												if (px)
												{
		    											passes=atoi(px);
		   										}
			  								}
										}
									}
									continue;
								}
								j++;
							}	// end loop on agent file

							rotorCount = k;

						} // end of reading agent file

               }	//end of active agent

               if (encrypt == no) // Stop if there are problens with the Agent file.
               	{
				      	CloseHandle(hSourceFile);
				      	CloseHandle(hTargetFile);
							CloseHandle(hAgentFile);
							HeapDestroy(hAgentBuffer);
							SetCursor(hSaveCursor);
  	 			         ReleaseCapture();
							strcpy(szBuffer, "Undetermined Agent file Failure: ");
							MessageBox(hWnd, szBuffer, "Agent File", MB_ICONEXCLAMATION | MB_OK);
               		break;
               	}

					// get user Key
					keyLength = SendMessage(hWndKey, WM_GETTEXTLENGTH,0,0);
					if (keyLength == 0)
					{
						keyFound = no;
					}
					else
					{
						keyFound = yes;
						p32KeyBuffer = (LPSTR)HeapAlloc(GetProcessHeap(), 0, keyLength+1);
						SendMessage(hWndKey, WM_GETTEXT, keyLength+1, (LPARAM)p32KeyBuffer);
					}

					// create temp file
					if (encrypt = yes)
					{
						GetTempPath(_MAX_PATH, (LPTSTR) szTempPath);

						GetTempFileName(szTempPath,
							"temp",
							0,
							(LPTSTR) szTempName);

						hTempFile = CreateFile((LPTSTR) szTempName,
							GENERIC_READ | GENERIC_WRITE,
							0,
							NULL,
							CREATE_ALWAYS,
							FILE_ATTRIBUTE_NORMAL | FILE_ATTRIBUTE_TEMPORARY,
							NULL);

						if (hTempFile == INVALID_HANDLE_VALUE)
						{
							encrypt = no;
							CloseHandle(hTempFile);
				      	CloseHandle(hSourceFile);
				      	CloseHandle(hTargetFile);
							CloseHandle(hAgentFile);
							HeapDestroy(hAgentBuffer);
					      if ( keyFound == yes)
					      {
								HeapFree(GetProcessHeap(), 0, p32KeyBuffer);
			      		}
							SetCursor(hSaveCursor);
  	 			         ReleaseCapture();
							MessageBox(hWnd, "CreateFile Failure", "Temp File", MB_ICONEXCLAMATION | MB_OK);
							break;
						}

					} // end of create temp file

					// Encypher the source characters
					i = 0;
						// setup for progress bar
					m = 220;
					hLineDC = GetDC(hWnd);
					hOrgPen = SelectObject(hLineDC, hGreenPen);
					MoveToEx(hLineDC, 220, 163, NULL);
					LineTo(hLineDC, 480, 163);
					hOrgPen = SelectObject(hLineDC, hRedPen);
					for (l = 0; l < 52; l++)
					{
						if (sourceFileLength >= 52)
							bumpPoint[l] =  (UINT)((float)(sourceFileLength / 52))* (1 + l);
						else
							bumpPoint[l] = 0;
					}
					bumpPoint_Hold = 0;
					l = 0;
					n = 0;
//					SetBoundsRect(hLineDC, &rcProgress, DCB_ENABLE);
					MoveToEx(hLineDC, 220, 163, NULL);

					while (encrypt == yes && sourceEOF == false)
					{
						// Get a character from source file
						bFileRead = ReadFile(hSourceFile, (LPSTR) charBuffer, 1, &bytesRead, NULL);
						if (bFileRead && (bytesRead == 0))
						{
							sourceEOF = true;
							continue;
						}
						if (!bFileRead)
						{
							encrypt = no;
							MessageBox(hWnd, "Read error", "Source char ", MB_ICONEXCLAMATION | MB_OK);
							if (GetLastError() == ERROR_NOACCESS)
								MessageBox(hWnd, "Error noaccess", "Source Error # ", MB_ICONEXCLAMATION | MB_OK);
							break;
						}

                  n++;
						ch = *charBuffer;

						// get a character from Key
						if (keyFound == yes)
						{
							if (i >= keyLength)
								i=0;
							uk = *(p32KeyBuffer + i);
							ch ^= uk;	// XOR source character against user key character
							i++;
						}

                  if (agent_active == yes && rotor_found ==yes)
                  {
							// loop and XOR on each rotor
							for (j=0; j < rotorCount; j++)
							{
								// get a char from rotor and XOR with buffer
								ch ^= *(p32RotorData[j] + rotorIndex[j]);

								if (rotorIndex[j] >= (rotorLength[j] -1))
								{
									rotorIndex[j] = 0;
								}
								else
									rotorIndex[j] += 1;
							} // end for on rotors for XOR

							// loop on each rotor to see if they are used up
							if ((rotorCount > 0) && (rotorIndex[0] == 0))
							{
								t_pass_sw = 1;
								for (j=0; j < rotorCount; j++)
								{
									if (rotorIndex[j] != 0)
									{
										t_pass_sw = 0;
									}
								} // end for on rotors for passes
							}

							if (t_pass_sw == 1)
							{
								pass_sw = 1;
								passes += 1;
								MessageBox(hWnd, "***WARNING*** A complete pass of the composite rotor has been detected", " rotors", MB_ICONEXCLAMATION | MB_OK);
							}
                  }
						// write buffer to temp target file
						WriteFile(hTempFile, &ch, 1, &bytesWritten, NULL);

						// move progress bar
						if ((n == bumpPoint[l]) || ((bumpPoint[l] == bumpPoint_Hold) && (sourceFileLength < 52)))
						{
							if (sourceFileLength >= 52)
								m += 5;
							else
								m += (UINT)(5 * (52 / (float)sourceFileLength));
							if (n == sourceFileLength)
								LineTo(hLineDC, 480, 163);
							else
								LineTo(hLineDC, m, 163);
							UpdateWindow(hWnd);
							bumpPoint_Hold = bumpPoint[l];
							l++;
						}

					}  	// end of loop on source file

					// close source file
					if (sourceFileFound == yes)
			      	CloseHandle(hSourceFile);

					if (agent_active == yes)
					{
						// write 512 byte index record to temp target
						if (encrypt == yes && rotor_found == yes)
						{
							for (i=0; i < rotorCount && keyFound == yes; i++)
							{
								rotorStart.index_byte[4*i] = rotorStart.index_byte[4*i] ^ *(p32KeyBuffer + (i % keyLength));
							}
						}
						WriteFile(hTempFile, rotorStart.index_int, 512, &bytesWritten, NULL);

						// Write 256 byte agent path info to temp target
						if (agentFileFound == yes)
						{
							WriteFile(hTempFile, szAgentPath, 256, &bytesWritten, NULL);
						}
						else
						{
							strcpy(szAgentPathx, "[-NONE-]");
							WriteFile(hTempFile, szAgentPathx, 256, &bytesWritten, NULL);
						}
               }

					if (encrypt == yes)
					{
						CloseHandle(hTempFile);
						CopyFile(szTempName, szTargetPath, FALSE);
						DeleteFile(szTempName);
					}

			      if ( keyFound == yes)
			      {
						HeapFree(GetProcessHeap(), 0, p32KeyBuffer);
			      }

					// Update Agent file

					if (agent_active == yes && encrypt == yes && agentFileFound == yes)
					{
						j = 0; // indexes lines from Agent file

						GetTempPath(_MAX_PATH, (LPTSTR) szTempPath);

						GetTempFileName(szTempPath,
							"temp",
							0,
							(LPTSTR) szTempName);

						hTempFile = CreateFile((LPTSTR) szTempName,
							GENERIC_READ | GENERIC_WRITE,
							0,
							NULL,
							CREATE_ALWAYS,
							FILE_ATTRIBUTE_NORMAL | FILE_ATTRIBUTE_TEMPORARY,
							NULL);

						if (hTempFile == INVALID_HANDLE_VALUE)
						{
							encrypt = no;
				      	CloseHandle(hTargetFile);
							CloseHandle(hAgentFile);
							HeapDestroy(hAgentBuffer);
		               SetCursor(hSaveCursor);
 			            ReleaseDC(hWnd, hLineDC);
      		         ReleaseCapture();
							MessageBox(hWnd, "CreateFile Failure", " 2nd. Temp File", MB_ICONEXCLAMATION | MB_OK);
							break;
						}

						for (i=0; i < agentFileLength; i++) // i indexes agent file character
						{
							agentLine[j] = p32AgentBuffer[i];
							if (agentLine[j] == '\n') 	// get a line
							{
								agentLine[j] = '\0';	//turn the line into a string
								j = 0;

								p = strstr(agentLine, "ROTOR_");
								if (p)
								{
									for (k=0; k < rotorCount; k++)
									{
										p = strstr(agentLine,p32RotorName[k]);
										if (p)
										{
											sprintf(agentLine,"%s=%s PTR=%s ",p32RotorName[k],p32RotorFileName[k],ultoa(rotorIndex[k],szBuffer,10));
											break;
										}
									}
								}

								p = strstr(agentLine,"PASSES_");
								if (p)
								{
									if (pass_sw == 1 || passes > 1)
									{
										sprintf(agentLine,"PASSES_=%s ***WARNING*** A complete pass of the rotors has been sensed. ",ultoa(passes,szBuffer,10));
									}
									else
									{
										sprintf(agentLine,"PASSES_=%s ",ultoa(passes,szBuffer,10));
									}
								}

								// write the line to the temp file
								agentLineLength = strlen(agentLine);
								agentLine[agentLineLength] = '\n';
								WriteFile(hTempFile, agentLine, agentLineLength+1, &bytesWritten, NULL);

								continue;
							}
							j++;
						}	// end loop on agent file

						CloseHandle(hTempFile);
						CopyFile(szTempName, szAgentPath, FALSE);
						DeleteFile(szTempName);
						HeapDestroy(hAgentBuffer);

               } // end of - if - to update agent

					// Cleanup

               SetCursor(hSaveCursor);
               ReleaseCapture();
					MessageBox(hWnd, "End of Encode", "Encode ", MB_ICONEXCLAMATION | MB_OK);
					hOrgPen = SelectObject(hLineDC, hGreenPen);
					MoveToEx(hLineDC, 220, 163, NULL);
					LineTo(hLineDC, 480, 163);
               ReleaseDC(hWnd, hLineDC);

					break;

//----------------------------------------------------------------------------------

				case IDB_DECRYPT:
					//  Initialize
					direction = decode;
					decrypt = yes;
					sourceFileFound = no;
					agentFileFound = no;
					sourceEOF = false;
					rotor_found = no;
					rotorCount = 0;
					keyFound = no;
					pass_sw = 0;
					t_pass_sw = 0;

					SetCapture(hWnd);
					hSaveCursor = SetCursor(hHourGlass);

					// get Source

					hSourceFile = CreateFile(szSourcePath, GENERIC_READ,
						FILE_SHARE_READ, NULL,
						OPEN_EXISTING, FILE_ATTRIBUTE_READONLY | FILE_FLAG_SEQUENTIAL_SCAN, NULL);

					if (hSourceFile == INVALID_HANDLE_VALUE)
					{
			      	CloseHandle(hSourceFile);
						SetCursor(hSaveCursor);
	               ReleaseCapture();
						MessageBox(hWnd, "CreateFile Failure", "Source File", MB_ICONEXCLAMATION | MB_OK);
						break;
					}
					else
					{
						sourceFileFound = yes;
						sourceFileLength = GetFileSize(hSourceFile, NULL);
					}

					// get Target

					if (strcmp(szTargetPath,"") == 0)
					{
			      	CloseHandle(hSourceFile);
						SetCursor(hSaveCursor);
	               ReleaseCapture();
						MessageBox(hWnd, "blank target file name ", "Target File", MB_ICONEXCLAMATION | MB_OK);
						break;
					}


					hTargetFile = CreateFile(szTargetPath, GENERIC_WRITE,
						FILE_SHARE_READ, NULL,
						CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);

					if (hTargetFile == INVALID_HANDLE_VALUE)
					{
			      	CloseHandle(hSourceFile);
			      	CloseHandle(hTargetFile);
						SetCursor(hSaveCursor);
	               ReleaseCapture();
						MessageBox(hWnd, "CreateFile Failure", "Target File", MB_ICONEXCLAMATION | MB_OK);
						break;
					}
					else
					{
						targetFileFound = yes;
					}

					CloseHandle(hTargetFile);

               // process Agent file
					if (agent_active == yes)
					{
						// define storage for rotors (half Meg.)
						hAgentBuffer = HeapCreate(0, 0x80000L, 0);

						// get Agent
						if (szAgentPath[0] == '\0')
						{
							agentFileFound = no;
							SetFilePointer(hSourceFile, -256, NULL, FILE_END);
							ReadFile(hSourceFile, &szAgentPath, 256, &bytesRead, NULL);

						}

						if (strcmp(szAgentPath,"[-NONE-]") != 0)
						{
							hAgentFile = CreateFile(szAgentPath, GENERIC_READ | GENERIC_WRITE,
								FILE_SHARE_READ, NULL,
								OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

							if (hAgentFile == INVALID_HANDLE_VALUE)
							{
								agentFileFound = no;
								encrypt = no;
				      		CloseHandle(hSourceFile);
					      	CloseHandle(hTargetFile);
								CloseHandle(hAgentFile);
								HeapDestroy(hAgentBuffer);
								SetCursor(hSaveCursor);
			               ReleaseCapture();
								strcpy(szBuffer, "CreateFile Failure \n could not find: ");
								strcat(szBuffer, szAgentPath);
								MessageBox(hWnd, szBuffer, "Agent File", MB_ICONEXCLAMATION | MB_OK);
								break;
							}
							else
							{
								agentFileFound = yes;
								agentFileLength = GetFileSize(hAgentFile, NULL);
								p32AgentBuffer = (LPSTR)HeapAlloc(hAgentBuffer, HEAP_ZERO_MEMORY, agentFileLength);
								ReadFile(hAgentFile, p32AgentBuffer, agentFileLength, &bytesRead, NULL);
								CloseHandle(hAgentFile);
							}
						}
						else
						{
							agentFileFound = no;
						}

						// Process Agent file
						if (agentFileFound == yes)
						{
							j = 0; // indexes lines from Agent file
							k = 0; // tracks rotors

							for (i=0; i < agentFileLength; i++) // i indexes agent file character
							{
								agentLine[j] = p32AgentBuffer[i];
								if (agentLine[j] == '\n')
								{
									agentLine[j] = '\0';
									agentLineLength = strlen(agentLine);
									strcpy(agentLineCopy, agentLine);
									j = 0;
									p = strstr(agentLine,"ROTOR_");
									if ((p != NULL) && (p == agentLine))
									{
										rotor_found = yes;
										// get rotor name
										rotorNameLength = strcspn(agentLine, "=");
										p32RotorName[k] = (char *)HeapAlloc(hAgentBuffer, HEAP_ZERO_MEMORY, rotorNameLength+1);
										strncpy(p32RotorName[k], agentLine, rotorNameLength);
										strcat(p32RotorName[k], "");

										// get rotor file name
										px=strtok(agentLine,"=");

										// open rotor file and copy name and contents to memory
										if (px)
										{
											px = strtok(NULL," ");

											hRotorFile = CreateFile(px,
												GENERIC_READ,
												FILE_SHARE_READ, NULL,
												OPEN_EXISTING,
												FILE_ATTRIBUTE_READONLY | FILE_FLAG_SEQUENTIAL_SCAN,
												NULL);

											if (hRotorFile == INVALID_HANDLE_VALUE)
											{
									      	CloseHandle(hSourceFile);
									      	CloseHandle(hTargetFile);
												CloseHandle(hAgentFile);
												CloseHandle(hRotorFile);
												HeapDestroy(hAgentBuffer);
												SetCursor(hSaveCursor);
							               ReleaseCapture();
												strcpy(szBuffer, "CreateFile Failure: ");
												strcat(szBuffer, px);
												MessageBox(hWnd, szBuffer, "Rotor File", MB_ICONEXCLAMATION | MB_OK);
												break;
											}
											else
											{
												// load rotor name into memory
												p32RotorFileName[k] = (char *)HeapAlloc(hAgentBuffer, HEAP_ZERO_MEMORY,  strlen(px)+1) ;
												strncpy(p32RotorFileName[k], px, strlen(px));
												strcat(p32RotorFileName[k], "");

												// load the rotor into memory
												fileSize = GetFileSize(hRotorFile, NULL);
												rotorLength[k] = LOWORD(fileSize);
												p32RotorData[k] = (unsigned char *)HeapAlloc(hAgentBuffer, HEAP_ZERO_MEMORY, rotorLength[k]+1);
												ReadFile(hRotorFile, p32RotorData[k], fileSize, &bytesRead, NULL);
												CloseHandle(hRotorFile);
											}

										}

										k++;
									}
									continue;
								}
								j++;
							}	// end loop on agent file

							rotorCount = k;

						} // end of reading agent file

						// get the rotor start pointersfrom the source file
						SetFilePointer(hSourceFile, -768, NULL, FILE_END);
						ReadFile(hSourceFile, &rotorStart, 512, &bytesRead, NULL);
						sourceFileLength -= 768;

               }	//end of active agent

					// get user Key
					keyLength = SendMessage(hWndKey, WM_GETTEXTLENGTH,0,0);
					if (keyLength == 0)
					{
						keyFound = no;
					}
					else
					{
						keyFound = yes;
						p32KeyBuffer = (LPSTR)HeapAlloc(GetProcessHeap(), 0, keyLength+1);
						SendMessage(hWndKey, WM_GETTEXT, keyLength+1, (LPARAM)p32KeyBuffer);
					}

					// decode rotor start points
					if (keyFound == yes && rotorCount > 0)
					{
						for (i=0; i < rotorCount; i++)
						{
							rotorStart.index_byte[4*i] = rotorStart.index_byte[4*i] ^ *(p32KeyBuffer + (i % keyLength));
						}
					}
					for (i = 0; i < rotorCount; i++)
					{
						rotorIndex[i] = rotorStart.index_int[i];
					}

					// create temp file
					if (decrypt = yes)
					{
						GetTempPath(_MAX_PATH, (LPTSTR) szTempPath);

						GetTempFileName(szTempPath,
							"temp",
							0,
							(LPTSTR) szTempName);

						hTempFile = CreateFile((LPTSTR) szTempName,
							GENERIC_READ | GENERIC_WRITE,
							0,
							NULL,
							CREATE_ALWAYS,
							FILE_ATTRIBUTE_NORMAL | FILE_ATTRIBUTE_TEMPORARY,
							NULL);

						if (hTempFile == INVALID_HANDLE_VALUE)
						{
							decrypt = no;
							CloseHandle(hTempFile);
				      	CloseHandle(hSourceFile);
				      	CloseHandle(hTargetFile);
							CloseHandle(hAgentFile);
							HeapDestroy(hAgentBuffer);
					      if ( keyFound == yes)
					      {
								HeapFree(GetProcessHeap(), 0, p32KeyBuffer);
			      		}
							MessageBox(hWnd, "CreateFile Failure", "Temp File", MB_ICONEXCLAMATION | MB_OK);
							break;
						}

					} // end of create temp file

					// Decypher the source characters

						// setup for progress bar
					m = 220;
					hLineDC = GetDC(hWnd);
					hOrgPen = SelectObject(hLineDC, hGreenPen);
					MoveToEx(hLineDC, 220, 163, NULL);
					LineTo(hLineDC, 480, 163);
					hOrgPen = SelectObject(hLineDC, hRedPen);
					for (l = 0; l < 52; l++)
					{
						if (sourceFileLength >= 52)
							bumpPoint[l] =  (UINT)((float)(sourceFileLength / 52))* (1 + l);
						else
							bumpPoint[l] = 0;
					}
					bumpPoint_Hold = 0;
					l = 0;
					n = 0;
					MoveToEx(hLineDC, 220, 163, NULL);

					k = 0;
					SetFilePointer(hSourceFile, 0, NULL, FILE_BEGIN);
					for (i=0; decrypt == yes && i < sourceFileLength; i++)
					{
						// Get a character from source file
						bFileRead = ReadFile(hSourceFile, (LPSTR) charBuffer, 1, &bytesRead, NULL);
						if (!bFileRead)
						{
							decrypt = no;
							MessageBox(hWnd, "Read error", "Source char ", MB_ICONEXCLAMATION | MB_OK);
							if (GetLastError() == ERROR_NOACCESS)
								MessageBox(hWnd, "Error noaccess", "Source Error # ", MB_ICONEXCLAMATION | MB_OK);
							break;
						}

                  n++;
						ch = *charBuffer;

						// get a character from Key
						if (keyFound == yes)
						{
							if (k >= keyLength)
								k = 0;
							uk = *(p32KeyBuffer + k);
							ch ^= uk;	// XOR source character against user key character
							k++;
						}

                  if (agent_active == yes && rotor_found ==yes)
                  {
							// loop and XOR on each rotor
							for (j=0; j < rotorCount; j++)
							{
								// get a char from rotor and XOR with buffer
								ch ^= *(p32RotorData[j] + rotorIndex[j]);

								if (rotorIndex[j] >= (rotorLength[j] -1))
								{
									rotorIndex[j] = 0;
								}
								else
									rotorIndex[j] += 1;
							} // end for on rotors for XOR

                  }
						// write buffer to temp target file
						WriteFile(hTempFile, &ch, 1, &bytesWritten, NULL);

						// move progress bar
						if ((n == bumpPoint[l]) || ((bumpPoint[l] == bumpPoint_Hold) && (sourceFileLength < 52)))
						{
							if (sourceFileLength >= 52)
								m += 5;
							else
								m += (UINT)(5 * (52 / (float)sourceFileLength));
							if (n == sourceFileLength)
								LineTo(hLineDC, 480, 163);
							else
								LineTo(hLineDC, m, 163);
							UpdateWindow(hWnd);
							bumpPoint_Hold = bumpPoint[l];
							l++;
						}

					}  	// end of loop on source file

					if (decrypt == yes)
					{
						CloseHandle(hTempFile);
						CopyFile(szTempName, szTargetPath, FALSE);
						DeleteFile(szTempName);
					}


			      if ( keyFound == yes)
			      {
						HeapFree(GetProcessHeap(), 0, p32KeyBuffer);
			      }
					if (agentFileFound == yes) HeapDestroy(hAgentBuffer);

		      	CloseHandle(hSourceFile);
		      	CloseHandle(hTargetFile);
					SetCursor(hSaveCursor);
               ReleaseCapture();
					MessageBox(hWnd, "End of Decode", "Decode ", MB_ICONEXCLAMATION | MB_OK);
					hOrgPen = SelectObject(hLineDC, hGreenPen);
					MoveToEx(hLineDC, 220, 163, NULL);
					LineTo(hLineDC, 480, 163);
               ReleaseDC(hWnd, hLineDC);

					break;

//----------------------------------------------------------------------------------
				case IDM_ABOUT:

					DialogBox(hInst, MAKEINTRESOURCE(ABOUT), hWnd, (DLGPROC)About);
					break;

//----------------------------------------------------------------------------------

				case IDM_EXIT:
					DestroyWindow (hWnd);
					break;

//----------------------------------------------------------------------------------

				default:

					return (DefWindowProc(hWnd, message,
						uParam, lParam));
			}
			break; // end of case WM_COMMAND

//----------------------------------------------------------------------------------

		case WM_DESTROY:

			DeleteObject(hRedPen);
			DeleteObject(hGreenPen);
			WinHelp(hWnd, szHelpFile, HELP_QUIT, 0L);

			PostQuitMessage(0);

			break;

//----------------------------------------------------------------------------------

		default:

			return (DefWindowProc(hWnd, message,
				uParam, lParam));

	}	//end of message switch

	return(0);

}			// End main callback proc.



/******************************************************************/
/*               Make Agent   -    dialog procedure               */
/******************************************************************/

LRESULT CALLBACK Make_agent(HWND hDlg, UINT message,
	UINT uParam, LPARAM lParam)
{

				int		wmId, wmEvent, wmHctl;
				TCHAR		agentFileName[MAX_PATH];
				TCHAR		rotorFileName[MAX_PATH];
				TCHAR		rotorName[MAX_PATH];
				TCHAR		szBuffer[11];
				TCHAR		szLineBuffer[528];
				UINT		fnameLength;
				UINT		nameLength;
				UINT		lineLength;
				UINT		bytesWritten;
				HANDLE	hAgentFile;
	static	HANDLE	hAgentBuffer;
	static	LPSTR	p32RotorLines;
	static	UINT		lengthSoFar = 0;

	switch (message)
	{

		case WM_INITDIALOG:

				SetFocus( GetDlgItem( hDlg, AGENT_FILE_NAME));
				hAgentBuffer = HeapCreate(0, (528 * 127), 0);
				if (hAgentBuffer == NULL)
					MessageBox(hDlg, "NULL handle", "buffer", MB_ICONEXCLAMATION | MB_OK);
				p32RotorLines = (LPSTR)HeapAlloc(hAgentBuffer, HEAP_ZERO_MEMORY, (528 * 127));
				if (p32RotorLines == NULL)
					MessageBox(hDlg, "NULL pointer", "buffer", MB_ICONEXCLAMATION | MB_OK);

		  	  return (FALSE);

		case WM_COMMAND:

			wmId    = LOWORD(uParam);
			wmEvent = HIWORD(uParam);
			wmHctl  = lParam;

			switch (wmId)
			{
				case IDB_DONE_AGENT:

					HeapDestroy(hAgentBuffer);

					EndDialog(hDlg, TRUE);

					break;

				case ADD_ROTOR:

               // get rotor file name
               fnameLength = GetDlgItemText(hDlg, ROTOR_FILE_NAME, rotorFileName, MAX_PATH);
               if (fnameLength == 0)
               {
						MessageBox(hDlg, "no file name specified", "rotor file name ", MB_ICONEXCLAMATION | MB_OK);
						break;
               }

               // get rotor name
               nameLength = GetDlgItemText(hDlg, ROTOR_NAME, rotorName, MAX_PATH);

               // build rotor line
					strcpy(szLineBuffer,"ROTOR_");
					strcat(szLineBuffer,rotorName);
					strcat(szLineBuffer,"=");
					strcat(szLineBuffer,rotorFileName);
					strcat(szLineBuffer," PTR=0 \n");
					lineLength = strlen(szLineBuffer);
					ultoa(lineLength, szBuffer, 10);
					lstrcpy((p32RotorLines + lengthSoFar), szLineBuffer);
					lengthSoFar += lineLength;
					MessageBox(hDlg, "Rotor added", "Agent file", MB_ICONEXCLAMATION | MB_OK);

					break;

				case CREATE_AGENT:

               fnameLength = GetDlgItemText(hDlg, AGENT_FILE_NAME, agentFileName, MAX_PATH);
               if (fnameLength == 0)
               {
						MessageBox(hDlg, "no Agent file name specified", "agent file name ", MB_ICONEXCLAMATION | MB_OK);
						break;
               }
					hAgentFile = CreateFile(agentFileName, GENERIC_READ | GENERIC_WRITE,
						0, NULL,
						CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);

					if (hAgentFile == INVALID_HANDLE_VALUE)
					{
						MessageBox(hDlg, "CreateFile Failure", "Agent File", MB_ICONEXCLAMATION | MB_OK);
						break;
					}

					strcpy(szLineBuffer,"PASSES_=0 \n");
					lineLength = strlen(szLineBuffer);

					WriteFile(hAgentFile, p32RotorLines, lengthSoFar, &bytesWritten, NULL);
					WriteFile(hAgentFile, szLineBuffer, lineLength, &bytesWritten, NULL);

					CloseHandle(hAgentFile);

					MessageBox(hDlg, p32RotorLines, "Agent created", MB_ICONEXCLAMATION | MB_OK);

					break;

			}

			break;

		default:
			return(FALSE);

	}

   return(TRUE);

}	//end of Make Agent


/******************************************************************/
/*               Make Rotors   -   dialog procedure               */
/******************************************************************/

LRESULT CALLBACK Make_rotors(HWND hDlg, UINT message,
	UINT uParam, LPARAM lParam)
{

	int		wmId, wmEvent, wmHctl;
	int		i,j;
	TCHAR		rotorFileName[MAX_PATH];
	UINT		rotorFileLength;
	DWORD		fnameLength;
	HANDLE	hRotorFile;
	DWORD		bytesWritten;
	DWORD		bytesWrittenSum;
	HANDLE	hRotorBuffer;
	unsigned char	*p32RotorData;
	BOOL		lError;

	switch (message)
	{

		case WM_INITDIALOG:

		  	  SetFocus( GetDlgItem( hDlg, ROTOR_FNAME));
		  	  return (FALSE);

		case WM_COMMAND:

			wmId    = LOWORD(uParam);
			wmEvent = HIWORD(uParam);
			wmHctl  = lParam;

			switch (wmId)
			{
				case IDB_DONE_ROTOR:

					EndDialog(hDlg, TRUE);
					break;

				case IDB_CREATE_ROTOR:

               // get rotor file name
               fnameLength = GetDlgItemText(hDlg, ROTOR_FNAME, rotorFileName, MAX_PATH);
               if (fnameLength == 0)
               {
						MessageBox(hDlg, "no file name specified", "rotor file name ", MB_ICONEXCLAMATION | MB_OK);
						break;
               }

               // get rotor file length
               rotorFileLength = GetDlgItemInt(hDlg, ROTOR_LENGTH, &lError, FALSE);
               if (!lError || rotorFileLength == 0)
               {
						MessageBox(hDlg, "invalid or no length specified", "rotor file ", MB_ICONEXCLAMATION | MB_OK);
						break;
               }

					// create file
					hRotorFile = CreateFile(rotorFileName, GENERIC_WRITE,
						FILE_SHARE_READ, NULL,
						CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);

					if (hRotorFile == INVALID_HANDLE_VALUE)
					{
			      	CloseHandle(hRotorFile);
						MessageBox(hDlg, "CreateFile Failure", "Rotor File", MB_ICONEXCLAMATION | MB_OK);
						break;
					}

						hRotorBuffer = HeapCreate(0, rotorFileLength, 0);
						p32RotorData = (unsigned char *)HeapAlloc(hRotorBuffer, HEAP_ZERO_MEMORY, rotorFileLength);
					// write random bytes to buffer for length
					j = time(NULL)%1000;
					srand(j);

					for (bytesWrittenSum = 0; bytesWrittenSum < rotorFileLength; p32RotorData++, bytesWrittenSum++)
					{
						i = rand() % 256;
						*p32RotorData = i;
					}

					// write buffer to file
					p32RotorData -= rotorFileLength;
					WriteFile(hRotorFile, p32RotorData, rotorFileLength, &bytesWritten, NULL);

					// cleanup
					CloseHandle(hRotorFile);
					HeapDestroy(hRotorBuffer);

					MessageBox(hDlg, "Rotor created", "Rotor File", MB_ICONEXCLAMATION | MB_OK);
					break;
			}
			break;

		default:
			return (FALSE);

	}

	return (TRUE);

}	//end of Make Rotors


/******************************************************************/
/*          Change current directory -dialog procedure            */
/******************************************************************/

LRESULT CALLBACK Change_directory(HWND hDlg, UINT message,
	UINT uParam, LPARAM lParam)
{

	int		wmId, wmEvent, wmHctl;
	LPTSTR	szCurDir;
	LPTSTR	szNewDir;
	TCHAR		tchBuffer[MAX_PATH];

	switch (message)
	{

		case WM_INITDIALOG:

			szCurDir = tchBuffer;
			strcpy(szCurDir, "\\");
			DlgDirList(hDlg, szCurDir, ID_CUR_DIR, 0, DDL_DIRECTORY | DDL_DRIVES | DDL_EXCLUSIVE) ;

		  	return (TRUE);

		case WM_COMMAND:

			wmId    = LOWORD(uParam);
			wmEvent = HIWORD(uParam);
			wmHctl  = lParam;

			switch (wmId)
			{
				case IDOK:

					szNewDir = tchBuffer;
					DlgDirSelectEx(hDlg, szNewDir, MAX_PATH, ID_CUR_DIR);
					SetCurrentDirectory(szNewDir);
					EndDialog(hDlg, TRUE);
					break;

				case ID_EXPAND:

					szNewDir = tchBuffer;
					DlgDirSelectEx(hDlg, szNewDir, MAX_PATH, ID_CUR_DIR);
					DlgDirList(hDlg, szNewDir, ID_CUR_DIR, 0, DDL_DIRECTORY | DDL_DRIVES | DDL_EXCLUSIVE) ;
					break;

			}

			break;

		default:
			return (FALSE);

	}

	return (TRUE);

}	//end of set current directory


/******************************************************************/
/*               About - the About dialog procedure               */
/******************************************************************/

LRESULT CALLBACK About(HWND hDlg, UINT message,
	UINT uParam, LPARAM lParam)
{

	switch (message)
	{

		case WM_INITDIALOG:

			return(TRUE);

		case WM_COMMAND:

			EndDialog(hDlg, TRUE);
			return (TRUE);

	}

	return (FALSE);

}	//end of About


/**************************************************************************/
/*              Initialize File structure                                 */
/**************************************************************************/

void FileInitialize(HWND hWnd, OPENFILENAME *ofn)
{
	ofn->lStructSize			= sizeof (OPENFILENAME) ;
	ofn->hwndOwner				= hWnd ;
	ofn->hInstance				= NULL ;
	ofn->lpstrFilter			= "All files (*.*)", "*.*" ;
	ofn->lpstrCustomFilter	= NULL ;
	ofn->nMaxCustFilter		= 0 ;
	ofn->nFilterIndex			= 0 ;
	ofn->lpstrFile				= NULL ;		// Set in Open and Close functions
	ofn->nMaxFile				= MAX_PATH ;
	ofn->lpstrFileTitle		= NULL ;		// Set in Open and Close functions
	ofn->nMaxFileTitle		= 0 ;
	ofn->lpstrInitialDir		= NULL ;
	ofn->lpstrTitle			= NULL ;
	ofn->Flags					= 0 ;		// Set in Open and Close functions
	ofn->nFileOffset			= 0 ;
	ofn->nFileExtension		= 0 ;
	ofn->lpstrDefExt			= NULL ;
	ofn->lCustData				= 0L ;
	ofn->lpfnHook				= NULL ;
	ofn->lpTemplateName		= NULL ;

}	//end of file initialize
