/*******************************************************
	FBTOHEX

	Convert each byte of Infile to a pair of hexadecimal digits
	and write to Outfile seperated by spaces.

********************************************************/
#include <windows.h>
#include <stdio.h>
#include <io.h>
#include <stdlib.h>
#include <string.h>
#include <direct.h>

#define TRUE 1
#define FALSE 0

main(int argc, char *argv[])
{
  unsigned char ch;
  unsigned char chx[5];
  enum boolean {true=1, false=0, on=1, off=0};
  enum boolean eof = false;
  HANDLE hInFile;
  HANDLE hOutFile;
  BOOL bFileRead;
  DWORD dwError;
  int bytesRead, bytesWritten;

  if (argc != 3)
	{
		puts("fbtohexs: file bytes to HEX with spaces.\n");
		puts("syntax: fbtohexs Infile Outfile \n");
		puts("	This function will read each byte of Infile  \n");
		puts("	and write a pair of hexadecimal digits to Outfile seperated by spaces.  \n");
		return(0);
   }

    hInFile = CreateFile(argv[1], GENERIC_READ,
		0, NULL,
        		OPEN_EXISTING,
		FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN,
		NULL);

   if (hInFile == INVALID_HANDLE_VALUE)
		{
			puts("create Error InFile");
			return(0);
		}

    hOutFile = CreateFile(argv[2], GENERIC_WRITE,
		0, NULL,
        		CREATE_ALWAYS,
		FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN,
		NULL);

   if (hOutFile == INVALID_HANDLE_VALUE)
		{
			puts("create Error OutFile");
			return(0);
		}
    do
    {
	bFileRead = ReadFile(hInFile, &ch, 1, &bytesRead, NULL);
	if (bFileRead && (bytesRead == 0))
	{
	           puts( "Source eof" );
	           eof=true;
 	          continue;
	}

	if (!bFileRead)
	{
		dwError = GetLastError();
		printf( "%i \n", dwError);
 	          printf( "Read error" );
 	          break;
	}

	sprintf(chx, "%02X ", ch);
	WriteFile(hOutFile, chx, strlen(chx), &bytesWritten, NULL);

    } while (eof == false); // do loop
   CloseHandle(hInFile);
   CloseHandle(hOutFile);
   return(0);
}
