/********************************************************
        FHEXTOB

        Convert each pair of hex digits of Infile to the byte equivalent and write to Outfile.

********************************************************/
#include <windows.h>
#include <stdio.h>
#include <io.h>
#include <stdlib.h>
#include <string.h>
#include <direct.h>

#define TRUE 1
#define FALSE 0

main(int argc, char *argv[])
{
  unsigned char chx[3];
  unsigned char chb;
  unsigned int i;
  enum boolean {true=1, false=0, on=1, off=0};
  enum boolean eof = false;
  HANDLE hInFile;
  HANDLE hOutFile;
  BOOL bFileRead;
  DWORD dwError;
  int bytesRead, bytesWritten;

  if (argc != 3)
        {
                puts("fhextob: file HEX to byte.\n");
                puts("syntax: fbtodec Infile Outfile \n");
                puts("  This function will read a pair of hex digits of Infile  \n");
                puts("  and write the equivalent byte to Outfile.  \n");
                puts("  -- This program complements FBTOHEX. --  \n");
                return(0);
   }

    hInFile = CreateFile(argv[1], GENERIC_READ,
                0, NULL,
                OPEN_EXISTING,
                FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN,
                NULL);

   if (hInFile == INVALID_HANDLE_VALUE)
                {
                        puts("create Error InFile");
                        return(0);
                }

    hOutFile = CreateFile(argv[2], GENERIC_WRITE,
                0, NULL,
                        CREATE_ALWAYS,
                FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN,
                NULL);

   if (hOutFile == INVALID_HANDLE_VALUE)
                {
                        puts("create Error OutFile");
                        return(0);
                }
    do
    {
        bFileRead = ReadFile(hInFile, &chx, 2, &bytesRead, NULL);
        if (bFileRead && (bytesRead == 0))
        {
                   puts( "Source eof" );
                   eof=true;
                  continue;
        }

        if (!bFileRead)
        {
                dwError = GetLastError();
                printf( "%i \n", dwError);
                  printf( "Read error" );
                  break;
        }

        chx[2] = ' ';
        sscanf(chx, "%2x", &i);
        sprintf(&chb, "%c", i);
        WriteFile(hOutFile, &chb, 1, &bytesWritten, NULL);

    } while (eof == false); // do loop
   CloseHandle(hInFile);
   CloseHandle(hOutFile);
   return(0);
}
