#ifndef __ALLOC_P_H__
#define __ALLOC_P_H__

extern _VOID_ malloc_warning _P_((char *str));
extern _VOID_ display_malloc_warning _P_((void));
extern _VOID_ memory_full _P_((void));
extern pointer xmalloc _P_((int size));
extern pointer xrealloc _P_((pointer block, int size));
extern _VOID_ xfree _P_((pointer block));
extern _VOID_ uninterrupt_malloc _P_((void));
extern INTERVAL make_interval _P_((void));
extern _VOID_ init_float _P_((void));
extern _VOID_ free_float _P_((struct Lisp_Float *ptr));
extern Lisp_Object make_float _P_((double float_value));
extern _VOID_ init_cons _P_((void));
extern _VOID_ free_cons _P_((struct Lisp_Cons *ptr));
extern _VOID_ init_symbol _P_((void));
extern _VOID_ init_marker _P_((void));
extern _VOID_ init_strings _P_((void));
extern Lisp_Object make_string _P_((char *contents, int length));
extern Lisp_Object build_string _P_((char *str));
extern Lisp_Object make_uninit_string _P_((int length));
extern Lisp_Object make_event_array _P_((register int nargs,
                                         Lisp_Object *args));
extern Lisp_Object make_pure_string _P_((char *data, int length));
extern Lisp_Object pure_cons _P_((Lisp_Object car, Lisp_Object cdr));
extern Lisp_Object make_pure_float _P_((double num));
extern Lisp_Object make_pure_vector _P_((int len));
extern _VOID_ staticpro _P_((Lisp_Object *varaddress));
extern _VOID_ init_alloc_once _P_((void));
extern _VOID_ init_alloc _P_((void));
extern _VOID_ syms_of_alloc _P_((void));

DEFUN_P(Fcons, (Lisp_Object car, Lisp_Object cdr));
DEFUN_P(Flist, (int nargs, register Lisp_Object *args));
DEFUN_P(Fmake_list, (register Lisp_Object length,
                       register Lisp_Object init));
DEFUN_P(Fmake_vector, (register Lisp_Object length,
                         register Lisp_Object init));
DEFUN_P(Fvector, (register int nargs, Lisp_Object *args));
DEFUN_P(Fmake_byte_code, (register int nargs, Lisp_Object *args));
DEFUN_P(Fmake_symbol, (Lisp_Object str));
DEFUN_P(Fmake_marker, (void));
DEFUN_P(Fmake_string, (Lisp_Object length, Lisp_Object init));
DEFUN_P(Fpurecopy, (register Lisp_Object obj));
DEFUN_P(Fgarbage_collect, (void));
DEFUN_P(Fmemory_limit, (void));
    
#endif
