#ifndef __BUFFER_P_H__
#define __BUFFER_P_H__

extern _VOID_ nsberror _P_((Lisp_Object spec));
extern _VOID_ reset_buffer _P_((register struct buffer *b));
extern _VOID_ reset_buffer_local_variables _P_((register struct buffer *b));
extern _VOID_ record_buffer _P_((Lisp_Object buf));
extern _VOID_ set_buffer_internal _P_((register struct buffer *b));
extern _VOID_ validate_region _P_((register Lisp_Object *b,
                                   register Lisp_Object *e));
extern Lisp_Object list_buffers_1 _P_((Lisp_Object files));
extern int overlays_at _P_((int pos, int extend, Lisp_Object **vec_ptr,
                            int *len_ptr, int *next_ptr));
extern _VOID_ recenter_overlay_lists _P_((struct buffer *buf, int pos));
extern _VOID_ verify_overlay_modification _P_((Lisp_Object start,
                                               Lisp_Object end));
static void call_overlay_mod_hooks _P_((Lisp_Object list, Lisp_Object overlay,
                                        Lisp_Object start, Lisp_Object end));
extern _VOID_ buffer_slot_type_mismatch _P_((Lisp_Object valcontents,
                                             Lisp_Object newval));
extern _VOID_ init_buffer_once _P_((void));
extern _VOID_ init_buffer _P_((void));
extern _VOID_ syms_of_buffer _P_((void));
extern _VOID_ keys_of_buffer _P_((void));

DEFUN_P(Fbuffer_list, (void));
DEFUN_P(Fget_buffer, (register Lisp_Object name));
DEFUN_P(Fget_file_buffer, (register Lisp_Object filename));
DEFUN_P(Fget_buffer_create, (register Lisp_Object name));
DEFUN_P(Fgenerate_new_buffer_name, (register Lisp_Object name,
                                      register Lisp_Object ignore));
DEFUN_P(Fbuffer_name, (register Lisp_Object buffer));
DEFUN_P(Fbuffer_file_name, (register Lisp_Object buffer));
DEFUN_P(Fbuffer_local_variables, (register Lisp_Object buffer));
DEFUN_P(Fbuffer_modified_p, (register Lisp_Object buffer));
DEFUN_P(Fset_buffer_modified_p, (register Lisp_Object flag));
DEFUN_P(Fbuffer_modified_tick, (register Lisp_Object buffer));
DEFUN_P(Frename_buffer, (register Lisp_Object name,
                           register Lisp_Object unique));
DEFUN_P(Fother_buffer, (register Lisp_Object buffer,
                          register Lisp_Object visible_ok));
DEFUN_P(Fbuffer_disable_undo, (register Lisp_Object buffer));
DEFUN_P(Fbuffer_enable_undo, (register Lisp_Object buffer));
DEFUN_P(Fkill_buffer, (Lisp_Object bufname));
DEFUN_P(Fswitch_to_buffer, (Lisp_Object bufname, Lisp_Object norecord));
DEFUN_P(Fpop_to_buffer, (Lisp_Object bufname, Lisp_Object other));
DEFUN_P(Fcurrent_buffer, (void));
DEFUN_P(Fset_buffer, (register Lisp_Object bufname));
DEFUN_P(Fbarf_if_buffer_read_only, (void));
DEFUN_P(Fbury_buffer, (register Lisp_Object buf));
DEFUN_P(Ferase_buffer, (void));
DEFUN_P(Flist_buffers, (Lisp_Object files));
DEFUN_P(Fkill_all_local_variables, (void));
DEFUN_P(Foverlayp, (Lisp_Object object));
DEFUN_P(Fmake_overlay, (Lisp_Object beg, Lisp_Object end,
                          Lisp_Object buffer));
DEFUN_P(Fmove_overlay, (Lisp_Object overlay, Lisp_Object beg,
                          Lisp_Object end, Lisp_Object buffer));
DEFUN_P(Fdelete_overlay, (Lisp_Object overlay));
DEFUN_P(Foverlay_start, (Lisp_Object overlay));
DEFUN_P(Foverlay_end, (Lisp_Object overlay));
DEFUN_P(Foverlay_buffer, (Lisp_Object overlay));
DEFUN_P(Foverlay_properties, (Lisp_Object overlay));
DEFUN_P(Foverlays_at, (Lisp_Object pos));
DEFUN_P(Fnext_overlay_change, (Lisp_Object pos));
DEFUN_P(Foverlay_lists, (void));
DEFUN_P(Foverlay_recenter, (Lisp_Object pos));
DEFUN_P(Foverlay_get, (Lisp_Object overlay, Lisp_Object prop));
DEFUN_P(Foverlay_put, (Lisp_Object overlay, Lisp_Object prop,
                         Lisp_Object value));
    
#endif
